

jQuery( document ).ready( function ($) {
    
    $('.bkap-manual input[name="bkap_reminder_option"]').on( 'change', function(){
        if( 'bkap_reminder_booking' == $(this).val() ) {

            $('#reminder_product_ids').hide();
            $('#reminder_booking_ids').show();
            $('#reminder_order_ids').hide();
            
        }else if( 'bkap_reminder_product' == $(this).val() ) {

            $('#reminder_product_ids').show();
            $('#reminder_booking_ids').hide();
            $('#reminder_order_ids').hide();

        }else if( 'bkap_reminder_order' == $(this).val() ) {

            $('#reminder_order_ids').show();
            $('#reminder_product_ids').hide();
            $('#reminder_booking_ids').hide();

        }
    });
    
    $( '#button_reminder' ).on("click", function() {
        $("#ajax_img").show();
        var data = {
            booking_id : $(this).data('bookid'),
            action: 'bkap_send_reminder_action'
        }

        $.post( bkap_reminder_params.ajax_url, data, function(response) {

            if( response !== false ) {
                $("#ajax_img").hide();
                $('.wrap form').before( '<div class="notice notice-success"><p>Reminder sent successfully</p></div>')
                $('.notice-success').fadeOut(5000);          
            }
           
        });
    });

    // Showing Booking form when clicked on Edit Booking Button.
    $( '#edit_bkap' ).on( "click", function() {
        $(".edit-page-booking-form").removeAttr( "style" );
        $("#edit_bkap").hide();
    });

    $( '#bkap_save_message' ).on( "click", function() {

        let reminder_message = '';
        if ( $( '#wp-bkap_reminder_message-wrap' ).hasClass( 'tmce-active' ) ) {
            reminder_message = tinyMCE.get('bkap_reminder_message').getContent()
        } else {
            reminder_message = $('#bkap_reminder_message').val();
        }
        $("#ajax_img").show();
        var data = {
            subject : $( '#bkap_reminder_subject' ).val(),
            message : reminder_message,
            action: 'bkap_save_reminder_message'
        };

        $.post( bkap_reminder_params.ajax_url, data, function(response) {

            if( response !== false ) {
                $("#ajax_img").hide();
                $('.wrap form').after( '<div class="notice notice-success"><p>Message draft saved</p></div>');
                $('.notice-success').fadeOut(5000);
            }
            
        });
    });

    jQuery( '#bkap_test_sms' ).on( 'click', function() {

        jQuery("#send_ajax_img").show();        
        var data = {
            number: jQuery( '#bkap_test_number' ).val(),
            msg:    jQuery( '#bkap_test_msg' ).val(),
            action: 'bkap_test_sms' 
        };
        jQuery.post( bkap_reminder_params.ajax_url, data, function( response ) {
            jQuery("#send_ajax_img").hide();
            var message = JSON.parse( response );
            jQuery( '#status_msg' ).html( message );
            jQuery( '#status_msg' ).css( 'display', 'block' );
            jQuery( '#status_msg' ).fadeOut( 8000 );
            
        });
        
    });

    // For Customer and Products dropdown on Create Booking page.
    if ( jQuery(".bkap-customer-search").length > 0 ) {
        jQuery( ".bkap-customer-search, #bkap_product_id" ).select2({
            allowClear: true
        });
    }
});