/**
 * JS file for handling actions of Booking Search Widget
 * 
 * @since 4.12.0
 */

jQuery( document).ready( function() {
	var today 	= new Date();
	var dd 		= today.getDate();

	// Setting language of check-in and check-out calendar
	jQuery("#w_check_in").datepicker( "option", jQuery.datepicker.regional[ bkap_search_widget_params.bkap_language ] );
	jQuery("#w_check_out").datepicker( "option", jQuery.datepicker.regional[ bkap_search_widget_params.bkap_language ] );

	var check_enable_single_day = bkap_search_widget_params.allow_single_day_search;
	var disabledDates = bkap_search_widget_params.bkap_global_setting.booking_global_holidays;
	// Setting Datepicker options for Check-in calendar.
	jQuery( "#w_check_in" ).datepicker({
	 	minDate: 	today,
	 	dateFormat: bkap_search_widget_params.bkap_global_setting.booking_date_format,
	 	altField: 	"#w_checkin",
	 	altFormat: 	"yy-mm-dd",
	 	firstDay: 	bkap_search_widget_params.bkap_global_setting.booking_calendar_day,
	 	onClose: 	function( selectedDate ) {
			jQuery( "#w_check_out" ).datepicker( "option", "minDate", selectedDate );

			var selected_cat_value = jQuery( '#cat :selected' ).val();
			jQuery( "#w_category" ).val( selected_cat_value );
			
			if ( check_enable_single_day == "on" ) {
			   	var set_checkout = jQuery( '#w_check_in' ).val();
			   	jQuery( "#w_check_out" ).val( set_checkout );
			   
			   	var set_checkout_hidden = jQuery( '#w_checkin' ).val();
			   	jQuery( "#w_checkout" ).val( set_checkout_hidden );
			   	jQuery( "#bkap_search" ).prop( "disabled", false );
			} else {
				jQuery( "#w_check_out" ).datepicker( "show" );
				if ( jQuery( "#w_check_out" ).val() != "" ) {
					jQuery( "#bkap_search" ).prop( "disabled", false );
				}
			}
		},
		beforeShowDay: function( date ){
	        var string = jQuery.datepicker.formatDate( 'd-m-yy' , date );
	        return [ disabledDates.indexOf( string ) == -1, "", "Holiday" ]
	    }
	});
	
	// Setting category value on change of category dropdown.
	jQuery( "#cat" ).change( function() {	
		var selected_cat_value =  jQuery( '#cat :selected' ).val();
		jQuery( "#w_category" ).val( selected_cat_value );	
	});

	// Setting Datepicker options for Check-out calendar.	
	jQuery("#w_check_out").datepicker({
		minDate: 	today,
		dateFormat: bkap_search_widget_params.bkap_global_setting.booking_date_format,
		altField: 	"#w_checkout",
		altFormat: 	"yy-mm-dd",
		firstDay: 	bkap_search_widget_params.bkap_global_setting.booking_calendar_day,
		onClose: 	function ( selectedDate ) {
			
			var selected_cat_value =  jQuery( '#cat :selected' ).val();
		    jQuery( "#w_category" ).val( selected_cat_value );

		    if ( jQuery( "#w_checkin" ).val() != "" ){
		    	jQuery( "#bkap_search" ).prop( "disabled", false );
		    }
		},
		beforeShowDay: function( date ){
	        var string = jQuery.datepicker.formatDate( 'd-m-yy' , date );
	        return [ disabledDates.indexOf( string ) == -1, "", "Holiday" ]
	    }
	});
	
	jQuery("#ui-datepicker-div").wrap("<div class=\"hasDatepicker\"></div>");

	jQuery('.ui-datepicker').addClass( 'notranslate' ); // Do not translate the calendar when translated using google translator

	// Clearing sessions on click of Clear button.
	jQuery( "#bkap_clear" ).on( "click", function() {
		
		// removing searched date from cookie.
		bkap_del_cookie('start_date');
		bkap_del_cookie('end_date');

		var clear_data = {
			action: 'clear_widget_dates'
		};
		jQuery.post(bkap_search_widget_params.ajax_url, clear_data, function(response) {
			jQuery("#w_check_in").val('');
			jQuery("#w_check_out").val('');
			jQuery("#cat").val(0);

			window.location.href =  bkap_search_widget_params.shop_url;
		});
	});

	if ( check_enable_single_day == "on" && jQuery( "#w_check_in" ).val() != "" ) {
		jQuery( "#bkap_search" ).prop( "disabled", false );
	} else if ( jQuery( "#w_check_in" ).val() != "" && jQuery( "#w_check_out" ).val() != "" ) { 
		jQuery( "#bkap_search" ).prop( "disabled", false );
	}
});

/**
 * Removing searched dates from cookies.
 */
function bkap_del_cookie(name) {
   document.cookie = name +'=; Path=/; Expires=Thu, 01 Jan 1970 00:00:01 GMT;';
} 