/**
 * Bulk Booking Settings
 * @namespace bkap_bulk_booking
 * @since 4.16.0
 */
jQuery( document ).ready( function ($) {

	// Adding booking tab styling for the booking meta box tabs
	$('.tstab-content').wrapInner('<div class="tstab-content-inner"></div>');
	$(document).on('click', '.tstab-tab', function(){
		data_link = $(this).data("link");
		cur_data_link = $('.tstab-tab.tstab-active').data("link");
		if ( cur_data_link !== data_link ) {
			$('.tstab-content').removeClass('tstab-active').hide();
			$("#"+data_link).addClass('tstab-active').css('position', 'relative').fadeIn('slow');
			$('.tstab-tab').removeClass('tstab-active');
			$(this).addClass('tstab-active');
		}
	});

	jQuery( '.bkap-bulk-setting' ).on( 'click', function( event ) {    

		/* Checking for field before saving the settings */
	    var save          = true;
	    var bkap_products = jQuery( "#bkap_products" ).val();
	    if ( bkap_products == null || bkap_products == "" ) {
	    	alert( "Please select the products.." );
	     	save = false;
	    }

	    if ( save ) {
	    	var data = bkap_save_product_settings();

	    	if ( data.blocks_enabled != "" ) {
				if ( data.fixed_block_data == "false" ) {
					return false;
				}
	    	}

	    	if ( data.ranges_enabled != "" ) {
	    		if ( ! data.price_range_data ) {
					return false;

				}
	    	}

	    	if ( 'error' in data ) {
		        alert( data.error );
		        return false;
	      	} else {

		        data.product_id       = bkap_products;
		        data.all_product_ids  = jQuery( "#bkap_all_products" ).val();

		        var booking_options = JSON.parse( data.booking_options );    
		        if ( booking_options.booking_enable_date == "" || booking_options.booking_type == "" ) {
		          alert( "Please enable booking setting and select booking type." );
		          save = false;
		        }

		        if ( save ) {

		        	jQuery( '#woocommerce-booking' ).block({
			            message: null,
			            overlayCSS: {
			                background: '#fff',
			                opacity: 0.6
			            }
			        });

		          	jQuery( '#ajax_img' ).css( 'display', 'block' );
		          	jQuery( '.bkap_execute_row_bulk' ).hide();
		          	// add code to show ajax loader and disable save settings button
		          	jQuery.post( bkap_settings_params.ajax_url, data, function( response ) {

		          		jQuery( '.bkap_execute_row_bulk' ).show();
		          		jQuery( "#bkap_products" ).val('').trigger('change');
		          		jQuery( '#woocommerce-booking' ).unblock();
		            	jQuery( '#ajax_img' ).css( 'display', 'none' );
		            	jQuery( '#bulk_booking_update_notification' ).addClass( 'bkap_updated_notice' );
		            	jQuery( '#bulk_booking_update_notification' ).css( 'display', 'block' );
		            	jQuery( '#bulk_booking_update_notification' ).html( 'Settings Saved.' ).fadeOut( 10000 );
		            	window.location.reload();
		          	});
	        	}
	      	}
	    }
	});

  	jQuery( ".bkap_bulk_products" ).select2({ width: '75%', placeholder: "Select products.."});

	/**
	 * Event for showing the saved resource details
	 *
	 * @fires event:click
	 * @since 4.6.0
	 */
	$( '#bulk_setting_availability_rows' ).on( 'change', '#bkap_bulk_day_date', function() {
		var value = $(this).val();
		var row   = $(this).closest('tr');

		$(row).find( '.bkap_bulk_date, .bkap_bulk_day_div' ).hide();

		if ( value == 'day' ) {
			$(row).find('.bkap_bulk_day_div').show();
		}
		if ( value == 'date' ) {
			$(row).find('.bkap_bulk_date').show();
		}
	});

	/**
	 * Event for adding rows to the resources table
	 *
	 * @fires event:bkap_row_added
	 * @since 4.6.0
	 */
	$('body').on('bkap_bulk_row_added', function(){
		$('#bkap_bulk_day_date').change();
	});

	/**
	 * Callback Function when Edit Booking Button is clicked
	 *
	 * @function wc_bookings_trigger_change_events
	 * @return {bool} stop further propogation of event
	 * @since 4.6.0
	 */
	function bkap_bulk_booking_settings_trigger_change_events() {
		$('#bkap_bulk_day_date').change();
	}

	/**
	 * Event when add new row is clicked
	 *
	 * @fires event:click
	 * @since 4.6.0
	 */
	$( '.bkap_add_row_bulk' ).click(function( e ){

		var each_row    = new Array();
	    var i         = 0;
	    var last_class_name = "";
	    
	    // Calculating new ID to assign new tr.
	    jQuery( "tr[class^='bkap_bulk_booking_setting_row']" ).each( function(){
	      
	      	var class_name_row 	= jQuery(this)[0].className;
	      	last_class_name 		= class_name_row;
	      	var res 				= class_name_row.replace( "bkap_bulk_booking_setting_row_", "" );
	      
	      	if ( res == class_name_row && each_row.length == 0 ) {
	        	each_row[i] = 1;
	      	} else {
	        	each_row[i] = parseInt( res );
	      	}
	      	i++;
	    });
	    
	    if ( each_row.length == 0 ) {
	      	new_id = 0;
	    } else {
	    	var max = Math.max.apply(Math,each_row);
		    var new_id = max + 1;
	    }

		var newRow 	= $( this ).data( 'row' );
		newRow 		= newRow.replace( 'bkap_bulk_booking_setting_row', 'bkap_bulk_booking_setting_row_' + new_id );
		newRow      = newRow.replace( 'bkap_bulk_date_field', 'bkap_bulk_date_field_' + new_id );
		newRow      = newRow.replace( 'bkap_bulk_weekday', 'bkap_bulk_weekday_' + new_id );

		$(this).closest('table').find('tbody').append( newRow );
		var formats = ["d.m.y", "d-m-yyyy","MM d, yy"];
		jQuery( '#bkap_bulk_weekday_' + new_id ).select2( { placeholder: 'Select days..' } );		
		jQuery( '#bkap_bulk_date_field_' + new_id ).datepick({
	        minDate: 		new Date(), 
	        dateFormat: 	formats[1], 
	        multiSelect: 	999, 
	        monthsToShow: 	1, 
	        showTrigger: 	'#calImg'
	    });

		/**
		 * Indicates that the row is added
		 * 
		 * @event bkap_row_added
		 * @since 4.6.0
		 */
		$('body').trigger('bkap_bulk_row_added');
		return false;
	});

	/**
	 * Event when Close Resource clicked
	 *
	 * @fires event:click
	 * @since 4.6.0
	 */
	jQuery('#bulk_setting_availability_rows').on( 'click', '#bkap_close_bulk_row', function( e ) {
		$(this).parent().remove();
	});

	bkap_bulk_booking_settings_trigger_change_events();

	/**
	 * When Execute Added Action button is clicked then collect the info and execute script. 
	 */
	
	jQuery( document ).on( 'click', '.bkap_execute_row_bulk', function( e ) {

		/* Check if the product is selected */
		var bkap_executable_products = jQuery( "#bkap_executable_products" ).val();
	    if ( bkap_executable_products == null || bkap_executable_products == "" ) {
	    	alert( "Please select the products.." );
	    	return;
	    }
		
		var j 				= 0;
		var execution_data 	= {};
		//run through each row for collecting the data..
		var validated 		= true; 
		jQuery( 'tr[class^="bkap_bulk_booking_setting_row"]' ).each(function (i, row) {

			jQuery( this ).removeClass('bkap_error');
		    
		    var daydate 		= jQuery(this).find( 'select[id^="bkap_bulk_day_date"]' ).val();
		    var daydate_value 	= '';
		    
		    switch( daydate ) {		      
		      	case 'day':
		      		daydate_value = jQuery( this ).find( 'select[id^="bkap_bulk_weekday_"]' ).val();
		        	break;		      
		      	case 'date':
		      		daydate_value = jQuery( this ).find( 'textarea[class^="date-picker"]' ).val();
		        	break;		      
		      	default:
		      	break;
		    }
	        
	        execution_data[j] = {};
	        execution_data[j][ 'bulk_day_date' ] 		= daydate;
	        execution_data[j][ 'bulk_day_date_value' ] 	= daydate_value;
	        execution_data[j][ 'bulk_action' ] 			= jQuery( this ).find( 'select[id^="bkap_bulk_action"]' ).val();
	        execution_data[j][ 'bulk_from_time' ]     	= jQuery( this ).find( 'input[id^="bkap_bulk_from_time"]' ).val();
	        execution_data[j][ 'bulk_to_time' ]       	= jQuery( this ).find( 'input[id^="bkap_bulk_to_time"]' ).val();        
	        execution_data[j][ 'bulk_lockout_slot' ]  	= jQuery( this ).find( 'input[id^="bkap_bulk_max_booking"]' ).val();        
	        execution_data[j][ 'bulk_slot_price' ]    	= jQuery( this ).find( 'input[id^="bkap_bulk_price"]' ).val();
	        execution_data[j][ 'bulk_note' ]    		= jQuery( this ).find( 'textarea[id^="bkap_bulk_note"]' ).val();

	        j++;
	        if ( daydate_value == "" || daydate_value == null ) {
	        	jQuery( this ).addClass('bkap_error');
	        	validated = false;	
	        }
	        
		});

		if ( jQuery.isEmptyObject( execution_data ) ) {
			alert( "Please add action to execute it." );
		} else if ( ! validated ) {
			jQuery( '#execute_booking_update_notification' ).css( 'display', 'block' );
	        jQuery( '#execute_booking_update_notification' ).html( '<b style="color:red;">Please fillout all fields.</b>' ).fadeOut( 5000 );
			return false;
		} else {

			jQuery( '.bkap-executable-table' ).block({
	            message: null,
	            overlayCSS: {
	                background: '#fff',
	                opacity: 0.6
	            }
	        });

			jQuery( '.bkap_execute_row_bulk #ajax_img' ).css( 'display', 'block' );

			var bkap_all_bookable_products = jQuery( "#bkap_all_bookable_products" ).val();
			
			var data = {
				bulk_execution_data : 		JSON.stringify( execution_data ),
				bkap_selected_product: 		bkap_executable_products,
		        bkap_all_bookable_products: bkap_all_bookable_products,
				action: 					'bkap_execute_data'
			}

			jQuery( '.bkap-bulk-setting' ).hide(); // Hiding save changes button of the adding booking setting

			jQuery.post( bkap_settings_params.ajax_url, data, function( response ) {

				jQuery( '.bkap-bulk-setting' ).show(); // Displaying the save changes button after the successful response.
				jQuery( '#bulk_setting_availability_rows' ).empty();
				jQuery( '#bkap_executable_products' ).val('').trigger('change');
				jQuery( '.bkap-executable-table' ).unblock();
	            jQuery( '.bkap_execute_row_bulk #ajax_img' ).css( 'display', 'none' );
	            jQuery( '#execute_booking_update_notification' ).css( 'display', 'block' );
	            jQuery( '#execute_booking_update_notification' ).html( '<b>' + response + '</b>' ).fadeOut( 10000 );
	        });		
		}
	});

	var tipText = '';
	$( '.woocommerce-help-tip' ).each( function(i, el) {
		tipText = el.getAttribute( 'data-tip' );
		el.removeAttribute( 'data-tip' );
		el.setAttribute( 'title', tipText );
	});

	//$( '.help_tip, .woocommerce-help-tip' ).addClass( 'fa fa-question-circle tips' ).removeClass( 'help_tip' );	
});