<?php
namespace Worldpay;

class OrderService
{
    public static function createOrder($order)
    {
        //override float conversion and rounding error on amount?
        $orderArray = $order->toArray();
        $orderArray['amount'] = (int)$orderArray['amount'];
        return Connection::getInstance()->sendRequest('orders', json_encode($orderArray), true);
    }

    public static function authorize3DSOrder($orderCode, $responseCode)
    {
        $obj = array_merge(array("threeDSResponseCode" => $responseCode), Utils::getThreeDSShopperObject());
        $json = json_encode($obj);
        return Connection::getInstance()->sendRequest('orders/' . $orderCode, $json, true, 'PUT');
    }

    public static function captureAuthorizedOrder($orderCode, $amount)
    {
        if (!empty($amount) && is_numeric($amount)) {
            $json = json_encode(array('captureAmount'=>"{$amount}"));
        } else {
            $json = false;
        }
        Connection::getInstance()->sendRequest('orders/' . $orderCode . '/capture', $json, !!$json);
    }

    public static function cancelAuthorizedOrder($orderCode)
    {
        Connection::getInstance()->sendRequest('orders/' . $orderCode, false, false, 'DELETE');
    }

    public static function getOrder($orderCode)
    {
        return Connection::getInstance()->sendRequest('orders/' . $orderCode, false, true, 'GET');
    }

    public static function refundOrder($orderCode, $amount)
    {
        if (!empty($amount) && is_numeric($amount)) {
            $json = json_encode(array('refundAmount'=>"{$amount}"));
        } else {
            $json = false;
        }
        Connection::getInstance()->sendRequest('orders/' . $orderCode . '/refund', $json, false);
    }
}
