<?php

/**
 * Bidder placed a bid email notification (plain)
 * 
 * @package Ultimate WooCommerce Auction PRO
 * @author Nitesh Singh 
 * @since 1.0  
 *
 */

if (!defined('ABSPATH')) {
    exit;
}

global $woocommerce;
$product_id = $email->object['product_id']; 
$product = wc_get_product($product_id);
$auction_url = $email->object['url_product'];
$user_name = $email->object['user_name'];
$auction_title = $product->get_title();
$auction_bid_value = wc_price($product->get_uwa_current_bid());
$checkout_url  = add_query_arg( array( 'pay-uwa-auction' => $product_id ), 
	uwa_auction_get_checkout_url());
$paynowbtn = __( 'Pay Now', 'woo_ua');

$user_type = $email->object['user_type'];

	echo $email_heading . "</br>";
	
	if($user_type ==="bidder"){ 
	printf( __( "Hi %s,", 'woo_ua' ), $user_name);
	echo "</br>";
	printf( __( 'Congratulations! You are the winner! of the auction product <a href="%s">%s</a>.', 
		'woo_ua' ),$auction_url,$auction_title);
	echo "</br>";
	printf( __( "Winning bid %s.", 'woo_ua' ),$auction_bid_value);
	echo "</br>";
	printf( __( 'Please, proceed to checkout ,<a href="%s">%s</a>.', 'woo_ua' ),$checkout_url,
		$paynowbtn);
	echo "</br>";
	}
	if($user_type ==="admin"){
		$auction_url = $email->object['edit_url_product']; 
		$userlink = add_query_arg( 'user_id', $email->object['user_id'] , admin_url( 'user-edit.php' ) );
		
		printf( __( "Hi Admin,", 'woo_ua'  ));
		echo "</br>";
		printf( __( "The auction has expired and won by user. Auction url <a href='%s'>%s</a>.", 'woo_ua' ),$auction_url,$auction_title);
		echo "</br>";
		printf( __( "<a href='%s'>%s</a>.", 'woo_ua' ),$userlink,$user_name);
		echo "</br>";
		echo "</br>";
		printf( __( "Winning bid %s.", 'woo_ua' ),$auction_bid_value);
		echo "</br>";
			
		
	}
	
	
	
	echo apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) );