<?php

/**
 * Admin deleted user bid notification (HTML)
 * 
 * @package Ultimate WooCommerce Auction PRO
 * @author Nitesh Singh 
 * @since 1.0  
 *
 */

if (!defined('ABSPATH')) {
    exit;
}
?>
<?php do_action('woocommerce_email_header', $email_heading, $email); ?>

<?php
	$product = $email->object['product'];
	$auction_title = $email->object['product_name'];
	$auction_url = $email->object['url_product'];
	$deleted_bid_value = $email->object['deleted_bid'];
	$thumb_image = $product->get_image( 'thumbnail' );	
	$user_name = $email->object['user_name'];	
?>

<p><?php printf( __( "Hi %s,", "woo_ua" ), $user_name); ?></p>
<p><?php printf( __( "You are receiving this email as auction owner has deleted your bid. Kindly contact admin/owner for further discussion.", "woo_ua" )); ?></p>

<p><?php printf( __( "Here are the details : ", "woo_ua" )); ?></p>

<table>
   	<tr>	 
		<td><?php echo __( 'Image', 'woo_ua' ); ?></td>
		<td><?php echo __( 'Product', 'woo_ua' ); ?></td>
		<td><?php echo __( 'Deleted Bid', 'woo_ua' ); ?></td>	
	</tr>
    <tr>
		<td><?php echo $thumb_image;?></td>
		<td><a href="<?php echo $auction_url ;?>"><?php echo $auction_title; ?></a></td>
		<td><?php echo wc_price($deleted_bid_value);  ?></td>
    </tr>
</table>

<Br><Br>

<?php do_action('woocommerce_email_footer', $email); ?>