<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * UWA_Bidding Class
 *
 * @class  UWA_Bid
 * @package Ultimate WooCommerce Auction PRO
 * @author Nitesh Singh
 * @since 1.0
 *
 */
class UWA_Bid {
	public $bid;

	/**
	 * Constructor for Loads options and hooks in the init method.
	 *
	 */
	public function __construct() {
		add_action('init', array($this, 'init'), 5);
	}

	/**	
	 * Load bid data while Wordpress init and hooks in method.
	 *
	 */
	public function init() {
	}

	/**
	 * Bid Place On Auction Product
	 *
	 * @param string Product id and Bid Value
	 * @return bool
	 * 
	 */
	public function uwa_bidplace( $product_id, $bid ) {
		global $product_data,$wpdb;	
		global $sitepress;

		$proxy_engine = false;
		$history_bid_id = false;
		/* For WPML Support*/
		if (function_exists('icl_object_id') && method_exists($sitepress, 'get_default_language')) {
				
		    $product_id = icl_object_id($product_id	,'product',false, $sitepress->get_default_language());
		}
		
		$product_data = wc_get_product($product_id);
		$post_obj    = get_post( $product_id ); // The WP_Post object
        $post_author = $post_obj->post_author; // <=== The post author ID		
		
		do_action('ultimate_woocommerce_auction_before_place_bid', $product_id, $bid,$product_data);

		if (!is_user_logged_in()) {
			wc_add_notice(sprintf(__('Please Login/Register in to place your bid or buy the product. <a href="%s"  target="_blank"  class="button">Login/Register &rarr;</a>', 'woo_ua'), get_permalink(wc_get_page_id('myaccount'))), 'error');
			return false;
		}
		$current_user = wp_get_current_user();		
		$user_status = get_user_meta($current_user->ID, 'uwa_block_user_status', true);
		if ($user_status =="uwa_block_user_to_bid") {
			wc_add_notice(sprintf(__('You are not allow to place bid please contact to admin.', 'woo_ua')), 'error');
			return false;
		}
		
		if ((apply_filters( 'ultimate_woocommerce_auction_before_place_bid_filter',$product_data, $bid) == false) OR !is_object($product_data) ){
			
			return false;
		}	
		
		$uwa_allow_admin_to_bid = get_option('uwa_allow_admin_to_bid', "no");
		$uwa_allow_owner_to_bid = get_option('uwa_allow_owner_to_bid', "no");
		
		if(is_user_logged_in()){

			/* for administrator role only */
			if(current_user_can('administrator')){
				if($uwa_allow_admin_to_bid == "no" && $current_user->ID == $post_author){
					wc_add_notice(sprintf(__('Sorry, you can not bid on your own auction product.', 'woo_ua')), 'error');
					return false;			
				}
			}
			else{ /* for seller/vendor/other role  */
				if($uwa_allow_owner_to_bid == "no" && $current_user->ID == $post_author){
					wc_add_notice(sprintf(__('Sorry, you can not bid on your own auction product.', 'woo_ua')), 'error');
				return false;
				}
			}
		}		
		
		if ($bid <= 0) {
			wc_add_notice(sprintf(__('Please enter a value greater than 0!', 'woo_ua'), get_permalink(wc_get_page_id('myaccount'))), 'error');
			return false;
		}
		
		/* Check if auction product expired */
		if ($product_data -> is_uwa_expired()) {
			wc_add_notice( sprintf( __( 'This auction &quot;%s&quot; has expired', 'woo_ua' ), $product_data -> get_title()), 'error' );
			return false;
		}

		/* Check if auction product Live or schedule */
		if (!$product_data -> is_uwa_live()) {
			wc_add_notice(sprintf(__('Sorry, the auction for &quot;%s&quot; has not started yet', 
				'woo_ua'), $product_data -> get_title()),'error');
			return false;
		}
		
		/* Check Stock */
		if (!$product_data -> is_in_stock()) {
			wc_add_notice(sprintf(__('You cannot place a bid for &quot;%s&quot; because the product is out of stock.', 'woo_ua'), $product_data -> get_title()),'error');
			return false;
		}
		
		/* Check User Can Max Bid */
		$max_bid_amt = get_option( 'uwa_can_maximum_bid_amt');	
		if(empty($max_bid_amt)){
			$max_bid_amt= 999999999999.99;
		}
		
		if ($bid >= $max_bid_amt) {
			wc_add_notice(sprintf(__('Bid Value must less than %s !', 'woo_ua'), wc_price($max_bid_amt)), 'error');
			return false;
		}
		
		
		
		$auction_type = $product_data->get_uwa_auction_type();
		$auction_bid_value = $product_data->uwa_bid_value();
		$auction_bid_increment = $product_data->get_uwa_auction_bid_increment();
		$auction_current_bid = $product_data->get_uwa_auction_current_bid();
		$auction_current_bider = $product_data->get_uwa_auction_current_bider();
		$auction_high_bid = $product_data->get_uwa_auction_max_bid();
		$auction_high_current_bider = $product_data->get_uwa_auction_max_current_bider();
		$auction_reserved_price = $product_data->get_uwa_auction_reserved_price();
		$auction_bid_count = $product_data->get_uwa_auction_bid_count();
		$uwa_proxy_disable_reserve_price = get_option('uwa_proxy_disable_reserve_price');
		if ($product_data ->get_uwa_auction_silent() == 'yes') { 
			return $this->silent_bidplace_process($product_data, $bid);
		}		
		
		if ($auction_type == 'normal') {			
	
			if ( apply_filters( 'ultimate_woocommerce_auction_minimum_bid_value', $auction_bid_value, $product_data, $bid )<= ($bid )) {
				/* Check for proxy bidding	*/		
				if ($product_data->get_uwa_auction_proxy()) {
			
				if($bid > (float) $auction_high_bid && $auction_current_bider == $current_user->ID ){				  

						update_post_meta($product_id, 'woo_ua_auction_max_bid', $bid );

						// update maxbid in usermeta						
						$maxbid_metakey = "woo_ua_auction_user_max_bid_".$product_id;
						update_user_meta($current_user->ID, $maxbid_metakey, 
							$bid);

					wc_add_notice(sprintf(__('You have changed your maximum bid successfully to %s', 'woo_ua'),wc_price($bid)));

					return false;
				}
				elseif($bid < (float) $auction_high_bid && $auction_current_bider == $current_user->ID ){			  				
					wc_add_notice(sprintf(__('New maximum bid cannot be smaller than old maximum bid.', 'woo_ua'),wc_price($bid)),'error');				
					return false;
				} 	
				else {
				   if ($bid > (float)$auction_high_bid) {					   
					   
						if($uwa_proxy_disable_reserve_price =="yes"){
						
						if ($auction_reserved_price && $product_data->is_uwa_reserve_met() === FALSE) {
							if ($bid  > (float)$auction_reserved_price) {
								$curent_bid = (float)$auction_reserved_price;
							} else {
									$curent_bid = $bid ;
							}
						} else {
								if ($auction_high_bid){
									$temp_bid = (float) $auction_high_bid + (float)$product_data->get_uwa_increase_bid_value();
									$curent_bid = ($bid  < $temp_bid) ? $bid  : $temp_bid ;
								} else {
									$curent_bid = ($bid  < $auction_bid_value) ? $bid  : $auction_bid_value;		
								}							
							}
						}   
						else {
							if ($auction_high_bid){
								$temp_bid = (float) $auction_high_bid + (float)$product_data->get_uwa_increase_bid_value();
								$curent_bid = ($bid  < $temp_bid) ? $bid  : $temp_bid ;
							} else {
								$curent_bid = ($bid  < $auction_bid_value) ? $bid  : $auction_bid_value;		
							}
						} 
						
						if($auction_high_bid > $auction_current_bid){
							$this->history_bid($product_id, $auction_high_bid, get_userdata($auction_high_current_bider), 1);
						}

						$curent_bid =  apply_filters( 
							'ultimate_woocommerce_auction_proxy_curent_bid_value' , 
								$curent_bid ,$product_data,$bid  );
						$outbiddeduser = $auction_current_bider;
						update_post_meta($product_id, 'woo_ua_auction_max_bid', $bid );

						// update maxbid in usermeta						
						$maxbid_metakey = "woo_ua_auction_user_max_bid_".$product_id;
						update_user_meta($current_user->ID, $maxbid_metakey, 
							$bid);

						update_post_meta($product_id, 'woo_ua_auction_max_current_bider', $current_user->ID);
						update_post_meta($product_id, 'woo_ua_auction_current_bid', $curent_bid);
						update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);						
						update_post_meta($product_id, 'woo_ua_auction_bid_count',(int)$auction_bid_count + 1);
						delete_post_meta($product_id, 'woo_ua_auction_current_bid_proxy');
						
						

						$history_bid_id = $this->history_bid($product_id, $curent_bid, $current_user, 0);
							WC()->mailer();
							//$outbiddeduser = $current_user->ID;					
							do_action( 'uwa_pro_outbid_bid_email', $outbiddeduser, $product_data);
							do_action('ultimate_woocommerce_auction_outbid_bid', $product_id,
								$outbiddeduser);
						 
					 
					} 
					elseif($bid  == (float)$auction_high_bid){
					wc_add_notice(sprintf(__('Your amount matches with maximum bidding amount of an user. Kindly check new bid and enter more value.', 'woo_ua'),wc_price($bid)),'error');				
					return false;
					}				
					else {
				
					$proxy_engine = true;					
					$this->history_bid($product_id, $bid , $current_user, 0);
					if($bid  == (float)$auction_high_bid) {
						$proxy_bid = $auction_high_bid;	
					} else {
						
						$proxy_bid =  apply_filters( 'ultimate_woocommerce_auction_proxy_bid_value' , $bid  + $auction_bid_increment , $product_data , $bid );						
					
						
						if ($proxy_bid > (float)$auction_high_bid) 
							$proxy_bid = (float)$auction_high_bid;
					}	

					update_post_meta($product_id, 'woo_ua_auction_current_bid', $proxy_bid);
					update_post_meta($product_id, 'woo_ua_auction_current_bid_proxy', 'yes');
					update_post_meta($product_id, 'woo_ua_auction_current_bider', $auction_high_current_bider);
					update_post_meta($product_id, 'woo_ua_auction_bid_count',(int)$auction_bid_count + 2);					
					$history_bid_id = $this -> history_bid($product_id, $proxy_bid, get_userdata($auction_high_current_bider), 1);					
					wc_add_notice(sprintf(__('You have been outbid.', 'woo_ua'), $product_data -> get_title()),'error');
						WC()->mailer();
						$outbiddeduser = $current_user->ID;					
						do_action( 'uwa_pro_outbid_bid_email', $outbiddeduser, $product_data);
						do_action('ultimate_woocommerce_auction_outbid_bid', $product_id,
							$outbiddeduser);
					
				}
			   }
			
			} else {				
		
				$outbiddeduser = $auction_current_bider;
				$curent_bid = $product_data -> get_uwa_current_bid();
				update_post_meta($product_id, 'woo_ua_auction_current_bid', $bid);
				update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);				
				update_post_meta($product_id, 'woo_ua_auction_bid_count',(int)$auction_bid_count + 1);	
				$history_bid_id = $this -> history_bid($product_id, $bid, $current_user);	
						
				
			}

		} else {
			wc_add_notice(sprintf(__('Please enter a bid value for &quot;%s&quot; greater than the current bid. Your bid must be at least %s ', 'woo_ua'), $product_data -> get_title(),wc_price($product_data -> uwa_bid_value())),'error');
			return false;
		}
		
			
		} elseif ($auction_type == 'reverse') {
				
			if (apply_filters( 'ultimate_woocommerce_auction_minimum_bid_value', $product_data->uwa_bid_value(), $product_data, $bid) >= $bid) {
				
				if ($product_data->get_uwa_auction_proxy() ) {
					
				    
					if ($bid > (float)$auction_high_bid) {

						if ($auction_high_bid){
								$temp_bid = (float) $auction_high_bid - (float)$product_data->get_uwa_increase_bid_value();
								$curent_bid = $bid > $temp_bid ? $bid: $temp_bid ;
								
						  } else {
								$curent_bid = $bid < $auction_bid_value ? $bid: $auction_bid_value;			
						}
							
						if($auction_high_bid > $auction_current_bid){
							$this->history_bid($product_id, $auction_high_bid, get_userdata($auction_high_current_bider), 1);
						}	

						$outbiddeduser = $auction_current_bider;
						update_post_meta($product_id, 'woo_ua_auction_max_bid', $bid);

						// update maxbid in usermeta
						$maxbid_metakey = "woo_ua_auction_user_max_bid_".$product_id;
						update_user_meta($current_user->ID, $maxbid_metakey, 
							$bid);

						update_post_meta($product_id, 'woo_ua_auction_max_current_bider', $current_user->ID);
						update_post_meta($product_id, 'woo_ua_auction_current_bid', $curent_bid);
						update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);
						update_post_meta($product_id, 'woo_ua_auction_bid_count',(int)$auction_bid_count + 1);						
						delete_post_meta($product_id, 'woo_ua_auction_current_bid_proxy');

						$uwa_user_max_bid = $product_data->get_uwa_auction_max_bid();
						$maxbid_metakey = "woo_ua_auction_user_max_bid_".$product_id;
						update_user_meta($current_user->ID, $maxbid_metakey, 
							$uwa_user_max_bid);


						$history_bid_id = $this->history_bid($product_id, $curent_bid, $current_user, 0);
							WC()->mailer();
							//$outbiddeduser = $current_user->ID;
							do_action( 'uwa_pro_outbid_bid_email', $outbiddeduser, $product_data);
							do_action('ultimate_woocommerce_auction_outbid_bid', $product_id,
								$outbiddeduser);
                        
					} else {
					    $proxy_engine = true;
						$this->history_bid($product_id, $bid , $current_user, 0);						
						if($bid  == (float)$auction_high_bid) {
						$proxy_bid = $auction_high_bid;	
						}else {
						$proxy_bid =  apply_filters( 'ultimate_woocommerce_auction_proxy_bid_value' , $bid  - $auction_bid_increment ,$product_data ,$bid );
						
						if ($proxy_bid > (float)$auction_high_bid) 
							$proxy_bid = (float)$auction_high_bid;
						}
						update_post_meta($product_id, 'woo_ua_auction_current_bid', $proxy_bid);
						update_post_meta($product_id, 'woo_ua_auction_current_bid_proxy', 'yes');
						update_post_meta($product_id, 'woo_ua_auction_current_bider', $auction_high_current_bider);					
						update_post_meta($product_id, 'woo_ua_auction_bid_count',(int)$auction_bid_count + 2);
						$history_bid_id = $this -> history_bid($product_id, $proxy_bid, get_userdata($auction_high_current_bider), 1);
						wc_add_notice(sprintf(__('You have been outbid.', 'woo_ua'), $product_data -> get_title()),'error');
							WC()->mailer();
							$outbiddeduser = $current_user->ID;					
							do_action( 'uwa_pro_outbid_bid_email', $outbiddeduser, $product_data);
							do_action('ultimate_woocommerce_auction_outbid_bid', $product_id,
								$outbiddeduser);
						
					}

				} else {
				    $outbiddeduser = $auction_current_bider;
					$curent_bid = $product_data->get_uwa_current_bid();
					update_post_meta($product_id, 'woo_ua_auction_current_bid', $bid);
					update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);					
					update_post_meta($product_id, 'woo_ua_auction_bid_count',(int)$auction_bid_count + 1);
					delete_post_meta($product_id, 'woo_ua_auction_current_bid_proxy');
					$history_bid_id = $this -> history_bid($product_id, $bid, $current_user);
						
					
				}
				
			} else {
				/* wc_add_notice(sprintf(__('Please enter a bid value for &quot;%s&quot; greater than the current bid', 'woo_ua'), $product_data -> get_title()),'error'); */
				wc_add_notice(sprintf(__('Please enter a bid value for &quot;%s&quot; less than the current bid', 'woo_ua'), $product_data -> get_title()),'error');
				return false;
			}	

			 
		} else {
			wc_add_notice(sprintf(__('There was no bid Placed.', 'woo_ua'), $product_data -> get_title()),'error');
			return false;
		}
		do_action('ultimate_woocommerce_auction_place_bid', array( 'product_id' => $product_id ,'log_id' => $history_bid_id ));
		return true;
	}
	
	/**
     * Process For Silent Bid
     *    
     */
	function silent_bidplace_process($product_data, $bid){
		global $wpdb;
		$current_user = wp_get_current_user();
		$product_id = $product_data->get_id();
		$auction_type = $product_data->get_uwa_auction_type();		
		$auction_bid_count = $product_data->get_uwa_auction_bid_count();
		
		if ( ($product_data -> is_uwa_user_biding($current_user->ID) > 0 ) && get_option( 'uwa_restrict_bidder_enable') == 'yes') {	
			wc_add_notice(sprintf(__('You already placed bid for this auction. ', 'woo_ua'), $product_data -> get_title()),'error');
			return false;
		}
			
		if ($auction_type == 'normal') {
			if ( !empty($product_data->get_uwa_auction_start_price())) {

				if ($product_data->get_uwa_auction_start_price()  > $bid)  {
			    	wc_add_notice(sprintf(__('Your bid is smaller for &quot;%s&quot;.Your bid must be at least %s ', 'woo_ua'), $product_data -> get_title(),
						wc_price($product_data->get_uwa_auction_start_price() )),'error');
					return false;
				} 
				
				/* check user bid must be greater than his previous max bid */
				$slient_userid = $current_user->ID;
				/* Select max(bid) from wp_woo_ua_auction_log where userid = 2 and auction_id = 198 */
				$user_max_bid = $wpdb->get_var('SELECT MAX(bid) FROM '.$wpdb->prefix.'woo_ua_auction_log  WHERE auction_id = ' .$product_id .' AND userid = '.$slient_userid);
				/* echo $user_max_bid; */
				 
				if (!empty($user_max_bid) && $user_max_bid >= $bid){										
					if($user_max_bid == $bid){
						wc_add_notice(sprintf(__('Your bid is same as your previous bid %s, Please enter higher bid.', 'woo_ua'),
							wc_price($user_max_bid)), 'error');
							return false;
					}
					elseif($user_max_bid > $bid){						
						wc_add_notice(sprintf(__('Your bid is lower than your previous bid %s, Please enter higher bid.', 'woo_ua'),
							wc_price($user_max_bid)), 'error');
							return false;						
					}					
				} /* end of if - user_max-bid */
			}


			if (  $bid > (float)$product_data -> get_uwa_current_bid()) {
			
				update_post_meta($product_id, 'woo_ua_auction_current_bid', $bid);
				update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);
			}

			update_post_meta($product_id, 'woo_ua_auction_bid_count',(int)$auction_bid_count + 1);
			update_post_meta($product_id, 'woo_ua_auction_last_bid', $bid);			
			$history_bid_id = $this->history_bid($product_id, $bid, $current_user);
			

		} elseif ($auction_type == 'reverse'){

			if ( !empty($product_data->get_uwa_auction_start_price())) {

				if ($product_data->get_uwa_auction_start_price() < $bid)  {
					
					wc_add_notice(sprintf(__('Your bid is greater for &quot;%s&quot;.Your bid must be at least %s ', 'woo_ua'), $product_data -> get_title(),
						wc_price($product_data->get_uwa_auction_start_price() )),'error');
					return false;
				} 
				
				/* check user bid must be less than his previous min bid */
				$slient_userid = $current_user->ID;
				/* Select max(bid) from wp_woo_ua_auction_log where userid = 2 and auction_id = 198 */
				$user_min_bid = $wpdb->get_var('SELECT MIN(bid) FROM '.$wpdb->prefix.'woo_ua_auction_log  WHERE auction_id = ' .$product_id .' AND userid = '.$slient_userid);
				/* echo $user_min_bid; */
				 
				if (!empty($user_min_bid) && $user_min_bid <= $bid){
					if($user_min_bid == $bid){
						wc_add_notice(sprintf(__('Your bid is same as your previous bid %s, Please enter lower bid.', 'woo_ua'),
							wc_price($user_min_bid)), 'error');
							return false;
					}
					elseif($user_min_bid < $bid){
						wc_add_notice(sprintf(__('Your bid is higher than your previous bid %s, Please enter lower bid.', 'woo_ua'),
							wc_price($user_min_bid)), 'error');
							return false;
					}
				} /* end of if - user_min_bid */
			}	


			if ($bid < (float)$product_data -> get_uwa_current_bid()) {
				update_post_meta($product_id, 'woo_ua_auction_current_bid', $bid);
				update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);
			}
			update_post_meta($product_id, 'woo_ua_auction_bid_count',(int)$auction_bid_count + 1);
			update_post_meta($product_id, 'woo_ua_auction_last_bid', $bid);			
			$history_bid_id = $this->history_bid($product_id, $bid, $current_user);
			

		} else{
			wc_add_notice(sprintf(__('There was no bid', 'woo_ua'), $product_data -> get_title()),'error');
			return false;

		}

		do_action('ultimate_woocommerce_auction_place_bid', array( 'product_id' => $product_id ));
		return true;


	}
	
    /**
     * Adding Bid data to history
     *
     * @param string $current_user, int $product_id, $bid, $proxy
     * @return.
     * 
     */
	public function history_bid($product_id, $bid, $current_user, $proxy = 0) {
		
		global $wpdb;
		$history_bid_id = false;
		$history_bid = $wpdb -> insert($wpdb -> prefix . 'woo_ua_auction_log', array('userid' => $current_user->ID, 'auction_id' => $product_id, 'bid' => $bid, 'proxy' => $proxy , 'date' => current_time('mysql')), array('%d', '%d', '%f', '%d' , '%s'));
		if($history_bid){
			$history_bid_id = $wpdb->insert_id;
		}
	
		return $history_bid_id;
	}
	
	
	/* place bid using AJAX */
	/* added - new function  */	
	public function ajax_uwa_bidplace( $product_id, $bid ) {
		global $product_data;		
		global $sitepress;
		$proxy_engine = false;
		$history_bid_id = false;
		/* For WPML Support*/
		if (function_exists('icl_object_id') && method_exists($sitepress, 'get_default_language')) {
				
		    $product_id = icl_object_id($product_id	,'product',false, $sitepress->get_default_language());
		}
		$ret_arr = array();  /* this is for main return */
		
		$product_data = wc_get_product($product_id);
		$post_obj    = get_post( $product_id ); // The WP_Post object
        $post_author = $post_obj->post_author; // <=== The post author ID
		if (!is_user_logged_in()) {
			
			$ret_arr1['error'] = sprintf(__('Please Login/Register in to place your bid or buy the product. <a href="%s"  target="_blank"  class="button">Login/Register &rarr;</a>', 
				'woo_ua'), get_permalink(wc_get_page_id('myaccount')));
			$ret_arr1['status'] = false;
			return $ret_arr1;
		}

		$current_user = wp_get_current_user();		
		$user_status = get_user_meta($current_user->ID, 'uwa_block_user_status', true);
		if ($user_status =="uwa_block_user_to_bid") {
			
			$ret_arr7['error'] = sprintf(__('You are not allow to place bid please contact to admin.', 'woo_ua'));
			$ret_arr7['status'] = false;
			return $ret_arr7;
			
		}
		
		$uwa_allow_admin_to_bid = get_option('uwa_allow_admin_to_bid', "no");
		$uwa_allow_owner_to_bid = get_option('uwa_allow_owner_to_bid', "no");
		
		if(is_user_logged_in()){

			/* for administrator role only */
			if(current_user_can('administrator')){
				if($uwa_allow_admin_to_bid == "no" && $current_user->ID == $post_author){
					$ret_arr14['error'] = sprintf(__('Sorry, you can not bid on your own auction product.', 'woo_ua'));
					$ret_arr14['status'] = false;
					return $ret_arr14;
				}
			}
			else{ /* for seller/vendor/other role  */
				if($uwa_allow_owner_to_bid == "no" && $current_user->ID == $post_author){
					$ret_arr15['error'] = sprintf(__('Sorry, you can not bid on your own auction product.', 'woo_ua'));
					$ret_arr15['status'] = false;
					return $ret_arr15;
				}
			}
		}

		
		
		if ($bid <= 0) {
			/*_notice(sprintf(__('Please enter a value greater than 0!', 'woo_ua'), get_permalink(wc_get_page_id('myaccount'))), 'error');*/

			$ret_arr2['error'] = sprintf(__('Please enter a value greater than 0!', 'woo_ua'), get_permalink(wc_get_page_id('myaccount')));

			$ret_arr2['status'] = false;
			return $ret_arr2;
		}
		
		/* Check if auction product expired */
		if ($product_data -> is_uwa_expired()) {
			/*_notice( sprintf( __( 'This auction &quot;%s&quot; has expired', 'woo_ua' ), $product_data -> get_title()), 'error' );*/
			$ret_arr3['error'] = sprintf( __( 'This auction &quot;%s&quot; has expired', 
				'woo_ua' ), $product_data -> get_title());
			$ret_arr3['status'] = false;
			return $ret_arr3;	
		}

		/* Check if auction product Live or schedule */
		if (!$product_data -> is_uwa_live()) {
			/*_notice(sprintf(__('Sorry, the auction for &quot;%s&quot; has not started yet', 'woo_ua'), $product_data -> get_title()),'error');*/
			$ret_arr4['error'] = sprintf(__('Sorry, the auction for &quot;%s&quot; has not started yet', 'woo_ua'), $product_data -> get_title());
			$ret_arr4['status'] = false;
			return $ret_arr4;	
		}
		
		/* Check Stock */
		if (!$product_data -> is_in_stock()) {
			/*_notice(sprintf(__('You cannot place a bid for &quot;%s&quot; because the product is out of stock.', 'woo_ua'), $product_data -> get_title()),'
				error');*/
			$ret_arr5['error'] = sprintf(__('You cannot place a bid for &quot;%s&quot; because the product is out of stock.', 'woo_ua'), $product_data -> get_title());
			$ret_arr5['status'] = false;
			return $ret_arr5;	
		}
		
		/* Check User Can Max Bid */
		$max_bid_amt = get_option( 'uwa_can_maximum_bid_amt');
		if(empty($max_bid_amt)){
			$max_bid_amt= 999999999999.99;
		}
		
		if ($bid >= $max_bid_amt) {
			/*_notice(sprintf(__('Bid Value must less than %s !', 'woo_ua'), wc_price($max_bid_amt)), 'error');*/
			$ret_arr6['error'] = sprintf(__('Bid Value must less than %s !', 'woo_ua'), wc_price($max_bid_amt));
			$ret_arr6['status'] = false;
			return $ret_arr6;
		}

		$current_user = wp_get_current_user();
		$auction_type = $product_data->get_uwa_auction_type();
		$auction_bid_value = $product_data->uwa_bid_value();
		$auction_bid_increment = $product_data->get_uwa_auction_bid_increment();
		$auction_current_bid = $product_data->get_uwa_auction_current_bid();
		$auction_current_bider = $product_data->get_uwa_auction_current_bider();
		$auction_high_bid = $product_data->get_uwa_auction_max_bid();
		$auction_high_current_bider = $product_data->get_uwa_auction_max_current_bider();
		$auction_reserved_price = $product_data->get_uwa_auction_reserved_price();
		$auction_bid_count = $product_data->get_uwa_auction_bid_count();
		$uwa_proxy_disable_reserve_price = get_option('uwa_proxy_disable_reserve_price');
		if ($product_data ->get_uwa_auction_silent() == 'yes') { 

			/* here  change function name */	
			return $this->ajax_silent_bidplace_process($product_data, $bid);
		}		
		
		if ($auction_type == 'normal') {			
	
			if ( apply_filters( 'ultimate_woocommerce_auction_minimum_bid_value', 
				$auction_bid_value, $product_data, $bid )<= ($bid )) {
				/* Check for proxy bidding	*/		
				if ($product_data->get_uwa_auction_proxy()) {
			
				if($bid > (float) $auction_high_bid && $auction_current_bider == 
					$current_user->ID ){				  

						update_post_meta($product_id, 'woo_ua_auction_max_bid', $bid );

						// update maxbid in usermeta						
						$maxbid_metakey = "woo_ua_auction_user_max_bid_".$product_id;
						update_user_meta($current_user->ID, $maxbid_metakey, 
							$bid);

					/*_notice(sprintf(__('You have changed your maximum bid successfully to %s', 'woo_ua'),wc_price($bid)));*/
					$ret_arr7['success'] = sprintf(__('You have changed your maximum bid successfully to %s', 'woo_ua'), wc_price($bid));
					$ret_arr7['status'] = false;
					return $ret_arr7;
				}
				elseif($bid < (float) $auction_high_bid && $auction_current_bider == $current_user->ID ){			  				
					/*_notice(sprintf(__('New maximum bid cannot be smaller than old maximum bid.', 'woo_ua'),wc_price($bid)),'error');*/				
					$ret_arr8['error'] = sprintf(__('New maximum bid cannot be smaller than old maximum bid.', 'woo_ua'), wc_price($bid));
					$ret_arr8['status'] = false;
					return $ret_arr8;
				} 	
				else {
				   if ($bid > (float)$auction_high_bid) {					   
					   
						if($uwa_proxy_disable_reserve_price =="yes"){
						
						if ($auction_reserved_price && $product_data->is_uwa_reserve_met() === FALSE) {
							if ($bid  > (float)$auction_reserved_price) {
								$curent_bid = (float)$auction_reserved_price;
							} else {
									$curent_bid = $bid ;
							}
						} else {
								if ($auction_high_bid){
									$temp_bid = (float) $auction_high_bid + (float)$product_data->get_uwa_increase_bid_value();
									$curent_bid = ($bid  < $temp_bid) ? $bid  : $temp_bid ;
								} else {
									$curent_bid = ($bid  < $auction_bid_value) ? $bid  : $auction_bid_value;		
								}							
							}
						}   
						else {
							if ($auction_high_bid){
								$temp_bid = (float) $auction_high_bid + (float)$product_data->get_uwa_increase_bid_value();
								$curent_bid = ($bid  < $temp_bid) ? $bid  : $temp_bid ;
							} else {
								$curent_bid = ($bid  < $auction_bid_value) ? $bid  : $auction_bid_value;		
							}
						} 
						
						if($auction_high_bid > $auction_current_bid){
							$this->history_bid($product_id, $auction_high_bid, get_userdata($auction_high_current_bider), 1);
						}

						$curent_bid =  apply_filters( 
							'ultimate_woocommerce_auction_proxy_curent_bid_value' , 
								$curent_bid ,$product_data, $bid  );
						$outbiddeduser = $auction_current_bider;
						update_post_meta($product_id, 'woo_ua_auction_max_bid', $bid );

						// update maxbid in usermeta						
						$maxbid_metakey = "woo_ua_auction_user_max_bid_".$product_id;
						update_user_meta($current_user->ID, $maxbid_metakey, 
							$bid);

						update_post_meta($product_id, 'woo_ua_auction_max_current_bider', 
							$current_user->ID);
						update_post_meta($product_id, 'woo_ua_auction_current_bid', 
							$curent_bid);
						update_post_meta($product_id, 'woo_ua_auction_current_bider', 
							$current_user->ID);
						update_post_meta($product_id, 'woo_ua_auction_bid_count', absint(
							$auction_bid_count + 1));
						delete_post_meta($product_id, 'woo_ua_auction_current_bid_proxy');
												

						$history_bid_id = $this->history_bid($product_id, $curent_bid, 
							$current_user, 0);
							WC()->mailer();
							//$outbiddeduser = $current_user->ID;					
							do_action( 'uwa_pro_outbid_bid_email', $outbiddeduser, 
								$product_data);
							do_action('ultimate_woocommerce_auction_outbid_bid', $product_id,
								$outbiddeduser);						 
					 
					} 
					elseif($bid  == (float)$auction_high_bid){
						/*_notice(sprintf(__('Your amount matches with maximum bidding amount of an user. Kindly check new bid and enter more value.', 'woo_ua'), wc_price($bid)), 'error');*/

						$ret_arr9['error'] = sprintf(__('Your amount matches with maximum bidding amount of an user. Kindly check new bid and enter more value.', 'woo_ua'), wc_price($bid));
						
						$ret_arr9['status'] = false;
						return $ret_arr9;
					}				
					else {
				
					$proxy_engine = true;
					$this->history_bid($product_id, $bid , $current_user, 0);
					if($bid  == (float)$auction_high_bid) {
						$proxy_bid = $auction_high_bid;	
					} else {
						$proxy_bid =  apply_filters( 
							'ultimate_woocommerce_auction_proxy_bid_value' , $bid  + 
							$auction_bid_increment ,$product_data ,$bid );
						
						if ($proxy_bid > (float)$auction_high_bid) 
							$proxy_bid = (float)$auction_high_bid;
					}	

					update_post_meta($product_id, 'woo_ua_auction_current_bid', $proxy_bid);
					update_post_meta($product_id, 'woo_ua_auction_current_bid_proxy', 'yes');
					update_post_meta($product_id, 'woo_ua_auction_current_bider', $auction_high_current_bider);
					update_post_meta($product_id, 'woo_ua_auction_bid_count', absint($auction_bid_count + 2));
					$history_bid_id = $this -> history_bid($product_id, $proxy_bid, get_userdata($auction_high_current_bider), 1);					
					/*_notice(sprintf(__('You have been outbid.', 'woo_ua'), $product_data -> get_title()),'error');*/

					$ret_arr['error'] = sprintf(__('You have been outbid.', 'woo_ua'), 
						$product_data -> get_title());

						WC()->mailer();
						$outbiddeduser = $current_user->ID;					
						do_action( 'uwa_pro_outbid_bid_email', $outbiddeduser, 
							$product_data);
						do_action('ultimate_woocommerce_auction_outbid_bid', $product_id,
								$outbiddeduser);
					
				}
			   }
			
			} else {				
		
				$outbiddeduser = $auction_current_bider;
				$curent_bid = $product_data -> get_uwa_current_bid();
				update_post_meta($product_id, 'woo_ua_auction_current_bid', $bid);
				update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);
				update_post_meta($product_id, 'woo_ua_auction_bid_count', absint($auction_bid_count + 1));				
				$history_bid_id = $this -> history_bid($product_id, $bid, $current_user);
				
			}

		} else {
			/*_notice(sprintf(__('Please enter a bid value for &quot;%s&quot; greater than the current bid. Your bid must be at least %s ', 'woo_ua'), 
				$product_data -> get_title(),wc_price($product_data -> uwa_bid_value())),
				'error');*/
			$ret_arr10['error'] =  sprintf(__('Please enter a bid value for &quot;%s&quot; greater than the current bid. Your bid must be at least %s ', 'woo_ua'), 
				$product_data -> get_title(), wc_price($product_data -> uwa_bid_value()));
			$ret_arr10['status'] = false;
			return $ret_arr10;
		}
		
			
		} elseif ($auction_type == 'reverse') {
				
			if (apply_filters( 'ultimate_woocommerce_auction_minimum_bid_value', 
				$product_data->uwa_bid_value(), $product_data, $bid) >= $bid) {
				
				if ($product_data->get_uwa_auction_proxy() ) {
					
				    
					if ($bid > (float)$auction_high_bid) {

						if ($auction_high_bid){
								$temp_bid = (float) $auction_high_bid - (float)$product_data->get_uwa_increase_bid_value();
								$curent_bid = $bid > $temp_bid ? $bid: $temp_bid ;
								
						  } else {
								$curent_bid = $bid < $auction_bid_value ? $bid: $auction_bid_value;			
						}
							
						if($auction_high_bid > $auction_current_bid){
							$this->history_bid($product_id, $auction_high_bid, get_userdata($auction_high_current_bider), 1);
						}	

						$outbiddeduser = $auction_current_bider;
						update_post_meta($product_id, 'woo_ua_auction_max_bid', $bid);

						// update maxbid in usermeta
						$maxbid_metakey = "woo_ua_auction_user_max_bid_".$product_id;
						update_user_meta($current_user->ID, $maxbid_metakey, 
							$bid);

						update_post_meta($product_id, 'woo_ua_auction_max_current_bider', $current_user->ID);
						update_post_meta($product_id, 'woo_ua_auction_current_bid', $curent_bid);
						update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);
						update_post_meta($product_id, 'woo_ua_auction_bid_count', absint($auction_bid_count + 1));
						delete_post_meta($product_id, 'woo_ua_auction_current_bid_proxy');

						$uwa_user_max_bid = $product_data->get_uwa_auction_max_bid();
						$maxbid_metakey = "woo_ua_auction_user_max_bid_".$product_id;
						update_user_meta($current_user->ID, $maxbid_metakey, 
							$uwa_user_max_bid);


						$history_bid_id = $this->history_bid($product_id, $curent_bid, 
							$current_user, 0);
							WC()->mailer();
							//$outbiddeduser = $current_user->ID;
							do_action( 'uwa_pro_outbid_bid_email', $outbiddeduser, 
								$product_data);
							do_action('ultimate_woocommerce_auction_outbid_bid', $product_id ,
								$outbiddeduser);
                        
					} else {
					    $proxy_engine = true;
						$this->history_bid($product_id, $bid , $current_user, 0);				
						if($bid  == (float)$auction_high_bid) {
							$proxy_bid = $auction_high_bid;	
						}else {
							$proxy_bid =  apply_filters( 'ultimate_woocommerce_auction_proxy_bid_value' , $bid  - 
								$auction_bid_increment ,$product_data ,$bid );
						
						if ($proxy_bid > (float)$auction_high_bid) 
							$proxy_bid = (float)$auction_high_bid;
						}
						update_post_meta($product_id, 'woo_ua_auction_current_bid', $proxy_bid);
						update_post_meta($product_id, 'woo_ua_auction_current_bid_proxy', 'yes');
						update_post_meta($product_id, 'woo_ua_auction_current_bider', $auction_high_current_bider);
						update_post_meta($product_id, 'woo_ua_auction_bid_count', absint($auction_bid_count + 2));
						$history_bid_id = $this -> history_bid($product_id, $proxy_bid, get_userdata($auction_high_current_bider), 1);

						/*_notice(sprintf(__('You have been outbid.', 'woo_ua'), 
							$product_data -> get_title()),'error');*/

						$ret_arr['error'] = sprintf(__('You have been outbid.', 'woo_ua'), $product_data -> get_title());

							WC()->mailer();
							$outbiddeduser = $current_user->ID;					
							do_action( 'uwa_pro_outbid_bid_email', $outbiddeduser, $product_data);
							do_action('ultimate_woocommerce_auction_outbid_bid', $product_id ,
								$outbiddeduser);
						
					}

				} else {
				    $outbiddeduser = $auction_current_bider;
					$curent_bid = $product_data->get_uwa_current_bid();
					update_post_meta($product_id, 'woo_ua_auction_current_bid', $bid);
					update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);
					update_post_meta($product_id, 'woo_ua_auction_bid_count', absint($auction_bid_count + 1));
					delete_post_meta($product_id, 'woo_ua_auction_current_bid_proxy');
					$history_bid_id = $this -> history_bid($product_id, $bid, $current_user);
				}
				
			} else {
				/* _notice(sprintf(__('Please enter a bid value for &quot;%s&quot; greater than the current bid', 'woo_ua'), $product_data -> get_title()),'error'); */
				$ret_arr11['error'] = sprintf(__('Please enter a bid value for &quot;%s&quot; less than the current bid', 'woo_ua'), $product_data -> get_title());
				$ret_arr11['status'] = false;
				return $ret_arr11;
			}	

			 
		} else {
			/*_notice(sprintf(__('There was no bid Placed.', 'woo_ua'), $product_data -> get_title()),'error');*/

			$ret_arr12['error'] = sprintf(__('There was no bid Placed.', 'woo_ua'), $product_data -> get_title());
			$ret_arr12['status'] = false;
			return $ret_arr12;
			
		}
		do_action('ultimate_woocommerce_auction_place_bid', array( 'product_id' => $product_id ,'log_id' => $history_bid_id ));

		/*return true;*/
		$ret_arr['status'] = true;
		return $ret_arr;
		
	} /* end of function - ajax_uwa_bidplace */


	/**
     * Process For Silent Bid
     *    
     */
	/* here we added - new function  */	
	function ajax_silent_bidplace_process($product_data, $bid){
		global $wpdb;

		$sret_arr = array();
		$current_user = wp_get_current_user();
		$product_id = $product_data->get_id();
		$auction_type = $product_data->get_uwa_auction_type();
		$auction_bid_count = $product_data->get_uwa_auction_bid_count();
		
		if ( ($product_data -> is_uwa_user_biding($current_user->ID) > 0 ) && 
			get_option( 'uwa_restrict_bidder_enable') == 'yes') {
			/*_notice(sprintf(__('You already placed bid for this auction. ', 'woo_ua'), $product_data -> get_title()),'error');*/
			$sret_arr1['error'] = sprintf(__('You already placed bid for this auction. ', 
				'woo_ua'), $product_data -> get_title());
			$sret_arr1['status'] = false;
			return $sret_arr1;
		}
			
		if ($auction_type == 'normal') {
			if ( !empty($product_data->get_uwa_auction_start_price())) {

				if ($product_data->get_uwa_auction_start_price()  > $bid)  {
			    	/*_notice(sprintf(__('Your bid is smaller for &quot;%s&quot;.Your bid must be at least %s ', 'woo_ua'), $product_data -> get_title(),
						wc_price($product_data->get_uwa_auction_start_price() )),'error');*/
			    	$sret_arr2['error'] = sprintf(__('Your bid is smaller for &quot;%s&quot;.Your bid must be at least %s ', 'woo_ua'), 
			    		$product_data -> get_title(),
						wc_price($product_data->get_uwa_auction_start_price() ));
					$sret_arr2['status'] = false;
					return $sret_arr2;
				} 
				
				/* check user bid must be greater than his previous max bid */
				$slient_userid = $current_user->ID;
				/* Select max(bid) from wp_woo_ua_auction_log where userid = 2 and auction_id = 198 */
				$user_max_bid = $wpdb->get_var('SELECT MAX(bid) FROM '.$wpdb->prefix.'woo_ua_auction_log  WHERE auction_id = ' .$product_id .' AND userid = '.$slient_userid);
				/* echo $user_max_bid; */
				 
				if (!empty($user_max_bid) && $user_max_bid >= $bid){										
					if($user_max_bid == $bid){
						/*_notice(sprintf(__('Your bid is same as your previous bid %s, Please enter higher bid.', 'woo_ua'),
							wc_price($user_max_bid)), 'error');*/

						$sret_arr3['error'] = sprintf(__('Your bid is same as your previous bid %s, Please enter higher bid.', 'woo_ua'),
							wc_price($user_max_bid));
						$sret_arr3['status'] = false;					
						return $sret_arr3;
					}
					elseif($user_max_bid > $bid){						
						/*_notice(sprintf(__('Your bid is lower than your previous bid %s, Please enter higher bid.', 'woo_ua'),
							wc_price($user_max_bid)), 'error');*/
						$sret_arr4['error'] = sprintf(__('Your bid is lower than your previous bid %s, Please enter higher bid.', 'woo_ua'),
							wc_price($user_max_bid));
						$sret_arr4['status'] = false;					
						return $sret_arr4;
							
					}					
				} /* end of if - user_max-bid */
			}


			if (  $bid > (float)$product_data -> get_uwa_current_bid()) {
			
				update_post_meta($product_id, 'woo_ua_auction_current_bid', $bid);
				update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);
			}

			update_post_meta($product_id, 'woo_ua_auction_bid_count', absint($auction_bid_count + 1));
			update_post_meta($product_id, 'woo_ua_auction_last_bid', $bid);			
			$history_bid_id = $this->history_bid($product_id, $bid, $current_user);
			

		} elseif ($auction_type == 'reverse'){

			if ( !empty($product_data->get_uwa_auction_start_price())) {

				if ($product_data->get_uwa_auction_start_price() < $bid)  {
					
					/*_notice(sprintf(__('Your bid is greater for &quot;%s&quot;.Your bid must be at least %s ', 'woo_ua'), $product_data -> get_title(),
						wc_price($product_data->get_uwa_auction_start_price() )),'error');*/
					$sret_arr5['error'] = sprintf(__('Your bid is greater for &quot;%s&quot;.Your bid must be at least %s ', 'woo_ua'), $product_data -> get_title(),
						wc_price($product_data->get_uwa_auction_start_price() ));
					$sret_arr5['status'] = false;					
					return $sret_arr5;
						
				} 
				
				/* check user bid must be less than his previous min bid */
				$slient_userid = $current_user->ID;
				/* Select max(bid) from wp_woo_ua_auction_log where userid = 2 and auction_id = 198 */
				$user_min_bid = $wpdb->get_var('SELECT MIN(bid) FROM '.$wpdb->prefix.'woo_ua_auction_log  WHERE auction_id = ' .$product_id .' AND userid = '.$slient_userid);
				/* echo $user_min_bid; */
				 
				if (!empty($user_min_bid) && $user_min_bid <= $bid){
					if($user_min_bid == $bid){
						/*_notice(sprintf(__('Your bid is same as your previous bid %s, Please enter lower bid.', 'woo_ua'),
							wc_price($user_min_bid)), 'error');*/
						$sret_arr6['error'] = sprintf(__('Your bid is same as your previous bid %s, Please enter lower bid.', 'woo_ua'),
							wc_price($user_min_bid));
						$sret_arr6['status'] = false;					
						return $sret_arr6;
					}
					elseif($user_min_bid < $bid){
						/*_notice(sprintf(__('Your bid is higher than your previous bid %s, Please enter lower bid.', 'woo_ua'),
							wc_price($user_min_bid)), 'error');*/
						$sret_arr7['error'] = sprintf(__('Your bid is higher than your previous bid %s, Please enter lower bid.', 'woo_ua'),
							wc_price($user_min_bid));
						$sret_arr7['status'] = false;					
						return $sret_arr7;
							
					}
				} /* end of if - user_min_bid */
			}	

			if ($bid < (float)$product_data -> get_uwa_current_bid()) {
				update_post_meta($product_id, 'woo_ua_auction_current_bid', $bid);
				update_post_meta($product_id, 'woo_ua_auction_current_bider', $current_user->ID);
			}
					
			update_post_meta($product_id, 'woo_ua_auction_bid_count', absint($auction_bid_count + 1));
			update_post_meta($product_id, 'woo_ua_auction_last_bid', $bid);			
			$history_bid_id = $this->history_bid($product_id, $bid, $current_user);
			

		} else{
			/*_notice(sprintf(__('There was no bid', 'woo_ua'), $product_data -> get_title()),'error');*/

			$sret_arr8['error'] = sprintf(__('There was no bid', 'woo_ua'), $product_data -> get_title());
			$sret_arr8['status'] = false;
			return $sret_arr8;

		}

		do_action('ultimate_woocommerce_auction_place_bid', array( 'product_id' => 
			$product_id ));

		$sret_arr['status'] = true;
		return $sret_arr;


	} /* end of function -  ajax_silent_bidplace_process */ 
}