<?php

if (!defined('ABSPATH')) {
	exit;
}

if ( !class_exists( 'UWA_Email_Auction_Winner' ) ) {

    /**
     *
     * @class UWA_Email_Auction_Winner
     * @package Ultimate WooCommerce Auction PRO
     * @author Nitesh Singh 
     * @since 1.0 
     *
     */
    class UWA_Email_Auction_Winner extends WC_Email {
	
        /**
         * Define email related information
         *         
         */
        public function __construct() {
            $this->id = 'woo_ua_email_auction_winner';
            $this->title = __( 'Ultimate Auction - Auction Won', 'woo_ua' );
            $this->customer_email = true;           
            $this->description = __( '​Email ​Can be sent to the bidder after winning an auction', 
                'woo_ua' );
            $this->heading = __( 'Congratulations! You have won an auction on {site_title}', 'woo_ua' );
            $this->subject = __( 'Congratulations! You have won an auction on {site_title}', 'woo_ua' );            
			$this->template_html = 'emails/auction-winner.php';
            $this->template_plain = 'emails/plain/auction-winner.php'; 
			$this->uwa_admin_won_enabled = $this->get_option( 'uwa_admin_won_enabled','yes');
			$this->uwa_bidders_won_enabled = $this->get_option( 'uwa_bidders_won_enabled','yes');
            /* Trigger on new paid orders */
            add_action( 'woo_ua_auctions_won_email_bidder', array( $this, 'trigger' ), 10, 2 );

            /* Call parent constructor to load any other defaults not explicity defined here */
            parent::__construct();
			if ($this->uwa_admin_won_enabled ===  'yes') {
					
					$this->recipient = $this->get_option( 'recipient' );
					if ( ! $this->recipient ){
						$this->recipient = get_option( 'admin_email' );
					}
				}
        }

        /**
         * Define trigger
         *
         * @param int $product_id, int $winneruser
         *
         */
        public function trigger($product_id, $winneruser) {
			
            /* Check is email enable or not */
            if ( !$this->is_enabled() ) {
                return;
            }	
			
            $user = get_user_by('id', $winneruser);
            $url_product = get_permalink($product_id);
			
			$recipients1 =array();
            $recipients2 =array();
				
			if ($this->uwa_bidders_won_enabled ===  'yes') {				
				$this->object = array(
                'user_email'    => $user->data->user_email,
                'user_name'     => $user->user_login, 
                'product_id'    => $product_id,
                'url_product'   => $url_product,
				'user_type'   => "bidder",
				);	
				
				$recipients2[]= $this->object['user_email'];
				if ( count( $recipients2 ) > 0 ) {
				foreach ( $recipients2 as $key=>$value) {	
				
				$this->send( $value, $this->get_subject(),$this->get_content(),$this->get_headers(),$this->get_attachments() );
				}
				}

			}
			
			if ($this->uwa_admin_won_enabled ===  'yes') {
				
				
				$url_product = get_edit_post_link($product_id);
            
					$this->object = array(
						'user_email'    => $user->data->user_email,
						'user_name'     => $user->user_login, 
						'user_id'     => $winneruser, 
						'product_id'    => $product_id,
						'edit_url_product'   => $url_product,
						'user_type'   => "admin",
					);
					
				$recipients1[]= $this->get_recipient();

				if ( count( $recipients1 ) > 0 ) {
				foreach ( $recipients1 as $key=>$value) {	
				
						$this->send( $value, $this->get_subject(),$this->get_content(),$this->get_headers(),$this->get_attachments() );
					}
				}
				
			}
			
			
		}

        /**
         * Get content html 
         *
         * @return array
         *
         */
        public function get_content_html() {
            return wc_get_template_html( $this->template_html, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => false,
                    'email'         => $this
                ),'', UW_AUCTION_PRO_WC_TEMPLATE);
        }

        /**
         * Get content plain 
         *
         * @return array
         *
         */
        public function get_content_plain() {
            return wc_get_template_html( $this->template_plain, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => true,
                    'email'         => $this
                ),'', UW_AUCTION_PRO_WC_TEMPLATE);
        }

        /**
         * Add form fields for email        
         *
         */
        public function init_form_fields() {
            $this->form_fields = array(
                'enabled' => array(
                    'title'   => __( 'Enable/Disable', 'woocommerce' ),
                    'type'    => 'checkbox',
                    'label'   => __( 'Enable this email notification', 'woocommerce' ),
                    'default' => 'yes'
                ),
				'uwa_admin_won_enabled' => array(
				'title' 		=> __( 'Enabled for Admin.', 'woo_ua' ),
				'type' 			=> 'checkbox',
				'label' 		=> __( 'Send won email notification to admin when Bidder won auction.', 'woo_ua' ),
				'default' 		=> 'yes'
			     ),
				  'uwa_bidders_won_enabled' => array(
				'title' 		=> __( 'Enabled for Bidder.', 'woo_ua' ),
				'type' 			=> 'checkbox',
				'label' 		=> __( 'Send won email notification to Bidder when Bidder won auction.', 'woo_ua' ),
				'default' 		=> 'yes'
			     ),
                  'recipient'    => array(
                    'title'       => __( 'Recipient', 'woocommerce' ),
                    'type'        => 'text',
                    'description' => sprintf( __( 'Enter recipients (comma separated) for admin email.Leave blank to use the default subject:- <code>%s</code>.', 'woo_ua' ), esc_attr( get_option('admin_email') ) ),
                    'placeholder' => '',
                    'default'     => '',
                    'user_type'   => 'admin',
                    'desc_tip'    => true
                ),
                'subject'    => array(
                    'title'       => __( 'Subject', 'woocommerce' ),
                    'type'        => 'text',
                    'description' => sprintf( __( 'Enter the subject of the email that is sent to the bidder after winning an auction. Leave blank to use the default subject: <code>%s</code>.', 'woo_ua' ), $this->subject ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'heading'    => array(
                    'title'       => __( 'Email Heading', 'woocommerce' ),
                    'type'        => 'text',
                    'description' => sprintf( __( 'Enter the Heading of the email that is sent to the bidder after winning an auction. Leave blank to use the default heading: <code>%s</code>.', 'woo_ua' ), $this->heading ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'email_type' => array(
                    'title'       => __( 'Email type', 'woocommerce' ),
                    'type'        => 'select',
                    'description' => __( 'Choose which format of email to send.', 'woocommerce' ),
                    'default'     => 'html',
                    'class'       => 'email_type wc-enhanced-select',
                    'options'     => $this->get_email_type_options(),
                    'desc_tip'    => true
                )
            );
        }

    } /* end of class */
} /* end of if - class exists */

return new UWA_Email_Auction_Winner();