<?php

if (!defined('ABSPATH')) {
	exit;
}

if ( !class_exists( 'UWA_Email_Auction_Remind_to_Pay' ) ) {

    /**
     *
     * @class UWA_Email_Auction_Remind_to_Pay
     * @package Ultimate WooCommerce Auction PRO
     * @author Nitesh Singh 
     * @since 1.0 
     *
     */
    class UWA_Email_Auction_Remind_to_Pay extends WC_Email {
	
        /**
         * Define email related information
         *         
         */
        public function __construct() {
            $this->id = 'woo_ua_email_auction_remind_to_pay';
            $this->title = __( 'Ultimate Auction - Payment Reminder', 'woo_ua' );
            $this->customer_email = true;           
            $this->description = __( '​Email ​Can be sent to the bidder after winning an auction', 
                'woo_ua' );
            $this->heading = __( 'Congratulations! You have won an auction on {site_title}', 'woo_ua' );
            $this->subject = __( 'Congratulations! You have won an auction on {site_title}', 'woo_ua' );            
			$this->template_html = 'emails/auction-remind-to-pay.php';
            $this->template_plain = 'emails/plain/auction-remind-to-pay.php'; 
			$this->uwa_interval			= '5';
			$this->uwa_stopsending      = '4';
			
            /* Trigger on new paid orders */
            add_action( 'uwa_email_remind_to_pay_notification', array( $this, 'trigger' ), 10, 2 );

            /* Call parent constructor to load any other defaults not explicity defined here */
            parent::__construct();
        }

        /**
         * Define trigger
         *
         * @param int $product_id
         *
         */
        public function trigger( $product_id ) {
			
            /* Check is email enable or not */
            if ( !$this->is_enabled() ) {
                return;
            }	
			
			if ( $product_id ) {
				$product_data = wc_get_product(  $product_id );
				
				$winneruser = absint( get_post_meta( $product_id, 'woo_ua_auction_current_bider', true ) );
			
				if ( $product_data ) {
					if ( $winneruser ) {
							$winneruser_data 		= new WP_User( $winneruser );
							$winneruser_email	= $winneruser_data->user_email;
							$winneruser_login	= $winneruser_data->user_email;
							
					}
						
					
				}
			
			}	
			
			$this->object = array(
                'user_email'    => $winneruser_email,
                'user_name'     => $winneruser_login, 
                'product_id'    => $product_id,
               
            );

            $this->send( $this->object[ 'user_email' ],
                $this->get_subject(),
                $this->get_content(),
                $this->get_headers(),
                $this->get_attachments() );
		}

        /**
         * Get content html 
         *
         * @return array
         *
         */
        public function get_content_html() {
            return wc_get_template_html( $this->template_html, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => false,
                    'email'         => $this
                ),'', UW_AUCTION_PRO_WC_TEMPLATE);
        }

        /**
         * Get content plain 
         *
         * @return array
         *
         */
        public function get_content_plain() {
            return wc_get_template_html( $this->template_plain, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => true,
                    'email'         => $this
                ),'', UW_AUCTION_PRO_WC_TEMPLATE);
        }

        /**
         * Add form fields for email        
         *
         */
        public function init_form_fields() {
            $this->form_fields = array(
                'enabled' => array(
                    'title'   => __( 'Enable/Disable', 'woocommerce' ),
                    'type'    => 'checkbox',
                    'label'   => __( 'Enable this email notification', 'woocommerce' ),
                    'default' => 'yes'
                ),				
				'uwa_interval' => array(
				'title' 		=> __( 'Interval in Days.', 'woo_ua' ),
				'type' 			=> 'number',
				'custom_attributes' => array('step' 	=> '1',		'min'	=> '0'),
				'description' 	=> sprintf( __( 'Set reminder interval in days default is <code>%s</code>.', 'woo_ua' ), $this->uwa_interval ),
				'placeholder' 	=> '',
				'default' 		=> ''
			 ),
			   'uwa_stopsending' => array(
				'title' 		=> __( 'Number of reminder mail.', 'woo_ua' ),
				'type' 			=> 'number',
				'custom_attributes' => array('step' 	=> '1',		'min'	=> '0'),
				'description' 	=> sprintf( __( 'if sent numbers of mail stop mail to remind. default is <code>%s</code>.', 'woo_ua' ), $this->uwa_stopsending ),
				'placeholder' 	=> '',
				'default' 		=> ''
			 ),
				
                'subject'    => array(
                    'title'       => __( 'Subject', 'woocommerce' ),
                    'type'        => 'text',
                    'description' => sprintf( __( 'Enter the subject of the email that is sent to the bidder after winning an auction. Leave blank to use the default subject: <code>%s</code>.', 'woo_ua' ), $this->subject ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'heading'    => array(
                    'title'       => __( 'Email Heading', 'woocommerce' ),
                    'type'        => 'text',
                    'description' => sprintf( __( 'Enter the Heading of the email that is sent to the bidder after winning an auction. Leave blank to use the default heading: <code>%s</code>.', 'woo_ua' ), $this->heading ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'email_type' => array(
                    'title'       => __( 'Email type', 'woocommerce' ),
                    'type'        => 'select',
                    'description' => __( 'Choose which format of email to send.', 'woocommerce' ),
                    'default'     => 'html',
                    'class'       => 'email_type wc-enhanced-select',
                    'options'     => $this->get_email_type_options(),
                    'desc_tip'    => true
                )
            );
        }

    } /* end of class */
} /* end of if - class exists */

return new UWA_Email_Auction_Remind_to_Pay();