<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( !class_exists( 'UWA_Email_Auction_Loser_Bidders' ) ) {

    /**
     *
     * @class UWA_Email_Auction_Loser_Bidders
     * @package Ultimate WooCommerce Auction PRO
     * @author Nitesh Singh 
     * @since 2.0 
     *
     */
    class UWA_Email_Auction_Loser_Bidders extends WC_Email {
	
        /**
         * Define email related information
         *         
         */
        public function __construct() {
            $this->id = 'woo_ua_email_auction_loser_bidders';
            $this->title = __('Ultimate Auction - Auction Lost', 'woo_ua' );
            $this->customer_email = true;
            $this->description = __( '​Email ​sent to users who lost in bidding','woo_ua' );           
            $this->heading = __( 'You have lost auction product on {site_title}', 'woo_ua' );
            $this->subject = __( 'You have lost auction product on {site_title}', 'woo_ua' );        
			$this->template_html = 'emails/loser-bidders.php';
            $this->template_plain = 'emails/plain/loser-bidders.php';

			$this->uwa_proxy_loser_enabled = $this->get_option( 'uwa_proxy_loser_enabled','no');
			$this->uwa_silent_loser_enabled = $this->get_option( 'uwa_silent_loser_enabled','no');			
			$this->productid =  0;
			
            /* Trigger on new paid orders */
            add_action( 'woo_ua_auctions_loser_email_bidder', array( $this, 'trigger' ), 10, 2);
            
            /* Call parent constructor to load any other defaults not explicity defined here */
            parent::__construct();                         
            
            
        }

         /**
         * Define trigger
         *
         * @param int $product_id, int $winneruser
         *
         */
        public function trigger($product_id, $winneruser) {            
            
            global $wpdb;
            
            if ( !$this->is_enabled() ) {
                return;
            }               
                        
            $final_receipents1 = array();
            $final_receipents2 = array();

			$this->productid = $product_id;
			$product = wc_get_product($product_id);
            $product_title = $product->get_title();

            $this->heading = sprintf(__( 'You have lost %s', 'woo_ua' ), $product_title);
            $this->subject = sprintf(__( 'You have lost %s', 'woo_ua' ), $product_title);

			if($this->uwa_proxy_loser_enabled == "yes" && $product->get_uwa_auction_proxy()=="yes"){
					
					$proxy_loser_users = $wpdb->get_results("SELECT DISTINCT userid
                        FROM ". $wpdb->prefix ."woo_ua_auction_log
                        WHERE auction_id = ". $product_id, OBJECT_K); //ARRAY_A

                    if (count($proxy_loser_users) > 0){
                        $arr_proxy_loser_users = array_keys($proxy_loser_users);                       
                        $final_receipents1 = $arr_proxy_loser_users;
                    }     

					
				}
				
				if($this->uwa_silent_loser_enabled == "yes" && $product->get_uwa_auction_silent()=="yes"){
					
					$silent_loser_users = $wpdb->get_results("SELECT DISTINCT userid
                        FROM ". $wpdb->prefix ."woo_ua_auction_log
                        WHERE auction_id = ". $product_id, OBJECT_K); //ARRAY_A

                    if (count($silent_loser_users) > 0){
                        $arr_silent_loser_users = array_keys($silent_loser_users);                       
                        $final_receipents2 = $arr_silent_loser_users;
                    }     

					
				}
				
				
				$c = array();
                $c = array_merge($final_receipents1, $final_receipents2);
                //$totla_userlist = array_unique($c);
                $final_userlist = array_unique($c);
				
				if (($key = array_search($winneruser, $final_userlist)) !== false) {
					unset($final_userlist[$key]);
				}
				
				$total_users = count($final_userlist);
				if ( $total_users > 0 ) {
					
						foreach ( $final_userlist as $key => $value) {
							   $user_obj = get_user_by('id', $value);
							   $email_id = $user_obj->user_email;
							   if(!empty($email_id)){
									$this->send( $email_id, $this->get_subject(), $this->get_content(), $this->get_headers(),  $this->get_attachments());
							   }
							
						}
						 
				}
           
        }


        /**
         * Get content html 
         *
         * @return array
         *
         */
        public function get_content_html() {
            return wc_get_template_html( $this->template_html, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => false,
                    'email'         => $this
                ),'', UW_AUCTION_PRO_WC_TEMPLATE);
        }

        /**
         * Get content plain 
         *
         * @return array
         *
         */
        public function get_content_plain() {
            return wc_get_template_html( $this->template_plain, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => true,
                    'email'         => $this
                ),'', UW_AUCTION_PRO_WC_TEMPLATE);
        }

        /**
         * Add form fields for email        
         *
         */
        public function init_form_fields() {
            $this->form_fields = array(
                'enabled' => array(
                    'title'   => __( 'Enable/Disable', 'woocommerce' ),
                    'type'    => 'checkbox',
                    'label'   => __( 'Enable this email notification', 'woo_ua' ),
                    'default' => 'no'
                ),
				'uwa_proxy_loser_enabled' => array(
				'title' 		=> __( 'Enable for Proxy Bidding', 'woo_ua' ),
				'type' 			=> 'checkbox',
				'label' 		=> __( 'Users who lost in proxy bidding', 'woo_ua' ),
				'default' 		=> 'no'
				),
				'uwa_silent_loser_enabled' => array(
				'title' 		=> __( 'Enable for Silent Bidding', 'woo_ua' ),
				'type' 			=> 'checkbox',
				'label' 		=> __( 'Users who lost in silent bidding', 'woo_ua' ),
				'default' 		=> 'no'
				),
				
                'subject'    => array(
                    'title'       => __( 'Subject', 'woocommerce' ),
                    'type'        => 'text',                    
					'description' => sprintf( __( 'Enter the subject of the email that is sent to the loser. Leave blank to use the default subject:- <code>%s</code>.', 'woo_ua' ), $this->subject ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'heading'    => array(
                    'title'       => __( 'Email Heading', 'woocommerce' ),
                    'type'        => 'text',				
					'description' => sprintf( __( 'Enter the heading of the email that is sent to the loser. Leave blank to use the default heading: <code>%s</code>.', 'woo_ua' ), $this->heading ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'email_type' => array(
                    'title'       => __( 'Email type', 'woocommerce' ),
                    'type'        => 'select',
                    'description' => __( 'Choose which format of email to send.', 'woocommerce' ),
                    'default'     => 'html',
                    'class'       => 'email_type wc-enhanced-select',
                    'options'     => $this->get_email_type_options(),
                    'desc_tip'    => true
                )
            );
        }

    } /* end of class */
} /* end of if - class exists */

return new UWA_Email_Auction_Loser_Bidders();