jQuery(document).ready(function($){

	
	/* Start Date */
	jQuery('#woo_ua_auction_start_date').datetimepicker({
		defaultDate: "",
		timeFormat: "HH:mm:ss", 
		dateFormat: "yy-mm-dd",
		minDate: 0 ,
		numberOfMonths: 1,
		showButtonPanel: true,
		showOn: "button",
		buttonImage: UWA_Auction.calendar_image,
		buttonText : 'Select a time',
		buttonImageOnly: true,
		showMillisec : 0,
	});

	jQuery('#woo_ua_auction_end_date').datetimepicker({
		defaultDate: "",
		timeFormat: "HH:mm:ss", 
		dateFormat: "yy-mm-dd",
		minDate: 0 ,
		numberOfMonths: 1,
		showButtonPanel: true,
		showOn: "button",
		buttonImage: UWA_Auction.calendar_image,
		buttonText : 'Select a time',
		buttonImageOnly: true,
		showMillisec : 0,
		beforeShow: function(){
			$("#woo_ua_auction_end_date").datetimepicker("option", {
				minDate: $("#woo_ua_auction_start_date").datetimepicker('getDate')
			});
		}
	});

	/* Start Date */
	jQuery('#uwa_relist_start_date').datetimepicker({
		defaultDate: "",
		timeFormat: "HH:mm:ss", 
		dateFormat: "yy-mm-dd",
		minDate: 0 ,
		numberOfMonths: 1,
		showButtonPanel: true,
		showOn: "button",
		buttonImage: UWA_Auction.calendar_image,
		buttonText : 'Select a time',
		buttonImageOnly: true,
		showMillisec : 0,
	});
	
	jQuery('#uwa_relist_end_date').datetimepicker({
		defaultDate: "",
		timeFormat: "HH:mm:ss", 
		dateFormat: "yy-mm-dd",
		minDate: 0 ,
		numberOfMonths: 1,
		showButtonPanel: true,
		showOn: "button",
		buttonImage: UWA_Auction.calendar_image,
		buttonText : 'Select a time',
		buttonImageOnly: true,
		showMillisec : 0,
		beforeShow: function(){
			$("#uwa_relist_start_date").datetimepicker("option", {		
				minDate: $("#uwa_relist_start_date").datetimepicker('getDate')
			});
		}
	});
	
		
	/* Set regular price for other product type */
	jQuery('#general_product_data #_regular_price').on('keyup', function(){
		jQuery('#auction_options #_regular_price').val(jQuery(this).val());
	});

	jQuery("#woo_ua_auction_end_date").keypress(function(event) {
		event.preventDefault();
	});

	/* If Auction product Selected */
	var productType = jQuery('#product-type').val();
	if (productType=='auction'){
		jQuery('.show_if_simple').show();
		jQuery('.inventory_options').show();
		jQuery('.general_options').show();
		jQuery('#inventory_product_data ._manage_stock_field').addClass('hide_if_auction').hide();
        jQuery('#inventory_product_data ._sold_individually_field').parent().addClass('hide_if_auction').hide();
        jQuery('#inventory_product_data ._sold_individually_field').addClass('hide_if_auction').hide();
        jQuery('#inventory_product_data ._stock_field ').addClass('hide_if_auction').hide();
        jQuery('#inventory_product_data ._backorders_field ').parent().addClass('hide_if_auction').hide();
        jQuery('#inventory_product_data ._stock_status_field ').addClass('hide_if_auction').hide();
        jQuery('.options_group.pricing ').addClass('hide_if_auction').hide();
		jQuery('#uwa_automatic_renew_auction.postbox').show();
		jQuery('#uwa-auction-log.postbox').show();
	} else {				
		jQuery('#uwa_automatic_renew_auction.postbox').hide();
		jQuery('#uwa-auction-log.postbox').hide();
	}

	/* hide inventory_product_data */
	jQuery('select#product-type').on('change',function(){
		var value = jQuery(this).val();
			if (value == 'auction'){				
				jQuery('.show_if_simple').show();				
				jQuery('.general_options').show();				
				jQuery('#inventory_product_data ._manage_stock_field').addClass('hide_if_auction').hide();
				jQuery('#inventory_product_data ._sold_individually_field').parent().addClass('hide_if_auction').hide();
				jQuery('#inventory_product_data ._sold_individually_field').addClass('hide_if_auction').hide();		
				jQuery('#inventory_product_data ._backorders_field ').parent().addClass('hide_if_auction').hide();			
				jQuery('.options_group.pricing ').addClass('hide_if_auction').hide();
				jQuery('#uwa_automatic_renew_auction.postbox').show();
				jQuery('#uwa-auction-log.postbox').show();							
				
				
			} else {		
		
				jQuery('#uwa_automatic_renew_auction.postbox').hide();
				jQuery('#uwa-auction-log.postbox').hide();
			}
	});

	/* show virtual and downloadable option for auction product */
	jQuery('label[for="_virtual"]').addClass('show_if_auction');
	jQuery('label[for="_downloadable"]').addClass('show_if_auction');

	/* End Bid Now */
	jQuery('.uwa_force_end_now').on('click', function(event){
		var auction_id = $(this).data('auction_id');		
			jQuery.ajax({
				type : "post",
				url : UWA_Auction.ajaxurl,
				data : {action: "uwa_admin_force_end_now", postid:auction_id, ua_nonce : UWA_Auction.uwa_nonce },
				success: function(response) {
					var data = $.parseJSON( response ); 
					if( data.status == 1 ) {
						alert(data.success_message);
						window.location.reload();
					} else {
						alert(data.error_message);
						window.location.reload();
					}
				}

      		});
		event.preventDefault();
	});	

	/* Force make it Live */
	jQuery('.uwa_force_make_live').on('click', function(event){
		var auction_id = $(this).data('auction_id');
			jQuery.ajax({
				type : "post",
				url : UWA_Auction.ajaxurl,
				data : {action: "uwa_admin_force_make_live_now", auction_id:auction_id, ua_nonce : UWA_Auction.uwa_nonce },
				success: function(response) {
					var data = $.parseJSON( response ); 
					if( data.status == 1 ) {
						alert(data.success_message);
						window.location.reload();
					} else {
						alert(data.error_message);
						window.location.reload();
					}
        		}

      		});
		event.preventDefault();
	});	

	/* Re-List Auction */
	jQuery('.uwa_force_relist').on('click', function(event){
			event.preventDefault();
			jQuery('.uwa_auction_relist_date_field').toggle();
	});
	
	/* Force make it Live */
	jQuery('.uwa_force_remind_to_pay').on('click', function(event){
		var postid = $(this).data('postid');
		//alert(postid);
			jQuery.ajax({
				type : "post",
				url : UWA_Auction.ajaxurl,
				data : {action: "uwa_admin_force_remind_to_pay", postid:postid, ua_nonce : UWA_Auction.uwa_nonce },
				success: function(response) {
					var data = $.parseJSON( response ); 
					if( data.status == 1 ) {
						alert(data.success_message);
						window.location.reload();
					} else {
						alert(data.error_message);
						window.location.reload();
					}
        		}

      		});
		event.preventDefault();
	});	
	
	
	/* Cancel Last bid */
	jQuery('.uwa-admin-table .bid_action a:not(.disabled)').on('click', function(event){
		var logid = $(this).data('id');
		var postid = $(this).data('postid');
		var curent = $(this);
		jQuery.ajax({
			type : "post",
			url : UWA_Auction.ajaxurl,
			data : {action: "admin_cancel_bid", logid : logid, postid: postid, ua_nonce : UWA_Auction.uwa_nonce },
			success: function(response) {
				var data = $.parseJSON( response ); 
				if( data.status == 1 ) {
					alert(data.success_message);
					window.location.reload();
				} else {
			        alert(data.error_message);
					window.location.reload();
				}
			}
      	});
      	event.preventDefault();
	});	

	/* Force Delete  BID */
		jQuery('.uwa_force_delete_bid').on('click', function(event){
				var logid = $(this).data('id');
				var postid = $(this).data('postid');
				var curent = $(this);
				jQuery.ajax({
					type : "post",
					url : UWA_Auction.ajaxurl,
					data : {action: "admin_cancel_bid", logid : logid, postid: postid, ua_nonce : UWA_Auction.uwa_nonce },
					success: function(response) {
						var data = $.parseJSON( response ); 
						if( data.status == 1 ) {
							alert(data.success_message);
							window.location.reload();
						} else {
							alert(data.error_message);
							window.location.reload();
						}
					}
				});
				event.preventDefault();
		});

	jQuery(".uwa-see-more").on('click', function(){	

		var current = jQuery(this);
		var auction_id = jQuery(this).attr('rel');

		var auction_status = jQuery("#statusofauction").val();
		/* alert(auction_status); */

		jQuery(".uwa-bidder-list-"+auction_id).css('opacity', '0.4');
		var show_rows;
		var label_text;
		if(jQuery(this).hasClass('show-all')){
			show_rows=-1;
			jQuery(this).removeClass('show-all');
			jQuery(this).addClass('show-one');	    
		}
		else{
			show_rows=1;			
			jQuery(this).removeClass('show-one');
			jQuery(this).addClass('show-all');			
		}		

		var data = {
			action: 'uwa_see_more_bids_ajax',
			auction_id: auction_id,
			show_rows: show_rows,			
			auction_status: auction_status
		};	

		jQuery.post(ajaxurl, data, function(response) {		
			var data = jQuery.parseJSON( response );		
			jQuery(".uwa-bidder-list-"+auction_id).html(data.bids_list);		
			current.text(data.uwa_label_text);		
			jQuery(".uwa-bidder-list-"+auction_id).css('opacity','1');
		});	

	  return false;	
	  event.preventDefault();
	});
		
	jQuery('#uwa_auction_proxy').on('change', function(){
	
		if(this.checked) {
			$('#uwa_auction_silent').prop('checked', false);		 
			$('.form-field.uwa_auction_silent_field  ').css("display", "none");
		} else {
			$('.form-field.uwa_auction_silent_field  ').css("display", "block");
		}	
	});

	jQuery('#uwa_auction_silent').on('change', function(){ 

		if(this.checked) {
			$('#uwa_auction_proxy').prop('checked', false);		 
			$('.form-field.uwa_auction_proxy_field').css("display", "none");
		} else {
			$('.form-field.uwa_auction_proxy_field').css("display", "block");
		}
	});

	
	
	var product_type = jQuery("#product-type").val();
	if(product_type == "auction"){
		var woo_ua_auction_form_type = jQuery("#woo_ua_auction_form_type").val();	
		if(woo_ua_auction_form_type == "edit_product"){
			
			/* make fields disabled when auction is live/expired */
			var woo_ua_auction_status_type = jQuery("#woo_ua_auction_status_type").val();			
			if(woo_ua_auction_status_type == "live"){	
				jQuery("#woo_ua_auction_start_date").attr("disabled","disabled");
				/*jQuery("#woo_ua_auction_start_date").datepicker( "option", "disabled", true);*/
			} 
			if(woo_ua_auction_status_type == "expired"){
				jQuery("#woo_ua_auction_start_date").attr("disabled","disabled");
				jQuery("#woo_ua_auction_end_date").attr("disabled","disabled");
			}
			
			
			/* =========  new start  =====   */
			
			var is_selling_type_auction = jQuery("#uwa_auction_selling_type_auction").is(":checked");
			var is_selling_type_buynow = jQuery("#uwa_auction_selling_type_buyitnow").is(":checked");
									
			jQuery("div.selling_type_auction").hide();
			jQuery("div.selling_type_buyitnow").hide();
			if(is_selling_type_auction == true){
				jQuery("div.selling_type_auction").show();
			}
			if(is_selling_type_buynow == true){
				jQuery("div.selling_type_buyitnow").show();
			}
			
			
			/* =========  new end  ======   */
			
			
			
		}
	} /* end of if - producttype */
	
	
	/* ======================== new start  ============================ */
	jQuery('#uwa_auction_selling_type_auction').on('click',function(){
		/*jQuery("div.selling_type_auction").toggle();*/
		
		if(jQuery(this).is(":checked")) {
			jQuery("div.selling_type_auction").slideDown();
		}else{
			jQuery("div.selling_type_auction").slideUp();
		}
	});
	
	jQuery('#uwa_auction_selling_type_buyitnow').on('click',function(){	
	
		if(jQuery(this).is(":checked")) {
			jQuery("div.selling_type_buyitnow").slideDown();
		}else{
			jQuery("div.selling_type_buyitnow").slideUp();
		}		
	});
	
	
	/* VALIDATIONS FOR PRO 1.1.1 */
	jQuery('#publish').on('click', function(){
		
		var pro_type  = jQuery('#product-type').val();
		if(pro_type == 'auction'){
			
			var is_selling_type_auction = jQuery("#uwa_auction_selling_type_auction").is(":checked");
			var is_selling_type_buynow = jQuery("#uwa_auction_selling_type_buyitnow").is(":checked");
			
			//alert(is_selling_type_auction);
			//alert(is_selling_type_buynow);
			
			jQuery('#woo_ua_opening_price').removeAttr("required");
			jQuery('#woo_ua_lowest_price').removeAttr("required");
			jQuery('#woo_ua_bid_increment').removeAttr("required");
			/* jQuery('#_regular_price').removeAttr("required"); */
							

			/* first check for selling type only */
			if(is_selling_type_auction == false && is_selling_type_buynow == false){
					alert("Please select auction selling type");
					jQuery('#uwa_auction_selling_type_auction').focus();
					event.preventDefault();
			}
			else{
				
				jQuery('#woo_ua_auction_start_date').attr("required", "required");
				jQuery('#woo_ua_auction_end_date').attr("required", "required");			
				
				var op_val = jQuery('#woo_ua_opening_price').val();
				var lp_val =  jQuery('#woo_ua_lowest_price').val();				
				var buynow_val =  jQuery('#_regular_price').val();
				var enddate_val =  jQuery('#woo_ua_auction_end_date').val();
				var startdate_val =  jQuery('#woo_ua_auction_start_date').val();
				var relist_enddate_val =  jQuery('#uwa_relist_end_date').val();
				var relist_startdate_val =  jQuery('#uwa_relist_start_date').val();				
			
				/* check for - both selling type  */
				if(is_selling_type_auction == true && is_selling_type_buynow == true){
					jQuery('#woo_ua_opening_price').attr("required", "required");
					jQuery('#woo_ua_lowest_price').attr("required", "required");					
					
					if(op_val <= 0  || lp_val <= 0  ){ /*|| buynow_val <= 0){*/
						alert("Both selling types are selected, Please fill auction product related data in 'Auction' tab");
						
					}
				}												
				/* check for - auction selling type  */
				else if(is_selling_type_auction == true){
					jQuery('#woo_ua_opening_price').attr("required", "required");
					jQuery('#woo_ua_lowest_price').attr("required", "required");
					
					
					/*if(op_val == ""  || lp_val == "" || bid_val == ""){*/
					if(op_val <= 0  || lp_val <= 0 ){
						alert("Please fill auction product related data in 'Auction' tab");						
					}					
				}	
				
				/* check for - buyitnow selling type -- recheck */
				else if(is_selling_type_buynow == true){					
					
				}
				
				
				/*  -------  common fields to check  -------- */				
				if(enddate_val == "" || startdate_val == ""){
					alert("Please fill auction start date and end date");
					
				}
				else if(startdate_val != "" && enddate_val != ""){				
					sd_obj = new Date(startdate_val);
					ed_obj = new Date(enddate_val);
					sd_time = sd_obj.getTime();
					ed_time = ed_obj.getTime();				
					if(sd_time > ed_time || sd_time == ed_time){
						alert("End date must be greater than Start date");
						jQuery('#woo_ua_auction_end_date').focus();
						event.preventDefault();
					}
				}
				
				
				if(relist_startdate_val != "" && relist_enddate_val != ""){
					rlsd_obj = new Date(relist_startdate_val);
					rled_obj = new Date(relist_enddate_val);
					rlsd_time = rlsd_obj.getTime();
					rled_time = rled_obj.getTime();
					if(rlsd_time > rled_time || rlsd_time == rled_time){
						alert("Relist End date must be greater than Relist Start date");
						jQuery('#uwa_relist_end_date').focus();
						event.preventDefault();
					}
				
				}				
				
			} /* end of else */
			

		} /* end of if pro_type */
		else if(pro_type != 'auction'){	
			jQuery('#woo_ua_opening_price').removeAttr("required");
			jQuery('#woo_ua_lowest_price').removeAttr("required");			
			jQuery('#woo_ua_auction_end_date').removeAttr("required");
			jQuery('#woo_ua_auction_start_date').removeAttr("required");
		}
		
	}); /* end of validations */
	
	jQuery('#uwa_auction_variable_bid_increment').on('change', function(){	
		if(this.checked) {			
			jQuery('p.uwa_variable_bid_increment_main').css("display", "block"); 
			jQuery('.uwa_custom_field_onwards_main').css("display", "block");			
			jQuery('.form-field.woo_ua_bid_increment_field').css("display", "none");
			jQuery('#woo_ua_bid_increment').val("");			
			
		} else {
			jQuery('p.uwa_variable_bid_increment_main').css("display", "none");
			jQuery('.uwa_custom_field_onwards_main').css("display", "none");
			jQuery('.form-field.woo_ua_bid_increment_field').css("display", "block");
		}	
	});
	
	jQuery('#uwa_auto_renew_enable').on('change', function(){
		if(this.checked) {	
		   jQuery('.uwa_auto_renew_auction_main').css("display", "block");
		} else {
			jQuery('.uwa_auto_renew_auction_main').css("display", "none");
		}
	});
	
	jQuery('#uwa_auto_renew_not_paid_enable').on('change', function(){
		if(this.checked) {	
		   jQuery('.uwa_auto_renew_auction_not_paid').css("display", "block");
		} else {
			jQuery('.uwa_auto_renew_auction_not_paid').css("display", "none");
		}
	});
	
	jQuery('#uwa_auto_renew_no_bids_enable').on('change', function(){
		if(this.checked) {	
		   jQuery('.uwa_auto_renew_auction_no_bids').css("display", "block");
		} else {
			jQuery('.uwa_auto_renew_auction_no_bids').css("display", "none");
		}
	});
	
	jQuery('#uwa_auto_renew_no_reserve_enable').on('change', function(){
		if(this.checked) {	
		   jQuery('.uwa_auto_renew_auction_no_reserve').css("display", "block");
		} else {
			jQuery('.uwa_auto_renew_auction_no_reserve').css("display", "none");
		}
	});
	
	
	/* ======================== new end  ============================ */
	
	/* Force choose winner */
	
	jQuery(document).on('click', '.uwa_force_choose_winner', function (event) {
		var is_confirm = confirm_choose_winner();

		if(is_confirm == true){

			var auction_id = $(this).data('auction_id');
			var bid_id = $(this).data('bid_id');
			var bid_user_id = $(this).data('bid_user_id');
			var bid_amount = $(this).data('bid_amount');

				jQuery.ajax({
					type : "post",
					url : UWA_Auction.ajaxurl,
					data : {
						action: "uwa_admin_force_choose_winner", 
						postid: auction_id,
						bid_id: bid_id,
						bid_user_id: bid_user_id,
						bid_amount: bid_amount,
						ua_nonce: UWA_Auction.uwa_nonce 
					},
					success: function(response) {
						var data = $.parseJSON( response ); 
						if( data.status == 1 ) {
							alert(data.success_message);
							window.location.reload();
						} else {
							alert(data.error_message);
							window.location.reload();
						}
					}

	      		});

			event.preventDefault();
		}
	});	


	/* Extra confirmation message on choose winner */
		function  confirm_choose_winner() {
			
			var confirm_message = "Do you really want to choose this bidder as a Winner?";
			var result_conf = confirm(confirm_message);

			if(result_conf == false){
				event.preventDefault(); /* don't use return it reloads page */
			}
			else{
				return true;
			}	
			
		} /* end of function - confirm_choose_winner() */
	

}); /* end of document ready */