<?php

/**
 * Pay button
 * 
 * @package Ultimate WooCommerce Auction PRO
 * @author Nitesh Singh 
 * @since 1.0  
 *
 */

if (!defined('ABSPATH')) {
	exit;
}

global $product;
if (  method_exists( $product, 'get_type') && $product->get_type() == 'auction' ) : 
	$user_id  = get_current_user_id();
	$checkout_url = esc_attr(add_query_arg("pay-uwa-auction", $product->get_id(), uwa_auction_get_checkout_url()));
	if ( $user_id == $product->get_uwa_auction_current_bider() && $product->get_uwa_auction_expired() == '2' && !$product->get_uwa_auction_payed() ) : ?>
		<a href="<?php echo $checkout_url; ?>" class="button alt">
				<?php echo apply_filters('ultimate_woocommerce_auction_pay_now_button_text', __( 'Pay Now', 'woo_ua' ), $product); ?></a>
	<?php endif; ?>
<?php endif; ?>	