<?php

/**
 * Send Email to bidder when the bidder won the auction. (HTML)
 * 
 * @package Ultimate WooCommerce Auction PRO
 * @author Nitesh Singh 
 * @since 1.0  
 *
 */

if (!defined('ABSPATH')) {
    exit;
}

?>
<?php do_action( 'woocommerce_email_header', $email_heading, $email ); ?>

<?php

	$product_id = $email->productid; 
 	$product = wc_get_product($product_id);

 	$product_base_currency = $product->uwa_aelia_get_base_currency();	
	$args = array("currency" => $product_base_currency);
	
	$uwa_silent = $product->get_uwa_auction_silent();
	
?>

<p>
<?php

	if ($uwa_silent == 'yes'){
			printf(
			__('Auction <a href="%s">%s</a> is going to be expire at %s.', 'woo_ua'),
				get_permalink($product_id), $product -> get_title(),  date_i18n( 
					get_option( 'date_format' ),
				strtotime( $product->get_uwa_auctions_end_time() )).' '.date_i18n( 
					get_option( 'time_format' ),
				strtotime( $product->get_uwa_auctions_end_time() )));	
	} else {
		
		printf(
        __('Auction <a href="%s">%s</a> is going to be expire at %s. Current bid is %s', 'woo_ua'),
            get_permalink($product_id), $product -> get_title(),  date_i18n( 
            	get_option( 'date_format' ),
            strtotime( $product->get_uwa_auctions_end_time() )).' '.date_i18n( 
            	get_option( 'time_format' ),
            strtotime( $product->get_uwa_auctions_end_time() )), 
            wc_price($product->get_uwa_auction_current_bid(), $args) );    
	}

?>
</p>
<?php do_action( 'woocommerce_email_footer', $email ); ?>