<?php

/**
 * outbid email
 * 
 * @package Ultimate WooCommerce Auction PRO
 * @author Nitesh Singh 
 * @since 1.0  
 *
 */

if (!defined('ABSPATH')) {
    exit;
}
?>
<?php do_action('woocommerce_email_header', $email_heading, $email); ?>
<?php
	$product = $email->object['product'];
	$auction_url = $email->object['url_product'];
	$user_name = $email->object['user_name'];
	$auction_title = $product->get_title();
	$auction_bid_value = wc_price($product->get_uwa_current_bid());
	$thumb_image = $product->get_image( 'thumbnail' );
	$uwa_silent = $product->get_uwa_auction_silent();
	$uwa_silent_outbid_email_cprice = get_option('uwa_silent_outbid_email_cprice',"no");
	if($uwa_silent == 'yes'){
		if($uwa_silent_outbid_email_cprice =="no"){		
		    $auction_bid_value = $product->get_price_html();		
	    } else {
		   $auction_bid_value = wc_price($product->get_uwa_last_bid());	
	      }
	}
?>
<p><?php printf( __( "Hi %s,", 'woo_ua' ), $user_name); ?></p>
<p><?php printf( __( 'You have been outbid on the product <a href="%s">%s</a>.', 
	'woo_ua' ),
    $auction_url, $auction_title); ?></p>
<p><?php printf( __( "Here are the details : ", 'woo_ua' )); ?></p>
<table>
   	<tr>	 
		<td><?php echo __( 'Image', 'woo_ua' ); ?></td>
		<td><?php echo __( 'Product', 'woo_ua' ); ?></td>
		<td><?php echo __( 'Current bid', 'woo_ua' ); ?></td>	
	</tr>
    <tr>
		<td><?php echo $thumb_image;?></td>
		<td><a href="<?php echo $auction_url ;?>"><?php echo $auction_title; ?></a></td>
		<td><?php echo $auction_bid_value;  ?></td>
    </tr>
</table>
<div>
	<p><?php _e( 'If you want to bid a new amount, click here', 'woo_ua' ); ?> 
	<a href="<?php echo $auction_url;?>"><?php echo $auction_title; ?></a> </p>
</div>

<?php do_action('woocommerce_email_footer', $email); ?>