<?php

/**
 * Send Email to bidder when the bidder won the auction. (HTML)
 * 
 * @package Ultimate WooCommerce Auction PRO
 * @author Nitesh Singh 
 * @since 1.0  
 *
 */

if (!defined('ABSPATH')) {
    exit;
}

?>
<?php do_action( 'woocommerce_email_header', $email_heading, $email ); ?>

<?php
  $product_id = $email->object['product_id']; 
  $product = wc_get_product($product_id);  
  $user_name = $email->object['user_name'];
  $auction_title = $product->get_title();
  $auction_bid_value = wc_price($product->get_uwa_current_bid());
  $thumb_image = $product->get_image( 'thumbnail' );
  $checkout_url  = add_query_arg( array( 'pay-uwa-auction' => $product_id  ), uwa_auction_get_checkout_url() );

  $user_type = $email->object['user_type'];
  $button_text = __('Pay Now', 'woo_ua');

  
?>
<?php if($user_type ==="bidder"){ 
$auction_url = $email->object['url_product'];
?>
<p><?php printf( __( "Hi %s,", 'woo_ua' ), $user_name); ?></p>
<p><?php printf( __( 'Congratulations! You are the winner! of the auction product <a href="%s">%s</a>.', 'woo_ua' ),$auction_url,$auction_title); ?></p>
<p><?php printf( __( "Here are the details : ", 'woo_ua' )); ?></p>

<table>
    <tr>	 
      <td><?php echo __( 'Image', 'woo_ua' ); ?></td>
      <td><?php echo __( 'Product', 'woo_ua' ); ?></td>
      <td><?php echo __( 'Winning bid', 'woo_ua' ); ?></td>	
  	</tr>
    <tr>
      <td><?php echo $thumb_image;?></td>
      <td><a href="<?php echo $auction_url ;?>"><?php echo $auction_title; ?></a></td>
      <td><?php echo $auction_bid_value;  ?></td>
    </tr>
</table>
    
<div>
  <p><?php _e( 'Please, proceed to checkout', 'woo_ua' ); ?></p>
  <p><a style="padding:6px 28px !important;font-size: 12px !important; background: #ccc !important; color: #333 !important; text-decoration: none!important; text-transform: uppercase!important; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif !important;font-weight: 800 !important; border-radius: 3px !important; display: inline-block !important;" href="<?php echo $checkout_url; ?>" class="button">
    <?php echo $button_text; ?></a>
  </p>
</div>
<?php } ?>
<?php if($user_type ==="admin"){ ?>

<?php  $auction_url = $email->object['edit_url_product']; 
$userlink = add_query_arg( 'user_id', $email->object['user_id'] , admin_url( 'user-edit.php' ) );

?>

<p><?php printf( __( "Hi admin,", 'woo_ua' )); ?></p>

<p><?php printf( __( "The auction has expired and won by user. Auction url <a href='%s'>%s</a>.", 'woo_ua' ),$auction_url,$auction_title); ?></p>
<p><?php printf( __( "Here are the details : ", 'woo_ua' )); ?></p>
<table>
     <tr>	 
	 <td><?php echo __( 'Image', 'woo_ua' ); ?></td>
	 <td><?php echo __( 'Product', 'woo_ua' ); ?></td>
	 <td><?php echo __( 'Winning bid', 'woo_ua' ); ?></td>	
	 <td><?php echo __( 'Winner', 'woo_ua' ); ?></td>	
	 </tr>
    <tr>
      <td><?php echo $thumb_image;?></td>
	  <td><a href="<?php echo $auction_url ;?>"><?php echo $auction_title; ?></a></td>
      <td><?php echo $auction_bid_value;  ?></td>
      <td><a href="<?php echo $userlink;?>"><?php echo $user_name;  ?></a></td>
    </tr>
</table>
<?php } ?>
<?php do_action( 'woocommerce_email_footer', $email ); ?>