<?php

if (!defined('ABSPATH')) {
    exit;
}

if ( ! class_exists( 'UWA_Email_Auction_Relist' ) ) {

    /**
     *
     * @class UWA_Email_Auction_Relist
     * @package Ultimate WooCommerce Auction PRO
     * @author Nitesh Singh 
     * @since 1.0 
     *
     */
    class UWA_Email_Auction_Relist extends WC_Email {

        /**
         * Define email related information
         *         
         */        
        public function __construct() {
            
            //$this->id = 'woo_ua_email_place_bid';          
            $this->id = 'woo_ua_email_auction_relist';                      
            $this->title = __('Ultimate Auction - Relist', 'woo_ua');
            //$this->customer_email = true;
            
            $this->description = __('Email can be send to admin when auction is relisted', 
                'woo_ua');            
            $this->heading = __('Auction is relisted from  {site_title}', 'woo_ua');
            $this->subject = __('Auction is relisted from  {site_title}', 'woo_ua');

            $this->template_html = 'emails/auction-relist.php';
            $this->template_plain = 'emails/plain/auction-relist.php';
            $this->uwa_bidders_enabled = $this->get_option( 'uwa_bidders_enabled','yes');
            $this->uwa_admin_enabled = $this->get_option( 'uwa_admin_enabled','yes');  
            $this->productid = 0;
            $this->uwa_reason = "";
            
            /* Trigger action when auction is relisted */            
            add_action( 'uwa_pro_auction_relist_email', array( $this, 'trigger' ), 10, 1 );
            
            /* Call parent constructor to load any other defaults not explicity defined here */
            parent::__construct();   
                if ($this->uwa_admin_enabled ===  'yes') {
                    
                    $this->recipient = $this->get_option( 'recipient' );
                    if ( ! $this->recipient ){
                        $this->recipient = get_option( 'admin_email' );
                    }
                }

             /* do_action( 'uwa_pro_auction_relist_email', 127);   */
        }

        /**
         * Define trigger
         *
         * @param int $product_id
         *
         */
        public function trigger( $product_id ) {            
            global $wpdb;

            /* Check is email enable or not */
            if ( !$this->is_enabled() ) {
                return;
            }

            if ( $product_id ) {

                /*  Don't remove */
                $this->productid = $product_id;

                /* Relist reasons */
                $product_data = wc_get_product($product_id);
                if ($product_data->get_uwa_auction_fail_reason() == '1'){
                    $this->uwa_reason = __('Auction Expired because there were no bids', 'woo_ua');
                }    
                elseif($product_data->get_uwa_auction_fail_reason() == '2'){         
                    $this->uwa_reason = __('Auction expired without reaching reserve price', 'woo_ua');
                }
                elseif($product_data->get_uwa_auction_expired() && 
                    !$product_data->get_uwa_auction_payed()){
                    $this->uwa_reason = __('Auction is expired because user have not paid amount', 
                        'woo_ua');
                }

                    if($this->uwa_bidders_enabled == 'yes'){
                       
                        $auc_id = $product_id;                     
                        $auction_bidders =     $wpdb->get_results("SELECT DISTINCT userid
                            FROM ". $wpdb->prefix ."woo_ua_auction_log
                            WHERE auction_id = ". $auc_id, OBJECT_K); //ARRAY_A

                        if(count($auction_bidders) > 0){

                            $final_userlist = array_keys($auction_bidders);
                            
                            if (count($final_userlist) > 0) {
                                foreach ($final_userlist as $key => $value) {  
                                    $arr_mail =  $wpdb->get_col("SELECT user_email
                                            FROM ". $wpdb->prefix ."users
                                            WHERE ID = ". $value); 
                                    $mail_id = $arr_mail[0];
                                   
                                    $this->send( $mail_id, $this->get_subject(), $this->get_content(),
                                        $this->get_headers(), $this->get_attachments());
                                    
                                }

                            } /* end of if - count finallist */ 
                        
                        } /* end of if - count auction bidders */ 

                    } /* end of if - uwa_bidders_enabled */ 

                    if($this->uwa_admin_enabled == 'yes'){ 
                        
                        $admin_mailid = $this->recipient;                           
                        
                        $this->send( $admin_mailid, $this->get_subject(), $this->get_content(),
                            $this->get_headers(), $this->get_attachments());

                    } /* end of if - uwa_admin_enabled */ 

            } /* end of if - product id */ 
                  
        }

        /**
         * Get content html 
         *
         * @return array
         *
         */
        public function get_content_html() {
            return wc_get_template_html( $this->template_html, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => false,
                    'email'         => $this
                ),'', UW_AUCTION_PRO_WC_TEMPLATE );
        }

        /**
         * Get content plain 
         *
         * @return array
         *
         */
        public function get_content_plain() {
            return wc_get_template_html( $this->template_plain, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => true,
                    'email'         => $this
                ),'', UW_AUCTION_PRO_WC_TEMPLATE );
        }

        /**
         * Add form fields for email        
         *
         */
        public function init_form_fields() {
            
            $this->form_fields = array(
                'enabled'    => array(
                    'title'   => __( 'Enable/Disable', 'woocommerce' ),
                    'type'    => 'checkbox',
                    'label'   => __( 'Enable this email notification', 'woocommerce' ),
                    'default' => 'yes'
                ),
                'uwa_admin_enabled' => array(
                    'title'         => __( 'Enabled for Admin.', 'woo_ua' ),
                    'type'          => 'checkbox',
                    'label'         => __( 'Send email notification to admin when auction is relisted', 
                        'woo_ua' ),
                    'default'       => 'yes'
                ),
                'uwa_bidders_enabled' => array(
                    'title'         => __( 'Enabled for Bidder.', 'woo_ua' ),
                    'type'          => 'checkbox',
                    'label'         => __( 'Send email notification all participate(bidders) when auction is relisted.', 'woo_ua' ),
                    'default'       => 'yes'
                ),
                'recipient'    => array(
                    'title'       => __( 'Recipient', 'woocommerce' ),
                    'type'        => 'text',
                    'description' => sprintf( __( 'Enter recipients (comma separated) for admin email.Leave blank to use the default subject:- <code>%s</code>.', 'woo_ua' ), esc_attr( get_option('admin_email') ) ),
                    'placeholder' => '',
                    'default'     => '',
                    'user_type'   => 'admin',
                    'desc_tip'    => true
                ),                
                'subject' => array(
                    'title'         => __( 'Subject', 'woocommerce' ),
                    'type'          => 'text',
                    'description'   => sprintf( __( 'Enter the subject of the email that is sent to the admin when auction is relisted. Leave blank to use the default subject: <code>%s</code>.', 
                        'woo_ua' ), $this->subject ),
                    'placeholder'   => '',
                    'default'       => '',
                    //'desc_tip'    => true
                ),
                'heading' => array(
                    'title'         => __( 'Email Heading', 'woocommerce' ),
                    'type'          => 'text',
                    'description'   => sprintf( __( 'Enter the heading of the email that is sent to the admin when auction is relisted. Leave blank to use the default heading: <code>%s</code>.', 
                        'woo_ua' ), $this->heading ),
                    'placeholder'   => '',
                    'default'       => '',
                    //'desc_tip'    => true
                ),
                'email_type' => array(
                    'title'       => __( 'Email type', 'woocommerce' ),
                    'type'        => 'select',
                    'description' => __( 'Choose which format of email to send.', 'woocommerce' ),
                    'default'     => 'html',
                    'class'       => 'email_type wc-enhanced-select',
                    'options'     => $this->get_email_type_options(),
                    //'desc_tip'    => true
                )
            );
        }
        
    } /* end of class */
} /* end of if - class exists */

return new UWA_Email_Auction_Relist();