<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( !class_exists( 'UWA_Email_Auction_Ending_Soon_Bidder' ) ) {

    /**
     *
     * @class UWA_Email_Auction_Ending_Soon_Bidder
     * @package Ultimate WooCommerce Auction PRO
     * @author Nitesh Singh 
     * @since 1.0 
     *
     */
    class UWA_Email_Auction_Ending_Soon_Bidder extends WC_Email {
	
        /**
         * Define email related information
         *         
         */
        public function __construct() {
            $this->id = 'woo_ua_email_auction_ending_bidders';
            $this->title = __('Ultimate Auction - Ending Soon', 'woo_ua' );
            $this->customer_email = true;
            $this->description = __( '​Email ​Can be sent to the bidders to reminder auction is ending soon.', 
                'woo_ua' );
            $this->heading = __( 'Auction Ending soon on {site_title}', 'woo_ua' );
            $this->subject = __( 'Auction Ending soon on {site_title}', 'woo_ua' );            
			$this->template_html = 'emails/ending-soon-bidder.php';
            $this->template_plain = 'emails/plain/ending-soon-bidder.php'; 

			$this->uwa_enabled_bidders = $this->get_option( 'uwa_enabled_bidders','yes');
			$this->uwa_enabled_watchlist_users = $this->get_option( 'uwa_enabled_watchlist_users','no');
			$this->uwa_interval =  $this->get_option( 'interval', '1');
			$this->productid =  0;
			
            /* Trigger on new paid orders */
            add_action( 'woo_ua_auctions_ending_soon_email_bidders', 
                array( $this, 'trigger' ), 10, 1 );
            
            /* Call parent constructor to load any other defaults not explicity defined here */
            parent::__construct();                         
            
            //do_action( 'woo_ua_auctions_ending_soon_email_bidders', 13250); 
        }

        /**
         * Define trigger
         *
         * @param int $product_id, int $winneruser
         *
         */
        public function trigger($product_id) {            
            
            global $wpdb;
            
            if ( !$this->is_enabled() ) {
                return;
            }               
                        
            $final_receipents1 = array();
            $final_receipents2 = array();

            if ( $product_id ) {                
                
                /* Don't remove */
                $this->productid = $product_id;
                $auc_id = $product_id;

                if($this->uwa_enabled_bidders == 'yes'){                    
                    $ending_auction_users =     $wpdb->get_results("SELECT DISTINCT userid
                        FROM ". $wpdb->prefix ."woo_ua_auction_log
                        WHERE auction_id = ". $auc_id, OBJECT_K); //ARRAY_A

                    if (count($ending_auction_users) > 0){
                        $arr_ending_auction_users = array_keys($ending_auction_users);
                        $final_auction_users[$auc_id] =  $arr_ending_auction_users;
                        $final_receipents1 = $arr_ending_auction_users;
                    }                   
                }

                if($this->uwa_enabled_watchlist_users == 'yes'){

                    $watchlist_users[$auc_id] = get_post_meta( $auc_id,"woo_ua_auction_watch", false);
                    $final_receipents2 = get_post_meta( $auc_id, "woo_ua_auction_watch",false);
                }

                $c = array();
                $c = array_merge($final_receipents1, $final_receipents2);
                $final_userlist = array_unique($c);				
				$total_users = count($final_userlist);
                
                    if ( $total_users > 0 ) {

                        foreach ( $final_userlist as $key => $value) {
							
							$author_obj = get_user_by('id', $value);
							$user_email = $author_obj->user_email;							
								$this->send( $user_email,	
								$this->get_subject(),
								$this->get_content(), 
								$this->get_headers(), 
								$this->get_attachments());
								
						} /* end of foreach */
					
                            
                   } /* end of if - count */  
						

            } /* end of if - productid */     
         
        }


        /**
         * Get content html 
         *
         * @return array
         *
         */
        public function get_content_html() {
            return wc_get_template_html( $this->template_html, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => false,
                    'email'         => $this
                ),'', UW_AUCTION_PRO_WC_TEMPLATE);
        }

        /**
         * Get content plain 
         *
         * @return array
         *
         */
        public function get_content_plain() {
            return wc_get_template_html( $this->template_plain, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => true,
                    'email'         => $this
                ),'', UW_AUCTION_PRO_WC_TEMPLATE);
        }

        /**
         * Add form fields for email        
         *
         */
        public function init_form_fields() {
            $this->form_fields = array(
                'enabled' => array(
                    'title'   => __( 'Enable/Disable', 'woocommerce' ),
                    'type'    => 'checkbox',
                    'label'   => __( 'Enable this email notification', 'woo_ua' ),
                    'default' => 'yes'
                ),
				'uwa_enabled_bidders' => array(
				'title' 		=> __( 'Enabled for all Bidders those have bid on auction', 'woo_ua' ),
				'type' 			=> 'checkbox',
				'label' 		=> __( 'Send email to all Bidders', 'woo_ua' ),
				'default' 		=> 'yes'
				),
				'uwa_enabled_watchlist_users' => array(
					'title' 		=> __( 'Enabled for users who have auction in their watchlist', 'woo_ua' ),
					'type' 			=> 'checkbox',
					'label' 		=> __( 'Send email to users who has auction in their watchlist.', 'woo_ua' ),
					'default' 		=> 'no'
				),
				
				'uwa_interval' => array(
				'title' 		=> __( ' Mention time left for auction to close:', 'woo_ua' ),
				'type' 			=> 'number',
				'custom_attributes' => array('step'	=> '0.5', 'min'	=> '0.5'),
				'description' 	=> sprintf( __( 'Send reminder mail intervals in hour default is <code>%s</code>.', 'woo_ua' ), '1', $this->uwa_interval),

				'placeholder' 	=> '',
				'default' 		=> '1'
				),
				
                'subject'    => array(
                    'title'       => __( 'Subject', 'woocommerce' ),
                    'type'        => 'text',
                        /*'description' => sprintf( __( 'Enter the subject of the email that is sent 
                        to the bidders to reminder auction is ending soon.
                        to the bidder after winning an auction. Leave blank to use the default subject: <code>%s</code>.', 'woo_ua' ), $this->subject ), */

                    'description' => __( 'Enter the subject of the email that is sent 
                        to the bidders to reminder auction is ending soon.', 'woo_ua' ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'heading'    => array(
                    'title'       => __( 'Email Heading', 'woocommerce' ),
                    'type'        => 'text',
                    /*'description' => sprintf( __( 'Enter the Heading of the email that is sent to the bidder after winning an auction. Leave blank to use the default heading: <code>%s</code>.', 'woo_ua' ), $this->heading ),*/

                    'description' =>  __( 'Enter the Heading of the email that is sent 
                        to the bidders to reminder auction is ending soon.', 'woo_ua' ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'email_type' => array(
                    'title'       => __( 'Email type', 'woocommerce' ),
                    'type'        => 'select',
                    'description' => __( 'Choose which format of email to send.', 'woocommerce' ),
                    'default'     => 'html',
                    'class'       => 'email_type wc-enhanced-select',
                    'options'     => $this->get_email_type_options(),
                    'desc_tip'    => true
                )
            );
        }

    } /* end of class */
} /* end of if - class exists */

return new UWA_Email_Auction_Ending_Soon_Bidder();