<?php

if (!defined('ABSPATH')) {
	exit;
}


if ( ! class_exists( 'UWA_Email_Auction_Bid_Overbid' ) ) {

    /**
     *
     * @class UWA_Email_Auction_Bid_Overbid
     * @package Ultimate WooCommerce Auction PRO
     * @author Nitesh Singh 
     * @since 1.0 
     *
     */
    class UWA_Email_Auction_Bid_Overbid extends WC_Email {

        /**
         * Define email related information
         *         
         */
        public function __construct() {
			
            $this->id = 'woo_ua_email_auction_bid_overbidded';
            $this->title = __('Ultimate Auction - Outbid Notification', 'woo_ua');
            $this->customer_email = true;           
            $this->description = __('Email is sent to Bidder to outbid their bid.', 'woo_ua');
            $this->heading = __('You have been outbid on {site_title}', 'woo_ua');
            $this->subject = __('You have been outbid on {site_title}', 'woo_ua');
            $this->template_html = 'emails/bid-outbided.php';
            $this->template_plain = 'emails/plain/bid-outbided.php';

            /* Trigger on bid overbidded by other bidder */
            add_action( 'uwa_pro_outbid_bid_email', array( $this, 'trigger' ), 10, 2 );

            /* Call parent constructor to load any other defaults not explicity defined here */
            parent::__construct();
        }

        /**
         * Define trigger
         *
         * @param object $product, $outbiddeduser
         *
         */
        public function trigger( $outbiddeduser, $product ) {
          
            if ( !$this->is_enabled() ) {
                return;
            }
            $user = get_user_by('id', $outbiddeduser);
            $url_product = get_permalink($product->get_id());
            
            $this->object = array(
                'user_email'    => $user->data->user_email,
                'user_name'     => $user->data->user_login,
                'product_name'  => $product->get_title(),
                'product'       => $product,
                'url_product'   => $url_product,
            );
            $this->send( $this->object['user_email'],
                $this->get_subject(),
                $this->get_content(),
                $this->get_headers(),
                $this->get_attachments() );
        }

        /**
         * Get content html 
         *
         * @return array
         *
         */
        public function get_content_html() {
            return wc_get_template_html( $this->template_html, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => false,
                    'email'         => $this
                ), '', UW_AUCTION_PRO_WC_TEMPLATE );
        }

        /**
         * Get content plain 
         *
         * @return array
         *
         */
        public function get_content_plain() {
            return wc_get_template_html( $this->template_plain, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => true,
                    'email'         => $this
                ), '', UW_AUCTION_PRO_WC_TEMPLATE );
        }

        /**
         * Add form fields for email        
         *
         */
        public function init_form_fields() {
            $this->form_fields = array(
                'enabled'    => array(
                    'title'   => __( 'Enable/Disable', 'woocommerce' ),
                    'type'    => 'checkbox',
                    'label'   => __( 'Enable this email notification', 'woocommerce' ),
                    'default' => 'yes'
                ),
               
                'subject'    => array(
                    'title'       => __( 'Subject', 'woocommerce' ),
                    'type'        => 'text',
                    'description' => sprintf( __( 'This controls the email subject line. Leave blank to use the default subject: <code>%s</code>.', 'woo_ua' ), $this->subject ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'heading'    => array(
                    'title'       => __( 'Email Heading', 'woo_ua' ),
                    'type'        => 'text',
                    'description' => sprintf( __( 'This controls the main heading contained within the email notification. Leave blank to use the default heading: <code>%s</code>.', 'woo_ua' ), $this->heading ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'email_type' => array(
                    'title'       => __( 'Email type', 'woocommerce' ),
                    'type'        => 'select',
                    'description' => __( 'Choose which format of email to send.', 'woocommerce' ),
                    'default'     => 'html',
                    'class'       => 'email_type wc-enhanced-select',
                    'options'     => $this->get_email_type_options(),
                    'desc_tip'    => true
                )
            );
        }
    }
}
return new UWA_Email_Auction_Bid_Overbid();