<?php

if (!defined('ABSPATH')) {
	exit;
}


if ( ! class_exists( 'UWA_Email_Auction_Bid_Delete' ) ) {

    /**
     *
     * @class UWA_Email_Auction_Bid_Delete
     * @package Ultimate WooCommerce Auction PRO
     * @author Nitesh Singh 
     * @since 1.0 
     *
     */
    class UWA_Email_Auction_Bid_Delete extends WC_Email {

        /**
         * Define email related information
         *         
         */
        public function __construct() {
			
            $this->id = 'woo_ua_email_auction_bid_delete';
            $this->title = __('Ultimate Auction - Bid Delete Notification', 'woo_ua');
            $this->customer_email = true;           
            $this->description = __('Email is sent to Bidder to inform their bid has been deleted.', 
                'woo_ua');
            $this->heading = __('Your bid has been deleted on {site_title}', 'woo_ua');
            $this->subject = __('Your bid has been deleted on {site_title}', 'woo_ua');
            $this->template_html = 'emails/bid-deleted.php';
            $this->template_plain = 'emails/plain/bid-deleted.php';

            /* Trigger on bid deleted */
            add_action( 'uwa_pro_delete_bid_email', array( $this, 'trigger' ), 10, 3 );

            /* Call parent constructor to load any other defaults not explicity defined here */
            parent::__construct();

            /*do_action('uwa_pro_delete_bid_email', $postid, $userid, $deletedbid);*/
            /*do_action('uwa_pro_delete_bid_email', 59, 2, 20.0000);*/
         
        }

        /**
         * Define trigger
         *
         * @param number $postid, $userid, $deletedbid
         *
         */
        public function trigger( $postid, $userid, $deletedbid ) {
          
            if ( !$this->is_enabled() ) {
                return;
            }

            $product = wc_get_product($postid);
            $user = get_user_by('id', $userid);            
            $url_product = get_permalink($product->get_id());
            
            $this->object = array(
                'user_email'    => $user->data->user_email,
                'user_name'     => $user->data->user_login,
                'product_name'  => $product->get_title(),
                'product'       => $product,
                'product_id'    => $postid, 
                'url_product'   => $url_product,
                'deleted_bid'   => $deletedbid
            );

            $this->send( $this->object['user_email'],
                $this->get_subject(),
                $this->get_content(),
                $this->get_headers(),
                $this->get_attachments() );
        

        } /* end of fuction - trigger */

        /**
         * Get content html 
         *
         * @return array
         *
         */
        public function get_content_html() {
            return wc_get_template_html( $this->template_html, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => false,
                    'email'         => $this
                ), '', UW_AUCTION_PRO_WC_TEMPLATE );
        }

        /**
         * Get content plain 
         *
         * @return array
         *
         */
        public function get_content_plain() {
            return wc_get_template_html( $this->template_plain, 
                array(
                    'email_heading' => $this->get_heading(),
                    'sent_to_admin' => true,
                    'plain_text'    => true,
                    'email'         => $this
                ), '', UW_AUCTION_PRO_WC_TEMPLATE );
        }

        /**
         * Add form fields for email        
         *
         */
        public function init_form_fields() {
            $this->form_fields = array(
                'enabled'    => array(
                    'title'   => __( 'Enable/Disable', 'woocommerce' ),
                    'type'    => 'checkbox',
                    'label'   => __( 'Enable this email notification', 'woocommerce' ),
                    'default' => 'yes'
                ),
               
                'subject'    => array(
                    'title'       => __( 'Subject', 'woocommerce' ),
                    'type'        => 'text',
                    'description' => sprintf( __( 'This controls the email subject line. Leave blank to use the default subject: <code>%s</code>.', 'woo_ua' ), $this->subject ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'heading'    => array(
                    'title'       => __( 'Email Heading', 'woo_ua' ),
                    'type'        => 'text',
                    'description' => sprintf( __( 'This controls the main heading contained within the email notification. Leave blank to use the default heading: <code>%s</code>.', 'woo_ua' ), $this->heading ),
                    'placeholder' => '',
                    'default'     => '',
                    'desc_tip'    => true
                ),
                'email_type' => array(
                    'title'       => __( 'Email type', 'woocommerce' ),
                    'type'        => 'select',
                    'description' => __( 'Choose which format of email to send.', 
                        'woocommerce' ),
                    'default'     => 'html',
                    'class'       => 'email_type wc-enhanced-select',
                    'options'     => $this->get_email_type_options(),
                    'desc_tip'    => true
                )
            );
        }
    }
}
return new UWA_Email_Auction_Bid_Delete();