import { __ } from '@wordpress/i18n';
import SbSettingsCard from '../../lib/SbSettingsCard';
import Spacer from '../../lib/Spacer';
import SbUtils from '../../../Utils/SbUtils';
import { useContext } from 'react';
import SettingsContext from '../../../context/SettingsContext';

const Feeds = () => {
	const { register } = useContext(SettingsContext);

	return (
		<>
			<SbSettingsCard
				leftCol={
					<>
						<h2 className={'sw-text-lg sw-font-semibold'}>
							{__('Caching', 'social-wall')}
						</h2>
					</>
				}
				rightCol={
					<>
						<div className={'sw-flex sw-flex-col sm:sw-flex-row sm:sw-items-center sw-gap-3 sm:gap-0'}>
							<span className={'sw-text-sm'}>
								{__('Check for new posts', 'social-wall')}
							</span>
							<select
								{...register('cache_cron_interval')}
								id="cache_cron_interval"
								defaultValue={
									window.sbsw_admin.settings.cache_cron_interval
								}
								className="sw-select sm:sw-ml-4 sw-w-52"
							>
								<option defaultValue={'30mins'} value="30mins">
									{__('Every 30 minutes', 'social-wall')}
								</option>
								<option value="1hour">
									{__('Every hour', 'social-wall')}
								</option>
								<option value="12hours">
									{__('Every 12 hours', 'social-wall')}
								</option>
								<option value="24hours">
									{__('Every 24 hours', 'social-wall')}
								</option>
							</select>

							<button
								className={'sw-button-base sw-h-full sm:sw-ml-2 sw-text-sm sw-font-medium'}
								onClick={() => {
									SbUtils.clearExistingCache();
								}}
							>
								<svg
									width="20"
									height="20"
									viewBox="0 0 20 20"
									fill="none"
									xmlns="http://www.w3.org/2000/svg"
								>
									<path
										d="M15.8333 6.66665L12.4999 9.99998H14.9999C14.9999 11.3261 14.4731 12.5978 13.5355 13.5355C12.5978 14.4732 11.326 15 9.99992 15C9.16658 15 8.35825 14.7916 7.66658 14.4166L6.44992 15.6333C7.51083 16.3085 8.74237 16.667 9.99992 16.6666C11.768 16.6666 13.4637 15.9643 14.714 14.714C15.9642 13.4638 16.6666 11.7681 16.6666 9.99998H19.1666L15.8333 6.66665ZM4.99992 9.99998C4.99992 8.6739 5.5267 7.40213 6.46438 6.46445C7.40207 5.52676 8.67384 4.99998 9.99992 4.99998C10.8333 4.99998 11.6416 5.20831 12.3333 5.58331L13.5499 4.36665C12.489 3.69144 11.2575 3.33296 9.99992 3.33331C8.23181 3.33331 6.53612 4.03569 5.28587 5.28593C4.03563 6.53618 3.33325 8.23187 3.33325 9.99998H0.833252L4.16658 13.3333L7.49992 9.99998"
										fill="#141B38"
									/>
								</svg>
								<span className={'sw-ml-2'}>
									{__('Clear All Caches', 'social-wall')}
								</span>
							</button>
						</div>
					</>
				}
			/>

			<Spacer />

			<SbSettingsCard
				leftCol={
					<>
						<h2 className={'sw-text-lg sw-font-semibold'}>
							{__('Custom CSS', 'social-wall')}
						</h2>
					</>
				}
				rightCol={
					<>
						<textarea
							{...register('custom_css')}
							placeholder={__(
								'Enter your custom CSS here',
								'social-wall'
							)}
							rows={4}
							defaultValue={window.sbsw_admin.settings.custom_css}
							className={
								'sw-w-full sw-border sw-border-gray-300 sw-p-3 sw-text-base'
							}
						/>
					</>
				}
			/>

			<hr />

			<SbSettingsCard
				leftCol={
					<>
						<h2 className={'sw-text-lg sw-font-semibold'}>
							{__('Custom Javascript', 'social-wall')}
						</h2>
					</>
				}
				rightCol={
					<>
						<textarea
							{...register('custom_js')}
							placeholder={__(
								'Enter your custom Javascript here',
								'social-wall'
							)}
							rows={4}
							defaultValue={window.sbsw_admin.settings.custom_js}
							className={
								'sw-w-full sw-border sw-border-gray-300 sw-p-3 sw-text-base'
							}
						/>
					</>
				}
			/>
		</>
	);
};

export default Feeds;
