<?php

namespace B2;

class SekersSite extends \Fuse\Site
{

    const GOOGLE_API_KEY = "AIzaSyDwwR9nnze7Zea_Ms17M3EOUG58HX_T9xM";

    public function __construct($pluginDirectory)
    {
        parent::__construct($pluginDirectory, 'UA-8190406-1'); //UA-8190406-1

        add_action('init', array($this, 'registerPostTypes'));
        add_action('init', array($this, 'registerTaxonomies'));
        add_action('wpcf7_before_send_mail',array($this,'location_email'));
        if(isset($_GET['action']) && $_GET['action'] == 'update-terms'){
        add_action('init', array($this, 'registerTerms'));
        }
        add_action('acf/save_post', array($this, 'onSaveSupplier'), 20);
        add_action('pre_get_posts', array($this, 'includeVariations'));
        add_action('set_user_role', array($this, 'user_role_update'), 20, 2);
       add_filter('wp_title', array($this, 'customiseTitle'), 20, 2);
       add_filter('wpseo_title', array($this, 'customiseTitle'), 20, 2);
       add_filter('query_vars', array($this, 'addCollectionVar'));
       add_filter('rewrite_rules_array', array($this, 'addCollectionRewrite'));
       
       add_filter('manage_users_columns', array($this, 'addUserColumns'));
       add_action('manage_users_custom_column',  array($this, 'showUserColumnContent'), 10, 3);
       add_action( 'restrict_manage_users', array($this, 'addUserFilters') );
       add_filter( 'pre_get_users', array($this, 'filterUsers') );
       add_filter( 'wp_nav_menu_items', array($this, 'addTradePrices'), 10, 2 );


        $customWoo = new SekersSiteWooCustom();
        $customWoo->startCustomisations();

    }

    public function addTradePrices($items, $args )
    {
        if ($args->theme_location == 'footer_menu') {

            $priceList = get_field('price_list', 'option');
            if($this->showPriceList() && $priceList != ''){

                $items .= '<li><a href="'.$priceList.'" target="_blank">Trade Price List</a></li>';
            }
        }
        return $items;
    }
    
    public function filterUsers( $query ) {
        global $pagenow;
    
        if ( is_admin() && 'users.php' == $pagenow){  
            $meta = [];               
            if(isset( $_GET[ 'sales_rep' ] ) && !empty( $_GET[ 'sales_rep' ] )) {
                $section = $_GET[ 'sales_rep' ];
                $meta[] = array(
                        'key'   => 'sales_rep',
                        'value' => $section);
            }              
            if(isset( $_GET[ 'trade' ] ) && !empty( $_GET[ 'trade' ] )) {
                $section = $_GET[ 'trade' ];
                $meta[] = array(
                        'key'   => 'trade',
                        'value' => $section);
            }

            if(count($meta)){
                $query->set( 'meta_query', $meta );
            }
        }
    }

    public function addUserFilters($which) {

        if($which == 'top'){
            echo '<select name="sales_rep" style="float:none;">';
            echo '<option value="">Sales Rep...</option>';

            $users = new \WP_User_Query(['role__in' => ['Administrator','Shop Manager'], 'orderby' => 'display_name']);
            $currentFilter = isset($_GET['sales_rep']) ? $_GET[ 'sales_rep' ] : false;

            if ( ! empty( $users->get_results() ) ) {
                foreach ( $users->get_results() as $user ) {
                    $state = $currentFilter == $user->ID ? 'selected':'';
                    echo "<option value='{$user->ID}' {$state}>{$user->display_name}</option>";
                }
            }
            echo '</select>';

            echo '<select name="trade" style="float:none;">';
            echo '<option value="">Consider for Trade Account...</option>';
            echo '<option value="1">Yes</option>';
            echo '<option value="0">No</option>';
            echo '</select>';

            echo '<input id="post-query-submit" type="submit" class="button" value="Filter" name="">';
        }
    }

    public function addUserColumns($columns) {
        $columns['trade'] = 'Consider for trade account';
        $columns['sales_rep'] = 'Sales Rep';
        return $columns;
    }

    public function showUserColumnContent($value, $column_name, $user_id) {
        if ( 'sales_rep' == $column_name ){
            $repId = get_user_meta($user_id, 'sales_rep', true);
            $rep = get_userdata( $repId );

            return $rep ? $rep->get('display_name') : '';
        }elseif ( 'trade' == $column_name ){
            $trade = get_user_meta($user_id, 'trade', true);

            return $trade ? 'Yes' : 'No';
        }
        return $value;
    }

    public function addCollectionVar($aVars)
    {
        $aVars[] = "wemyss_coll_filter";
        return $aVars;
    }

    public function addCollectionRewrite($aRules)
    {
        $shopId = get_option( 'woocommerce_shop_page_id' );
        $collectionPage =  get_post_field( 'post_name', $shopId );
        $aNewRules = array($collectionPage.'/([^/]+)/?$' => 'index.php?pagename='.$collectionPage.'&wemyss_coll_filter=$matches[1]');
        $aRules = $aNewRules + $aRules;
        return $aRules;
    }

    public function customiseTitle( $title, $sep = ' - ' )
    {
        if(is_shop()){
            $pageId = get_option( 'woocommerce_shop_page_id' );
            $title = get_the_title($pageId);// Add the site name.
            $title .=  $sep . get_bloginfo( 'name' );
        }
        elseif(is_archive())
        {
            return str_replace(' Archives', '', $title);
        }
        elseif(is_front_page())
        {
            return get_bloginfo( 'name' );
        }

        return $title;
    }

    public function registerPostTypes()
    {
        $projectPT = new \Fuse\PostType("supplier");
        $projectPT->register("Supplier", "Suppliers", array(), array("menu_icon" => "dashicons-businessman", 'exclude_from_search' => true));
    
        $teamMember = new \Fuse\PostType("team_member");
        $teamMember->register("Team Member", "Team Members", array(), array("menu_icon" => "dashicons-groups", 'exclude_from_search' => true,
        'rewrite' => array( 'slug' => 'team' ),));
/*
        $timeline = new \Fuse\PostType("timeline");
        $timeline->register("Timeline", "Timeline", array(), array("menu_icon" => "dashicons-clock", 'exclude_from_search' => true,
        'has_archive' => false,));*/
    }    

    public static function getBrochureProducts()
    {
        $args = [
            'post_type' => 'product',
            'post_status' => 'publish',
            'order' => 'ASC',
            'orderby' => 'title',
            'meta_query' => [[         
			'key'     => 'show_in_collection_brochure',
			'value'   => '1',
			'compare' => '=',]
        ]];

        $products = new \WP_Query($args);
        return $products->posts;
    }

    public function registerTaxonomies()
    {
        $colourTax = new \Fuse\Taxonomy("colour");
        $colourTax->register("Colour", "Colours", array("product"), [], array('public' => false, 'show_ui' => false, 'show_admin_column' => false));

        $fabricTax = new \Fuse\Taxonomy("fabric_types");
        $fabricTax->register("Fabric Type", "Fabric Types", array("product"), [],  array('public' => false, 'show_in_menu' => false, 'show_admin_column' => false));

        $designTax = new \Fuse\Taxonomy("designs");
        $designTax->register("Design", "Designs", array("product"), [],  array('public' => false, 'show_in_menu' => false, 'show_admin_column' => false));

        $usageTax = new \Fuse\Taxonomy("usages");
        $usageTax->register("Usage", "Usages", array("product"), [],  array('public' => false, 'show_in_menu' => false, 'show_admin_column' => false));

        /*$careTax = new \Fuse\Taxonomy("care");
        $careTax->register("Care Tag", "Care Tags", array("product"), [],  array('public' => false, 'show_in_menu' => false, 'show_admin_column' => false,
        'capabilities'      => array(
            'assign_terms' => 'manage_options',
            'edit_terms'   => 'non-existent',
            'manage_terms' => 'non-existent',
        )));*/

    }  
    
    public function includeVariations($query)
    {
        if ( !is_admin() && $query->is_main_query() ) {
            if ( $query->is_search ) {
                $query->set('post_type', array( 'post', 'page', 'product', 'product_variation' ));
                $query->set('orderby', ['post_type' => 'ASC', 'post_title' => 'ASC', 'post_date' => 'desc']);

            }
        }
    }
    
    public function registerTerms()
    {
        
        $colours = ["Beige", "Black", "Blue", "Brown", "Cream", "Gold", "Green", "Grey", "Mauve", "Orange", "Pink", "Purple", "Red", "Silver", "Taupe", "Turquoise", "White", "Yellow"];
        $this->updateTerms($colours, "colour");

        $fabrics = ["Chenilles", "Cottons", "Embroidery", "Faux Leathers", "Faux Suedes", "Jacquards", "Linens", "Metallics", "Prints", "Quilted", "Sheers & Voiles", "Silks", "Textures", "Velvets", "Wools"];
        $this->updateTerms($fabrics, "fabric_types");

        $designs = ["Animal", "Abstract", "Checks & Plaids", "Dots & Spots", "Florals", "Geometric", "Herringbone", "Paisley", "Plains & Semi-plains", "Semi-plains", "Small pattern", "Stripes", "Trellis & Lattice", "Large pattern"];
        $this->updateTerms($designs, "designs");

        $usages = ["Drapery", "Bedding", "Upholstery", "Cushions", "Contract"];
        $this->updateTerms($usages, "usages");

        /*$care = ["Dry Clean", "Do Not Wash", "Do Not Bleach", "Do Not Iron", "Do Not Dry Clean", "Wash At 30", "Tumble Dry", "Wash at 60", "Do Not Tumble Dry", "Wash at 40", "Hand Wash"];
        $careArgs = [
            "Dry Clean" => ['slug' => 'dry-clean'],
            "Do Not Wash" => ['slug' => 'no-wash'],
            "Do Not Bleach" => ['slug' => 'no-bleach'],
            "Do Not Iron" => ['slug' => 'no-iron'],
            //"Sponge Clean" => ['slug' => 'sponge-clean'],
            "Do Not Dry Clean" => ['slug' => 'no-dry-clean'],
            "Wash At 30" => ['slug' => 'wash-30'],
            "Tumble Dry" => ['slug' => 'tumble-dry'],
            "Wash at 60" => ['slug' => 'wash-60'],
            "Do Not Tumble Dry" => ['slug' => 'no-tumble-dry'],
            "Wash at 40" => ['slug' => 'wash-40'],
            "Hand Wash" => ['slug' => 'hand-wash'],
        ];
        $this->updateTerms($care, "care", $careArgs);*/

    }

    private function updateTerms($terms, $taxonomy, $args = []){        

        $existingTerms = get_terms($taxonomy, ['hide_empty' => false]);

        foreach($existingTerms as $existingTerm){
           if(!in_array($existingTerm->name, $terms)){
            wp_delete_term( $existingTerm->term_id, $taxonomy);
            }
        }

        foreach ($terms as $term) {
            if(!term_exists( $term, $taxonomy )){
                $termArgs = isset($args[$term]) ? $args[$term] : [];
                wp_insert_term($term, $taxonomy, $termArgs);
            }
        }
    }

    public static function collectionSearch()
    {

        $args = array(
            'taxonomy'      => array( 'product_cat' ), // taxonomy name
            'orderby'       => 'id', 
            'order'         => 'ASC',
            'hide_empty'    => true,
            'fields'        => 'all',
            'name__like'    => get_search_query()
        ); 
        
        return get_terms( $args );
    }

    public static function supplierPostcodeForm($internationalOnly = false)
    {
        global $wpdb;

        $postTerm = isset($_POST['supplier_postcode']) ? trim($_POST['supplier_postcode']) : null;
        $coords = self::geocode($postTerm);
        $limit = isset($_POST['supplier_postcode'])? 20 : 10000;


        if ($coords) {
            $latitude = $coords['lat'];
            $longitude = $coords['lng'];
            $query = "
            SELECT p.ID, p.post_title, p.guid, ( 3959 * acos( cos( radians( $latitude ) ) 
            * cos( radians( pm.meta_value ) ) * cos( radians( pm2.meta_value ) - radians( $longitude ) ) 
            + sin( radians( $latitude ) ) * sin( radians( pm.meta_value ) ) ) ) as distance
            FROM $wpdb->posts p, $wpdb->postmeta pm, $wpdb->postmeta pm2
            WHERE p.ID = pm.post_id AND pm.meta_key = 'b2_lat' AND pm.meta_value IS NOT NULL
            AND p.ID = pm2.post_id  AND pm2.meta_key = 'b2_lng' AND pm2.meta_value IS NOT NULL
            AND p.post_status = 'publish' AND p.post_type = 'supplier'

            ORDER BY distance
            LIMIT 0, $limit";
        } else {
            $intQuery = $internationalOnly ? " AND p.ID = pm.post_id  AND pm.meta_key = 'country' AND pm.meta_value != 'United Kingdom'" : '';
            $intJoin = $internationalOnly ? ", $wpdb->postmeta pm " : '';
            $query = "
            SELECT p.ID, p.post_title, p.guid
            FROM $wpdb->posts p".$intJoin."
            WHERE p.post_status = 'publish' 
            AND p.post_type = 'supplier' ".$intQuery."
            ORDER BY p.post_title
            LIMIT 0, $limit";
        }

        return $wpdb->get_results($query, OBJECT);
    }

    public static function geocode($address)
    {

        if ($address) {
            $searchTerm = urlencode($address);

            $result = file_get_contents('https://maps.google.com/maps/api/geocode/json?address=' . $searchTerm . '&sensor=false&key=' . self::GOOGLE_API_KEY);
            $output = json_decode($result);

            $latitude = $output->status === "OK" ? $output->results[0]->geometry->location->lat : false;
            $longitude = $output->status === "OK" ? $output->results[0]->geometry->location->lng : false;
            $coordinates = $latitude !== false && $longitude !== false ? array("lat" => $latitude, "lng" => $longitude) : false;
            return $coordinates;
        }
        return false;
    }

    public static function showPriceList()
    {
        $user = wp_get_current_user();

        if ($user && (in_array('trade_customer', $user->roles) || in_array('administrator', $user->roles) )) {
            return true;
        }
        return false;
    }

    public function onSaveSupplier($post_id)
    {
        $post_type = get_post_type($post_id);

        if ("supplier" != $post_type) {
            return;
        }

        $map = get_field('map');

        $lat = isset($map['lat']) ? $map['lat'] : null;
        $lng = isset($map['lng']) ? $map['lng'] : null;
        update_post_meta($post_id, 'b2_lat', $lat);
        update_post_meta($post_id, 'b2_lng', $lng);

        return;
    }

    public static function getFullAddress($postId)
    {
        $address = [
            get_field('address_1', $postId),
            get_field('address_2', $postId),
            get_field('town', $postId),
            get_field('county', $postId),
            get_field('post_code', $postId),
            get_field('country', $postId),
        ];

        $address = array_filter($address);

        return implode('<br/>', $address);

    }



    public function location_email($wpcf7){

        $submission = \WPCF7_Submission::get_instance();
        if ( $submission ) {
            $posted_data = $submission->get_posted_data();
        }

        $location = $posted_data['country'];

        if ($location != 'United Kingdom'){
            $custom_email = get_field('row_email_address','option');
            $mail = $wpcf7->prop( 'mail' );
            $mail['recipient'] = $custom_email;
            $wpcf7->set_properties(array('mail'=>$mail));
        }

        return $wpcf7;
    }


    public function user_role_update( $user_id, $new_role ) {
        if($new_role == 'trade_customer'){
            $user_info = get_userdata( $user_id );
            $to = $user_info->user_email;
            $headers = "Content-Type: text/html; charset=UTF-8" . "\r\n";
            $subject = "Sekers Trade Account now active";
            $message = 'Hello '.ucfirst($user_info->first_name).', <br/><br/>Your Trade Account is now active on <a href="https://www.sekersfabrics.co.uk/" target=_blank>Sekers Fabrics</a>.<br/> Your user login is still:  '.$user_info->user_login.'<br/>and you can log in <a href="https://www.sekersfabrics.co.uk/my-account/">HERE.</a><br/><br/>Thanks,<br/> The Sekers Team';
            wp_mail($to, $subject, $message, $headers);
        }
    }

}
