<?php

namespace B2;

class SekersSiteWooCustom
{
    public function startCustomisations()
    {
        add_action('init', array($this, 'initWooCommerce'));
        add_action( 'admin_menu', array($this, 'remove_woo'));
        add_action( 'init', array($this, 'registerDownloadStatus') );
        add_action( 'woocommerce_email_recipient_new_order', array($this, 'wc_email_by_country_filter'), 10, 2  );
    }

    /**
     * Set up custom actions and filters
     */
    public function initWooCommerce()
    {
        add_filter( 'woocommerce_customer_get_downloadable_products', [$this, 'removeDuplicateDownloads'], 10, 1 );
        add_filter( 'wc_order_statuses', array($this, 'addDownloadToStatuses') );
        add_action( 'woocommerce_order_status_download-swatch', 'wc_downloadable_product_permissions' );
        add_filter( 'woocommerce_order_is_download_permitted', array($this, 'addDownloadStatusToPermissions'), 10, 2);
        add_filter('woocommerce_order_is_paid_statuses', array($this, 'addDownloadSwatchToPaid'), 10, 1);

        add_action( 'wp_ajax_download_swatch', array($this, 'downloadSwatch') );
        add_action( 'wp_ajax_nopriv_download_swatch', array($this, 'downloadSwatch') );


        $this->renameCategory();
        add_role('trade_customer', 'Trade Customer', ['read' => true]);

        add_action('woocommerce_product_query', array($this, 'wooShowVariations'), 20, 3);
        add_action('save_post_product', array($this, 'wooUpdateVariation'), 50, 3);

        add_action('woocommerce_register_form', [$this, 'addFrontendFields'], 10 );
        add_action('woocommerce_edit_account_form', [$this, 'addFrontendFields'], 10 );
        add_filter('woocommerce_checkout_fields', [$this, 'addBootstrapFormClass'], 10, 1);
        add_filter('woocommerce_checkout_fields', [$this, 'addCheckoutFields'], 20, 1 );
        add_action('show_user_profile', [$this, 'addAdminFields'], 30 ); // admin: edit profile
        add_action('edit_user_profile', [$this, 'addAdminFields'], 30 ); // admin: edit other users
        add_action( 'woocommerce_created_customer', [$this, 'saveAccountFields'] ); // register/checkout
        add_action( 'personal_options_update', [$this, 'saveAccountFields']  ); // edit own account admin
        add_action( 'edit_user_profile_update', [$this, 'saveAccountFields']  ); // edit other account admin
        add_action( 'woocommerce_save_account_details', [$this, 'saveAccountFields']  ); // edit WC account
        add_action( 'woocommerce_created_customer', [$this, 'sendRegistrationNotification'], 20, 3  );

        add_filter( 'wemyss_account_fields', [$this, 'addPostToAccountFields'], 10, 1 );
        add_filter('woocommerce_account_orders_columns', [$this, 'removeTotalColumn'], 10, 1);
        add_filter('woocommerce_product_add_to_cart_text',[$this, 'updateCartText'], 20);

        add_action('woocommerce_product_after_variable_attributes', array($this, 'addColourToVariation'), 10, 3);
        // Save Variation Settings
        add_action('woocommerce_save_product_variation', array($this, 'saveVariationColour'), 10, 2);
        add_action( 'woocommerce_add_to_cart', array($this, 'limitCartTotal'), 10, 6 );

        remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
        add_action( 'wp_print_scripts', array($this,'removePasswordStrength'), 10 );
        add_filter( 'woocommerce_min_password_strength', array($this, 'reduceMinStrengthRequirement'), 10 );

    }
    function reduceMinStrengthRequirement( $strength ) {
        return 1;
    }
    function removePasswordStrength() {
        wp_dequeue_script( 'wc-password-strength-meter' );
    }

    public function removeDuplicateDownloads($downloads){

        $newDownloads = [];

        foreach($downloads as $download){
            if(!isset($newDownloads[$download['product_id']])){
                $newDownloads[$download['product_id']] = $download;
            }
        }

        return $newDownloads;
    }

    public static function getAllVariations()
    {
        global $wpdb;
        $result = $wpdb->get_results( "SELECT t.name AS collection, t.slug AS collectionSlug, p2.ID AS productId,
        p2.post_title AS product, p.ID AS variationId, p.post_title AS variation FROM pex_sekers_dev_posts p
        JOIN pex_sekers_dev_posts p2 ON p2.ID = p.post_parent
        JOIN pex_sekers_dev_term_relationships tr ON p.ID = tr.object_id
        JOIN pex_sekers_dev_terms t ON tr.term_taxonomy_id = t.term_id
        JOIN pex_sekers_dev_term_taxonomy tt ON t.term_id = tt.term_id AND tt.taxonomy = 'product_cat'
        WHERE p.post_type = 'product_variation'
        ORDER BY t.name, p2.post_title, p.post_title");

        $variationGrouped = [];

        foreach($result as $result){
            if(!isset($variationGrouped[$result->collection])){
                $variationGrouped[$result->collection] = [];
            }
            if(!isset($variationGrouped[$result->collection][$result->product])){
                $variationGrouped[$result->collection][$result->product] = [];
            }
            $variationGrouped[$result->collection][$result->product][] = $result;
        }
        return $variationGrouped;

    }

    public static function getAllFROneVariations()
    {
        global $wpdb;
        $result = $wpdb->get_results( "SELECT t.name AS collection, t.slug AS collectionSlug, p2.ID AS productId,
        p2.post_title AS product, p.ID AS variationId, p.post_title AS variation FROM pex_sekers_dev_posts p
        JOIN pex_sekers_dev_posts p2 ON p2.ID = p.post_parent
        JOIN pex_sekers_dev_term_relationships tr ON p.ID = tr.object_id
        JOIN pex_sekers_dev_terms t ON tr.term_taxonomy_id = t.term_id
        JOIN pex_sekers_dev_term_taxonomy tt ON t.term_id = tt.term_id AND tt.taxonomy = 'product_cat'
        WHERE p.post_type = 'product_variation'
        ORDER BY t.name, p2.post_title, p.post_title");

        $variationGrouped = [];

        foreach($result as $result){
            $term = get_term_by('slug', $result->collectionSlug, 'product_cat');
            $isFroneCollection = get_field('is_frone', 'term_' . $term->term_id);
            if ($isFroneCollection) {
                if(!isset($variationGrouped[$result->collection])){
                    $variationGrouped[$result->collection] = [];
                }
                if(!isset($variationGrouped[$result->collection][$result->product])){
                    $variationGrouped[$result->collection][$result->product] = [];
                }
                $variationGrouped[$result->collection][$result->product][] = $result;
            }
        }
        return $variationGrouped;
    }

    public static function createDownloadOrder($product_id)
    {
        $user_id = get_current_user_id();
        $product = wc_get_product( $product_id );

        if($product){
            if($user_id){ //Logged in
                //Check for existing order to avoid duplicating
                $order = self::hasDownloadedSwatch(1, $product_id);
                if(!$order){
                    // Now we create the order
                    $order = wc_create_order();
                    $order->add_product( $product, $user_id);
                    $order->set_customer_id(1);
                    $res = $order->set_status("download-swatch", 'Auto generated swatch download', TRUE);
                    $order->save();
                }

                $data_store = \WC_Data_Store::load( 'customer-download' );

                $download_ids = $data_store->get_downloads( array(
                    'order_id'  => $order->get_id(),
                    'product_id'  => $product_id,
                    'orderby'     => 'downloads_remaining',
                    'order'       => 'DESC',
                    'limit'       => 1,
                    'return'      => 'ids',
                ) );

                //Increment download number
                $download = new \WC_Customer_Download( current( $download_ids ) );
                $count     = $download->get_download_count();
                $download->set_download_count( $count + 1 );
                $download->save();
            }

            $availableDownloads = $product->get_downloads();
            $availableDownload = current($availableDownloads);

            \WC_Download_Handler::download( $availableDownload['file'], $product_id );

        }

        return false;
    }


    function registerDownloadStatus() {
        register_post_status( 'wc-download-swatch', array(
            'label'                     => 'Download Swatch',
            'public'                    => true,
            'exclude_from_search'       => false,
            'show_in_admin_all_list'    => true,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop( 'Download Swatch <span class="count">(%s)</span>', 'Download Swatch <span class="count">(%s)</span>' )
        ) );
    }

    function addDownloadToStatuses( $order_statuses ) {
        $new_order_statuses = array();
        // add new order status after processing
        foreach ( $order_statuses as $key => $status ) {
            $new_order_statuses[ $key ] = $status;
            if ( 'wc-processing' === $key ) {
                $new_order_statuses['wc-download-swatch'] = 'Download Swatch';
            }
        }
        return $new_order_statuses;
    }

    function addDownloadStatusToPermissions($result, $order)
    {
        return $order->get_status() == 'download-swatch' ?: $result;
    }

    public static function hasDownloadedSwatch( $user_id = 0,  $product_ids = 0 ) {
        global $wpdb;
        $customer_id = $user_id == 0 || $user_id == '' ? get_current_user_id() : $user_id;
        $statuses      = array_map( 'esc_sql', wc_get_is_paid_statuses() );

        if ( is_array( $product_ids ) )
            $product_ids = implode(',', $product_ids);

        if ( $product_ids !=  ( 0 || '' ) )
            $query_line = "AND woim.meta_value IN ($product_ids)";
        else
            $query_line = "AND woim.meta_value != 0";

        // Count the number of products
        $product_count_query = $wpdb->get_col( "
            SELECT woi.order_id FROM {$wpdb->prefix}posts AS p
            INNER JOIN {$wpdb->prefix}postmeta AS pm ON p.ID = pm.post_id
            INNER JOIN {$wpdb->prefix}woocommerce_order_items AS woi ON p.ID = woi.order_id
            INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta AS woim ON woi.order_item_id = woim.order_item_id
            WHERE p.post_status IN ( 'wc-" . implode( "','wc-", $statuses ) . "' )
            AND pm.meta_key = '_customer_user'
            AND pm.meta_value = $customer_id
            AND woim.meta_key IN ( '_product_id', '_variation_id' )
            $query_line
        " );

        $order_id = reset($product_count_query);

        if($order_id > 0){
            return wc_get_order( $order_id );
        }

        return  false;
    }

    function addDownloadSwatchToPaid($paid)
    {
        $paid[] = 'download-swatch';

        return $paid;
    }

    function downloadSwatch()
    {
        $product_id = filter_input(INPUT_GET, 'product_id', FILTER_SANITIZE_STRING);
        self::createDownloadOrder($product_id);
        die;
    }

    function renameCategory() {
        global $wp_taxonomies;

        $cat = $wp_taxonomies['product_cat'];
        $cat->label = 'Collections';
        $cat->labels->singular_name = 'Collection';
        $cat->labels->name = $cat->label;
        $cat->labels->menu_name = $cat->label;
        $cat->labels->search_items      = __( 'Search collections', 'wemyss' );
        $cat->labels->all_items         = __( 'All collections', 'wemyss' );
        $cat->labels->parent_item       = __( 'Parent collection', 'wemyss' );
        $cat->labels->parent_item_colon = __( 'Parent collection:', 'wemyss' );
        $cat->labels->edit_item         = __( 'Edit collection', 'wemyss' );
        $cat->labels->update_item       = __( 'Update collection', 'wemyss' );
        $cat->labels->add_new_item      = __( 'Add new collection', 'wemyss' );
        $cat->labels->new_item_name     = __( 'New collection name', 'wemyss' );
        $cat->labels->not_found         = __( 'No collections found', 'wemyss' );
    }

    public function updateCartText()
    {
        return 'Order Sample';
    }

    /**
     * Custom multiselect based on Woocommerce field helper function
     */
    public static function woocommerce_wp_select_multi($field)
    {
        global $thepostid, $post;

        $thepostid = empty($thepostid) ? $post->ID : $thepostid;
        $field['class'] = isset($field['class']) ? $field['class'] : 'select short';
        $field['style'] = isset($field['style']) ? $field['style'] : '';
        $field['wrapper_class'] = isset($field['wrapper_class']) ? $field['wrapper_class'] : '';
        $field['value'] = isset($field['value']) ? $field['value'] : get_post_meta($thepostid, $field['id'], true);
        $field['name'] = isset($field['name']) ? $field['name'] : $field['id'];
        $field['desc_tip'] = isset($field['desc_tip']) ? $field['desc_tip'] : false;

        // Custom attribute handling
        $custom_attributes = array();

        if (!empty($field['custom_attributes']) && is_array($field['custom_attributes'])) {

            foreach ($field['custom_attributes'] as $attribute => $value) {
                $custom_attributes[] = esc_attr($attribute) . '="' . esc_attr($value) . '"';
            }
        }

        echo '<p class="form-row form-row-full ' . esc_attr($field['id']) . '_field ' . esc_attr($field['wrapper_class']) . '">
            <label for="' . esc_attr($field['id']) . '">' . wp_kses_post($field['label']) . '</label>';

        if (!empty($field['description']) && false !== $field['desc_tip']) {
            echo wc_help_tip($field['description']);
        }
        $values = unserialize($field['value']);

        echo '<select id="' . esc_attr($field['id']) . '" name="' . esc_attr($field['name']) . '" class="' . esc_attr($field['class']) . '" style="' . esc_attr($field['style']) . '" ' . implode(' ', $custom_attributes) . '>';

        foreach ($field['options'] as $key => $value) {
            $selected = in_array(esc_attr($key), $values) ? 'selected' : '';
            echo '<option value="' . esc_attr($key) . '" ' . $selected . '>' . esc_html($value) . '</option>';
        }
        echo '</select> ';

        if (!empty($field['description']) && false === $field['desc_tip']) {
            echo '<span class="description">' . wp_kses_post($field['description']) . '</span>';
        }
        echo '</p>';
    }

    /**
     * Adds a multiselect to product variations allowing colours to be set for search
     */
    public function addColourToVariation($loop, $variation_data, $variation)
    {

        $colours = get_terms('colour', ['hide_empty' => false]);
        $options = [];
        foreach ($colours as $colour) {
            $options[$colour->term_id] = $colour->name;
        }

        self::woocommerce_wp_select_multi(
            array(
                'id' => 'variation_colours[' . $variation->ID . '][]',
                'class' => 'postform',
                'label' => __('Colours', 'woocommerce'),
                'description' => __('Select which colours this variation should show in filters for. Hold \'Ctrl\' to select/deselect multiple options', 'woocommerce'),
                'value' => get_post_meta($variation->ID, 'variation_colours', true),
                'options' => $options,
                'custom_attributes' => ['multiple' => 'multiple']
            )
        );

    }

    public function limitCartTotal($cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data)
    {

        global $woocommerce;
        $items = $woocommerce->cart->get_cart();

        $maxItems = 6;

        $user = wp_get_current_user();

        if ($user && (in_array('trade_customer', $user->roles) || in_array('administrator', $user->roles) )) {
            $maxItems = 20;
        }

        if(count($items) > $maxItems){
            $woocommerce->cart->remove_cart_item($cart_item_key);
            throw new \Exception( sprintf( '<a href="%s" class="button wc-forward">%s</a> %s', wc_get_cart_url(), __( 'View cart', 'woocommerce' ), sprintf( __( 'You cannot add more than %s items to your cart.', 'woocommerce' ), $maxItems ) ) );
        }
    }

    /**
     * Save new fields for variations
     *
     */
    public function saveVariationColour($post_id)
    {
        // Select
        $select = $_POST['variation_colours'][$post_id];
        if (!empty($select)) {

            $clean = array_filter($select, 'esc_attr');

            update_post_meta($post_id, 'variation_colours', serialize($clean));
            wp_set_post_terms($post_id, $clean, 'colour');
        }

    }

    public function sendRegistrationNotification( $customer_id, $new_customer_data = array(), $password_generated = false ) {
        if ( ! $customer_id ) {
            return;
        }

        $trade = get_user_meta($customer_id, 'trade', true) ? 'yes' : 'no';
        $marketing = get_user_meta($customer_id, 'marketing', true) ? 'yes' : 'no';

        $siteName =  wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );

        $adminEmail = get_field('registration_admin_email', 'option');

        $to = $adminEmail ?: get_bloginfo('admin_email');
        $subject = $siteName.' - A new customer has registered';

        $message = wc_get_template_html('emails/new-customer-registration.php',array(
            'blogname'           => $siteName,
            'marketing'          => $marketing,
            'trade'              => $trade,
            'username'           => $new_customer_data['user_login'],
            'useremail'           => $new_customer_data['user_email']
        ));

        add_filter( 'wp_mail_content_type', array($this, 'setMailContentType') );
        wp_mail( $to, $subject, $this->style_inline($message), [], [] );
        remove_filter( 'wp_mail_content_type', array($this, 'setMailContentType') );
    }


    public function setMailContentType(){
        return 'text/html';
    }

    private function style_inline( $content ) {
        // make sure we only inline CSS for html emails

        // include css inliner
        if ( ! class_exists( 'Emogrifier' ) && class_exists( 'DOMDocument' ) ) {
            include_once( WooCommerce::plugin_path() . '/libraries/class-emogrifier.php' );
        }

        if ( class_exists( 'DOMDocument' ) ) {
            ob_start();
            wc_get_template( 'emails/email-styles.php' );
            $css = apply_filters( 'woocommerce_email_styles', ob_get_clean() );

            // apply CSS styles inline for picky email clients
            try {
                $emogrifier = new \Emogrifier( $content, $css );
                $content    = $emogrifier->emogrify();
            } catch ( Exception $e ) {
                $logger = wc_get_logger();
                $logger->error( $e->getMessage(), array( 'source' => 'emogrifier' ) );
            }
        }
        return $content;
    }

    private static function prepareFilter(&$query, $filterArgs = [])
    {

        $page = isset($filterArgs['page']) ? $filterArgs['page'] :0;

        $query->set('post_type', ['product_variation']);
        $query->set('post_status', 'publish');
        $query->set('posts_per_page', 300);
        $query->set('paged', $page);
        $query->set('orderby', 'title');
        $query->set('order', 'asc');

        $allowedSearchTerms = ['fabric', 'design', 'usage'];
        $keyTranslations = [
            'p_colour' => 'colour',
            'fabric' => 'fabric_types',
            'design' => 'designs',
            'usage' => 'usages',
        ];
        $tax_query = [];

        $parentIds = [];
        $parentTerms = [];
        foreach ($filterArgs as $key => $value) {
            if (in_array($key, $allowedSearchTerms)) {
                $parentTerms[] = [
                    'taxonomy' => $keyTranslations[$key],
                    'field' => 'slug',
                    'terms' => $value
                ];

            }
        }

        $parentMeta = ['relation' => 'AND'];
        if(isset($filterArgs['product_type'])){
            $parentMeta[] = ['key' => 'product_type',
                'value' => $filterArgs['product_type'],
                'compare' => '=',
            ];
        }
        if(isset($filterArgs['performance'])){
            $parentMeta[] = ['key' => 'performance',
                'value' => $filterArgs['performance'],
                'compare' => 'LIKE',
            ];
        }

        if (count($parentTerms) || count($parentMeta)) {

            $products = new \WP_Query([
                'post_type' => 'product',
                'post_status' => 'publish',
                'nopaging' => true,
                'fields' => 'ids',
                'tax_query' => $parentTerms,
                'meta_query' => $parentMeta
            ]);

            $parentIds = $products->posts;

            if(!count($parentIds)){
                $parentIds[] = -1;
            }
            $query->set('post_parent__in', $parentIds);
        }

        if (isset($filterArgs['p_colour'])) {
            $tax_query[] = [
                'taxonomy' => 'colour',
                'field' => 'slug',
                'terms' => $filterArgs['p_colour'],
            ];
        }

        if(isset($filterArgs['collectionIds'])){
            $tax_query[] = [
                'taxonomy' => 'product_cat',
                'field' => 'term_id',
                'terms' => $filterArgs['collectionIds'],
                'operator' => 'IN'
            ];

        }

        $query->set('tax_query', $tax_query);

        return $query;
    }

    /**
     * Modify the WooCommerce query to only show variations on the collection page
     */
    public function wooShowVariations($q, $wc, $override = false)
    {
        if (is_product_category() || $override) {

            $get = array_filter($_POST, function ($val) {
                return filter_var($val, FILTER_SANITIZE_SPECIAL_CHARS);
            });

            self::prepareFilter($q, $get);
        }
    }

    /**
     * Save the product category (collection) to all variations directly to show on collection page
     * default price to 0
     */
    public function wooUpdateVariation($post_id, $post, $update)
    {
        $product = wc_get_product($post_id);

        if ($product->get_type() == 'variable') {

            $categoryIds = $product->get_category_ids();
            $variations = $product->get_available_variations();

            if ($product->get_status() !== 'publish') {
                $categoryIds = [];
            }
            foreach ($variations as $variation) {
                wp_set_post_terms($variation['variation_id'], $categoryIds, 'product_cat');
                $price = get_post_meta($variation['variation_id'], '_regular_price', true);

                if ($price == "") {
                    update_post_meta($variation['variation_id'], '_regular_price', '0');
                    update_post_meta($variation['variation_id'], '_price', '0');
                }

            }
        }
    }

    public static function getFilteredCollectionIds($filter)
    {
        $filterArgs = [
            'product_type' => $filter,
            'performance' => $filter,
            'fabric' => $filter,
            'design' => $filter,
            'usage' => $filter,
            'p_colour' => $filter
        ];

        $allowedSearchTerms = ['fabric', 'design', 'usage'];
        $keyTranslations = [
            'p_colour' => 'colour',
            'fabric' => 'fabric_types',
            'design' => 'designs',
            'usage' => 'usages',
        ];

        $parentIds = [];

        //Find products with terms from filter
        $parentTerms = ['relation' => 'OR'];
        foreach ($filterArgs as $key => $value) {
            if (in_array($key, $allowedSearchTerms)) {
                $parentTerms[] = [
                    'taxonomy' => $keyTranslations[$key],
                    'field' => 'slug',
                    'terms' => $value
                ];

            }
        }

        $products = new \WP_Query([
            'post_type' => 'product',
            'post_status' => 'publish',
            'nopaging' => true,
            'fields' => 'ids',
            'tax_query' => $parentTerms
        ]);
        $parentIds = $products->posts;

        //Find products with meta from filter
        $parentMeta = ['relation' => 'OR'];
        if(isset($filterArgs['product_type'])){
            $parentMeta[] = ['key' => 'product_type',
                'value' => $filterArgs['product_type'],
                'compare' => '=',
            ];
        }
        if(isset($filterArgs['performance'])){
            $parentMeta[] = ['key' => 'performance',
                'value' => $filterArgs['performance'],
                'compare' => 'LIKE',
            ];
        }

        $products = new \WP_Query([
            'post_type' => 'product',
            'post_status' => 'publish',
            'nopaging' => true,
            'fields' => 'ids',
            'meta_query' => $parentMeta
        ]);
        $parentIds = array_merge($parentIds, $products->posts);

        //Find variations with colour from filter
        $tax_query = [];
        if (isset($filterArgs['p_colour'])) {
            $tax_query[] = [
                'taxonomy' => 'colour',
                'field' => 'slug',
                'terms' => $filterArgs['p_colour']
            ];
        }
        $query = new \WP_Query([
            'post_type' => 'product_variation',
            'post_status' => 'publish',
            'nopaging' => true,
            'fields' => 'ids',
            'tax_query' => $tax_query
        ]);

        $parentIds = array_merge($parentIds, $query->posts);

        $parentIds = array_unique($parentIds);

        $collectionIds = [];
        foreach($parentIds as $parentId){
            $productCats = wp_get_post_terms( $parentId, 'product_cat', array("fields" => "ids") );
            if ($productCats) {
                $collectionIds = array_merge($collectionIds, $productCats);
            }
        }

        return $collectionIds = array_unique($collectionIds);

    }

    public static function showFilteredCollections($show = false)
    {
        //check for url filter to limit categories
        global $wp_query;
        $urlFilter = isset($wp_query->query_vars['wemyss_coll_filter']) ? $wp_query->query_vars['wemyss_coll_filter'] : null;
        $validCollectionIds = $urlFilter ? self::getFilteredCollectionIds($urlFilter) : null;

        if (isset($_POST['filter']) || $urlFilter) {

            $get = array_filter($_POST, function ($val) {
                return filter_var($val, FILTER_SANITIZE_SPECIAL_CHARS);
            });

            //only param set is filter notifier, no filtering taking place so return categories
            if(count($get) <= 1 && !$urlFilter){
                $collections = get_terms('product_cat', ['hide_empty' => true] );
                $show ? self::showCategoryPanels($collections) : woocommerce_product_subcategories();
                return;
            }
            //permanent url filter, get vaild categories
            else if(count($get) <= 1 && $urlFilter){
                $collections = get_terms(['taxonomy' => 'product_cat', 'term_taxonomy_id' => $validCollectionIds] );
                self::showCategoryPanels($collections);
                return;
            }

            $filters = $get;
            unset($filters['filter']);

            echo '<div class="col-12">';

            echo '<p class="filter-bar">Filters: ';

            foreach($filters as $filter => $filterVar){
                $name = str_replace('-', ' ', $filterVar);
                echo '<a class="filter" data-id="'.$filter.'">'.ucfirst($name).' <i class="far fa-times"></i></a>';
            }

            echo '</p></div>';

            $get['collectionIds'] = $validCollectionIds;

            $query = new \WP_Query();
            self::prepareFilter($query, $get);
            $query->get_posts();

            if ($query->have_posts()) {
                while ($query->have_posts()) {
                    $query->the_post();

                    wc_get_template('content-product.php', array());
                }

                echo '<div class="col-12">';
                //paginate
                echo paginate_links( [
                    'format' => '?page=%#%',
                    'current' => max( 1, isset($get['page']) ? $get['page']  : 0 ),
                    'total' => $query->max_num_pages,
                    'prev_text'          => __('Prev'),
                    'next_text'          => __('Next'),
                    'type' => 'list',
                ] );
                echo '</div>';

            }else{
                echo '<p class="no-results">No collections found</p>';
            }
            wp_reset_postdata();

        }
        elseif($show){
            $collections = get_terms('product_cat', ['hide_empty' => true] );
            self::showCategoryPanels($collections);
        }
        else {

            $collections = get_terms('product_cat', ['hide_empty' => true] );
            $notfrCollections = [];

            foreach ($collections as $collection) {

                $isFRone = get_field('is_frone','term_'.$collection->term_id);

                if ($isFRone == NULL || $isFRone == false) {
                    $notfrCollections[] = $collection;
                }
            }
            self::showCategoryPanels($notfrCollections);
        }
    }

    public static function showFilteredFroneCollections($show = false)
    {

        //check for url filter to limit categories
        global $wp_query;
        $urlFilter = isset($wp_query->query_vars['wemyss_coll_filter']) ? $wp_query->query_vars['wemyss_coll_filter'] : null;
        $validCollectionIds = $urlFilter ? self::getFilteredCollectionIds($urlFilter) : null;



        if (isset($_POST['filter']) || $urlFilter) {

            $get = array_filter($_POST, function ($val) {
                return filter_var($val, FILTER_SANITIZE_SPECIAL_CHARS);
            });

            //only param set is filter notifier, no filtering taking place so return categories
            if(count($get) <= 1 && !$urlFilter){
                $collections = get_terms('product_cat', ['hide_empty' => true] );
                $show ? self::showCategoryPanels($collections) : woocommerce_product_subcategories();
                return;
            }
            //permanent url filter, get vaild categories
            else if(count($get) <= 1 && $urlFilter){
                $collections = get_terms(['taxonomy' => 'product_cat', 'term_taxonomy_id' => $validCollectionIds] );
                self::showCategoryPanels($collections);
                return;
            }

            $filters = $get;
            unset($filters['filter']);

            echo '<div class="col-12">';

            echo '<p class="filter-bar">Filters: ';

            foreach($filters as $filter => $filterVar){
                $name = str_replace('-', ' ', $filterVar);
                echo '<a class="filter" data-id="'.$filter.'">'.ucfirst($name).' <i class="far fa-times"></i></a>';
            }

            echo '</p></div>';
            $get['collectionIds'] = $validCollectionIds;
            $query = new \WP_Query();
            self::prepareFilter($query, $get);

            $args = [
                'taxonomy' => 'product_cat',
                'hide_empty' => false,
                'meta_query' => [
                    [
                        'key'     => 'is_frone',
                        'value'   => "1",
                        'compare' => '='
                    ]
                ]
            ];

            $allowedFrOneCollectionIDs = [];
            $allowedPostIDs = [];

            $allowedFrOneCollectionObjects = get_terms( $args );
            foreach($allowedFrOneCollectionObjects as $collection){
                array_push($allowedFrOneCollectionIDs, $collection->term_id);
            }

            if($query->get_posts()) {
                foreach ($query->get_posts() as $post) {
                    if (has_term($allowedFrOneCollectionIDs, 'product_cat', $post->ID)) {
                        array_push($allowedPostIDs, $post->ID);
                    }
                }
                if(empty($allowedPostIDs)) {
                    $allowedPostIDs = [0];
                }
            } else {
                $allowedPostIDs = [0];
            }

            $args = [
                'post_type' => 'product_variation',
                'post__in' => $allowedPostIDs,
                'posts_per_page' => 300,
                'post_status' => 'publish',
                'paged' => 1,
                'order' => 'ASC',
                'order_by' => 'title'
            ];

            $newQuery = new \WP_Query($args);

            if ($newQuery->have_posts()) {
                while ($newQuery->have_posts()) {
                    $newQuery->the_post();
                    wc_get_template('content-product.php', array());
                }

                echo '<div class="col-12">';
                //paginate
                echo paginate_links( [
                    'format' => '?page=%#%',
                    'current' => max( 1, isset($get['page']) ? $get['page']  : 0 ),
                    'total' => $newQuery->max_num_pages,
                    'prev_text'          => __('Prev'),
                    'next_text'          => __('Next'),
                    'type' => 'list',
                ] );
                echo '</div>';

            }else{
                echo '<p class="no-results">No collections found</p>';
            }
            wp_reset_postdata();

        }
        elseif($show){

            $collections = get_terms('product_cat', ['hide_empty' => true] );
            $frCollections = [];

            foreach ($collections as $collection) {

                $isFRone = get_field('is_frone','term_'.$collection->term_id);

                if ($isFRone == true) {
                    $frCollections[] = $collection;
                }
            }
            self::showCategoryPanels($frCollections);
        }
        else {
            woocommerce_product_subcategories();
        }
    }

    private static function showCategoryPanels($collections = [])
    {
        if(count($collections) > 0){
            foreach ($collections as $collection) {

                wc_get_template('content-product_cat.php', array(
                    'category' => $collection,
                ));
            }
        }else{
            echo '<p class="no-results">No collections found</p>';
        }

    }

    public function getRegistrationFields()
    {
        return apply_filters( 'wemyss_account_fields', array(
            'marketing'   => array(
                'type'  => 'checkbox',
                'label' => __( 'Tick this box if you would like to receive marketing materials from us', 'wemyss' ),
            ),
            'trade'   => array(
                'type'  => 'checkbox',
                'label' => __( 'Tick this box if you hold a trade account with us', 'wemyss' ),
            ),
            'tradenumber'   => array(
                'type'  => 'text',
                'label' => __( 'If you know your Trade Customer Number, enter below', 'wemyss' ),
            ),
        ) );

    }

    public function addFrontendFields() {
        $fields = $this->getRegistrationFields();
        $is_user_logged_in = is_user_logged_in();

        $user_id = isset( $_GET['user_id'] ) ? (int) $_GET['user_id'] : get_current_user_id();

        foreach ( $fields as $key => $field_args ) {
            $value = null;
            $value = null;

            if ( $is_user_logged_in ) {
                $value   = get_user_meta( $user_id, $key, true );
            }

            $value = isset( $field_args['value'] ) ? $field_args['value'] : $value;

            woocommerce_form_field( $key, $field_args, $value );
        }
    }

    public function addCheckoutFields( $checkout_fields ) {
        $fields = $this->getRegistrationFields();

        foreach ( $fields as $key => $field_args ) {
            $checkout_fields['account'][ $key ] = $field_args;
        }

        return $checkout_fields;
    }

    public function addBootstrapFormClass($fieldGroups)
    {
        foreach ($fieldGroups as $fieldGroup => &$fields) {

            foreach ($fields as &$field) {
                if (!isset($field['input_class']) || !is_array($field['input_class'])) {
                    $field['input_class'] = ['form-control'];
                } else {
                    $field['input_class'][] = 'form-control';
                }
            }
        }
        return $fieldGroups;
    }

    public function addAdminFields() {
        $fields = $this->getRegistrationFields();
        $user_id = isset( $_GET['user_id'] ) ? (int) $_GET['user_id'] : get_current_user_id();
        ?>
        <h2><?php _e( 'Additional Information', 'wemyss' ); ?></h2>
        <table class="form-table" id="iconic-additional-information">
            <tbody>
            <?php foreach ( $fields as $key => $field_args ) {

                $value   = get_user_meta( $user_id, $key, true );
                ?>
                <tr>
                    <th>
                        <label for="<?php echo $key; ?>"><?php echo $field_args['label']; ?></label>
                    </th>
                    <td>
                        <?php $field_args['label'] = false; ?>
                        <?php woocommerce_form_field( $key, $field_args, $value ); ?>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
        </table>
        <?php
    }

    public function saveAccountFields( $customer_id ) {
        $fields = $this->getRegistrationFields();

        foreach ( $fields as $key => $field_args ) {
            $sanitize = isset( $field_args['sanitize'] ) ? $field_args['sanitize'] : 'wc_clean';
            $value    = isset( $_POST[ $key ] ) ? call_user_func( $sanitize, $_POST[ $key ] ) : '';
            update_user_meta( $customer_id, $key, $value );
        }
    }

    function addPostToAccountFields( $fields ) {
        if ( empty( $_POST ) ) {
            return $fields;
        }

        foreach ( $fields as $key => $field_args ) {
            if ( empty( $_POST[ $key ] ) ) {
                $fields[ $key ]['value'] = '';
                continue;
            }

            $fields[ $key ]['value'] = $_POST[ $key ];
        }

        return $fields;
    }

    public function removeTotalColumn($columns){

        if(isset($columns['order-total'])){
            unset($columns['order-total']);
        }

        return $columns;
    }

    public static function getProductCatName($product){

        $parent_id = $product->get_parent_id();
        $parent = get_post($parent_id);

        $category = get_the_terms($parent_id, 'product_cat');
        return $category[0]->name . '/';

    }

    public static function getCollectionMemberIds(&$availablePerformances = [])
    {
        $ids = [];
        if (have_posts()){
            while (have_posts()) {
                the_post();
                $variation = wc_get_product(get_the_ID());
                $parent_id = $variation->get_parent_id();

                $ids[] = get_the_ID();
                $ids[] = $parent_id;
                $performance = get_post_meta($parent_id, 'performance', true);
                if(is_array($performance)){
                    $availablePerformances = array_merge($availablePerformances, $performance);
                }

            }
        }

        $availablePerformances = array_unique($availablePerformances);

        return $ids;
    }


    // Remove Woocommerce for user_admin role
    function remove_woo() {
        $user = wp_get_current_user();
        $role = ( array ) $user->roles;
        if ( in_array("user_admin", $role) ) {
            remove_menu_page( 'woocommerce' );
        }
    }

    // send email to specific address in theme settings if order is not for the UK
    function wc_email_by_country_filter( $recipient, $order ) {
        if($order){
            if ($order->billing_country != 'GB' && $order->billing_country != 'IE' ) {
                $recipient = get_field('row_email_orders','option');
            }
        }
        return $recipient;
    }
}
