<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

if ( ! class_exists( 'Ph_Royalmail_Woocommerce_Shipping_Common' ) ) {

	/**
	 * Common Royal Mail Class.
	 */
	class Ph_Royalmail_Woocommerce_Shipping_Common {

		/**
		 * Active plugins.
		 *
		 * @var array
		 */
		private static $active_plugins;

		/**
		 * Active plugins.
		 *
		 * @return array.
		 */
		public static function get_active_plugins() {

			if ( empty( self::$active_plugins ) ) {

				self::$active_plugins = apply_filters( 'active_plugins', get_option( 'active_plugins', array() ) );

				// Multisite case.
				if ( is_multisite() ) {
					self::$active_plugins = array_merge( self::$active_plugins, array_keys( get_site_option( 'active_sitewide_plugins', array() ) ) );
				}
			}

			return self::$active_plugins;
		}

		/**
		 * Get the Royal Mail & Parcelforce Zone Name
		 *
		 * @param string $zone_id The ID of the zone to retrieve.
		 */
		public static function ph_get_matched_zone_names( $zone_id ) {

			$zone_list = array(

				// Common.
				'uk'     => __( 'UK', 'ph-shipping-royalmail' ),

				// Royal Mail.
				'eu1'    => __( 'Europe Zone 1', 'ph-shipping-royalmail' ),
				'eu2'    => __( 'Europe Zone 2', 'ph-shipping-royalmail' ),
				'eu3'    => __( 'Europe Zone 3', 'ph-shipping-royalmail' ),
				'w1'     => __( 'World Zone 1', 'ph-shipping-royalmail' ),
				'w2'     => __( 'World Zone 2', 'ph-shipping-royalmail' ),
				'w3'     => __( 'World Zone 3', 'ph-shipping-royalmail' ),
				'im'     => __( 'Isle of Man', 'ph-shipping-royalmail' ),
				'je'     => __( 'Jersey', 'ph-shipping-royalmail' ),
				'gg'     => __( 'Guernsey', 'ph-shipping-royalmail' ),

				// Parcelforce.
				'zone4'  => __( 'Zone 4 - Channel Islands', 'ph-shipping-royalmail' ),
				'zone5'  => __( 'Zone 5 - Republic of Ireland', 'ph-shipping-royalmail' ),
				'zone6'  => __( 'Zone 6 - Netherlands, Belgium, Luxembourg', 'ph-shipping-royalmail' ),
				'zone7'  => __( 'Zone 7 - France, Germany, Denmark', 'ph-shipping-royalmail' ),
				'zone8'  => __( 'Zone 8 - Italy, Spain, Portugal, Greece', 'ph-shipping-royalmail' ),
				'zone9'  => __( 'Zone 9 - Rest of Europe', 'ph-shipping-royalmail' ),
				'zone10' => __( 'Zone 10 - USA, Canada', 'ph-shipping-royalmail' ),
				'zone11' => __( 'Zone 11 - Far East, Australasia', 'ph-shipping-royalmail' ),
				'zone12' => __( 'Zone 12 - Rest of the World', 'ph-shipping-royalmail' ),
			);

			return $zone_list[ $zone_id ] ?? $zone_id;
		}
	}
}
