<?php

// Add a filter to modify the currency used by the PluginHive Royal Mail integration
add_filter( 'ph_change_woocommerce_currency_for_multicurrency', 'ph_curcy_modify_default_royalmail_currency', 10, 1 );

// Check if the function doesn't already exist to avoid redeclaration errors
if( ! function_exists('ph_curcy_modify_default_royalmail_currency') ) {
	
	/**
	 * Function to enforce GBP as the default currency for Royal Mail.
	 *
	 * @param string $currency The current currency being used.
	 * @return string The modified currency ('GBP' if it is not already GBP).
	 */
	function ph_curcy_modify_default_royalmail_currency( $currency ) {

		// If the currency is not GBP, change it to GBP
		if( $currency != 'GBP' ) {
			return 'GBP';
		}

		// Otherwise, return the original currency
		return $currency;
	}
}
