<?php
return array(

	array(
		'name'             => 'Royal Mail Special Delivery by 1pm&reg;',
		'id'               => 'special_delivery_guaranteed_by_1',
		'special_services' => array(
			'insured_cost' => array(
				'price_750-1000'  => 3,
				'price_1000-2500' => 10,
			),
		),
		'rules'            => array(
			'uk_0-0.1kg'   => 8.75,
			'uk_0.1-0.5kg' => 9.85,
			'uk_0.5-1kg'   => 10.95,
			'uk_1-2kg'     => 14.05,
			'uk_2-10kg'    => 19.55,
			'uk_10-20kg'   => 23.75,

			// Isle of Man
			'im_0-0.1kg'   => 8.75,
			'im_0.1-0.5kg' => 9.85,
			'im_0.5-1kg'   => 10.95,
			'im_1-2kg'     => 14.05,
			'im_2-10kg'    => 19.55,
			'im_10-20kg'   => 23.75,

			// Jersey
			'je_0-0.1kg'   => 8.75,
			'je_0.1-0.5kg' => 9.85,
			'je_0.5-1kg'   => 10.95,
			'je_1-2kg'     => 14.05,
			'je_2-10kg'    => 19.55,
			'je_10-20kg'   => 23.75,

			// Guernsey
			'gg_0-0.1kg'   => 8.75,
			'gg_0.1-0.5kg' => 9.85,
			'gg_0.5-1kg'   => 10.95,
			'gg_1-2kg'     => 14.05,
			'gg_2-10kg'    => 19.55,
			'gg_10-20kg'   => 23.75,
		),
	),

	array(
		'name'             => 'Royal Mail Special Delivery by 1pm&reg; with Saturday',
		'id'               => 'special_delivery_guaranteed_by_1_with_saturday',
		'special_services' => array(
			'insured_cost' => array(
				'price_750-1000'  => 3.6,
				'price_1000-2500' => 12,
			),
		),
		'rules'            => array(
			'uk_0-0.1kg'   => 13.50,
			'uk_0.1-0.5kg' => 14.82,
			'uk_0.5-1kg'   => 16.14,
			'uk_1-2kg'     => 19.86,
			'uk_2-10kg'    => 26.46,
			'uk_10-20kg'   => 31.50,

			// Isle of Man
			'im_0-0.1kg'   => 13.50,
			'im_0.1-0.5kg' => 14.82,
			'im_0.5-1kg'   => 16.14,
			'im_1-2kg'     => 19.86,
			'im_2-10kg'    => 26.46,
			'im_10-20kg'   => 31.50,

			// Guernsey
			'gg_0-0.1kg'   => 13.50,
			'gg_0.1-0.5kg' => 14.82,
			'gg_0.5-1kg'   => 16.14,
			'gg_1-2kg'     => 19.86,
			'gg_2-10kg'    => 26.46,
			'gg_10-20kg'   => 31.50,
		),
	),

	array(
		'name'             => 'Royal Mail Special Delivery by 9am&reg;',
		'id'               => 'special_delivery_guaranteed_by_9am',
		'special_services' => array(
			'insured_cost' => array(
				'price_50-1000'   => 7,
				'price_1000-2500' => 15,
			),
		),
		'rules'            => array(
			'uk_0-0.1kg'   => 38.95,
			'uk_0.1-0.5kg' => 43.95,
			'uk_0.5-1kg'   => 48.95,
			'uk_1-2kg'     => 60.95,

			// Isle of Man IM1 postcode Only
			'im_0-0.1kg'   => 38.95,
			'im_0.1-0.5kg' => 43.95,
			'im_0.5-1kg'   => 48.95,
			'im_1-2kg'     => 60.95,
		),
	),

	array(
		'name'             => 'Royal Mail Special Delivery by 9am&reg; with Saturday',
		'id'               => 'special_delivery_guaranteed_by_9_with_saturday',
		'special_services' => array(
			'insured_cost' => array(
				'price_50-1000'   => 7,
				'price_1000-2500' => 15,
			),
		),
		'rules'            => array(
			'uk_0-0.1kg'   => 41.95,
			'uk_0.1-0.5kg' => 46.95,
			'uk_0.5-1kg'   => 51.95,
			'uk_1-2kg'     => 63.95,
		),
	),

	array(
		'name'             => 'Royal Mail 1st Class',
		'id'               => '1st_class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 //Signature rates are added seperatly
		),
		'rules'            => array(
			'uk_0-0.1kg_letter'            => 1.70,
			'uk_0-0.1kg_largeletter'       => 3.15,
			'uk_0.1-0.250kg_largeletter'   => 3.60,
			'uk_0.250-0.500kg_largeletter' => 3.60,
			'uk_0.500-0.750kg_largeletter' => 3.60,

			'uk_0-2kg_smallparcel'         => 4.99,

			'uk_0-2kg_mediumparcel'        => 7.19,
			'uk_2-10kg_mediumparcel'       => 8.99,
			'uk_10-20kg_mediumparcel'      => 13.69,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel'        => 4.99,

			'ijg_0-2kg_mediumparcel'       => 7.19,
			'ijg_2-10kg_mediumparcel'      => 8.99,
			'ijg_10-20kg_mediumparcel'     => 13.69,
		),
	),

	array(
		'name'             => 'Royal Mail 1st Class Signed For',
		'id'               => '1st_class_signed',
		'special_services' => array(
			// 'signature_cost'  => 1.1
		),
		'rules'            => array(
			'uk_0-0.1kg_letter'            => 3.60,
			'uk_0-0.1kg_largeletter'       => 5.05,
			'uk_0.1-0.250kg_largeletter'   => 5.50,
			'uk_0.250-0.500kg_largeletter' => 5.50,
			'uk_0.500-0.750kg_largeletter' => 5.50,

			'uk_0-2kg_smallparcel'         => 6.49,

			'uk_0-2kg_mediumparcel'        => 8.69,
			'uk_2-10kg_mediumparcel'       => 10.49,
			'uk_10-20kg_mediumparcel'      => 15.19,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel'        => 6.49,

			'ijg_0-2kg_mediumparcel'       => 8.69,
			'ijg_2-10kg_mediumparcel'      => 10.49,
			'ijg_10-20kg_mediumparcel'     => 15.19,
		),
	),

	array(
		'name'             => 'Royal Mail 2nd Class',
		'id'               => '2nd_class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 //Signature rates are added seperatly
		),
		'rules'            => array(
			'uk_0-0.1kg_letter'            => 0.87,
			'uk_0-0.1kg_largeletter'       => 1.55,
			'uk_0.1-0.250kg_largeletter'   => 2.00,
			'uk_0.250-0.500kg_largeletter' => 2.40,
			'uk_0.500-0.750kg_largeletter' => 2.70,

			'uk_0-2kg_smallparcel'         => 3.90,

			'uk_0-2kg_mediumparcel'        => 6.29,
			'uk_2-10kg_mediumparcel'       => 7.89,
			'uk_10-20kg_mediumparcel'      => 11.89,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel'        => 3.90,

			'ijg_0-2kg_mediumparcel'       => 6.29,
			'ijg_2-10kg_mediumparcel'      => 7.89,
			'ijg_10-20kg_mediumparcel'     => 11.89,
		),
	),

	array(
		'name'             => 'Royal Mail 2nd Class Signed For',
		'id'               => '2nd_class_signed',
		'special_services' => array(
			// 'signature_cost'  => 1.1
		),
		'rules'            => array(
			'uk_0-0.1kg_letter'            => 2.77,
			'uk_0-0.1kg_largeletter'       => 3.45,
			'uk_0.1-0.250kg_largeletter'   => 3.90,
			'uk_0.250-0.500kg_largeletter' => 4.30,
			'uk_0.500-0.750kg_largeletter' => 4.60,

			'uk_0-2kg_smallparcel'         => 5.40,

			'uk_0-2kg_mediumparcel'        => 7.79,
			'uk_2-10kg_mediumparcel'       => 9.39,
			'uk_10-20kg_mediumparcel'      => 13.39,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel'        => 5.40,

			'ijg_0-2kg_mediumparcel'       => 7.79,
			'ijg_2-10kg_mediumparcel'      => 9.39,
			'ijg_10-20kg_mediumparcel'     => 13.39,
		),
	),

	// UK Online Rates

	array(
		'name'             => 'Royal Mail Tracked 24&reg;',
		'id'               => 'tracked24',
		'special_services' => array(),
		'rules'            => array(

			'uk_0-1kg_largeletter' => 3.60,

			'uk_0-2kg_smallparcel'     => 4.29,

			'uk_0-2kg_mediumparcel'    => 6.05,
			'uk_2-10kg_mediumparcel'   => 7.90,
			'uk_10-20kg_mediumparcel'  => 12.60,
		),
	),

	array(
		'name'             => 'Royal Mail Tracked 24&reg; with Signature',
		'id'               => 'tracked24_with_signature',
		'special_services' => array(),
		'rules'            => array(

			'uk_0-1kg_largeletter' => 5.50,

			'uk_0-2kg_smallparcel'     => 5.79,

			'uk_0-2kg_mediumparcel'    => 7.55,
			'uk_2-10kg_mediumparcel'   => 9.40,
			'uk_10-20kg_mediumparcel'  => 14.10,
		),
	),

	array(
		'name'             => 'Royal Mail Tracked 48&reg;',
		'id'               => 'tracked48',
		'special_services' => array(),
		'rules'            => array(

			'uk_0-1kg_largeletter' => 2.70,

			'uk_0-2kg_smallparcel'     => 3.45,

			'uk_0-2kg_mediumparcel'    => 5.15,
			'uk_2-10kg_mediumparcel'   => 6.80,
			'uk_10-20kg_mediumparcel'  => 10.80,
		),
	),

	array(
		'name'             => 'Royal Mail Tracked 48&reg; with Signature',
		'id'               => 'tracked48_with_signature',
		'special_services' => array(),
		'rules'            => array(

			'uk_0-1kg_largeletter' => 4.60,

			'uk_0-2kg_smallparcel'     => 4.95,

			'uk_0-2kg_mediumparcel'    => 6.65,
			'uk_2-10kg_mediumparcel'   => 8.30,
			'uk_10-20kg_mediumparcel'  => 12.30,
		),
	),

	array(
		'name'             => 'Royal Mail Tracked 24&reg; with Age Verification',
		'id'               => 'tracked24_with_age_verification',
		'special_services' => array(),
		'rules'            => array(

			'uk_0-2kg_smallparcel'     => 7.17,

			'uk_0-2kg_mediumparcel'    => 8.93,
			'uk_2-10kg_mediumparcel'   => 10.78,
			'uk_10-20kg_mediumparcel'  => 15.48,
		),
	),

	array(
		'name'             => 'Royal Mail Tracked 48&reg; with Age Verification',
		'id'               => 'tracked48_with_age_verification',
		'special_services' => array(),
		'rules'            => array(

			'uk_0-2kg_smallparcel'     => 6.33,

			'uk_0-2kg_mediumparcel'    => 8.03,
			'uk_2-10kg_mediumparcel'   => 9.68,
			'uk_10-20kg_mediumparcel'  => 13.68,
		),
	),

	// International services

	array(
		'name'             => 'Royal Mail International Standard',
		'id'               => 'international_standard',
		'special_services' => array(),
		'rules'            => array(

			// letter
			'0-0.1kg_letter'                => 3.20,

			// large letter
			'eu1_0-0.1kg_largeletter'       => 3.50,
			'eu1_0.1-0.250kg_largeletter'   => 5.80,
			'eu1_0.250-0.500kg_largeletter' => 7.20,
			'eu1_0.500-0.750kg_largeletter' => 9.55,

			'eu2_0-0.1kg_largeletter'       => 3.50,
			'eu2_0.1-0.250kg_largeletter'   => 5.80,
			'eu2_0.250-0.500kg_largeletter' => 7.20,
			'eu2_0.500-0.750kg_largeletter' => 9.55,

			'eu3_0-0.1kg_largeletter'       => 3.50,
			'eu3_0.1-0.250kg_largeletter'   => 5.80,
			'eu3_0.250-0.500kg_largeletter' => 7.20,
			'eu3_0.500-0.750kg_largeletter' => 9.55,

			'w1_0-0.1kg_largeletter'        => 4.30,
			'w1_0.1-0.250kg_largeletter'    => 7.70,
			'w1_0.250-0.500kg_largeletter'  => 10.80,
			'w1_0.500-0.750kg_largeletter'  => 16.00,

			'w2_0-0.1kg_largeletter'        => 4.30,
			'w2_0.1-0.250kg_largeletter'    => 9.00,
			'w2_0.250-0.500kg_largeletter'  => 13.10,
			'w2_0.500-0.750kg_largeletter'  => 20.10,

			'w3_0-0.1kg_largeletter'        => 4.30,
			'w3_0.1-0.250kg_largeletter'    => 8.00,
			'w3_0.250-0.500kg_largeletter'  => 11.50,
			'w3_0.500-0.750kg_largeletter'  => 17.10,

			// Small Parcel
			'eu1_0-0.250kg_smallparcel'     => 8.95,
			'eu1_0.250-0.500kg_smallparcel' => 11.25,
			'eu1_0.500-0.750kg_smallparcel' => 12.40,
			'eu1_0.750-1kg_smallparcel'     => 13.55,
			'eu1_1-1.25kg_smallparcel'      => 14.25,
			'eu1_1.25-1.5kg_smallparcel'    => 14.25,
			'eu1_1.5-2kg_smallparcel'       => 16.25,

			'eu2_0-0.250kg_smallparcel'     => 9.70,
			'eu2_0.250-0.500kg_smallparcel' => 12.35,
			'eu2_0.500-0.750kg_smallparcel' => 13.90,
			'eu2_0.750-1kg_smallparcel'     => 15.35,
			'eu2_1-1.25kg_smallparcel'      => 16.90,
			'eu2_1.25-1.5kg_smallparcel'    => 16.90,
			'eu2_1.5-2kg_smallparcel'       => 18.80,

			'eu3_0-0.250kg_smallparcel'     => 10.65,
			'eu3_0.250-0.500kg_smallparcel' => 13.10,
			'eu3_0.500-0.750kg_smallparcel' => 14.90,
			'eu3_0.750-1kg_smallparcel'     => 16.60,
			'eu3_1-1.25kg_smallparcel'      => 18.10,
			'eu3_1.25-1.5kg_smallparcel'    => 19.55,
			'eu3_1.5-2kg_smallparcel'       => 21.25,

			'w1_0-0.1kg_smallparcel'        => 13.05,
			'w1_0.1-0.250kg_smallparcel'    => 14.05,
			'w1_0.250-0.500kg_smallparcel'  => 19.30,
			'w1_0.500-0.750kg_smallparcel'  => 22.70,
			'w1_0.750-1kg_smallparcel'      => 26.20,
			'w1_1-1.25kg_smallparcel'       => 29.25,
			'w1_1.25-1.5kg_smallparcel'     => 32.00,
			'w1_1.5-2kg_smallparcel'        => 33.55,

			'w2_0-0.1kg_smallparcel'        => 14.55,
			'w2_0.1-0.250kg_smallparcel'    => 15.20,
			'w2_0.250-0.500kg_smallparcel'  => 21.20,
			'w2_0.500-0.750kg_smallparcel'  => 25.10,
			'w2_0.750-1kg_smallparcel'      => 29.15,
			'w2_1-1.25kg_smallparcel'       => 32.90,
			'w2_1.25-1.5kg_smallparcel'     => 36.75,
			'w2_1.5-2kg_smallparcel'        => 38.85,

			'w3_0-0.1kg_smallparcel'        => 16.95,
			'w3_0.1-0.250kg_smallparcel'    => 16.95,
			'w3_0.250-0.500kg_smallparcel'  => 23.85,
			'w3_0.500-0.750kg_smallparcel'  => 26.95,
			'w3_0.750-1kg_smallparcel'      => 30.05,
			'w3_1-1.25kg_smallparcel'       => 34.15,
			'w3_1.25-1.5kg_smallparcel'     => 34.15,
			'w3_1.5-2kg_smallparcel'        => 35.70,
		),
	),

	array(
		'name'             => 'Royal Mail International Tracked and Signed',
		'id'               => 'international_tracked_signed',
		'special_services' => array(),
		'rules'            => array(

			// letter
			'0-0.1kg_letter'                => 8.50,

			// large letter
			'eu1_0-0.1kg_largeletter'       => 10.05,
			'eu1_0.1-0.250kg_largeletter'   => 11.35,
			'eu1_0.250-0.500kg_largeletter' => 12.15,
			'eu1_0.500-0.750kg_largeletter' => 12.65,

			'eu2_0-0.1kg_largeletter'       => 10.05,
			'eu2_0.1-0.250kg_largeletter'   => 11.35,
			'eu2_0.250-0.500kg_largeletter' => 12.15,
			'eu2_0.500-0.750kg_largeletter' => 12.65,

			'eu3_0-0.1kg_largeletter'       => 10.05,
			'eu3_0.1-0.250kg_largeletter'   => 11.35,
			'eu3_0.250-0.500kg_largeletter' => 12.15,
			'eu3_0.500-0.750kg_largeletter' => 12.65,

			'w1_0-0.1kg_largeletter'        => 11.10,
			'w1_0.1-0.250kg_largeletter'    => 12.80,
			'w1_0.250-0.500kg_largeletter'  => 14.85,
			'w1_0.500-0.750kg_largeletter'  => 17.00,

			'w2_0-0.1kg_largeletter'        => 11.25,
			'w2_0.1-0.250kg_largeletter'    => 14.05,
			'w2_0.250-0.500kg_largeletter'  => 16.95,
			'w2_0.500-0.750kg_largeletter'  => 20.10,

			'w3_0-0.1kg_largeletter'        => 11.25,
			'w3_0.1-0.250kg_largeletter'    => 13.05,
			'w3_0.250-0.500kg_largeletter'  => 15.30,
			'w3_0.500-0.750kg_largeletter'  => 17.60,

			// Small Parcel
			'eu1_0-0.250kg_smallparcel'     => 14.25,
			'eu1_0.250-0.500kg_smallparcel' => 15.80,
			'eu1_0.500-0.750kg_smallparcel' => 17.00,
			'eu1_0.750-1kg_smallparcel'     => 18.10,
			'eu1_1-1.25kg_smallparcel'      => 18.70,
			'eu1_1.25-1.5kg_smallparcel'    => 18.80,
			'eu1_1.5-2kg_smallparcel'       => 19.00,

			'eu2_0-0.250kg_smallparcel'     => 14.60,
			'eu2_0.250-0.500kg_smallparcel' => 16.40,
			'eu2_0.500-0.750kg_smallparcel' => 17.55,
			'eu2_0.750-1kg_smallparcel'     => 18.60,
			'eu2_1-1.25kg_smallparcel'      => 18.95,
			'eu2_1.25-1.5kg_smallparcel'    => 19.20,
			'eu2_1.5-2kg_smallparcel'       => 19.75,

			'eu3_0-0.250kg_smallparcel'     => 16.35,
			'eu3_0.250-0.500kg_smallparcel' => 18.20,
			'eu3_0.500-0.750kg_smallparcel' => 19.55,
			'eu3_0.750-1kg_smallparcel'     => 20.90,
			'eu3_1-1.25kg_smallparcel'      => 21.65,
			'eu3_1.25-1.5kg_smallparcel'    => 22.35,
			'eu3_1.5-2kg_smallparcel'       => 22.90,

			'w1_0-0.1kg_smallparcel'        => 18.95,
			'w1_0.1-0.250kg_smallparcel'    => 18.95,
			'w1_0.250-0.500kg_smallparcel'  => 23.50,
			'w1_0.500-0.750kg_smallparcel'  => 26.25,
			'w1_0.750-1kg_smallparcel'      => 29.35,
			'w1_1-1.25kg_smallparcel'       => 31.65,
			'w1_1.25-1.5kg_smallparcel'     => 33.30,
			'w1_1.5-2kg_smallparcel'        => 33.80,

			'w2_0-0.1kg_smallparcel'        => 19.95,
			'w2_0.1-0.250kg_smallparcel'    => 19.95,
			'w2_0.250-0.500kg_smallparcel'  => 25.50,
			'w2_0.500-0.750kg_smallparcel'  => 28.75,
			'w2_0.750-1kg_smallparcel'      => 32.40,
			'w2_1-1.25kg_smallparcel'       => 35.25,
			'w2_1.25-1.5kg_smallparcel'     => 38.10,
			'w2_1.5-2kg_smallparcel'        => 39.30,

			'w3_0-0.1kg_smallparcel'        => 19.50,
			'w3_0.1-0.250kg_smallparcel'    => 20.80,
			'w3_0.250-0.500kg_smallparcel'  => 27.20,
			'w3_0.500-0.750kg_smallparcel'  => 29.50,
			'w3_0.750-1kg_smallparcel'      => 33.20,
			'w3_1-1.25kg_smallparcel'       => 38.30,
			'w3_1.25-1.5kg_smallparcel'     => 39.95,
			'w3_1.5-2kg_smallparcel'        => 40.90,
		),
	),

	array(
		'name'             => 'Royal Mail International Tracked',
		'id'               => 'international_tracked',
		'special_services' => array(
			'noneu' => true, // Contains noneu rules
		),
		'rules'            => array(

			// letter
			'0-0.1kg_letter'                => 8.10,

			// large letter
			'eu1_0-0.1kg_largeletter'       => 9.75,
			'eu1_0.1-0.250kg_largeletter'   => 10.75,
			'eu1_0.250-0.500kg_largeletter' => 11.90,
			'eu1_0.500-0.750kg_largeletter' => 12.35,

			'eu2_0-0.1kg_largeletter'       => 9.75,
			'eu2_0.1-0.250kg_largeletter'   => 10.75,
			'eu2_0.250-0.500kg_largeletter' => 11.90,
			'eu2_0.500-0.750kg_largeletter' => 12.35,

			'eu3_0-0.1kg_largeletter'       => 9.75,
			'eu3_0.1-0.250kg_largeletter'   => 10.75,
			'eu3_0.250-0.500kg_largeletter' => 11.90,
			'eu3_0.500-0.750kg_largeletter' => 12.35,

			'w1_0-0.1kg_largeletter'        => 10.80,
			'w1_0.1-0.250kg_largeletter'    => 12.45,
			'w1_0.250-0.500kg_largeletter'  => 14.55,
			'w1_0.500-0.750kg_largeletter'  => 16.65,

			'w2_0-0.1kg_largeletter'        => 10.85,
			'w2_0.1-0.250kg_largeletter'    => 13.70,
			'w2_0.250-0.500kg_largeletter'  => 16.55,
			'w2_0.500-0.750kg_largeletter'  => 19.75,

			'w3_0-0.1kg_largeletter'        => 10.70,
			'w3_0.1-0.250kg_largeletter'    => 12.50,
			'w3_0.250-0.500kg_largeletter'  => 14.65,
			'w3_0.500-0.750kg_largeletter'  => 16.90,

			// Small parcel and printer papers
			'eu1_0-0.250kg_smallparcel'     => 12.40,
			'eu1_0.250-0.500kg_smallparcel' => 13.70,
			'eu1_0.500-0.750kg_smallparcel' => 14.25,
			'eu1_0.750-1kg_smallparcel'     => 15.00,
			'eu1_1-1.25kg_smallparcel'      => 15.50,
			'eu1_1.25-1.5kg_smallparcel'    => 15.50,
			'eu1_1.5-2kg_smallparcel'       => 15.50,

			'eu2_0-0.250kg_smallparcel'     => 12.70,
			'eu2_0.250-0.500kg_smallparcel' => 14.05,
			'eu2_0.500-0.750kg_smallparcel' => 15.10,
			'eu2_0.750-1kg_smallparcel'     => 15.85,
			'eu2_1-1.25kg_smallparcel'      => 16.30,
			'eu2_1.25-1.5kg_smallparcel'    => 16.30,
			'eu2_1.5-2kg_smallparcel'       => 17.90,

			'eu3_0-0.250kg_smallparcel'     => 13.90,
			'eu3_0.250-0.500kg_smallparcel' => 15.75,
			'eu3_0.500-0.750kg_smallparcel' => 16.75,
			'eu3_0.750-1kg_smallparcel'     => 17.55,
			'eu3_1-1.25kg_smallparcel'      => 18.45,
			'eu3_1.25-1.5kg_smallparcel'    => 19.35,
			'eu3_1.5-2kg_smallparcel'       => 20.15,

			'w1_0-0.250kg_smallparcel'      => 16.00,
			'w1_0.250-0.500kg_smallparcel'  => 20.70,
			'w1_0.500-0.750kg_smallparcel'  => 23.50,
			'w1_0.750-1kg_smallparcel'      => 26.55,
			'w1_1-1.25kg_smallparcel'       => 28.80,
			'w1_1.25-1.5kg_smallparcel'     => 30.45,
			'w1_1.5-2kg_smallparcel'        => 31.70,

			'w2_0-0.250kg_smallparcel'      => 17.55,
			'w2_0.250-0.500kg_smallparcel'  => 22.90,
			'w2_0.500-0.750kg_smallparcel'  => 26.10,
			'w2_0.750-1kg_smallparcel'      => 29.50,
			'w2_1-1.25kg_smallparcel'       => 32.75,
			'w2_1.25-1.5kg_smallparcel'     => 35.65,
			'w2_1.5-2kg_smallparcel'        => 37.60,

			'w3_0-0.250kg_smallparcel'      => 16.85,
			'w3_0.250-0.500kg_smallparcel'  => 21.85,
			'w3_0.500-0.750kg_smallparcel'  => 24.95,
			'w3_0.750-1kg_smallparcel'      => 28.05,
			'w3_1-1.25kg_smallparcel'       => 32.35,
			'w3_1.25-1.5kg_smallparcel'     => 32.35,
			'w3_1.5-2kg_smallparcel'        => 32.35,
		),
	),

	array(
		'name'             => 'Royal Mail International Signed',
		'id'               => 'international_signed',
		'special_services' => array(),
		'rules'            => array(

			// letter
			'0-0.1kg_letter'                => 8.50,

			// large letter
			'eu1_0-0.1kg_largeletter'       => 10.05,
			'eu1_0.1-0.250kg_largeletter'   => 11.35,
			'eu1_0.250-0.500kg_largeletter' => 12.15,
			'eu1_0.500-0.750kg_largeletter' => 12.65,

			'eu2_0-0.1kg_largeletter'       => 10.05,
			'eu2_0.1-0.250kg_largeletter'   => 11.35,
			'eu2_0.250-0.500kg_largeletter' => 12.15,
			'eu2_0.500-0.750kg_largeletter' => 12.65,

			'eu3_0-0.1kg_largeletter'       => 10.05,
			'eu3_0.1-0.250kg_largeletter'   => 11.35,
			'eu3_0.250-0.500kg_largeletter' => 12.15,
			'eu3_0.500-0.750kg_largeletter' => 12.65,

			'w1_0-0.1kg_largeletter'        => 11.10,
			'w1_0.1-0.250kg_largeletter'    => 12.80,
			'w1_0.250-0.500kg_largeletter'  => 14.85,
			'w1_0.500-0.750kg_largeletter'  => 17.00,

			'w2_0-0.1kg_largeletter'        => 11.25,
			'w2_0.1-0.250kg_largeletter'    => 14.05,
			'w2_0.250-0.500kg_largeletter'  => 16.95,
			'w2_0.500-0.750kg_largeletter'  => 20.10,

			// Small parcel and printer papers
			'eu1_0-0.250kg_smallparcel'     => 14.25,
			'eu1_0.250-0.500kg_smallparcel' => 15.80,
			'eu1_0.500-0.750kg_smallparcel' => 17.00,
			'eu1_0.750-1kg_smallparcel'     => 18.10,
			'eu1_1-1.25kg_smallparcel'      => 18.70,
			'eu1_1.25-1.5kg_smallparcel'    => 18.80,
			'eu1_1.5-2kg_smallparcel'       => 19.00,

			'eu2_0-0.250kg_smallparcel'     => 14.60,
			'eu2_0.250-0.500kg_smallparcel' => 16.40,
			'eu2_0.500-0.750kg_smallparcel' => 17.55,
			'eu2_0.750-1kg_smallparcel'     => 18.60,
			'eu2_1-1.25kg_smallparcel'      => 18.95,
			'eu2_1.25-1.5kg_smallparcel'    => 19.20,
			'eu2_1.5-2kg_smallparcel'       => 19.75,

			'eu3_0-0.250kg_smallparcel'     => 16.35,
			'eu3_0.250-0.500kg_smallparcel' => 18.20,
			'eu3_0.500-0.750kg_smallparcel' => 19.55,
			'eu3_0.750-1kg_smallparcel'     => 20.90,
			'eu3_1-1.25kg_smallparcel'      => 21.65,
			'eu3_1.25-1.5kg_smallparcel'    => 22.35,
			'eu3_1.5-2kg_smallparcel'       => 22.90,

			'w1_0-0.1kg_smallparcel'        => 18.95,
			'w1_0.1-0.250kg_smallparcel'    => 18.95,
			'w1_0.250-0.500kg_smallparcel'  => 23.50,
			'w1_0.500-0.750kg_smallparcel'  => 26.25,
			'w1_0.750-1kg_smallparcel'      => 29.35,
			'w1_1-1.25kg_smallparcel'       => 31.65,
			'w1_1.25-1.5kg_smallparcel'     => 33.30,
			'w1_1.5-2kg_smallparcel'        => 33.80,

			'w2_0-0.1kg_smallparcel'        => 19.95,
			'w2_0.1-0.250kg_smallparcel'    => 19.95,
			'w2_0.250-0.500kg_smallparcel'  => 25.50,
			'w2_0.500-0.750kg_smallparcel'  => 28.75,
			'w2_0.750-1kg_smallparcel'      => 32.40,
			'w2_1-1.25kg_smallparcel'       => 35.25,
			'w2_1.25-1.5kg_smallparcel'     => 38.10,
			'w2_1.5-2kg_smallparcel'        => 39.30,

		),
	),

	array(
		'name'             => 'Royal Mail International Economy',
		'id'               => 'international_economy',
		'special_services' => array(),
		'rules'            => array(

			// letter
			'0-0.1kg_letter'            => 3.10,

			// Large Letter
			'0-0.1kg_largeletter'       => 4.10,
			'0.1-0.250kg_largeletter'   => 7.30,
			'0.250-0.500kg_largeletter' => 8.45,
			'0.500-0.750kg_largeletter' => 10.25,

			// Small Parcels and Printed Papers
			'0-0.250kg_smallparcel'     => 9.30,
			'0.250-0.500kg_smallparcel' => 14.00,
			'0.500-0.750kg_smallparcel' => 14.45,
			'0.750-1kg_smallparcel'     => 15.60,
			'1-1.25kg_smallparcel'      => 17.15,
			'1.25-1.5kg_smallparcel'    => 17.15,
			'1.5-2kg_smallparcel'       => 20.25,
		),
	),

	array(
		'name'             => 'Royal Mail International Tracked and Signed Heavier',
		'id'               => 'international_tracked_signed_heavier',
		'special_services' => array(
			'insured_cost' => array(
				'price_0-999999' => 2.10,
			),
		),
		'rules'            => array(

			// Europe Zone 1
			'eu1_0-0.1kg_mediumparcel'       => 14.30,
			'eu1_0.1-0.250kg_mediumparcel'   => 14.30,
			'eu1_0.250-0.500kg_mediumparcel' => 14.30,
			'eu1_0.500-0.750kg_mediumparcel' => 14.30,
			'eu1_0.750-1kg_mediumparcel'     => 14.30,
			'eu1_1-1.250kg_mediumparcel'     => 14.90,
			'eu1_1.250-1.500kg_mediumparcel' => 14.90,
			'eu1_1.500-2kg_mediumparcel'     => 14.90,
			'eu1_2-3kg_mediumparcel'         => 17.00,
			'eu1_3-4kg_mediumparcel'         => 17.50,
			'eu1_4-5kg_mediumparcel'         => 18.05,
			'eu1_5-7.500kg_mediumparcel'     => 23.60,
			'eu1_7.500-10kg_mediumparcel'    => 28.70,
			'eu1_10-15kg_mediumparcel'       => 38.85,
			'eu1_15-20kg_mediumparcel'       => 48.50,

			// Europe Zone 2
			'eu2_0-0.1kg_mediumparcel'       => 13.30,
			'eu2_0.1-0.250kg_mediumparcel'   => 13.30,
			'eu2_0.250-0.500kg_mediumparcel' => 13.30,
			'eu2_0.500-0.750kg_mediumparcel' => 13.30,
			'eu2_0.750-1kg_mediumparcel'     => 13.30,
			'eu2_1-1.250kg_mediumparcel'     => 16.10,
			'eu2_1.250-1.500kg_mediumparcel' => 16.10,
			'eu2_1.500-2kg_mediumparcel'     => 16.10,
			'eu2_2-3kg_mediumparcel'         => 18.65,
			'eu2_3-4kg_mediumparcel'         => 33.60,
			'eu2_4-5kg_mediumparcel'         => 36.65,
			'eu2_5-7.500kg_mediumparcel'     => 54.45,
			'eu2_7.500-10kg_mediumparcel'    => 74.55,
			'eu2_10-15kg_mediumparcel'       => 103.65,
			'eu2_15-20kg_mediumparcel'       => 160.25,

			// Europe Zone 3
			'eu3_0-0.1kg_mediumparcel'       => 16.00,
			'eu3_0.1-0.250kg_mediumparcel'   => 16.00,
			'eu3_0.250-0.500kg_mediumparcel' => 16.00,
			'eu3_0.500-0.750kg_mediumparcel' => 16.00,
			'eu3_0.750-1kg_mediumparcel'     => 16.00,
			'eu3_1-1.250kg_mediumparcel'     => 22.45,
			'eu3_1.250-1.500kg_mediumparcel' => 22.45,
			'eu3_1.500-2kg_mediumparcel'     => 22.45,
			'eu3_2-3kg_mediumparcel'         => 26.25,
			'eu3_3-4kg_mediumparcel'         => 33.20,
			'eu3_4-5kg_mediumparcel'         => 39.10,
			'eu3_5-7.500kg_mediumparcel'     => 54.65,
			'eu3_7.500-10kg_mediumparcel'    => 74.65,
			'eu3_10-15kg_mediumparcel'       => 101.15,
			'eu3_15-20kg_mediumparcel'       => 124.60,

			// World zone 1
			'w1_0-0.1kg_mediumparcel'        => 25.85,
			'w1_0.1-0.250kg_mediumparcel'    => 25.85,
			'w1_0.250-0.500kg_mediumparcel'  => 25.85,
			'w1_0.500-0.750kg_mediumparcel'  => 25.85,
			'w1_0.750-1kg_mediumparcel'      => 25.85,
			'w1_1-1.250kg_mediumparcel'      => 28.80,
			'w1_1.250-1.500kg_mediumparcel'  => 28.80,
			'w1_1.500-2kg_mediumparcel'      => 28.80,
			'w1_2-3kg_mediumparcel'          => 32.90,
			'w1_3-4kg_mediumparcel'          => 39.40,
			'w1_4-5kg_mediumparcel'          => 49.40,
			'w1_5-7.500kg_mediumparcel'      => 66.55,
			'w1_7.500-10kg_mediumparcel'     => 99.75,
			'w1_10-15kg_mediumparcel'        => 128.00,
			'w1_15-20kg_mediumparcel'        => 176.45,

			// World zone 2
			'w2_0-0.1kg_mediumparcel'        => 27.50,
			'w2_0.1-0.250kg_mediumparcel'    => 27.50,
			'w2_0.250-0.500kg_mediumparcel'  => 27.50,
			'w2_0.500-0.750kg_mediumparcel'  => 27.50,
			'w2_0.750-1kg_mediumparcel'      => 27.50,
			'w2_1-1.250kg_mediumparcel'      => 35.10,
			'w2_1.250-1.500kg_mediumparcel'  => 35.10,
			'w2_1.500-2kg_mediumparcel'      => 35.10,
			'w2_2-3kg_mediumparcel'          => 38.85,
			'w2_3-4kg_mediumparcel'          => 43.15,
			'w2_4-5kg_mediumparcel'          => 51.80,
			'w2_5-7.500kg_mediumparcel'      => 70.60,
			'w2_7.500-10kg_mediumparcel'     => 97.90,
			'w2_10-15kg_mediumparcel'        => 137.70,
			'w2_15-20kg_mediumparcel'        => 190.75,

			// World zone 3
			'w3_0-0.1kg_mediumparcel'        => 23.45,
			'w3_0.1-0.250kg_mediumparcel'    => 23.45,
			'w3_0.250-0.500kg_mediumparcel'  => 23.45,
			'w3_0.500-0.750kg_mediumparcel'  => 23.45,
			'w3_0.750-1kg_mediumparcel'      => 23.45,
			'w3_1-1.250kg_mediumparcel'      => 30.90,
			'w3_1.250-1.500kg_mediumparcel'  => 30.90,
			'w3_1.500-2kg_mediumparcel'      => 30.90,
			'w3_2-3kg_mediumparcel'          => 30.90,
			'w3_3-4kg_mediumparcel'          => 39.20,
			'w3_4-5kg_mediumparcel'          => 45.00,
			'w3_5-7.500kg_mediumparcel'      => 61.00,
			'w3_7.500-10kg_mediumparcel'     => 76.00,
			'w3_10-15kg_mediumparcel'        => 110.70,
			'w3_15-20kg_mediumparcel'        => 133.00,
		),
	),

);
