<?php
return array(
	
	//Parcel force services
	array(
		'name' => 'Royal Mail Parcelforce express9',
		'id' => 'parcelforce_express9',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 57.45,
			'uk_weight_5-10kg' 	=> 65.45,
			'uk_weight_10-20kg' => 73.95,
			'uk_weight_20-30kg' => 87.95,
		)
	),
	array(
		'name' => 'Royal Mail Parcelforce express10',
		'id' => 'parcelforce_express10',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 27.45,
			'uk_weight_5-10kg'  => 30.45,
			'uk_weight_10-20kg' => 33.95,
			'uk_weight_20-30kg' => 37.95,
		)
	),
	array(
		'name' => 'Royal Mail Parcelforce expressAM',
		'id' => 'parcelforce_expressAM',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 17.45,
			'uk_weight_5-10kg' 	=> 20.45,
			'uk_weight_10-20kg' => 23.95,
			'uk_weight_20-30kg' => 27.95,
		)
	),
	array(
		'name' => 'Royal Mail Parcelforce express24',
		'id' => 'parcelforce_express24',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 13.45,
			'uk_weight_5-10kg' 	=> 16.45,
			'uk_weight_10-20kg' => 19.95,
			'uk_weight_20-30kg' => 23.95,
		)
	),
	array(
		'name' => 'Royal Mail Parcelforce express48',
		'id' => 'parcelforce_express48',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 12.95,
			'uk_weight_5-10kg' 	=> 14.95,
			'uk_weight_10-20kg' => 17.95,
			'uk_weight_20-30kg' => 20.95,
		)
	),
	array(
		'name' => 'Royal Mail Parcelforce express48 large',
		'id' => 'parcelforce_express48_large',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 47.95,
			'uk_weight_5-10kg' 	=> 54.95,
			'uk_weight_10-20kg' => 67.95,
			'uk_weight_20-30kg' => 90.95,
		)
	),

// These services available only for account users
/*
	array(
		'name' => 'Parcelforce Euro Priority Busines',
		'id' => 'ph_parcelforce:europrioritybusines',
		'special_services' => array(),
		'rules' => array( 

			// Zone 4 Channel Islands
			'zone4_0-0.5kg' 	=> 35.40,
			'zone4_0.5-1kg' 	=> 36.00,
			'zone4_1-1.5kg' 	=> 36.60,
			'zone4_1.5-2kg' 	=> 37.20,
			'zone4_2-2.5kg' 	=> 37.80,
			'zone4_2.5-3kg' 	=> 38.50,
			'zone4_3-3.5kg' 	=> 39.20,
			'zone4_3.5-4kg' 	=> 39.90,
			'zone4_4-4.5kg' 	=> 40.60,
			'zone4_4.5-5kg' 	=> 41.30,
			'zone4_5-5.5kg' 	=> 41.40,
			'zone4_5.5-6kg' 	=> 41.50,
			'zone4_6-6.5kg' 	=> 41.60,
			'zone4_6.5-7kg' 	=> 41.70,
			'zone4_7-7.5kg' 	=> 41.80,
			'zone4_7.5-8kg' 	=> 41.90,
			'zone4_8-8.5kg' 	=> 42.00,
			'zone4_8.5-9kg' 	=> 42.10,
			'zone4_9-9.5kg' 	=> 42.20,
			'zone4_9.5-10kg' 	=> 42.30,
			'zone4_10-10.5kg' 	=> 42.65,
			'zone4_10.5-11kg' 	=> 43.00,
			'zone4_11-11.5kg' 	=> 43.35,
			'zone4_11.5-12kg' 	=> 43.70,
			'zone4_12-12.5kg' 	=> 44.05,
			'zone4_12.5-13kg' 	=> 44.40,
			'zone4_13-13.5kg' 	=> 44.75,
			'zone4_13.5-14kg' 	=> 45.10,
			'zone4_14-14.5kg' 	=> 45.45,
			'zone4_14.5-15kg' 	=> 45.80,
			'zone4_additional-0.5' 	=> array('basecost'=>45.80, 'perweight'=>0.20),

			// Zone 5 Republic of Ireland
			'zone5_0-0.5kg' 	=> 36.40,
			'zone5_0.5-1kg' 	=> 37.25,
			'zone5_1-1.5kg' 	=> 38.10,
			'zone5_1.5-2kg' 	=> 38.95,
			'zone5_2-2.5kg' 	=> 39.80,
			'zone5_2.5-3kg' 	=> 41.45,
			'zone5_3-3.5kg' 	=> 43.10,
			'zone5_3.5-4kg' 	=> 44.75,
			'zone5_4-4.5kg' 	=> 46.40,
			'zone5_4.5-5kg' 	=> 48.05,
			'zone5_5-5.5kg' 	=> 49.15,
			'zone5_5.5-6kg' 	=> 50.25,
			'zone5_6-6.5kg' 	=> 51.35,
			'zone5_6.5-7kg' 	=> 52.45,
			'zone5_7-7.5kg' 	=> 53.55,
			'zone5_7.5-8kg' 	=> 54.65,
			'zone5_8-8.5kg' 	=> 55.75,
			'zone5_8.5-9kg' 	=> 56.85,
			'zone5_9-9.5kg' 	=> 57.95,
			'zone5_9.5-10kg' 	=> 59.05,
			'zone5_10-10.5kg' 	=> 59.95,
			'zone5_10.5-11kg' 	=> 60.85,
			'zone5_11-11.5kg' 	=> 61.75,
			'zone5_11.5-12kg' 	=> 62.65,
			'zone5_12-12.5kg' 	=> 63.55,
			'zone5_12.5-13kg' 	=> 64.45,
			'zone5_13-13.5kg' 	=> 65.35,
			'zone5_13.5-14kg' 	=> 66.25,
			'zone5_14-14.5kg' 	=> 67.15,
			'zone5_14.5-15kg' 	=> 68.05,
			'zone5_additional-0.5' 	=> array('basecost'=>68.05, 'perweight'=>0.60),

			// Zone 6 Belgium, Netherlands & Luxembourg
			'zone6_0-0.5kg' 	=> 32.30,
			'zone6_0.5-1kg' 	=> 34.10,
			'zone6_1-1.5kg' 	=> 35.90,
			'zone6_1.5-2kg' 	=> 37.70,
			'zone6_2-2.5kg' 	=> 39.50,
			'zone6_2.5-3kg' 	=> 41.15,
			'zone6_3-3.5kg' 	=> 42.80,
			'zone6_3.5-4kg' 	=> 44.45,
			'zone6_4-4.5kg' 	=> 46.10,
			'zone6_4.5-5kg' 	=> 47.75,
			'zone6_5-5.5kg' 	=> 48.80,
			'zone6_5.5-6kg' 	=> 49.85,
			'zone6_6-6.5kg' 	=> 50.90,
			'zone6_6.5-7kg' 	=> 51.95,
			'zone6_7-7.5kg' 	=> 53.00,
			'zone6_7.5-8kg' 	=> 54.05,
			'zone6_8-8.5kg' 	=> 55.10,
			'zone6_8.5-9kg' 	=> 56.15,
			'zone6_9-9.5kg' 	=> 57.20,
			'zone6_9.5-10kg' 	=> 58.25,
			'zone6_10-10.5kg' 	=> 59.30,
			'zone6_10.5-11kg' 	=> 60.35,
			'zone6_11-11.5kg' 	=> 61.40,
			'zone6_11.5-12kg' 	=> 62.45,
			'zone6_12-12.5kg' 	=> 63.50,
			'zone6_12.5-13kg' 	=> 64.55,
			'zone6_13-13.5kg' 	=> 65.60,
			'zone6_13.5-14kg' 	=> 66.65,
			'zone6_14-14.5kg' 	=> 67.70,
			'zone6_14.5-15kg' 	=> 68.75,
			'zone6_additional-0.5' 	=> array('basecost'=>68.75, 'perweight'=>0.60),

			// Zone 7 France, Germany& Denmark
			'zone7_0-0.5kg' 	=> 35.45,
			'zone7_0.5-1kg' 	=> 37.55,
			'zone7_1-1.5kg' 	=> 39.65,
			'zone7_1.5-2kg' 	=> 41.75,
			'zone7_2-2.5kg' 	=> 43.85,
			'zone7_2.5-3kg' 	=> 45.75,
			'zone7_3-3.5kg' 	=> 47.65,
			'zone7_3.5-4kg' 	=> 49.55,
			'zone7_4-4.5kg' 	=> 51.45,
			'zone7_4.5-5kg' 	=> 53.35,
			'zone7_5-5.5kg' 	=> 54.55,
			'zone7_5.5-6kg' 	=> 55.75,
			'zone7_6-6.5kg' 	=> 56.95,
			'zone7_6.5-7kg' 	=> 58.15,
			'zone7_7-7.5kg' 	=> 59.35,
			'zone7_7.5-8kg' 	=> 60.55,
			'zone7_8-8.5kg' 	=> 61.75,
			'zone7_8.5-9kg' 	=> 62.95,
			'zone7_9-9.5kg' 	=> 64.15,
			'zone7_9.5-10kg' 	=> 65.35,
			'zone7_10-10.5kg' 	=> 66.35,
			'zone7_10.5-11kg' 	=> 67.35,
			'zone7_11-11.5kg' 	=> 68.35,
			'zone7_11.5-12kg' 	=> 69.35,
			'zone7_12-12.5kg' 	=> 70.35,
			'zone7_12.5-13kg' 	=> 71.35,
			'zone7_13-13.5kg' 	=> 72.35,
			'zone7_13.5-14kg' 	=> 73.35,
			'zone7_14-14.5kg' 	=> 74.35,
			'zone7_14.5-15kg' 	=> 75.35,
			'zone7_additional-0.5' 	=> array('basecost'=>75.35, 'perweight'=>0.55),

			// Zone 8 Italy, Spain, Portugal & Greece
			'zone8_0-0.5kg' 	=> 38.50,
			'zone8_0.5-1kg' 	=> 40.50,
			'zone8_1-1.5kg' 	=> 42.50,
			'zone8_1.5-2kg' 	=> 44.50,
			'zone8_2-2.5kg' 	=> 46.50,
			'zone8_2.5-3kg' 	=> 48.70,
			'zone8_3-3.5kg' 	=> 50.90,
			'zone8_3.5-4kg' 	=> 53.10,
			'zone8_4-4.5kg' 	=> 55.30,
			'zone8_4.5-5kg' 	=> 57.50,
			'zone8_5-5.5kg' 	=> 58.95,
			'zone8_5.5-6kg' 	=> 60.40,
			'zone8_6-6.5kg' 	=> 61.85,
			'zone8_6.5-7kg' 	=> 63.30,	
			'zone8_7-7.5kg' 	=> 64.75,
			'zone8_7.5-8kg' 	=> 66.20,
			'zone8_8-8.5kg' 	=> 67.65,
			'zone8_8.5-9kg' 	=> 69.10,
			'zone8_9-9.5kg' 	=> 70.55,
			'zone8_9.5-10kg' 	=> 72.00,
			'zone8_10-10.5kg' 	=> 73.45,
			'zone8_10.5-11kg' 	=> 74.90,
			'zone8_11-11.5kg' 	=> 76.35,
			'zone8_11.5-12kg' 	=> 77.80,
			'zone8_12-12.5kg' 	=> 79.25,
			'zone8_12.5-13kg' 	=> 80.70,
			'zone8_13-13.5kg' 	=> 82.15,
			'zone8_13.5-14kg' 	=> 83.60,
			'zone8_14-14.5kg' 	=> 85.05,
			'zone8_14.5-15kg' 	=> 86.50,
			'zone8_additional-0.5' 	=> array('basecost'=>86.50, 'perweight'=>0.60),

			// Zone 9 Rest of Europe
			'zone9_0-0.5kg' 	=> 43.70,
			'zone9_0.5-1kg' 	=> 46.20,
			'zone9_1-1.5kg' 	=> 48.70,
			'zone9_1.5-2kg' 	=> 51.20,
			'zone9_2-2.5kg' 	=> 53.70,
			'zone9_2.5-3kg' 	=> 56.10,
			'zone9_3-3.5kg' 	=> 58.50,
			'zone9_3.5-4kg' 	=> 60.90,
			'zone9_4-4.5kg' 	=> 63.30,
			'zone9_4.5-5kg' 	=> 65.70,
			'zone9_5-5.5kg' 	=> 67.10,
			'zone9_5.5-6kg' 	=> 68.50,
			'zone9_6-6.5kg' 	=> 69.90,
			'zone9_6.5-7kg' 	=> 71.30,
			'zone9_7-7.5kg' 	=> 72.70,
			'zone9_7.5-8kg' 	=> 74.10,
			'zone9_8-8.5kg' 	=> 75.50,
			'zone9_8.5-9kg' 	=> 76.90,
			'zone9_9-9.5kg' 	=> 78.30,
			'zone9_9.5-10kg' 	=> 79.70,
			'zone9_10-10.5kg' 	=> 80.95,
			'zone9_10.5-11kg' 	=> 82.20,
			'zone9_11-11.5kg' 	=> 83.45,
			'zone9_11.5-12kg' 	=> 84.70,
			'zone9_12-12.5kg' 	=> 85.95,
			'zone9_12.5-13kg' 	=> 87.20,
			'zone9_13-13.5kg' 	=> 88.45,
			'zone9_13.5-14kg' 	=> 89.70,
			'zone9_14-14.5kg' 	=> 90.95,
			'zone9_14.5-15kg' 	=> 92.20,
			'zone9_additional-0.5' 	=> array('basecost'=>92.20, 'perweight'=>0.80),
		)
	),

	array(
		'name' => 'Parcelforce Euro Priority Home',
		'id' => 'ph_parcelforce:europriorityhome',
		'special_services' => array(),
		'rules' => array( 

			// Zone 4 Channel Islands
			'zone4_0-0.5kg' 	=> 38.50,
			'zone4_0.5-1kg' 	=> 39.55,
			'zone4_1-1.5kg' 	=> 40.60,
			'zone4_1.5-2kg' 	=> 41.65,
			'zone4_2-2.5kg' 	=> 42.70,
			'zone4_2.5-3kg' 	=> 43.20,
			'zone4_3-3.5kg' 	=> 43.70,
			'zone4_3.5-4kg' 	=> 44.20,
			'zone4_4-4.5kg' 	=> 44.70,
			'zone4_4.5-5kg' 	=> 45.20,
			'zone4_5-5.5kg' 	=> 45.50,
			'zone4_5.5-6kg' 	=> 45.80,
			'zone4_6-6.5kg' 	=> 46.10,
			'zone4_6.5-7kg' 	=> 46.40,
			'zone4_7-7.5kg' 	=> 46.70,
			'zone4_7.5-8kg' 	=> 47.00,
			'zone4_8-8.5kg' 	=> 47.30,
			'zone4_8.5-9kg' 	=> 47.60,
			'zone4_9-9.5kg' 	=> 47.90,
			'zone4_9.5-10kg' 	=> 48.20,
			'zone4_10-10.5kg' 	=> 48.30,
			'zone4_10.5-11kg' 	=> 48.40,
			'zone4_11-11.5kg' 	=> 48.50,
			'zone4_11.5-12kg' 	=> 48.60,
			'zone4_12-12.5kg' 	=> 48.70,
			'zone4_12.5-13kg' 	=> 48.80,
			'zone4_13-13.5kg' 	=> 48.90,
			'zone4_13.5-14kg' 	=> 49.00,
			'zone4_14-14.5kg' 	=> 49.10,
			'zone4_14.5-15kg' 	=> 49.20,
			'zone4_additional-0.5' 	=> array('basecost'=>49.20, 'perweight'=>0.30),

			// Zone 5 Republic of Ireland
			'zone5_0-0.5kg' 	=> 39.50,
			'zone5_0.5-1kg' 	=> 40.90,
			'zone5_1-1.5kg' 	=> 42.30,
			'zone5_1.5-2kg' 	=> 43.70,
			'zone5_2-2.5kg' 	=> 45.10,
			'zone5_2.5-3kg' 	=> 46.65,
			'zone5_3-3.5kg' 	=> 48.20,
			'zone5_3.5-4kg' 	=> 49.75,
			'zone5_4-4.5kg' 	=> 51.30,
			'zone5_4.5-5kg' 	=> 52.85,
			'zone5_5-5.5kg' 	=> 54.10,
			'zone5_5.5-6kg' 	=> 55.35,
			'zone5_6-6.5kg' 	=> 56.60,
			'zone5_6.5-7kg' 	=> 57.85,
			'zone5_7-7.5kg' 	=> 59.10,
			'zone5_7.5-8kg' 	=> 60.35,
			'zone5_8-8.5kg' 	=> 61.60,
			'zone5_8.5-9kg' 	=> 62.85,
			'zone5_9-9.5kg' 	=> 64.10,
			'zone5_9.5-10kg' 	=> 65.35,
			'zone5_10-10.5kg' 	=> 66.25,
			'zone5_10.5-11kg' 	=> 67.15,
			'zone5_11-11.5kg' 	=> 68.05,
			'zone5_11.5-12kg' 	=> 68.95,
			'zone5_12-12.5kg' 	=> 69.85,
			'zone5_12.5-13kg' 	=> 70.75,
			'zone5_13-13.5kg' 	=> 71.65,
			'zone5_13.5-14kg' 	=> 72.55,
			'zone5_14-14.5kg' 	=> 73.45,
			'zone5_14.5-15kg' 	=> 74.35,
			'zone5_additional-0.5' 	=> array('basecost'=>74.35, 'perweight'=>0.80),

			// Zone 6 Belgium, Netherlands & Luxembourg
			'zone6_0-0.5kg' 	=> 36.40,
			'zone6_0.5-1kg' 	=> 38.10,
			'zone6_1-1.5kg' 	=> 39.80,
			'zone6_1.5-2kg' 	=> 41.50,
			'zone6_2-2.5kg' 	=> 43.20,
			'zone6_2.5-3kg' 	=> 45.15,
			'zone6_3-3.5kg' 	=> 47.10,
			'zone6_3.5-4kg' 	=> 49.05,
			'zone6_4-4.5kg' 	=> 51.00,
			'zone6_4.5-5kg' 	=> 52.95,
			'zone6_5-5.5kg' 	=> 54.10,
			'zone6_5.5-6kg' 	=> 55.25,
			'zone6_6-6.5kg' 	=> 56.40,
			'zone6_6.5-7kg' 	=> 57.55,
			'zone6_7-7.5kg' 	=> 58.70,
			'zone6_7.5-8kg' 	=> 59.85,
			'zone6_8-8.5kg' 	=> 61.00,
			'zone6_8.5-9kg' 	=> 62.15,
			'zone6_9-9.5kg' 	=> 63.30,
			'zone6_9.5-10kg' 	=> 64.45,
			'zone6_10-10.5kg' 	=> 65.55,
			'zone6_10.5-11kg' 	=> 66.65,
			'zone6_11-11.5kg' 	=> 67.75,
			'zone6_11.5-12kg' 	=> 68.85,
			'zone6_12-12.5kg' 	=> 69.95,
			'zone6_12.5-13kg' 	=> 71.05,
			'zone6_13-13.5kg' 	=> 72.15,
			'zone6_13.5-14kg' 	=> 73.25,
			'zone6_14-14.5kg' 	=> 74.35,
			'zone6_14.5-15kg' 	=> 75.45,
			'zone6_additional-0.5' 	=> array('basecost'=>75.45, 'perweight'=>0.70),

			// Zone 7 France, Germany& Denmark
			'zone7_0-0.5kg' 	=> 38.50,
			'zone7_0.5-1kg' 	=> 41.00,
			'zone7_1-1.5kg' 	=> 43.50,
			'zone7_1.5-2kg' 	=> 46.00,
			'zone7_2-2.5kg' 	=> 48.50,
			'zone7_2.5-3kg' 	=> 50.60,
			'zone7_3-3.5kg' 	=> 52.70,
			'zone7_3.5-4kg' 	=> 54.80,
			'zone7_4-4.5kg' 	=> 56.90,
			'zone7_4.5-5kg' 	=> 59.00,
			'zone7_5-5.5kg' 	=> 60.40,
			'zone7_5.5-6kg' 	=> 61.80,
			'zone7_6-6.5kg' 	=> 63.20,
			'zone7_6.5-7kg' 	=> 64.60,
			'zone7_7-7.5kg' 	=> 66.00,
			'zone7_7.5-8kg' 	=> 67.40,
			'zone7_8-8.5kg' 	=> 68.80,
			'zone7_8.5-9kg' 	=> 70.20,
			'zone7_9-9.5kg' 	=> 71.60,
			'zone7_9.5-10kg' 	=> 73.00,
			'zone7_10-10.5kg' 	=> 74.20,
			'zone7_10.5-11kg' 	=> 75.40,
			'zone7_11-11.5kg' 	=> 76.60,
			'zone7_11.5-12kg' 	=> 77.80,
			'zone7_12-12.5kg' 	=> 79.00,
			'zone7_12.5-13kg' 	=> 80.20,
			'zone7_13-13.5kg' 	=> 81.40,
			'zone7_13.5-14kg' 	=> 82.60,
			'zone7_14-14.5kg' 	=> 83.80,
			'zone7_14.5-15kg' 	=> 85.00,
			'zone7_additional-0.5' 	=> array('basecost'=>85.00, 'perweight'=>0.60),

			// Zone 8 Italy, Spain, Portugal & Greece
			'zone8_0-0.5kg' 	=> 42.65,
			'zone8_0.5-1kg' 	=> 44.85,
			'zone8_1-1.5kg' 	=> 47.05,
			'zone8_1.5-2kg' 	=> 49.25,
			'zone8_2-2.5kg' 	=> 51.45,
			'zone8_2.5-3kg' 	=> 53.95,
			'zone8_3-3.5kg' 	=> 56.45,
			'zone8_3.5-4kg' 	=> 58.95,
			'zone8_4-4.5kg' 	=> 61.45,
			'zone8_4.5-5kg' 	=> 63.95,
			'zone8_5-5.5kg' 	=> 65.50,
			'zone8_5.5-6kg' 	=> 67.05,
			'zone8_6-6.5kg' 	=> 68.60,
			'zone8_6.5-7kg' 	=> 70.15,
			'zone8_7-7.5kg' 	=> 71.70,
			'zone8_7.5-8kg' 	=> 73.25,
			'zone8_8-8.5kg' 	=> 74.80,
			'zone8_8.5-9kg' 	=> 76.35,
			'zone8_9-9.5kg' 	=> 77.90,
			'zone8_9.5-10kg' 	=> 79.45,
			'zone8_10-10.5kg' 	=> 81.05,
			'zone8_10.5-11kg' 	=> 82.65,
			'zone8_11-11.5kg' 	=> 84.25,
			'zone8_11.5-12kg' 	=> 85.85,
			'zone8_12-12.5kg' 	=> 87.45,
			'zone8_12.5-13kg' 	=> 89.05,
			'zone8_13-13.5kg' 	=> 90.65,
			'zone8_13.5-14kg' 	=> 92.25,
			'zone8_14-14.5kg' 	=> 93.85,
			'zone8_14.5-15kg' 	=> 95.45,
			'zone8_additional-0.5' 	=> array('basecost'=>95.45, 'perweight'=>0.70),

			// Zone 9 Rest of Europe
			'zone9_0-0.5kg' 	=> 47.85,
			'zone9_0.5-1kg' 	=> 50.75,
			'zone9_1-1.5kg' 	=> 53.65,
			'zone9_1.5-2kg' 	=> 56.55,
			'zone9_2-2.5kg' 	=> 59.45,
			'zone9_2.5-3kg' 	=> 62.05,
			'zone9_3-3.5kg' 	=> 64.65,
			'zone9_3.5-4kg' 	=> 67.25,
			'zone9_4-4.5kg' 	=> 69.85,
			'zone9_4.5-5kg' 	=> 72.45,
			'zone9_5-5.5kg' 	=> 74.05,
			'zone9_5.5-6kg' 	=> 75.65,
			'zone9_6-6.5kg' 	=> 77.25,
			'zone9_6.5-7kg' 	=> 78.85,
			'zone9_7-7.5kg' 	=> 80.45,
			'zone9_7.5-8kg' 	=> 82.05,
			'zone9_8-8.5kg' 	=> 83.65,
			'zone9_8.5-9kg' 	=> 85.25,
			'zone9_9-9.5kg' 	=> 86.85,
			'zone9_9.5-10kg' 	=> 88.45,
			'zone9_10-10.5kg' 	=> 89.70,
			'zone9_10.5-11kg' 	=> 90.95,
			'zone9_11-11.5kg' 	=> 92.20,
			'zone9_11.5-12kg' 	=> 93.45,
			'zone9_12-12.5kg' 	=> 94.70,
			'zone9_12.5-13kg' 	=> 95.95,
			'zone9_13-13.5kg' 	=> 97.20,
			'zone9_13.5-14kg' 	=> 98.45,
			'zone9_14-14.5kg' 	=> 99.70,
			'zone9_14.5-15kg' 	=> 100.95,
			'zone9_additional-0.5' 	=> array('basecost'=>100.95, 'perweight'=>0.90),
		)
	),
	*/

	array(
		'name' => 'Parcelforce Global Express',
		'id' => 'ph_parcelforce:globalexpress',
		'special_services' => array(),
		'rules' => array( 
			
			// Zone 4 Channel Islands
			'zone4_0-0.5kg' 	=> 54.65,
			'zone4_0.5-1kg' 	=> 57.60,
			'zone4_1-1.5kg' 	=> 60.35,
			'zone4_1.5-2kg' 	=> 63.10,
			'zone4_2-2.5kg' 	=> 65.85,
			'zone4_2.5-3kg' 	=> 68.60,
			'zone4_3-3.5kg' 	=> 71.40,
			'zone4_3.5-4kg' 	=> 74.15,
			'zone4_4-4.5kg' 	=> 76.90,
			'zone4_4.5-5kg' 	=> 79.65,
			'zone4_5-5.5kg' 	=> 79.40,
			'zone4_5.5-6kg' 	=> 85.70,
			'zone4_6-6.5kg' 	=> 88.70,
			'zone4_6.5-7kg' 	=> 91.70,
			'zone4_7-7.5kg' 	=> 94.75,
			'zone4_7.5-8kg' 	=> 97.75,
			'zone4_8-8.5kg' 	=> 100.80,
			'zone4_8.5-9kg' 	=> 103.80,
			'zone4_9-9.5kg' 	=> 106.80,
			'zone4_9.5-10kg' 	=> 109.85,
			'zone4_10-10.5kg' 	=> 112.15,
			'zone4_10.5-11kg' 	=> 114.50,
			'zone4_11-11.5kg' 	=> 116.85,
			'zone4_11.5-12kg' 	=> 119.20,
			'zone4_12-12.5kg' 	=> 121.55,
			'zone4_12.5-13kg' 	=> 123.90,
			'zone4_13-13.5kg' 	=> 126.20,
			'zone4_13.5-14kg' 	=> 128.55,
			'zone4_14-14.5kg' 	=> 130.90,
			'zone4_14.5-15kg' 	=> 133.25,
			'zone4_additional-0.5' 	=> array('basecost'=>133.25, 'perweight'=>2.55),

			// Zone 5 Republic of Ireland
			'zone5_0-0.5kg' 	=> 47.85,
			'zone5_0.5-1kg' 	=> 50.50,
			'zone5_1-1.5kg' 	=> 53.10,
			'zone5_1.5-2kg' 	=> 55.75,
			'zone5_2-2.5kg' 	=> 59.60,
			'zone5_2.5-3kg' 	=> 63.45,
			'zone5_3-3.5kg' 	=> 67.35,
			'zone5_3.5-4kg' 	=> 71.20,
			'zone5_4-4.5kg' 	=> 75.05,
			'zone5_4.5-5kg' 	=> 78.95,
			'zone5_5-5.5kg' 	=> 80.75,
			'zone5_5.5-6kg' 	=> 82.55,
			'zone5_6-6.5kg' 	=> 84.35,
			'zone5_6.5-7kg' 	=> 86.20,
			'zone5_7-7.5kg' 	=> 88.00,
			'zone5_7.5-8kg' 	=> 89.80,
			'zone5_8-8.5kg' 	=> 91.60,
			'zone5_8.5-9kg' 	=> 93.45,
			'zone5_9-9.5kg' 	=> 95.25,
			'zone5_9.5-10kg' 	=> 97.05,
			'zone5_10-10.5kg' 	=> 99.50,
			'zone5_10.5-11kg' 	=> 101.90,
			'zone5_11-11.5kg' 	=> 104.35,
			'zone5_11.5-12kg' 	=> 106.80,
			'zone5_12-12.5kg' 	=> 109.20,
			'zone5_12.5-13kg' 	=> 111.65,
			'zone5_13-13.5kg' 	=> 114.10,
			'zone5_13.5-14kg' 	=> 116.50,
			'zone5_14-14.5kg' 	=> 118.95,
			'zone5_14.5-15kg' 	=> 121.40,
			'zone5_additional-0.5' 	=> array('basecost'=>121.40, 'perweight'=>1.8),

			// Zone 6 Belgium, Netherlands & Luxembourg
			'zone6_0-0.5kg' 	=> 43.25,
			'zone6_0.5-1kg' 	=> 47.50,
			'zone6_1-1.5kg' 	=> 51.75,
			'zone6_1.5-2kg' 	=> 56.00,
			'zone6_2-2.5kg' 	=> 59.45,
			'zone6_2.5-3kg' 	=> 62.95,
			'zone6_3-3.5kg' 	=> 66.45,
			'zone6_3.5-4kg' 	=> 69.95,
			'zone6_4-4.5kg' 	=> 73.45,
			'zone6_4.5-5kg' 	=> 77.00,
			'zone6_5-5.5kg' 	=> 79.15,
			'zone6_5.5-6kg' 	=> 81.35,
			'zone6_6-6.5kg' 	=> 83.50,
			'zone6_6.5-7kg' 	=> 85.70,
			'zone6_7-7.5kg' 	=> 87.85,
			'zone6_7.5-8kg' 	=> 90.05,
			'zone6_8-8.5kg' 	=> 92.20,
			'zone6_8.5-9kg' 	=> 94.40,
			'zone6_9-9.5kg' 	=> 96.60,
			'zone6_9.5-10kg' 	=> 98.75,
			'zone6_10-10.5kg' 	=> 100.75,
			'zone6_10.5-11kg' 	=> 102.75,
			'zone6_11-11.5kg' 	=> 104.75,
			'zone6_11.5-12kg' 	=> 106.75,
			'zone6_12-12.5kg' 	=> 108.75,
			'zone6_12.5-13kg' 	=> 110.75,
			'zone6_13-13.5kg' 	=> 112.75,
			'zone6_13.5-14kg' 	=> 114.75,
			'zone6_14-14.5kg' 	=> 116.75,
			'zone6_14.5-15kg' 	=> 118.75,
			'zone6_additional-0.5' 	=> array('basecost'=>118.75, 'perweight'=>1.85),

			// Zone 7 France, Germany& Denmark
			'zone7_0-0.5kg' 	=> 44.55,
			'zone7_0.5-1kg' 	=> 48.30,
			'zone7_1-1.5kg' 	=> 52.05,
			'zone7_1.5-2kg' 	=> 55.80,
			'zone7_2-2.5kg' 	=> 60.15,
			'zone7_2.5-3kg' 	=> 64.55,
			'zone7_3-3.5kg' 	=> 68.90,
			'zone7_3.5-4kg' 	=> 73.25,
			'zone7_4-4.5kg' 	=> 77.65,
			'zone7_4.5-5kg' 	=> 82.00,
			'zone7_5-5.5kg' 	=> 85.30,
			'zone7_5.5-6kg' 	=> 88.60,
			'zone7_6-6.5kg' 	=> 91.90,
			'zone7_6.5-7kg' 	=> 95.20,
			'zone7_7-7.5kg' 	=> 98.50,
			'zone7_7.5-8kg' 	=> 101.80,
			'zone7_8-8.5kg' 	=> 105.10,
			'zone7_8.5-9kg' 	=> 108.40,
			'zone7_9-9.5kg' 	=> 111.70,
			'zone7_9.5-10kg' 	=> 115.00,
			'zone7_10-10.5kg' 	=> 117.60,
			'zone7_10.5-11kg' 	=> 120.15,
			'zone7_11-11.5kg' 	=> 122.70,
			'zone7_11.5-12kg' 	=> 125.30,
			'zone7_12-12.5kg' 	=> 127.85,
			'zone7_12.5-13kg' 	=> 130.40,
			'zone7_13-13.5kg' 	=> 133.00,
			'zone7_13.5-14kg' 	=> 135.55,
			'zone7_14-14.5kg' 	=> 138.10,
			'zone7_14.5-15kg' 	=> 140.70,
			'zone7_additional-0.5' 	=> array('basecost'=>140.70, 'perweight'=>2.1),

			// Zone 8 Italy, Spain, Portugal & Greece
			'zone8_0-0.5kg' 	=> 48.00,
			'zone8_0.5-1kg' 	=> 52.00,
			'zone8_1-1.5kg' 	=> 56.00,
			'zone8_1.5-2kg' 	=> 60.00,
			'zone8_2-2.5kg' 	=> 63.25,
			'zone8_2.5-3kg' 	=> 66.45,
			'zone8_3-3.5kg' 	=> 69.70,
			'zone8_3.5-4kg' 	=> 72.95,
			'zone8_4-4.5kg' 	=> 76.20,
			'zone8_4.5-5kg' 	=> 79.45,
			'zone8_5-5.5kg' 	=> 82.70,
			'zone8_5.5-6kg' 	=> 85.95,
			'zone8_6-6.5kg' 	=> 89.20,
			'zone8_6.5-7kg' 	=> 92.45,
			'zone8_7-7.5kg' 	=> 95.70,
			'zone8_7.5-8kg' 	=> 98.95,
			'zone8_8-8.5kg' 	=> 102.15,
			'zone8_8.5-9kg' 	=> 105.40,
			'zone8_9-9.5kg' 	=> 108.65,
			'zone8_9.5-10kg' 	=> 111.90,
			'zone8_10-10.5kg' 	=> 115.10,
			'zone8_10.5-11kg' 	=> 118.25,
			'zone8_11-11.5kg' 	=> 121.45,
			'zone8_11.5-12kg' 	=> 124.65,
			'zone8_12-12.5kg' 	=> 127.80,
			'zone8_12.5-13kg' 	=> 131.00,
			'zone8_13-13.5kg' 	=> 134.15,
			'zone8_13.5-14kg' 	=> 137.35,
			'zone8_14-14.5kg' 	=> 140.50,
			'zone8_14.5-15kg' 	=> 143.70,
			'zone8_additional-0.5' 	=> array('basecost'=>143.70, 'perweight'=>2.85),

			// Zone 9 Rest of Europe
			'zone9_0-0.5kg' 	=> 52.60,
			'zone9_0.5-1kg' 	=> 57.45,
			'zone9_1-1.5kg' 	=> 62.35,
			'zone9_1.5-2kg' 	=> 67.20,
			'zone9_2-2.5kg' 	=> 75.00,
			'zone9_2.5-3kg' 	=> 82.80,
			'zone9_3-3.5kg' 	=> 90.60,
			'zone9_3.5-4kg' 	=> 98.40,
			'zone9_4-4.5kg' 	=> 106.20,
			'zone9_4.5-5kg' 	=> 114.00,
			'zone9_5-5.5kg' 	=> 119.25,
			'zone9_5.5-6kg' 	=> 124.50,
			'zone9_6-6.5kg' 	=> 129.75,
			'zone9_6.5-7kg' 	=> 135.00,
			'zone9_7-7.5kg' 	=> 140.25,
			'zone9_7.5-8kg' 	=> 145.50,
			'zone9_8-8.5kg' 	=> 150.75,
			'zone9_8.5-9kg' 	=> 156.00,
			'zone9_9-9.5kg' 	=> 161.25,
			'zone9_9.5-10kg' 	=> 166.45,
			'zone9_10-10.5kg' 	=> 169.95,
			'zone9_10.5-11kg' 	=> 173.45,
			'zone9_11-11.5kg' 	=> 176.95,
			'zone9_11.5-12kg' 	=> 180.45,
			'zone9_12-12.5kg' 	=> 183.95,
			'zone9_12.5-13kg' 	=> 187.40,
			'zone9_13-13.5kg' 	=> 190.90,
			'zone9_13.5-14kg' 	=> 194.40,
			'zone9_14-14.5kg' 	=> 197.90,
			'zone9_14.5-15kg' 	=> 201.40,
			'zone9_additional-0.5' 	=> array('basecost'=>201.40, 'perweight'=>3.85),

			// Zone 10 USA & Canada
			'zone10_0-0.5kg' 		=> 54.85,
			'zone10_0.5-1kg' 		=> 60.25,
			'zone10_1-1.5kg' 		=> 65.65,
			'zone10_1.5-2kg' 		=> 71.10,
			'zone10_2-2.5kg' 		=> 75.40,
			'zone10_2.5-3kg' 		=> 79.70,
			'zone10_3-3.5kg' 		=> 84.00,
			'zone10_3.5-4kg' 		=> 88.35,
			'zone10_4-4.5kg' 		=> 92.65,
			'zone10_4.5-5kg' 		=> 96.95,
			'zone10_5-5.5kg' 		=> 101.55,
			'zone10_5.5-6kg' 		=> 106.10,
			'zone10_6-6.5kg' 		=> 110.70,
			'zone10_6.5-7kg' 		=> 115.25,
			'zone10_7-7.5kg' 		=> 119.85,
			'zone10_7.5-8kg' 		=> 124.40,
			'zone10_8-8.5kg' 		=> 129.00,
			'zone10_8.5-9kg' 		=> 133.55,
			'zone10_9-9.5kg' 		=> 138.15,
			'zone10_9.5-10kg' 		=> 142.70,
			'zone10_10-10.5kg' 		=> 146.25,
			'zone10_10.5-11kg' 		=> 149.80,
			'zone10_11-11.5kg' 		=> 153.30,
			'zone10_11.5-12kg' 		=> 156.85,
			'zone10_12-12.5kg' 		=> 160.40,
			'zone10_12.5-13kg' 		=> 163.95,
			'zone10_13-13.5kg' 		=> 167.45,
			'zone10_13.5-14kg' 		=> 171.00,
			'zone10_14-14.5kg' 		=> 174.55,
			'zone10_14.5-15kg' 		=> 178.10,
			'zone10_additional-0.5' 	=> array('basecost'=>178.10, 'perweight'=>3.45),

			// Zone 11 Far East & Australasia 
			'zone11_0-0.5kg' 		=> 66.90,
			'zone11_0.5-1kg' 		=> 74.00,
			'zone11_1-1.5kg' 		=> 81.15,
			'zone11_1.5-2kg' 		=> 88.25,
			'zone11_2-2.5kg' 		=> 94.50,
			'zone11_2.5-3kg' 		=> 100.75,
			'zone11_3-3.5kg' 		=> 107.00,
			'zone11_3.5-4kg' 		=> 113.25,
			'zone11_4-4.5kg' 		=> 119.50,
			'zone11_4.5-5kg' 		=> 125.75,
			'zone11_5-5.5kg' 		=> 130.85,
			'zone11_5.5-6kg' 		=> 135.95,
			'zone11_6-6.5kg' 		=> 141.05,
			'zone11_6.5-7kg' 		=> 145.15,
			'zone11_7-7.5kg' 		=> 151.25,
			'zone11_7.5-8kg' 		=> 156.35,
			'zone11_8-8.5kg' 		=> 161.40,
			'zone11_8.5-9kg' 		=> 166.50,
			'zone11_9-9.5kg' 		=> 171.60,
			'zone11_9.5-10kg' 		=> 176.70,
			'zone11_10-10.5kg' 		=> 182.25,
			'zone11_10.5-11kg' 		=> 187.85,
			'zone11_11-11.5kg' 		=> 193.40,
			'zone11_11.5-12kg' 		=> 198.95,
			'zone11_12-12.5kg' 		=> 204.55,
			'zone11_12.5-13kg' 		=> 210.10,
			'zone11_13-13.5kg' 		=> 215.65,
			'zone11_13.5-14kg' 		=> 221.25,
			'zone11_14-14.5kg' 		=> 226.80,
			'zone11_14.5-15kg' 		=> 232.35,
			'zone11_additional-0.5' 	=> array('basecost'=>232.35, 'perweight'=>5.5),

			// Zone 12 Rest of the World
			'zone12_0-0.5kg' 		=> 76.70,
			'zone12_0.5-1kg' 		=> 86.15,
			'zone12_1-1.5kg' 		=> 95.60,
			'zone12_1.5-2kg' 		=> 105.10,
			'zone12_2-2.5kg' 		=> 113.85,
			'zone12_2.5-3kg' 		=> 122.55,
			'zone12_3-3.5kg' 		=> 131.30,
			'zone12_3.5-4kg' 		=> 140.05,
			'zone12_4-4.5kg' 		=> 148.75,
			'zone12_4.5-5kg' 		=> 157.50,
			'zone12_5-5.5kg' 		=> 164.35,
			'zone12_5.5-6kg' 		=> 171.25,
			'zone12_6-6.5kg' 		=> 178.10,
			'zone12_6.5-7kg' 		=> 184.95,
			'zone12_7-7.5kg' 		=> 191.80,
			'zone12_7.5-8kg' 		=> 198.65,
			'zone12_8-8.5kg' 		=> 205.50,
			'zone12_8.5-9kg' 		=> 212.40,
			'zone12_9-9.5kg' 		=> 219.25,
			'zone12_9.5-10kg' 		=> 226.10,
			'zone12_10-10.5kg' 		=> 233.20,
			'zone12_10.5-11kg' 		=> 240.35,
			'zone12_11-11.5kg' 		=> 247.45,
			'zone12_11.5-12kg' 		=> 254.60,
			'zone12_12-12.5kg' 		=> 261.70,
			'zone12_12.5-13kg' 		=> 268.85,
			'zone12_13-13.5kg' 		=> 275.95,
			'zone12_13.5-14kg' 		=> 283.05,
			'zone12_14-14.5kg' 		=> 290.20,
			'zone12_14.5-15kg' 		=> 297.30,
			'zone12_additional-0.5' => array('basecost'=>297.30, 'perweight'=>7.35),
		)
	),
	

	array(
		'name' => 'Parcelforce Ireland Express',
		'id' => 'ph_parcelforce:irelandexpress',
		'special_services' => array(),
		'rules' => array( 
			
			// Zone 5 Republic of Ireland
			'zone5_0-0.5kg' 	=> 16.68,
			'zone5_0.5-1kg' 	=> 16.68,
			'zone5_1-1.5kg' 	=> 16.68,
			'zone5_1.5-2kg' 	=> 16.68,
			'zone5_2-2.5kg' 	=> 17.70,
			'zone5_2.5-3kg' 	=> 17.70,
			'zone5_3-3.5kg' 	=> 17.70,
			'zone5_3.5-4kg' 	=> 17.70,
			'zone5_4-4.5kg' 	=> 17.70,
			'zone5_4.5-5kg' 	=> 17.70,
			'zone5_5-5.5kg' 	=> 21.12,
			'zone5_5.5-6kg' 	=> 21.12,
			'zone5_6-6.5kg' 	=> 21.12,
			'zone5_6.5-7kg' 	=> 21.12,
			'zone5_7-7.5kg' 	=> 21.12,
			'zone5_7.5-8kg' 	=> 21.12,
			'zone5_8-8.5kg' 	=> 21.12,
			'zone5_8.5-9kg' 	=> 21.12,
			'zone5_9-9.5kg' 	=> 21.12,
			'zone5_9.5-10kg' 	=> 21.12,
			'zone5_10-10.5kg' 	=> 27.96,
			'zone5_10.5-11kg' 	=> 27.96,
			'zone5_11-11.5kg' 	=> 27.96,
			'zone5_11.5-12kg' 	=> 27.96,
			'zone5_12-12.5kg' 	=> 27.96,
			'zone5_12.5-13kg' 	=> 27.96,
			'zone5_13-13.5kg' 	=> 27.96,
			'zone5_13.5-14kg' 	=> 27.96,
			'zone5_14-14.5kg' 	=> 27.96,
			'zone5_14.5-15kg' 	=> 27.96,
			'zone5_additional-0.5' 	=> array('basecost'=>27.96, 'perweight'=>5.4),
		)
	),
	
	

	array(
		'name' => 'Parcelforce Global Priority',
		'id' => 'ph_parcelforce:globalpriority',
		'special_services' => array(),
		'rules' => array( 
			
			// Zone 9 Rest of Europe
			'zone9_0-0.5kg' 	=> 37.40,
			'zone9_0.5-1kg' 	=> 39.35,
			'zone9_1-1.5kg' 	=> 41.30,
			'zone9_1.5-2kg' 	=> 43.25,
			'zone9_2-2.5kg' 	=> 46.40,
			'zone9_2.5-3kg' 	=> 49.50,
			'zone9_3-3.5kg' 	=> 52.65,
			'zone9_3.5-4kg' 	=> 55.75,
			'zone9_4-4.5kg' 	=> 58.90,
			'zone9_4.5-5kg' 	=> 62.05,
			'zone9_5-5.5kg' 	=> 64.20,
			'zone9_5.5-6kg' 	=> 66.40,
			'zone9_6-6.5kg' 	=> 68.60,
			'zone9_6.5-7kg' 	=> 70.75,
			'zone9_7-7.5kg' 	=> 72.95,
			'zone9_7.5-8kg' 	=> 75.10,
			'zone9_8-8.5kg' 	=> 77.30,
			'zone9_8.5-9kg' 	=> 79.50,
			'zone9_9-9.5kg' 	=> 81.65,
			'zone9_9.5-10kg' 	=> 83.90,
			'zone9_10-10.5kg' 	=> 84.70,
			'zone9_10.5-11kg' 	=> 85.45,
			'zone9_11-11.5kg' 	=> 86.30,
			'zone9_11.5-12kg' 	=> 87.10,
			'zone9_12-12.5kg' 	=> 87.95,
			'zone9_12.5-13kg' 	=> 88.70,
			'zone9_13-13.5kg' 	=> 89.55,
			'zone9_13.5-14kg' 	=> 90.35,
			'zone9_14-14.5kg' 	=> 91.15,
			'zone9_14.5-15kg' 	=> 91.95,
			'zone9_additional-0.5' 	=> array('basecost'=>91.95, 'perweight'=>0.85),

			// Zone 10 USA & Canada
			'zone10_0-0.5kg' 		=> 36.05,
			'zone10_0.5-1kg' 		=> 37.95,
			'zone10_1-1.5kg' 		=> 39.75,
			'zone10_1.5-2kg' 		=> 41.60,
			'zone10_2-2.5kg' 		=> 41.60,
			'zone10_2.5-3kg' 		=> 43.60,
			'zone10_3-3.5kg' 		=> 49.40,
			'zone10_3.5-4kg' 		=> 55.20,
			'zone10_4-4.5kg' 		=> 60.95,
			'zone10_4.5-5kg' 		=> 66.70,
			'zone10_5-5.5kg' 		=> 69.55,
			'zone10_5.5-6kg' 		=> 72.40,
			'zone10_6-6.5kg' 		=> 75.20,
			'zone10_6.5-7kg' 		=> 78.00,
			'zone10_7-7.5kg' 		=> 80.80,
			'zone10_7.5-8kg' 		=> 83.65,
			'zone10_8-8.5kg' 		=> 86.45,
			'zone10_8.5-9kg' 		=> 90.25,
			'zone10_9-9.5kg' 		=> 93.05,
			'zone10_9.5-10kg' 		=> 96.90,
			'zone10_10-10.5kg' 		=> 102.60,
			'zone10_10.5-11kg' 		=> 111.60,
			'zone10_11-11.5kg' 		=> 113.65,
			'zone10_11.5-12kg' 		=> 115.70,
			'zone10_12-12.5kg' 		=> 117.75,
			'zone10_12.5-13kg' 		=> 119.80,
			'zone10_13-13.5kg' 		=> 121.85,
			'zone10_13.5-14kg' 		=> 123.85,
			'zone10_14-14.5kg' 		=> 125.95,
			'zone10_14.5-15kg' 		=> 127.95,
			'zone10_additional-0.5' 	=> array('basecost'=>127.95, 'perweight'=>2.05),

			// Zone 11 Far East & Australasia 
			'zone11_0-0.5kg' 		=> 38.30,
			'zone11_0.5-1kg' 		=> 42.25,
			'zone11_1-1.5kg' 		=> 46.20,
			'zone11_1.5-2kg' 		=> 50.20,
			'zone11_2-2.5kg' 		=> 55.85,
			'zone11_2.5-3kg' 		=> 60.50,
			'zone11_3-3.5kg' 		=> 67.15,
			'zone11_3.5-4kg' 		=> 72.80,
			'zone11_4-4.5kg' 		=> 78.50,
			'zone11_4.5-5kg' 		=> 84.15,
			'zone11_5-5.5kg' 		=> 88.05,
			'zone11_5.5-6kg' 		=> 91.90,
			'zone11_6-6.5kg' 		=> 95.75,
			'zone11_6.5-7kg' 		=> 99.55,
			'zone11_7-7.5kg' 		=> 103.45,
			'zone11_7.5-8kg' 		=> 107.30,
			'zone11_8-8.5kg' 		=> 111.15,
			'zone11_8.5-9kg' 		=> 115.00,
			'zone11_9-9.5kg' 		=> 118.90,
			'zone11_9.5-10kg' 		=> 122.75,
			'zone11_10-10.5kg' 		=> 125.65,
			'zone11_10.5-11kg' 		=> 128.65,
			'zone11_11-11.5kg' 		=> 131.55,
			'zone11_11.5-12kg' 		=> 134.45,
			'zone11_12-12.5kg' 		=> 137.40,
			'zone11_12.5-13kg' 		=> 140.35,
			'zone11_13-13.5kg' 		=> 143.25,
			'zone11_13.5-14kg' 		=> 146.15,
			'zone11_14-14.5kg' 		=> 149.15,
			'zone11_14.5-15kg' 		=> 162.05,
			'zone11_additional-0.5' 	=> array('basecost'=>152.05, 'perweight'=>2.85),

			// Zone 12 Rest of the World
			'zone12_0-0.5kg' 		=> 49.75,
			'zone12_0.5-1kg' 		=> 55.65,
			'zone12_1-1.5kg' 		=> 61.65,
			'zone12_1.5-2kg' 		=> 67.65,
			'zone12_2-2.5kg' 		=> 73.55,
			'zone12_2.5-3kg' 		=> 79.55,
			'zone12_3-3.5kg' 		=> 85.40,
			'zone12_3.5-4kg' 		=> 91.40,
			'zone12_4-4.5kg' 		=> 97.35,
			'zone12_4.5-5kg' 		=> 103.30,
			'zone12_5-5.5kg' 		=> 108.60,
			'zone12_5.5-6kg' 		=> 113.95,
			'zone12_6-6.5kg' 		=> 119.25,
			'zone12_6.5-7kg' 		=> 124.00,
			'zone12_7-7.5kg' 		=> 129.90,
			'zone12_7.5-8kg' 		=> 135.25,
			'zone12_8-8.5kg' 		=> 140.55,
			'zone12_8.5-9kg' 		=> 145.95,
			'zone12_9-9.5kg' 		=> 151.30,
			'zone12_9.5-10kg' 		=> 156.60,
			'zone12_10-10.5kg' 		=> 159.05,
			'zone12_10.5-11kg' 		=> 161.45,
			'zone12_11-11.5kg' 		=> 163.90,
			'zone12_11.5-12kg' 		=> 166.40,
			'zone12_12-12.5kg' 		=> 168.85,
			'zone12_12.5-13kg' 		=> 171.30,
			'zone12_13-13.5kg' 		=> 173.75,
			'zone12_13.5-14kg' 		=> 176.15,
			'zone12_14-14.5kg' 		=> 178.60,
			'zone12_14.5-15kg' 		=> 181.05,
			'zone12_additional-0.5' => array('basecost'=>181.05, 'perweight'=>2.45),
		)
	),



	array(
		'name' => 'Parcelforce Global Value',
		'id' => 'ph_parcelforce:globalvalue',
		'special_services' => array(),
		'rules' => array( 
			
			// Zone 10 USA & Canada
			'zone10_0-0.5kg' 		=> 22.45,
			'zone10_0.5-1kg' 		=> 24.70,
			'zone10_1-1.5kg' 		=> 26.90,
			'zone10_1.5-2kg' 		=> 29.20,
			'zone10_2-2.5kg' 		=> 34.85,
			'zone10_2.5-3kg' 		=> 40.60,
			'zone10_3-3.5kg' 		=> 46.25,
			'zone10_3.5-4kg' 		=> 51.95,
			'zone10_4-4.5kg' 		=> 57.65,
			'zone10_4.5-5kg' 		=> 63.30,
			'zone10_5-5.5kg' 		=> 66.60,
			'zone10_5.5-6kg' 		=> 69.85,
			'zone10_6-6.5kg' 		=> 73.15,
			'zone10_6.5-7kg' 		=> 76.40,
			'zone10_7-7.5kg' 		=> 79.65,
			'zone10_7.5-8kg' 		=> 82.95,
			'zone10_8-8.5kg' 		=> 86.20,
			'zone10_8.5-9kg' 		=> 89.45,
			'zone10_9-9.5kg' 		=> 92.70,
			'zone10_9.5-10kg' 		=> 96.00,
			'zone10_10-10.5kg' 		=> 98.10,
			'zone10_10.5-11kg' 		=> 100.20,
			'zone10_11-11.5kg' 		=> 102.30,
			'zone10_11.5-12kg' 		=> 104.45,
			'zone10_12-12.5kg' 		=> 106.50,
			'zone10_12.5-13kg' 		=> 108.65,
			'zone10_13-13.5kg' 		=> 110.80,
			'zone10_13.5-14kg' 		=> 112.90,
			'zone10_14-14.5kg' 		=> 115.00,
			'zone10_14.5-15kg' 		=> 117.10,
			'zone10_additional-0.5' 	=> array('basecost'=>117.10, 'perweight'=>2.10),

			// Zone 11 Far East & Australasia 
			'zone11_0-0.5kg' 		=> 28.35,
			'zone11_0.5-1kg' 		=> 33.85,
			'zone11_1-1.5kg' 		=> 39.35,
			'zone11_1.5-2kg' 		=> 44.80,
			'zone11_2-2.5kg' 		=> 50.15,
			'zone11_2.5-3kg' 		=> 55.50,
			'zone11_3-3.5kg' 		=> 60.90,
			'zone11_3.5-4kg' 		=> 66.25,
			'zone11_4-4.5kg' 		=> 71.60,
			'zone11_4.5-5kg' 		=> 76.95,
			'zone11_5-5.5kg' 		=> 80.95,
			'zone11_5.5-6kg' 		=> 84.95,
			'zone11_6-6.5kg' 		=> 88.95,
			'zone11_6.5-7kg' 		=> 92.95,
			'zone11_7-7.5kg' 		=> 97.00,
			'zone11_7.5-8kg' 		=> 100.95,
			'zone11_8-8.5kg' 		=> 104.95,
			'zone11_8.5-9kg' 		=> 108.95,
			'zone11_9-9.5kg' 		=> 112.95,
			'zone11_9.5-10kg' 		=> 116.95,
			'zone11_10-10.5kg' 		=> 119.85,
			'zone11_10.5-11kg' 		=> 122.80,
			'zone11_11-11.5kg' 		=> 125.75,
			'zone11_11.5-12kg' 		=> 128.65,
			'zone11_12-12.5kg' 		=> 131.65,
			'zone11_12.5-13kg' 		=> 134.55,
			'zone11_13-13.5kg' 		=> 137.50,
			'zone11_13.5-14kg' 		=> 140.40,
			'zone11_14-14.5kg' 		=> 143.35,
			'zone11_14.5-15kg' 		=> 146.35,
			'zone11_additional-0.5' 	=> array('basecost'=>146.35, 'perweight'=>2.90),

			// Zone 12 Rest of the World
			'zone12_0-0.5kg' 		=> 28.00,
			'zone12_0.5-1kg' 		=> 34.05,
			'zone12_1-1.5kg' 		=> 40.00,
			'zone12_1.5-2kg' 		=> 46.05,
			'zone12_2-2.5kg' 		=> 52.05,
			'zone12_2.5-3kg' 		=> 58.05,
			'zone12_3-3.5kg' 		=> 64.05,
			'zone12_3.5-4kg' 		=> 70.10,
			'zone12_4-4.5kg' 		=> 76.10,
			'zone12_4.5-5kg' 		=> 82.10,
			'zone12_5-5.5kg' 		=> 87.55,
			'zone12_5.5-6kg' 		=> 93.05,
			'zone12_6-6.5kg' 		=> 98.45,
			'zone12_6.5-7kg' 		=> 103.90,
			'zone12_7-7.5kg' 		=> 109.35,
			'zone12_7.5-8kg' 		=> 114.80,
			'zone12_8-8.5kg' 		=> 120.30,
			'zone12_8.5-9kg' 		=> 125.75,
			'zone12_9-9.5kg' 		=> 131.20,
			'zone12_9.5-10kg' 		=> 136.65,
			'zone12_10-10.5kg' 		=> 139.45,
			'zone12_10.5-11kg' 		=> 142.20,
			'zone12_11-11.5kg' 		=> 145.00,
			'zone12_11.5-12kg' 		=> 147.75,
			'zone12_12-12.5kg' 		=> 150.55,
			'zone12_12.5-13kg' 		=> 153.30,
			'zone12_13-13.5kg' 		=> 156.05,
			'zone12_13.5-14kg' 		=> 158.85,
			'zone12_14-14.5kg' 		=> 161.60,
			'zone12_14.5-15kg' 		=> 164.35,
			'zone12_additional-0.5' => array('basecost'=>164.35, 'perweight'=>2.75),
		)
	),	
);