<style>
	/*Style for tooltip*/
	.ph-tooltip {
		position: relative;
		top: 3px;
	}
	.ph-tooltip .ph-tooltiptext {
		visibility: hidden;
		width: 150px;
		background-color: #333;
		color: #fff;
		text-align: center;
		border-radius: 3px; 
		padding: .618em 1em;
		font-size: .8em;
		/* Position the tooltip */
		position: absolute; z-index: 1;
	}
	.ph-tooltip:hover .ph-tooltiptext {
		visibility: visible;
	}
	/*End of tooltip styling*/
</style>
<tr valign="top" id="service_options">
	<td class="titledesc" colspan="2" style="padding-left:0px">
	<strong><?php _e( 'Services', 'ph-shipping-royalmail' ); ?></strong><br><br>
		<table class="royalmail_services widefat">
			<thead>
				<th class="sort">&nbsp;</th>
				<th><?php _e( 'Service Code', 'ph-shipping-royalmail' ); ?></th>
				<th><?php _e( 'Name', 'ph-shipping-royalmail' ); ?></th>
				<th><?php _e( 'Enabled', 'ph-shipping-royalmail' ); ?></th>
				<th><?php echo sprintf( __( 'Price Adjustment (%s)', 'ph-shipping-royalmail' ), get_woocommerce_currency_symbol() ); ?></th>
				<th><?php _e( 'Price Adjustment (%)', 'ph-shipping-royalmail' ); ?></th>
			</thead>
			<tbody>
				<?php
					$sort = 0;
					$this->ordered_services = array();

					$onlineRates = array( 'tracked24', 'tracked24_with_signature', 'tracked48', 'tracked48_with_signature', 'tracked24_with_age_verification', 'tracked48_with_age_verification' );

					foreach ( $this->services as $service ) {
						$code = $service['id'];
						$name = $service['name'];

						if ( isset( $this->custom_services[ $code ]['order'] ) ) {
							$sort = $this->custom_services[ $code ]['order'];
						}

						while ( isset( $this->ordered_services[ $sort ] ) )
							$sort++;

						$this->ordered_services[ $sort ] = array( $code, $name );

						$sort++;
					}

					ksort( $this->ordered_services );

					foreach ( $this->ordered_services as $value ) {
						$code = $value[0];
						$name = $value[1];
						?>
						<tr>
							<td class="sort"><input type="hidden" class="order" name="royalmail_service[<?php echo $code; ?>][order]" value="<?php echo isset( $this->custom_services[ $code ]['order'] ) ? $this->custom_services[ $code ]['order'] : ''; ?>" /></td>
							<td>
								<strong><?php echo $code; ?></strong>
								<?php if( in_array($code, $onlineRates) ) { echo __(' (Online Rates)','ph-shipping-royalmail'); echo '<span class="ph-tooltip"><img src="'.site_url("/wp-content/plugins/woocommerce/assets/images/help.png").'" height="16" width="16" /><span class="ph-tooltiptext">'.__('The shipping rates for these services are Royal Mail Online Rates, as the offline rates are not available for these services.', 'ph-shipping-royalmail').'</span></span>'; } ?>
							</td>
							<td><input type="text" name="royalmail_service[<?php echo $code; ?>][name]" placeholder="<?php echo $name; ?>" value="<?php echo isset( $this->custom_services[ $code ]['name'] ) ? $this->custom_services[ $code ]['name'] : ''; ?>" size="50" /></td>
							<td><input type="checkbox" name="royalmail_service[<?php echo $code; ?>][enabled]" <?php checked( ( ! isset( $this->custom_services[ $code ]['enabled'] ) || ! empty( $this->custom_services[ $code ]['enabled'] ) ), true ); ?> /></td>
							<td><input type="text" name="royalmail_service[<?php echo $code; ?>][adjustment]" placeholder="N/A" value="<?php echo isset( $this->custom_services[ $code ]['adjustment'] ) ? $this->custom_services[ $code ]['adjustment'] : ''; ?>" size="4" /></td>
							<td><input type="text" name="royalmail_service[<?php echo $code; ?>][adjustment_percent]" placeholder="N/A" value="<?php echo isset( $this->custom_services[ $code ]['adjustment_percent'] ) ? $this->custom_services[ $code ]['adjustment_percent'] : ''; ?>" size="4" /></td>
						</tr>
						<?php
					}
				?>
			</tbody>
		</table>
	</td>
</tr>