<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $woocommerce;


/**
 * Array of settings
 */
return array(

	'title_rate'		   => array(
		'title'		   => __( 'Rate Settings', 'ph-shipping-royalmail' ),
		'type'			=> 'title',
		'class'			=> 'royalmail_rates_tab',
		'description'	 => __( 'Configure the rate related settings here. You can enable desired Royal Mail services and other rate options.', 'ph-shipping-royalmail' ),
	),
	'enabled'		  => array(
		'title'		   	=> __( 'Enable Rates', 'ph-shipping-royalmail' ),
		'type'			=> 'checkbox',
		'label'			=> __( 'Enable', 'ph-shipping-royalmail' ),
		'default'		=> 'no',
		'class'			=>'royalmail_rates_tab'
	),
	'title'			=> array(
		'title'		   => __( 'Method Title', 'ph-shipping-royalmail' ),
		'type'			=> 'text',
		'description'	 => __( 'This controls the title which the user sees during checkout.', 'ph-shipping-royalmail' ),
		'default'		 => __( 'Royal Mail', 'ph-shipping-royalmail' ),
		'desc_tip'		=> true,
		'class'			=>'royalmail_rates_tab'
	),
	'availability'		=> array(
		'title'		   => __( 'Method Available to', 'ph-shipping-royalmail' ),
		'type'			=> 'select',
		'default'		 => 'all',
		'class'		   => 'availability wc-enhanced-select royalmail_rates_tab',
		'options'		 => array(
			'all'			=> __( 'All Countries', 'ph-shipping-royalmail' ),
			'specific'	   => __( 'Specific Countries', 'ph-shipping-royalmail' ),
		),
	),
	'countries'		   => array(
		'title'		   => __( 'Specific Countries', 'ph-shipping-royalmail' ),
		'type'			=> 'multiselect',
		'class'		   => 'chosen_select royalmail_rates_tab',
		'css'			 => 'width: 450px;',
		'default'		 => '',
		'options'		 => $woocommerce->countries->get_allowed_countries(),
	),

	'debug'	  => array(
		'title'		   => __( 'Debug Mode', 'ph-shipping-royalmail' ),
		'label'		   => __( 'Enable', 'ph-shipping-royalmail' ),
		'type'			=> 'checkbox',
		'default'		 => 'no',
		'desc_tip'	=> true,
		'description'	 => __( 'Enable debug mode to show debugging information on the cart/checkout.', 'ph-shipping-royalmail' ),
		'class'			=>'royalmail_general_tab',
	),

	'offer_rates'   => array(
		'title'		   => __( 'Offer Rates', 'ph-shipping-royalmail' ),
		'type'			=> 'select',
		'description'	 => '',
		'default'		 => 'all',
		'class'		   => 'wc-enhanced-select royalmail_rates_tab',
		'options'		 => array(
			'all'		 => __( 'Offer the customer all returned rates', 'ph-shipping-royalmail' ),
			'cheapest'	=> __( 'Offer the customer the cheapest rate only, anonymously', 'ph-shipping-royalmail' ),
		),
	),

	'title_packaging'		   => array(
		'title'		   => __( 'Packaging Settings', 'ph-shipping-royalmail' ),
		'type'			=> 'title',
		'class'			=> 'royalmail_packaging_tab',
		'description'	 => __( 'Choose the packing options suitable for your store here.', 'ph-shipping-royalmail' ),
	),
	'packing_method'   => array(
		'title'		   => __( 'Parcel Packing Method', 'ph-shipping-royalmail' ),
		'type'			=> 'select',
		'default'		 => 'weight_based',
		'class'		   => 'packing_method wc-enhanced-select royalmail_packaging_tab',
		'options'		 => array(
			'box_packing'	=> __( 'Flexible Packaging: Use boxes with customisable weight & dimension limits', 'ph-shipping-royalmail' ),
			'weight_based'  => __( 'Max Weight Limit: Pack products in same box until limit is reached', 'ph-shipping-royalmail' ),
			'per_item'	   	=> __( 'Individual Packaging: Separate box for each item in the cart', 'ph-shipping-royalmail' ),
		),
		'desc_tip'	=> true,
		'description'	 => __( 'Determine how items are packed.', 'ph-shipping-royalmail' ),
	),
	'box_max_weight'		   => array(
		'title'		   => __( 'Max Package Weight', 'ph-shipping-royalmail' ),
		'type'			=> 'text',
		'default'		 => '10',
		'class'		   => 'weight_based_option royalmail_packaging_tab',
		'desc_tip'		=> true,
		'description'	 => __( 'Maximum weight allowed for single box.', 'ph-shipping-royalmail' ),
	),

	//weight_packing_process
	'weight_pack_process'   => array(
		'title'		   => __( 'Packing Process', 'ph-shipping-royalmail' ),
		'type'			=> 'select',
		'default'		 => '',
		'class'		   => 'weight_based_option wc-enhanced-select royalmail_packaging_tab',
		'options'		 => array(
			'pack_descending'	   => __( 'Pack heavier items first', 'ph-shipping-royalmail' ),
			'pack_ascending'		=> __( 'Pack lighter items first.', 'ph-shipping-royalmail' ),
			'pack_simple'			=> __( 'Pack purely divided by weight.', 'ph-shipping-royalmail' ),
		),
		'desc_tip'	=> true,
		'description'	 => __( 'Select your packing order.', 'ph-shipping-royalmail' ),
	),

	'boxes'  => array(
		'type'			=> 'box_packing'
	),
	'services'  => array(
		'type'			=> 'services'
	),

	'conversion_rate'	 => array(
		'title' 		  => __('Conversion Rate', 'ph-shipping-royalmail'),
		'type' 			  => 'text',
		'default'		 => '',
		'class'			=>'royalmail_rates_tab',
		'description' 	  => __('Enter the conversion amount in case you have a different currency set up comparing to the currency of origin location. This amount will be multiplied with the shipping rates. Leave it empty if no conversion required.','ph-shipping-royalmail'),
		'desc_tip' 		  => true
	),
	'tracking_shipmentid' => array(
			'title'		   => __( 'Tracking PIN', 'ph-shipping-royalmail' ),
			'label'		   => __( 'Add Tracking PIN to customer order notes.', 'ph-shipping-royalmail' ),
			'type'			=> 'checkbox',
			'default'		 => 'no',
			'class'			=> 'royalmail_label_tab',
			'description'	 => '',
		),
	'custom_message'		=> array(
		'title'				=> __( 'Custom Shipment Message', 'ph-shipping-royalmail' ),
		'type'				=> 'text',
		'class'			=> 'royalmail_label_tab',
		'description'		=> __( 'Define your own shipment message. Use the place holder tags [ID], [SERVICE] and [DATE] for Shipment Id, Shipment Service and Shipment Date respectively. Leave it empty for default message.<br>', 'ph-shipping-royalmail' ),
		'css'				=> 'width:900px',
		//'id'				=> PHTrackingUtil::TRACKING_SETTINGS_TAB_KEY.PHTrackingUtil::TRACKING_MESSAGE_KEY,
		'placeholder'		=> __('Your order was shipped on [DATE] via [SERVICE]. To track shipment, please follow the link of shipment ID(s) [ID]','ph-shipping-royalmail'),
		'desc_tip'		   => true
	),
	
	'exclude_tax'	  => array(
		'title'		   => __( 'Exclude Tax', 'ph-shipping-royalmail' ),
		'description'	 => __( 'Taxes will be excluded from product prices while generating label', 'ph-shipping-royalmail' ),
		'desc_tip'		   => true,
		'type'			=> 'checkbox',
		'class'			=>'royalmail_general_tab',
		'default'		 => 'no'
	),
	'options' => array(
			'title' => __( 'Additional Options', 'ph-shipping-royalmail' ),
			'type' 	=> 'multiselect',
			'class' => 'chosen_select',
			'default' => '',
			'options' => array(
				'insurance'	=> __( 'Insurance', 'ph-shipping-royalmail' ),
				// 'signature'	=> __( 'Signature', 'ph-shipping-canada-post' ),
			),
			'description'	 => __( 'Additional options affect all rates.', 'ph-shipping-royalmail' ),
			'desc_tip'		=> true,
			'custom_attributes' => array(
				'data-placeholder' => __( 'Select the Special Services', 'ph-shipping-royalmail' ),
			  ),
	),
	'min_amount'  => array(
		'title'		   => __( 'Minimum Order Amount', 'ph-shipping-royalmail' ),
		'type'			=> 'text',
		'placeholder'	=> wc_format_localized_price( 0 ),
		'default'		 => '0',
		'class'			=>'royalmail_rates_tab',
		'description'	 => __( 'Users will need to spend this amount to get this shipping available.', 'ph-shipping-royalmail' ),
		'desc_tip'		   => true,
	),
);