<?php
return array(
	
	array(
		'name' 	=> 'Royal Mail Special Delivery by 1pm&reg;',
		'id' 	=> 'special_delivery_guaranteed_by_1',
		'special_services' 	=> array(
			'insured_cost'  => array(
				'price_750-1000' 	=> 1,
				'price_1000-2500' 	=> 2,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 6.85,
			'uk_0.1-0.5kg' 	=> 7.65,
			'uk_0.5-1kg' 	=> 8.95,
			'uk_1-2kg' 		=> 11.15,
			'uk_2-10kg' 	=> 15.45,
			'uk_10-20kg' 	=> 19.45,

			//Isle of Man
			'im_0-0.1kg' 	=> 6.85,
			'im_0.1-0.5kg' 	=> 7.65,
			'im_0.5-1kg' 	=> 8.95,
			'im_1-2kg' 		=> 11.15,
			'im_2-10kg' 	=> 15.45,
			'im_10-20kg' 	=> 19.45,

			//Jersey
			'je_0-0.1kg' 	=> 6.85,
			'je_0.1-0.5kg' 	=> 7.65,
			'je_0.5-1kg' 	=> 8.95,
			'je_1-2kg' 		=> 11.15,
			'je_2-10kg' 	=> 15.45,
			'je_10-20kg' 	=> 19.45,

			//Guernsey
			'gg_0-0.1kg' 	=> 6.85,
			'gg_0.1-0.5kg' 	=> 7.65,
			'gg_0.5-1kg' 	=> 8.95,
			'gg_1-2kg' 		=> 11.15,
			'gg_2-10kg' 	=> 15.45,
			'gg_10-20kg' 	=> 19.45,
		)
	),

	array(
		'name' 	=> 'Royal Mail Special Delivery by 1pm&reg; with Saturday',
		'id' 	=> 'special_delivery_guaranteed_by_1_with_saturday',
		'special_services' 	=> array(
			'insured_cost'  => array(
				'price_750-1000' 	=> 1.2,
				'price_1000-2500' 	=> 2.4,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 11.22,
			'uk_0.1-0.5kg' 	=> 12.18,
			'uk_0.5-1kg' 	=> 13.74,
			'uk_1-2kg' 		=> 16.38,
			'uk_2-10kg' 	=> 21.54,
			'uk_10-20kg' 	=> 26.34,

			//Isle of Man
			'im_0-0.1kg' 	=> 11.22,
			'im_0.1-0.5kg' 	=> 12.18,
			'im_0.5-1kg' 	=> 13.74,
			'im_1-2kg' 		=> 16.38,
			'im_2-10kg' 	=> 21.54,
			'im_10-20kg' 	=> 26.34,

			//Guernsey
			'gg_0-0.1kg' 	=> 11.22,
			'gg_0.1-0.5kg' 	=> 12.18,
			'gg_0.5-1kg' 	=> 13.74,
			'gg_1-2kg' 		=> 16.38,
			'gg_2-10kg' 	=> 21.54,
			'gg_10-20kg' 	=> 26.34,
		)
	),

	array(
		'name' => 'Royal Mail Special Delivery by 9am&reg;',
		'id' => 'special_delivery_guaranteed_by_9am',
		'special_services' => array(
			'insured_cost'  => array(
				'price_50-1000' 	=> 2.2,
				'price_1000-2500' 	=> 3.5,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg'	=> 23.95,
			'uk_0.1-0.5kg'	=> 26.95,
			'uk_0.5-1kg'	=> 29.95,
			'uk_1-2kg'		=> 35.95,

			//Isle of Man IM1 postcode Only
			'im_0-0.1kg'	=> 23.95,
			'im_0.1-0.5kg'	=> 26.95,
			'im_0.5-1kg'	=> 29.95,
			'im_1-2kg'		=> 35.95,
		)
	),

	array(
		'name' => 'Royal Mail Special Delivery by 9am&reg; with Saturday',
		'id' => 'special_delivery_guaranteed_by_9_with_saturday',
		'special_services' => array(
			'insured_cost'  => array(
				'price_50-1000' 	=> 2.2,
				'price_1000-2500' 	=> 3.5,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 26.95,
			'uk_0.1-0.5kg' 	=> 29.95,
			'uk_0.5-1kg' 	=> 32.95,
			'uk_1-2kg' 		=> 38.95,
		)
	),

	array(
		'name' => 'Royal Mail 1st Class',
		'id' => '1st_class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 //Signature rates are added seperatly
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 1.10,
			'uk_0-0.1kg_largeletter' 		=> 1.60,
			'uk_0.1-0.250kg_largeletter' 	=> 2.25,
			'uk_0.250-0.500kg_largeletter' 	=> 2.95,
			'uk_0.500-0.750kg_largeletter' 	=> 3.30,

			'uk_0-2kg_smallparcel' => 4.19,

			'uk_0-2kg_mediumparcel' 	=> 6.29,
			'uk_2-10kg_mediumparcel' 	=> 7.99,
			'uk_10-20kg_mediumparcel' 	=> 11.99,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel' => 4.19,

			'ijg_0-2kg_mediumparcel' 	=> 6.29,
			'ijg_2-10kg_mediumparcel' 	=> 7.99,
			'ijg_10-20kg_mediumparcel' 	=> 11.99,
		)
	),

	array(
		'name' => 'Royal Mail 1st Class Signed For',
		'id' => '1st_class_signed',
		'special_services' => array(
			// 'signature_cost'  => 1.1 
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 2.60,
			'uk_0-0.1kg_largeletter' 		=> 3.10,
			'uk_0.1-0.250kg_largeletter' 	=> 3.75,
			'uk_0.250-0.500kg_largeletter' 	=> 4.45,
			'uk_0.500-0.750kg_largeletter' 	=> 4.80,

			'uk_0-2kg_smallparcel' => 5.39,

			'uk_0-2kg_mediumparcel' 	=> 7.49,
			'uk_2-10kg_mediumparcel' 	=> 9.19,
			'uk_10-20kg_mediumparcel' 	=> 13.19,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel' => 5.39,

			'ijg_0-2kg_mediumparcel' 	=> 7.49,
			'ijg_2-10kg_mediumparcel' 	=> 9.19,
			'ijg_10-20kg_mediumparcel' 	=> 13.19,
		)
	),

	array(
		'name' => 'Royal Mail 2nd Class',
		'id' => '2nd_class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 //Signature rates are added seperatly
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 0.75,
			'uk_0-0.1kg_largeletter' 		=> 1.15,
			'uk_0.1-0.250kg_largeletter' 	=> 1.85,
			'uk_0.250-0.500kg_largeletter' 	=> 2.40,
			'uk_0.500-0.750kg_largeletter' 	=> 2.70,

			'uk_0-2kg_smallparcel'			=> 3.49,

			'uk_0-2kg_mediumparcel' 		=> 5.49,
			'uk_2-10kg_mediumparcel' 		=> 6.99,
			'uk_10-20kg_mediumparcel' 		=> 10.49,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel'			=> 3.49,

			'ijg_0-2kg_mediumparcel' 		=> 5.49,
			'ijg_2-10kg_mediumparcel' 		=> 6.99,
			'ijg_10-20kg_mediumparcel' 		=> 10.49,
		)
	),

	array(
		'name' => 'Royal Mail 2nd Class Signed For',
		'id' => '2nd_class_signed',
		'special_services' => array(
			// 'signature_cost'  => 1.1
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 2.25,
			'uk_0-0.1kg_largeletter' 		=> 2.65,
			'uk_0.1-0.250kg_largeletter' 	=> 3.35,
			'uk_0.250-0.500kg_largeletter' 	=> 3.90,
			'uk_0.500-0.750kg_largeletter' 	=> 4.20,

			'uk_0-2kg_smallparcel' => 4.69,

			'uk_0-2kg_mediumparcel' 	=> 6.69,
			'uk_2-10kg_mediumparcel' 	=> 8.19,
			'uk_10-20kg_mediumparcel' 	=> 11.69,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel' => 4.69,

			'ijg_0-2kg_mediumparcel' 	=> 6.69,		
			'ijg_2-10kg_mediumparcel'	=> 8.19,
			'ijg_10-20kg_mediumparcel' 	=> 11.69,
		)
	),

	// UK Online Rates

	array(
		'name'				=> 'Royal Mail Tracked 24&reg;',
		'id'				=> 'tracked24',
		'special_services'	=> array(),
		'rules' 			=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 3.30,

			'uk_0-2kg_smallparcel' 		=> 4.15,

			'uk_0-2kg_mediumparcel'		=> 5.95,
			'uk_2-10kg_mediumparcel'	=> 7.65,
			'uk_10-20kg_mediumparcel'	=> 11.65,
		)
	),

	array(
		'name'				=> 'Royal Mail Tracked 24&reg; with Signature',
		'id'				=> 'tracked24_with_signature',
		'special_services'	=> array(),
		'rules'				=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 4.80,

			'uk_0-2kg_smallparcel' 		=> 5.35,

			'uk_0-2kg_mediumparcel'		=> 7.15,
			'uk_2-10kg_mediumparcel'	=> 8.85,
			'uk_10-20kg_mediumparcel'	=> 12.85,
		)
	),

	array(
		'name'				=> 'Royal Mail Tracked 48&reg;',
		'id'				=> 'tracked48',
		'special_services'	=> array(),
		'rules' 			=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 2.70,

			'uk_0-2kg_smallparcel' 		=> 3.45,

			'uk_0-2kg_mediumparcel'		=> 5.15,
			'uk_2-10kg_mediumparcel'	=> 6.65,
			'uk_10-20kg_mediumparcel'	=> 10.15,
		)
	),

	array(
		'name'				=> 'Royal Mail Tracked 48&reg; with Signature',
		'id'				=> 'tracked48_with_signature',
		'special_services'	=> array(),
		'rules'				=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 4.20,

			'uk_0-2kg_smallparcel' 		=> 4.65,

			'uk_0-2kg_mediumparcel'		=> 6.35,
			'uk_2-10kg_mediumparcel'	=> 7.85,
			'uk_10-20kg_mediumparcel'	=> 11.35,
		)
	),

	// International services

	array(
		'name' => 'Royal Mail International Standard',
		'id' => 'international_standard',
		'special_services' => array(
		),
		'rules' => array( 
			//letter
			// 'eu1_0-0.02kg_letter'	=> 1.85,
			// 'eu1_0.02-0.1kg_letter'	=> 1.85,
			'eu1_0-0.1kg_letter'	=> 2.20,

			// 'eu2_0-0.02kg_letter'	=> 1.85,
			// 'eu2_0.02-0.1kg_letter'	=> 1.85,
			'eu2_0-0.1kg_letter'	=> 2.20,

			// 'eu3_0-0.02kg_letter'	=> 1.85,
			// 'eu3_0.02-0.1kg_letter'	=> 1.85,
			'eu3_0-0.1kg_letter'	=> 2.20,

			// 'w1_0-0.02kg_letter'	=> 1.85,
			// 'w1_0.02-0.1kg_letter'	=> 2.55,
			'w1_0-0.1kg_letter'	=> 2.20,

			// 'w2_0-0.02kg_letter'	=> 1.85,
			// 'w2_0.02-0.1kg_letter'	=> 2.55,
			'w2_0-0.1kg_letter'	=> 2.20,

			// 'w3_0-0.02kg_letter'	=> 1.85,
			// 'w3_0.02-0.1kg_letter'	=> 2.55,
			'w3_0-0.1kg_letter'	=> 2.20,

			
			//large letter
			'eu1_0-0.1kg_largeletter'		=> 3.25,
			'eu1_0.1-0.250kg_largeletter'	=> 4.95,
			'eu1_0.250-0.500kg_largeletter'	=> 5.95,
			'eu1_0.500-0.750kg_largeletter'	=> 6.95,
			
			'eu2_0-0.1kg_largeletter'		=> 3.25,
			'eu2_0.1-0.250kg_largeletter'	=> 4.95,
			'eu2_0.250-0.500kg_largeletter'	=> 5.95,
			'eu2_0.500-0.750kg_largeletter'	=> 6.95,

			'eu3_0-0.1kg_largeletter'		=> 3.25,
			'eu3_0.1-0.250kg_largeletter'	=> 4.95,
			'eu3_0.250-0.500kg_largeletter'	=> 5.95,
			'eu3_0.500-0.750kg_largeletter'	=> 6.95,

			'w1_0-0.1kg_largeletter'		=> 4.20,
			'w1_0.1-0.250kg_largeletter'	=> 6.40,
			'w1_0.250-0.500kg_largeletter'	=> 8.70,
			'w1_0.500-0.750kg_largeletter'	=> 11.35,

			'w2_0-0.1kg_largeletter' 		=> 4.20,
			'w2_0.1-0.250kg_largeletter' 	=> 7.50,
			'w2_0.250-0.500kg_largeletter' 	=> 10.55,
			'w2_0.500-0.750kg_largeletter' 	=> 14.25,

			'w3_0-0.1kg_largeletter'		=> 4.20,
			'w3_0.1-0.250kg_largeletter'	=> 6.55,
			'w3_0.250-0.500kg_largeletter'	=> 9.00,
			'w3_0.500-0.750kg_largeletter'	=> 11.80,



			//Small Parcel
			'eu1_0-0.250kg_smallparcel' 	=> 7.55,
			'eu1_0.250-0.500kg_smallparcel' => 9.45,
			'eu1_0.500-0.750kg_smallparcel' => 10.65,
			'eu1_0.750-1kg_smallparcel' 	=> 11.85,
			'eu1_1-1.25kg_smallparcel' 		=> 12.85,
			'eu1_1.25-1.5kg_smallparcel' 	=> 12.85,
			'eu1_1.5-2kg_smallparcel'		=> 14.35,

			'eu2_0-0.250kg_smallparcel' 	=> 7.70,
			'eu2_0.250-0.500kg_smallparcel' => 9.75,
			'eu2_0.500-0.750kg_smallparcel' => 11.00,
			'eu2_0.750-1kg_smallparcel' 	=> 12.15,
			'eu2_1-1.25kg_smallparcel' 		=> 13.35,
			'eu2_1.25-1.5kg_smallparcel' 	=> 13.35,
			'eu2_1.5-2kg_smallparcel'		=> 14.85,

			'eu3_0-0.250kg_smallparcel' 	=> 8.40,
			'eu3_0.250-0.500kg_smallparcel' => 10.35,
			'eu3_0.500-0.750kg_smallparcel' => 11.75,
			'eu3_0.750-1kg_smallparcel' 	=> 13.15,
			'eu3_1-1.25kg_smallparcel' 		=> 14.30,
			'eu3_1.25-1.5kg_smallparcel' 	=> 15.45,
			'eu3_1.5-2kg_smallparcel'		=> 16.45,

			'w1_0-0.1kg_smallparcel' 		=> 10.00,
			'w1_0.1-0.250kg_smallparcel' 	=> 11.35,
			'w1_0.250-0.500kg_smallparcel'	=> 15.45,
			'w1_0.500-0.750kg_smallparcel'	=> 18.20,
			'w1_0.750-1kg_smallparcel'		=> 21.00,
			'w1_1-1.25kg_smallparcel'		=> 23.40,
			'w1_1.25-1.5kg_smallparcel'		=> 25.65,
			'w1_1.5-2kg_smallparcel'		=> 26.85,

			'w2_0-0.1kg_smallparcel'		=> 11.30,
			'w2_0.1-0.250kg_smallparcel'	=> 12.25,
			'w2_0.250-0.500kg_smallparcel'	=> 17.00,
			'w2_0.500-0.750kg_smallparcel'	=> 20.10,
			'w2_0.750-1kg_smallparcel'		=> 23.35,
			'w2_1-1.25kg_smallparcel'		=> 26.35,
			'w2_1.25-1.5kg_smallparcel'		=> 29.45,
			'w2_1.5-2kg_smallparcel'		=> 31.15,

			'w3_0-0.1kg_smallparcel'		=> 11.35,
			'w3_0.1-0.250kg_smallparcel'	=> 12.95,
			'w3_0.250-0.500kg_smallparcel'	=> 18.60,
			'w3_0.500-0.750kg_smallparcel'	=> 21.35,
			'w3_0.750-1kg_smallparcel'		=> 25.00,
			'w3_1-1.25kg_smallparcel'		=> 28.45,
			'w3_1.25-1.5kg_smallparcel'		=> 31.20,
			'w3_1.5-2kg_smallparcel'		=> 32.45,
		)
	),
	
	array(
		'name' => 'Royal Mail International Tracked and Signed',
		'id' => 'international_tracked_signed',
		'special_services' => array(
		),
		'rules' => array( 
			//letter
			// 'eu1_0-0.02kg_letter'	 => 7.00,
			// 'eu1_0.02-0.1kg_letter'  => 7.00,
			'eu1_0-0.1kg_letter'	=> 7.40,

			// 'eu2_0-0.02kg_letter'	 => 7.00,
			// 'eu2_0.02-0.1kg_letter'  => 7.00,
			'eu2_0-0.1kg_letter'	=> 7.40,

			// 'eu3_0-0.02kg_letter'	 => 7.00,
			// 'eu3_0.02-0.1kg_letter'  => 7.00,
			'eu3_0-0.1kg_letter'	=> 7.40,

			// 'w1_0-0.02kg_letter' 	=> 7.00,
			// 'w1_0.02-0.1kg_letter' 	=> 7.85,
			'w1_0-0.1kg_letter'	=> 7.40,
			
			// 'w2_0-0.02kg_letter' 	=> 7.00,
			// 'w2_0.02-0.1kg_letter' 	=> 7.85,
			'w2_0-0.1kg_letter'	=> 7.40,

			// 'w3_0-0.02kg_letter' 	=> 7.00,
			// 'w3_0.02-0.1kg_letter' 	=> 7.85,
			'w3_0-0.1kg_letter'	=> 7.40,

			//large letter
			'eu1_0-0.1kg_largeletter'		=> 8.75,
			'eu1_0.1-0.250kg_largeletter'	=> 9.90,
			'eu1_0.250-0.500kg_largeletter'	=> 10.65,
			'eu1_0.500-0.750kg_largeletter'	=> 11.05,

			'eu2_0-0.1kg_largeletter' 		=> 8.75,
			'eu2_0.1-0.250kg_largeletter' 	=> 9.90,
			'eu2_0.250-0.500kg_largeletter'	=> 10.65,
			'eu2_0.500-0.750kg_largeletter' => 11.05,

			'eu3_0-0.1kg_largeletter' 		=> 8.75,
			'eu3_0.1-0.250kg_largeletter' 	=> 9.90,
			'eu3_0.250-0.500kg_largeletter' => 10.65,
			'eu3_0.500-0.750kg_largeletter' => 11.05,
			
			'w1_0-0.1kg_largeletter' 		=> 9.70,
			'w1_0.1-0.250kg_largeletter' 	=> 11.20,
			'w1_0.250-0.500kg_largeletter' 	=> 13.00,
			'w1_0.500-0.750kg_largeletter' 	=> 14.85,

			'w2_0-0.1kg_largeletter' 		=> 9.80,
			'w2_0.1-0.250kg_largeletter' 	=> 12.25,
			'w2_0.250-0.500kg_largeletter' 	=> 14.80,
			'w2_0.500-0.750kg_largeletter' 	=> 17.60,

			'w3_0-0.1kg_largeletter'		=> 9.75,
			'w3_0.1-0.250kg_largeletter'	=> 11.35,
			'w3_0.250-0.500kg_largeletter'	=> 13.30,
			'w3_0.500-0.750kg_largeletter'	=> 15.30,

			//Small Parcel
			'eu1_0-0.250kg_smallparcel'		=> 12.50,
			'eu1_0.250-0.500kg_smallparcel'	=> 13.80,
			'eu1_0.500-0.750kg_smallparcel' => 14.85,
			'eu1_0.750-1kg_smallparcel' 	=> 15.80,
			'eu1_1-1.25kg_smallparcel' 		=> 16.35,
			'eu1_1.25-1.5kg_smallparcel' 	=> 16.45,
			'eu1_1.5-2kg_smallparcel' 		=> 16.60,

			'eu2_0-0.250kg_smallparcel'		=> 12.65,
			'eu2_0.250-0.500kg_smallparcel' => 14.20,
			'eu2_0.500-0.750kg_smallparcel' => 15.20,
			'eu2_0.750-1kg_smallparcel' 	=> 16.10,
			'eu2_1-1.25kg_smallparcel' 		=> 16.40,
			'eu2_1.25-1.5kg_smallparcel' 	=> 16.65,
			'eu2_1.5-2kg_smallparcel' 		=> 17.10,

			'eu3_0-0.250kg_smallparcel'		=> 13.90,
			'eu3_0.250-0.500kg_smallparcel' => 15.45,
			'eu3_0.500-0.750kg_smallparcel' => 16.60,
			'eu3_0.750-1kg_smallparcel' 	=> 17.75,
			'eu3_1-1.25kg_smallparcel' 		=> 18.40,
			'eu3_1.25-1.5kg_smallparcel' 	=> 19.00,
			'eu3_1.5-2kg_smallparcel' 		=> 19.30,

			'w1_0-0.1kg_smallparcel' 		=> 16.10,
			'w1_0.1-0.250kg_smallparcel' 	=> 16.45,
			'w1_0.250-0.500kg_smallparcel' 	=> 20.35,
			'w1_0.500-0.750kg_smallparcel' 	=> 22.75,
			'w1_0.750-1kg_smallparcel' 		=> 25.40,
			'w1_1-1.25kg_smallparcel' 		=> 27.40,
			'w1_1.25-1.5kg_smallparcel' 	=> 28.80,
			'w1_1.5-2kg_smallparcel' 		=> 29.25,

			'w2_0-0.1kg_smallparcel' 		=> 17.25,
			'w2_0.1-0.250kg_smallparcel' 	=> 17.60,
			'w2_0.250-0.500kg_smallparcel' 	=> 22.10,
			'w2_0.500-0.750kg_smallparcel' 	=> 24.90,
			'w2_0.750-1kg_smallparcel' 		=> 28.05,
			'w2_1-1.25kg_smallparcel' 		=> 30.50,
			'w2_1.25-1.5kg_smallparcel' 	=> 33.00,
			'w2_1.5-2kg_smallparcel' 		=> 34.05,

			'w3_0-0.1kg_smallparcel' 		=> 16.75,
			'w3_0.1-0.250kg_smallparcel' 	=> 18.35,
			'w3_0.250-0.500kg_smallparcel' 	=> 23.75,
			'w3_0.500-0.750kg_smallparcel' 	=> 25.75,
			'w3_0.750-1kg_smallparcel' 		=> 29.40,
			'w3_1-1.25kg_smallparcel' 		=> 32.85,
			'w3_1.25-1.5kg_smallparcel' 	=> 35.60,
			'w3_1.5-2kg_smallparcel' 		=> 36.10,
		)
	),

	array(
		'name' => 'Royal Mail International Tracked',
		'id' => 'international_tracked',
		'special_services' => array(
			'noneu' => true, //Contains noneu rules
		),
		'rules' => array( 
			// letter
			// 'eu1_0-0.02kg_letter' 	=> 6.90,
			// 'eu1_0.02-0.1kg_letter' => 6.90,
			'eu1_0-0.1kg_letter'	=> 7.20,

			// 'eu2_0-0.02kg_letter' 	=> 6.90,
			// 'eu2_0.02-0.1kg_letter' => 6.90,
			'eu2_0-0.1kg_letter'	=> 7.20,

			// 'eu3_0-0.02kg_letter' 	=> 6.90,
			// 'eu3_0.02-0.1kg_letter' => 6.90,
			'eu3_0-0.1kg_letter'	=> 7.20,

			/*'noneu_0-0.01kg_letter' 	=> 6.75,
			'noneu_0.01-0.02kg_letter' 	=> 6.75,
			'noneu_0.02-0.1kg_letter' 	=> 6.75,*/

			// 'w1_0-0.02kg_letter' 	=> 6.90,
			// 'w1_0.02-0.1kg_letter' 	=> 7.75,
			'w1_0-0.1kg_letter'	=> 7.20,

			// 'w2_0-0.02kg_letter' 	=> 6.90,
			// 'w2_0.02-0.1kg_letter' 	=> 7.75,
			'w2_0-0.1kg_letter'	=> 7.20,

			// 'w3_0-0.02kg_letter' 	=> 6.90,
			// 'w3_0.02-0.1kg_letter' 	=> 7.75,
			'w3_0-0.1kg_letter'	=> 7.20,

			// large letter
			'eu1_0-0.1kg_largeletter' 		=> 8.65,
			'eu1_0.1-0.250kg_largeletter' 	=> 9.55,
			'eu1_0.250-0.500kg_largeletter' => 10.55,
			'eu1_0.500-0.750kg_largeletter' => 10.95,

			'eu2_0-0.1kg_largeletter' 		=> 8.65,
			'eu2_0.1-0.250kg_largeletter' 	=> 9.55,
			'eu2_0.250-0.500kg_largeletter' => 10.55,
			'eu2_0.500-0.750kg_largeletter' => 10.95,

			'eu3_0-0.1kg_largeletter' 		=> 8.65,
			'eu3_0.1-0.250kg_largeletter' 	=> 9.55,
			'eu3_0.250-0.500kg_largeletter' => 10.55,
			'eu3_0.500-0.750kg_largeletter' => 10.95,

		/*'noneu_0-0.1kg_largeletter' 		=> 8.65,
			'noneu_0.1-0.250kg_largeletter' 	=> 8.85,
			'noneu_0.250-0.500kg_largeletter'	=> 9.85,
			'noneu_0.500-0.750kg_largeletter' 	=> 10.25,*/

			'w1_0-0.1kg_largeletter' 		=> 9.60,
			'w1_0.1-0.250kg_largeletter' 	=> 11.05,
			'w1_0.250-0.500kg_largeletter' 	=> 12.90,
			'w1_0.500-0.750kg_largeletter' 	=> 14.75,

			'w2_0-0.1kg_largeletter' 		=> 9.65,
			'w2_0.1-0.250kg_largeletter' 	=> 12.15,
			'w2_0.250-0.500kg_largeletter' 	=> 14.70,
			'w2_0.500-0.750kg_largeletter' 	=> 17.50,

			'w3_0-0.1kg_largeletter' 		=> 9.65,
			'w3_0.1-0.250kg_largeletter' 	=> 11.25,
			'w3_0.250-0.500kg_largeletter' 	=> 13.20,
			'w3_0.500-0.750kg_largeletter' 	=> 15.20,

			//Small parcel and printer papers
			'eu1_0-0.250kg_smallparcel' 	=> 10.95,
			'eu1_0.250-0.500kg_smallparcel' => 12.15,
			'eu1_0.500-0.750kg_smallparcel' => 13.05,
			'eu1_0.750-1kg_smallparcel' 	=> 13.65,
			'eu1_1-1.25kg_smallparcel' 		=> 13.90,
			'eu1_1.25-1.5kg_smallparcel' 	=> 13.90,
			'eu1_1.5-2kg_smallparcel' 		=> 13.90,

			'eu2_0-0.250kg_smallparcel' 	=> 11.25,
			'eu2_0.250-0.500kg_smallparcel' => 12.45,
			'eu2_0.500-0.750kg_smallparcel' => 13.40,
			'eu2_0.750-1kg_smallparcel' 	=> 14.05,
			'eu2_1-1.25kg_smallparcel' 		=> 14.45,
			'eu2_1.25-1.5kg_smallparcel' 	=> 14.45,
			'eu2_1.5-2kg_smallparcel' 		=> 15.85,

			'eu3_0-0.250kg_smallparcel' 	=> 12.05,
			'eu3_0.250-0.500kg_smallparcel' => 13.65,
			'eu3_0.500-0.750kg_smallparcel' => 14.50,
			'eu3_0.750-1kg_smallparcel' 	=> 15.20,
			'eu3_1-1.25kg_smallparcel' 		=> 15.95,
			'eu3_1.25-1.5kg_smallparcel' 	=> 16.75,
			'eu3_1.5-2kg_smallparcel' 		=> 17.45,

			/*'noneu_0-0.1kg_smallparcel' 		=> 10.10,
			'noneu_0.1-0.250kg_smallparcel' 	=> 10.25,
			'noneu_0.250-0.500kg_smallparcel' 	=> 11.70,
			'noneu_0.500-0.750kg_smallparcel' 	=> 12.75,
			'noneu_0.750-1kg_smallparcel' 		=> 13.70,
			'noneu_1-1.25kg_smallparcel' 		=> 14.10,
			'noneu_1.25-1.5kg_smallparcel' 		=> 14.85,
			'noneu_1.5-1.75kg_smallparcel' 		=> 15.25,
			'noneu_0u_1.75-2kg_smallparcel' 		=> 15.25,*/

			// 'w1_0-0.1kg_smallparcel' 		=> 11.25,
			'w1_0-0.250kg_smallparcel' 		=> 13.85,
			'w1_0.250-0.500kg_smallparcel' 	=> 17.90,
			'w1_0.500-0.750kg_smallparcel' 	=> 20.35,
			'w1_0.750-1kg_smallparcel' 		=> 23.00,
			'w1_1-1.25kg_smallparcel' 		=> 24.95,
			'w1_1.25-1.5kg_smallparcel' 	=> 26.35,
			'w1_1.5-2kg_smallparcel' 		=> 27.45,

			// 'w2_0-0.1kg_smallparcel' 		=> 12.30,
			'w2_0-0.250kg_smallparcel' 		=> 15.20,
			'w2_0.250-0.500kg_smallparcel' 	=> 19.80,
			'w2_0.500-0.750kg_smallparcel' 	=> 22.60,
			'w2_0.750-1kg_smallparcel' 		=> 25.55,
			'w2_1-1.25kg_smallparcel' 		=> 28.35,
			'w2_1.25-1.5kg_smallparcel' 	=> 30.85,
			'w2_1.5-2kg_smallparcel' 		=> 32.55,

			// 'w2_0-0.1kg_smallparcel' 		=> 12.15,
			'w2_0-0.250kg_smallparcel' 		=> 15.65,
			'w2_0.250-0.500kg_smallparcel' 	=> 19.85,
			'w2_0.500-0.750kg_smallparcel' 	=> 22.45,
			'w2_0.750-1kg_smallparcel' 		=> 25.15,
			'w2_1-1.25kg_smallparcel' 		=> 28.95,
			'w2_1.25-1.5kg_smallparcel' 	=> 28.95,
			'w2_1.5-2kg_smallparcel' 		=> 28.95,
		)
	),

	array(
		'name' => 'Royal Mail International Signed',
		'id' => 'international_signed',
		'special_services' => array(
		),
		'rules' => array( 
			// letter
			// 'eu1_0-0.02kg_letter' 	=> 7.00,
			// 'eu1_0.02-0.1kg_letter' => 7.00,
			'eu1_0-0.1kg_letter' => 7.40,

			// 'eu2_0-0.02kg_letter' 	=> 7.00,
			// 'eu2_0.02-0.1kg_letter' => 7.00,
			'eu2_0-0.1kg_letter' => 7.40,

			// 'eu3_0-0.02kg_letter' 	=> 7.00,
			// 'eu3_0.02-0.1kg_letter' => 7.00,
			'eu3_0-0.1kg_letter' => 7.40,
			
			// 'w1_0-0.02kg_letter' 	=> 7.00,
			// 'w1_0.02-0.1kg_letter' 	=> 7.85,
			'w1_0-0.1kg_letter' => 7.40,

			// 'w2_0-0.02kg_letter' 	=> 7.00,
			// 'w2_0.02-0.1kg_letter' 	=> 7.85,
			'w2_0-0.1kg_letter' => 7.40,

			// large letter
			'eu1_0-0.1kg_largeletter' 		=> 8.75,
			'eu1_0.1-0.250kg_largeletter' 	=> 9.90,
			'eu1_0.250-0.500kg_largeletter' => 10.65,
			'eu1_0.500-0.750kg_largeletter' => 11.05,

			'eu2_0-0.1kg_largeletter' 		=> 8.75,
			'eu2_0.1-0.250kg_largeletter' 	=> 9.90,
			'eu2_0.250-0.500kg_largeletter' => 10.65,
			'eu2_0.500-0.750kg_largeletter' => 11.05,

			'eu3_0-0.1kg_largeletter' 		=> 8.75,
			'eu3_0.1-0.250kg_largeletter' 	=> 9.90,
			'eu3_0.250-0.500kg_largeletter' => 10.65,
			'eu3_0.500-0.750kg_largeletter' => 11.05,

			'w1_0-0.1kg_largeletter' 		=> 9.70,
			'w1_0.1-0.250kg_largeletter' 	=> 11.20,
			'w1_0.250-0.500kg_largeletter' 	=> 13.00,
			'w1_0.500-0.750kg_largeletter' 	=> 14.85,

			'w2_0-0.1kg_largeletter' 		=> 9.80,
			'w2_0.1-0.250kg_largeletter' 	=> 12.25,
			'w2_0.250-0.500kg_largeletter' 	=> 14.80,
			'w2_0.500-0.750kg_largeletter' 	=> 17.60,

			//Small parcel and printer papers
			'eu1_0-0.250kg_smallparcel' 	=> 12.50,
			'eu1_0.250-0.500kg_smallparcel' => 13.80,
			'eu1_0.500-0.750kg_smallparcel' => 14.85,
			'eu1_0.750-1kg_smallparcel'		=> 15.80,
			'eu1_1-1.25kg_smallparcel' 		=> 16.35,
			'eu1_1.25-1.5kg_smallparcel' 	=> 16.45,
			'eu1_1.5-2kg_smallparcel' 		=> 16.60,

			'eu2_0-0.250kg_smallparcel' 	=> 12.65,
			'eu2_0.250-0.500kg_smallparcel' => 14.20,
			'eu2_0.500-0.750kg_smallparcel' => 15.20,
			'eu2_0.750-1kg_smallparcel'		=> 16.10,
			'eu2_1-1.25kg_smallparcel' 		=> 16.40,
			'eu2_1.25-1.5kg_smallparcel' 	=> 16.65,
			'eu2_1.5-2kg_smallparcel' 		=> 17.10,

			'eu3_0-0.250kg_smallparcel' 	=> 13.90,
			'eu3_0.250-0.500kg_smallparcel' => 15.45,
			'eu3_0.500-0.750kg_smallparcel' => 16.60,
			'eu3_0.750-1kg_smallparcel'		=> 17.75,
			'eu3_1-1.25kg_smallparcel' 		=> 18.40,
			'eu3_1.25-1.5kg_smallparcel' 	=> 19.00,
			'eu3_1.5-2kg_smallparcel' 		=> 19.30,

			'w1_0-0.1kg_smallparcel' 		=> 16.10,
			'w1_0.1-0.250kg_smallparcel' 	=> 16.45,
			'w1_0.250-0.500kg_smallparcel' 	=> 20.35,
			'w1_0.500-0.750kg_smallparcel' 	=> 22.75,
			'w1_0.750-1kg_smallparcel' 		=> 25.40,
			'w1_1-1.25kg_smallparcel' 		=> 27.40,
			'w1_1.25-1.5kg_smallparcel' 	=> 28.80,
			'w1_1.5-2kg_smallparcel' 		=> 29.25,

			'w2_0-0.1kg_smallparcel' 		=> 17.25,
			'w2_0.1-0.250kg_smallparcel' 	=> 17.60,
			'w2_0.250-0.500kg_smallparcel' 	=> 22.10,
			'w2_0.500-0.750kg_smallparcel' 	=> 24.90,
			'w2_0.750-1kg_smallparcel' 		=> 28.05,
			'w2_1-1.25kg_smallparcel' 		=> 30.50,
			'w2_1.25-1.5kg_smallparcel' 	=> 33.00,
			'w2_1.5-2kg_smallparcel' 		=> 34.05,

		)
	),
	
	array(
		'name' => 'Royal Mail International Economy',
		'id' => 'international_economy',
		'special_services' => array(
		),
		'rules' => array( 
			// letter
			// '0-0.02kg_letter' 		=> 1.60,
			// '0.02-0.1kg_letter' 	=> 1.60,
			'0-0.1kg_letter' 	=> 2.00,
									
			//Large Letter
			'0-0.1kg_largeletter' 		=> 3.20,
			'0.1-0.250kg_largeletter' 	=> 5.30,
			'0.250-0.500kg_largeletter' => 6.00,
			'0.500-0.750kg_largeletter' => 7.05,

			//Small Parcels and Printed Papers
			// '0-0.1kg_smallparcel' 		=> 5.05,
			'0-0.250kg_smallparcel' 	=> 6.75,
			'0.250-0.500kg_smallparcel' => 9.40,
			'0.500-0.750kg_smallparcel' => 10.60,
			'0.750-1kg_smallparcel' 	=> 11.80,
			// '1-1.25kg_smallparcel' 		=> 11.60,
			'1-1.5kg_smallparcel' 		=> 12.80,
			'1.5-2kg_smallparcel' 		=> 14.30,
		),
	),

);