<?php
/*
	Plugin Name: PH Royal Mail WooCommerce Shipping Premium
	Plugin URI: http://pluginhive.com/product/woocommerce-royal-mail-shipping-with-tracking/
	Description: This plugin helps you display Royal Mail shipping rates in WooCommerce Cart & Checkout page, automatically classify packages into letters or parcels based on the weight and dimensions of the products and also enables shipment tracking.
	Version: 1.3.1
	Author: PluginHive
	Author URI: http://pluginhive.com/about/
	WC requires at least: 3.0.0
	WC tested up to: 7.5.1
	Text Domain: ph-shipping-royalmail

*/

if (!defined('PHive_Royal_Mail_ID')){
	define("PHive_Royal_Mail_ID", "phive_royalmail_shipping");
}

// Define PH_ROYAL_MAIL_PLUGIN_VERSION
if ( !defined( 'PH_ROYAL_MAIL_PLUGIN_VERSION' ) )
{
	define( 'PH_ROYAL_MAIL_PLUGIN_VERSION', '1.3.1' );
}

// Include API Manager
if ( !class_exists( 'PH_Royal_Mail_API_Manager' ) ) {

	include_once( 'ph-api-manager/ph_api_manager_royal_mail.php' );
}

if ( class_exists( 'PH_Royal_Mail_API_Manager' ) ) {

	$product_title 		= 'Royal Mail'; 
	$server_url 		= 'https://www.pluginhive.com/';
	$product_id 		= '';

	$ph_royal_mail_api_obj 	= new PH_Royal_Mail_API_Manager( __FILE__, $product_id, PH_ROYAL_MAIL_PLUGIN_VERSION, 'plugin', $server_url, $product_title, 'ph-shipping-royalmail' );

}

/**
 * Plugin activation check
 */
function phive_royalmail_pre_activation_check_premium(){
	//check if basic version is there
	if ( is_plugin_active('royalmail-woocommerce-shipping/royalmail-woocommerce-shipping.php') ){
        deactivate_plugins( basename( __FILE__ ) );
		wp_die( __("Oops! You tried installing the premium version without deactivating and deleting the basic version. Kindly deactivate and delete RoyalMail(Basic) Woocommerce Extension and then try again", "ph-shipping-royalmail" ), "", array('back_link' => 1 ));
	}
}

register_activation_hook( __FILE__, 'phive_royalmail_pre_activation_check_premium' );

/**
 * Common Class.
 */
if( ! class_exists('Ph_Royalmail_Woocommerce_Shipping_Common') ) {
	require_once 'royalmail-woocommerce-shipping-premium-common.php';
}

/**
 * Check if WooCommerce is active
 */
$ph_active_plugins = Ph_Royalmail_Woocommerce_Shipping_Common::get_active_plugins();

if (in_array( 'woocommerce/woocommerce.php', $ph_active_plugins )) {
	
	class phive_royalmail_wooCommerce_shipping_setup {
		
		/**
		 * @var $active_plugins
		 */
		public $active_plugins;

		/**
		 * @var $settings
		 */
		public $settings;

		public function __construct() {

			$this->active_plugins = Ph_Royalmail_Woocommerce_Shipping_Common::get_active_plugins();

			add_action(	'init', array($this,'phive_init') );
			add_action( 'woocommerce_shipping_init', array( $this, 'phive_royalmail_wooCommerce_shipping_init' ) );
			add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'plugin_action_links' ) );
			add_filter( 'woocommerce_shipping_methods', array( $this, 'phive_royalmail_wooCommerce_shipping_methods' ) );		
			add_filter( 'admin_enqueue_scripts', array( $this, 'phive_royalmail_scripts' ) );		
				
			load_plugin_textdomain( 'ph-shipping-royalmail', false, dirname( plugin_basename( __FILE__ ) ) . '/i18n/' );
			add_action( 'admin_notices', array( $this, 'ph_royal_mail_check_store_currency' ) );
		}
		public function phive_init() {
			include_once( 'includes/ph-legacy-handler.php' );
			include_once ( 'includes/class-ph-tracking-admin.php' );

			// To Support Third Party plugins
			$this->third_party_plugin_support();
		}
		
		public function third_party_plugin_support() {

			// WOOCS - WooCommerce Currency Switcher Plugin support
			if( in_array( 'woocommerce-currency-switcher/index.php', $this->active_plugins ) ) {
				require_once 'includes/third-party-plugin-support/ph-royalmail-woocs-currency-switcher.php';
			}

			// Currency Switcher for WooCommerce - WP Wham
			if( in_array( 'currency-switcher-woocommerce/currency-switcher-woocommerce.php', $this->active_plugins ) || in_array( 'currency-switcher-woocommerce-pro/currency-switcher-woocommerce-pro.php', $this->active_plugins ) ) {
				require_once 'includes/third-party-plugin-support/ph-royalmail-currency-switcher-woocommerce.php';
			}
		}
		
		public function phive_royalmail_scripts() {
			wp_enqueue_script( 'jquery-ui-sortable' );
			wp_enqueue_script( 'ph-common-script', plugins_url( '/resources/js/ph_common.js', __FILE__ ), array( 'jquery' ) );
			wp_enqueue_style( 'ph-common-style', plugins_url( '/resources/css/ph_common_style.css', __FILE__ ));
		}
		
		public function plugin_action_links( $links ) {
			$plugin_links = array(
				'<a href="' . admin_url( 'admin.php?page=' . $this->phive_get_settings_url() . '&tab=shipping&section=phive_royalmail_shipping' ) . '">' . __( 'Settings', 'ph-shipping-royalmail' ) . '</a>',
				'<a href="https://www.xadapter.com/online-support/" target="_blank">' . __('Support', 'ph-shipping-royalmail') . '</a>',
			);
			return array_merge( $plugin_links, $links );
		}			
		
		private function phive_get_settings_url(){
			return version_compare(WC()->version, '2.1', '>=') ? "wc-settings" : "woocommerce_settings";
		}

		public function phive_royalmail_wooCommerce_shipping_init() {
			include_once( 'includes/class-ph-royalmail-woocommerce-shipping.php' );
		}

		
		public function phive_royalmail_wooCommerce_shipping_methods( $methods ) {
			$methods[] = 'phive_royalmail_woocommerce_shipping_method';
			return $methods;
		}	
		
		/**
		 * Check for store currency and show error notice
		 */
		public function ph_royal_mail_check_store_currency() {
			
			// Show error notice if store currency is not GBP and conversion rate is not given
			$this->settings = get_option( 'woocommerce_'.PHive_Royal_Mail_ID.'_settings', null );
			$wc_currency 	= apply_filters('ph_change_woocommerce_currency_for_multicurrency', get_woocommerce_currency() );
			
			if( $wc_currency != "GBP" && empty( $this->settings['conversion_rate'] ) ) {

				?>
				<div class="notice notice-error">
                        <p><?php echo __('Royal Mail requires currency to be GBP to calculate shipping rates. If you have different currency, please provide the Conversion Rate under WooCommerce > Settings > Shipping > Royal Mail', 'ph-shipping-royalmail');?></p>
                    </div>
				<?php
			}
		}

	}
	new phive_royalmail_wooCommerce_shipping_setup();
}
