<?php
return array(
	
	//Parcel force services
	array(
		'name' => 'Royal Mail Parcelforce express9',
		'id' => 'parcelforce_express9',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 40.45,
			'uk_weight_5-10kg' 	=> 47.95,
			'uk_weight_10-20kg' => 55.95,
			'uk_weight_20-30kg' => 63.95,
		)
	),
	array(
		'name' => 'Royal Mail Parcelforce express10',
		'id' => 'parcelforce_express10',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 20.45,
			'uk_weight_5-10kg'  => 22.95,
			'uk_weight_10-20kg' => 25.95,
			'uk_weight_20-30kg' => 28.95,
		)
	),
	array(
		'name' => 'Royal Mail Parcelforce expressAM',
		'id' => 'parcelforce_expressAM',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 13.45,
			'uk_weight_5-10kg' 	=> 15.95,
			'uk_weight_10-20kg' => 18.95,
			'uk_weight_20-30kg' => 21.95,
		)
	),
	array(
		'name' => 'Royal Mail Parcelforce express24',
		'id' => 'parcelforce_express24',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 10.45,
			'uk_weight_5-10kg' 	=> 12.95,
			'uk_weight_10-20kg' => 15.95,
			'uk_weight_20-30kg' => 18.95,
		)
	),
	array(
		'name' => 'Royal Mail Parcelforce express48',
		'id' => 'parcelforce_express48',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 9.95,
			'uk_weight_5-10kg' 	=> 11.45,
			'uk_weight_10-20kg' => 13.45,
			'uk_weight_20-30kg' => 16.45,
		)
	),
	array(
		'name' => 'Royal Mail Parcelforce express48 large',
		'id' => 'parcelforce_express48_large',
		'special_services' => array(
		),
		'rules' => array( 
			'uk_weight_0-5kg' 	=> 34.95,
			'uk_weight_5-10kg' 	=> 41.45,
			'uk_weight_10-20kg' => 48.45,
			'uk_weight_20-30kg' => 66.45,
		)
	),

// These services available only for account users
/*
	array(
		'name' => 'Parcelforce Euro Priority Busines',
		'id' => 'ph_parcelforce:europrioritybusines',
		'special_services' => array(),
		'rules' => array( 

			// Zone 4 Channel Islands
			'zone4_0-0.5kg' 	=> 35.40,
			'zone4_0.5-1kg' 	=> 36.00,
			'zone4_1-1.5kg' 	=> 36.60,
			'zone4_1.5-2kg' 	=> 37.20,
			'zone4_2-2.5kg' 	=> 37.80,
			'zone4_2.5-3kg' 	=> 38.50,
			'zone4_3-3.5kg' 	=> 39.20,
			'zone4_3.5-4kg' 	=> 39.90,
			'zone4_4-4.5kg' 	=> 40.60,
			'zone4_4.5-5kg' 	=> 41.30,
			'zone4_5-5.5kg' 	=> 41.40,
			'zone4_5.5-6kg' 	=> 41.50,
			'zone4_6-6.5kg' 	=> 41.60,
			'zone4_6.5-7kg' 	=> 41.70,
			'zone4_7-7.5kg' 	=> 41.80,
			'zone4_7.5-8kg' 	=> 41.90,
			'zone4_8-8.5kg' 	=> 42.00,
			'zone4_8.5-9kg' 	=> 42.10,
			'zone4_9-9.5kg' 	=> 42.20,
			'zone4_9.5-10kg' 	=> 42.30,
			'zone4_10-10.5kg' 	=> 42.65,
			'zone4_10.5-11kg' 	=> 43.00,
			'zone4_11-11.5kg' 	=> 43.35,
			'zone4_11.5-12kg' 	=> 43.70,
			'zone4_12-12.5kg' 	=> 44.05,
			'zone4_12.5-13kg' 	=> 44.40,
			'zone4_13-13.5kg' 	=> 44.75,
			'zone4_13.5-14kg' 	=> 45.10,
			'zone4_14-14.5kg' 	=> 45.45,
			'zone4_14.5-15kg' 	=> 45.80,
			'zone4_additional-0.5' 	=> array('basecost'=>45.80, 'perweight'=>0.20),

			// Zone 5 Republic of Ireland
			'zone5_0-0.5kg' 	=> 36.40,
			'zone5_0.5-1kg' 	=> 37.25,
			'zone5_1-1.5kg' 	=> 38.10,
			'zone5_1.5-2kg' 	=> 38.95,
			'zone5_2-2.5kg' 	=> 39.80,
			'zone5_2.5-3kg' 	=> 41.45,
			'zone5_3-3.5kg' 	=> 43.10,
			'zone5_3.5-4kg' 	=> 44.75,
			'zone5_4-4.5kg' 	=> 46.40,
			'zone5_4.5-5kg' 	=> 48.05,
			'zone5_5-5.5kg' 	=> 49.15,
			'zone5_5.5-6kg' 	=> 50.25,
			'zone5_6-6.5kg' 	=> 51.35,
			'zone5_6.5-7kg' 	=> 52.45,
			'zone5_7-7.5kg' 	=> 53.55,
			'zone5_7.5-8kg' 	=> 54.65,
			'zone5_8-8.5kg' 	=> 55.75,
			'zone5_8.5-9kg' 	=> 56.85,
			'zone5_9-9.5kg' 	=> 57.95,
			'zone5_9.5-10kg' 	=> 59.05,
			'zone5_10-10.5kg' 	=> 59.95,
			'zone5_10.5-11kg' 	=> 60.85,
			'zone5_11-11.5kg' 	=> 61.75,
			'zone5_11.5-12kg' 	=> 62.65,
			'zone5_12-12.5kg' 	=> 63.55,
			'zone5_12.5-13kg' 	=> 64.45,
			'zone5_13-13.5kg' 	=> 65.35,
			'zone5_13.5-14kg' 	=> 66.25,
			'zone5_14-14.5kg' 	=> 67.15,
			'zone5_14.5-15kg' 	=> 68.05,
			'zone5_additional-0.5' 	=> array('basecost'=>68.05, 'perweight'=>0.60),

			// Zone 6 Belgium, Netherlands & Luxembourg
			'zone6_0-0.5kg' 	=> 32.30,
			'zone6_0.5-1kg' 	=> 34.10,
			'zone6_1-1.5kg' 	=> 35.90,
			'zone6_1.5-2kg' 	=> 37.70,
			'zone6_2-2.5kg' 	=> 39.50,
			'zone6_2.5-3kg' 	=> 41.15,
			'zone6_3-3.5kg' 	=> 42.80,
			'zone6_3.5-4kg' 	=> 44.45,
			'zone6_4-4.5kg' 	=> 46.10,
			'zone6_4.5-5kg' 	=> 47.75,
			'zone6_5-5.5kg' 	=> 48.80,
			'zone6_5.5-6kg' 	=> 49.85,
			'zone6_6-6.5kg' 	=> 50.90,
			'zone6_6.5-7kg' 	=> 51.95,
			'zone6_7-7.5kg' 	=> 53.00,
			'zone6_7.5-8kg' 	=> 54.05,
			'zone6_8-8.5kg' 	=> 55.10,
			'zone6_8.5-9kg' 	=> 56.15,
			'zone6_9-9.5kg' 	=> 57.20,
			'zone6_9.5-10kg' 	=> 58.25,
			'zone6_10-10.5kg' 	=> 59.30,
			'zone6_10.5-11kg' 	=> 60.35,
			'zone6_11-11.5kg' 	=> 61.40,
			'zone6_11.5-12kg' 	=> 62.45,
			'zone6_12-12.5kg' 	=> 63.50,
			'zone6_12.5-13kg' 	=> 64.55,
			'zone6_13-13.5kg' 	=> 65.60,
			'zone6_13.5-14kg' 	=> 66.65,
			'zone6_14-14.5kg' 	=> 67.70,
			'zone6_14.5-15kg' 	=> 68.75,
			'zone6_additional-0.5' 	=> array('basecost'=>68.75, 'perweight'=>0.60),

			// Zone 7 France, Germany& Denmark
			'zone7_0-0.5kg' 	=> 35.45,
			'zone7_0.5-1kg' 	=> 37.55,
			'zone7_1-1.5kg' 	=> 39.65,
			'zone7_1.5-2kg' 	=> 41.75,
			'zone7_2-2.5kg' 	=> 43.85,
			'zone7_2.5-3kg' 	=> 45.75,
			'zone7_3-3.5kg' 	=> 47.65,
			'zone7_3.5-4kg' 	=> 49.55,
			'zone7_4-4.5kg' 	=> 51.45,
			'zone7_4.5-5kg' 	=> 53.35,
			'zone7_5-5.5kg' 	=> 54.55,
			'zone7_5.5-6kg' 	=> 55.75,
			'zone7_6-6.5kg' 	=> 56.95,
			'zone7_6.5-7kg' 	=> 58.15,
			'zone7_7-7.5kg' 	=> 59.35,
			'zone7_7.5-8kg' 	=> 60.55,
			'zone7_8-8.5kg' 	=> 61.75,
			'zone7_8.5-9kg' 	=> 62.95,
			'zone7_9-9.5kg' 	=> 64.15,
			'zone7_9.5-10kg' 	=> 65.35,
			'zone7_10-10.5kg' 	=> 66.35,
			'zone7_10.5-11kg' 	=> 67.35,
			'zone7_11-11.5kg' 	=> 68.35,
			'zone7_11.5-12kg' 	=> 69.35,
			'zone7_12-12.5kg' 	=> 70.35,
			'zone7_12.5-13kg' 	=> 71.35,
			'zone7_13-13.5kg' 	=> 72.35,
			'zone7_13.5-14kg' 	=> 73.35,
			'zone7_14-14.5kg' 	=> 74.35,
			'zone7_14.5-15kg' 	=> 75.35,
			'zone7_additional-0.5' 	=> array('basecost'=>75.35, 'perweight'=>0.55),

			// Zone 8 Italy, Spain, Portugal & Greece
			'zone8_0-0.5kg' 	=> 38.50,
			'zone8_0.5-1kg' 	=> 40.50,
			'zone8_1-1.5kg' 	=> 42.50,
			'zone8_1.5-2kg' 	=> 44.50,
			'zone8_2-2.5kg' 	=> 46.50,
			'zone8_2.5-3kg' 	=> 48.70,
			'zone8_3-3.5kg' 	=> 50.90,
			'zone8_3.5-4kg' 	=> 53.10,
			'zone8_4-4.5kg' 	=> 55.30,
			'zone8_4.5-5kg' 	=> 57.50,
			'zone8_5-5.5kg' 	=> 58.95,
			'zone8_5.5-6kg' 	=> 60.40,
			'zone8_6-6.5kg' 	=> 61.85,
			'zone8_6.5-7kg' 	=> 63.30,	
			'zone8_7-7.5kg' 	=> 64.75,
			'zone8_7.5-8kg' 	=> 66.20,
			'zone8_8-8.5kg' 	=> 67.65,
			'zone8_8.5-9kg' 	=> 69.10,
			'zone8_9-9.5kg' 	=> 70.55,
			'zone8_9.5-10kg' 	=> 72.00,
			'zone8_10-10.5kg' 	=> 73.45,
			'zone8_10.5-11kg' 	=> 74.90,
			'zone8_11-11.5kg' 	=> 76.35,
			'zone8_11.5-12kg' 	=> 77.80,
			'zone8_12-12.5kg' 	=> 79.25,
			'zone8_12.5-13kg' 	=> 80.70,
			'zone8_13-13.5kg' 	=> 82.15,
			'zone8_13.5-14kg' 	=> 83.60,
			'zone8_14-14.5kg' 	=> 85.05,
			'zone8_14.5-15kg' 	=> 86.50,
			'zone8_additional-0.5' 	=> array('basecost'=>86.50, 'perweight'=>0.60),

			// Zone 9 Rest of Europe
			'zone9_0-0.5kg' 	=> 43.70,
			'zone9_0.5-1kg' 	=> 46.20,
			'zone9_1-1.5kg' 	=> 48.70,
			'zone9_1.5-2kg' 	=> 51.20,
			'zone9_2-2.5kg' 	=> 53.70,
			'zone9_2.5-3kg' 	=> 56.10,
			'zone9_3-3.5kg' 	=> 58.50,
			'zone9_3.5-4kg' 	=> 60.90,
			'zone9_4-4.5kg' 	=> 63.30,
			'zone9_4.5-5kg' 	=> 65.70,
			'zone9_5-5.5kg' 	=> 67.10,
			'zone9_5.5-6kg' 	=> 68.50,
			'zone9_6-6.5kg' 	=> 69.90,
			'zone9_6.5-7kg' 	=> 71.30,
			'zone9_7-7.5kg' 	=> 72.70,
			'zone9_7.5-8kg' 	=> 74.10,
			'zone9_8-8.5kg' 	=> 75.50,
			'zone9_8.5-9kg' 	=> 76.90,
			'zone9_9-9.5kg' 	=> 78.30,
			'zone9_9.5-10kg' 	=> 79.70,
			'zone9_10-10.5kg' 	=> 80.95,
			'zone9_10.5-11kg' 	=> 82.20,
			'zone9_11-11.5kg' 	=> 83.45,
			'zone9_11.5-12kg' 	=> 84.70,
			'zone9_12-12.5kg' 	=> 85.95,
			'zone9_12.5-13kg' 	=> 87.20,
			'zone9_13-13.5kg' 	=> 88.45,
			'zone9_13.5-14kg' 	=> 89.70,
			'zone9_14-14.5kg' 	=> 90.95,
			'zone9_14.5-15kg' 	=> 92.20,
			'zone9_additional-0.5' 	=> array('basecost'=>92.20, 'perweight'=>0.80),
		)
	),

	array(
		'name' => 'Parcelforce Euro Priority Home',
		'id' => 'ph_parcelforce:europriorityhome',
		'special_services' => array(),
		'rules' => array( 

			// Zone 4 Channel Islands
			'zone4_0-0.5kg' 	=> 38.50,
			'zone4_0.5-1kg' 	=> 39.55,
			'zone4_1-1.5kg' 	=> 40.60,
			'zone4_1.5-2kg' 	=> 41.65,
			'zone4_2-2.5kg' 	=> 42.70,
			'zone4_2.5-3kg' 	=> 43.20,
			'zone4_3-3.5kg' 	=> 43.70,
			'zone4_3.5-4kg' 	=> 44.20,
			'zone4_4-4.5kg' 	=> 44.70,
			'zone4_4.5-5kg' 	=> 45.20,
			'zone4_5-5.5kg' 	=> 45.50,
			'zone4_5.5-6kg' 	=> 45.80,
			'zone4_6-6.5kg' 	=> 46.10,
			'zone4_6.5-7kg' 	=> 46.40,
			'zone4_7-7.5kg' 	=> 46.70,
			'zone4_7.5-8kg' 	=> 47.00,
			'zone4_8-8.5kg' 	=> 47.30,
			'zone4_8.5-9kg' 	=> 47.60,
			'zone4_9-9.5kg' 	=> 47.90,
			'zone4_9.5-10kg' 	=> 48.20,
			'zone4_10-10.5kg' 	=> 48.30,
			'zone4_10.5-11kg' 	=> 48.40,
			'zone4_11-11.5kg' 	=> 48.50,
			'zone4_11.5-12kg' 	=> 48.60,
			'zone4_12-12.5kg' 	=> 48.70,
			'zone4_12.5-13kg' 	=> 48.80,
			'zone4_13-13.5kg' 	=> 48.90,
			'zone4_13.5-14kg' 	=> 49.00,
			'zone4_14-14.5kg' 	=> 49.10,
			'zone4_14.5-15kg' 	=> 49.20,
			'zone4_additional-0.5' 	=> array('basecost'=>49.20, 'perweight'=>0.30),

			// Zone 5 Republic of Ireland
			'zone5_0-0.5kg' 	=> 39.50,
			'zone5_0.5-1kg' 	=> 40.90,
			'zone5_1-1.5kg' 	=> 42.30,
			'zone5_1.5-2kg' 	=> 43.70,
			'zone5_2-2.5kg' 	=> 45.10,
			'zone5_2.5-3kg' 	=> 46.65,
			'zone5_3-3.5kg' 	=> 48.20,
			'zone5_3.5-4kg' 	=> 49.75,
			'zone5_4-4.5kg' 	=> 51.30,
			'zone5_4.5-5kg' 	=> 52.85,
			'zone5_5-5.5kg' 	=> 54.10,
			'zone5_5.5-6kg' 	=> 55.35,
			'zone5_6-6.5kg' 	=> 56.60,
			'zone5_6.5-7kg' 	=> 57.85,
			'zone5_7-7.5kg' 	=> 59.10,
			'zone5_7.5-8kg' 	=> 60.35,
			'zone5_8-8.5kg' 	=> 61.60,
			'zone5_8.5-9kg' 	=> 62.85,
			'zone5_9-9.5kg' 	=> 64.10,
			'zone5_9.5-10kg' 	=> 65.35,
			'zone5_10-10.5kg' 	=> 66.25,
			'zone5_10.5-11kg' 	=> 67.15,
			'zone5_11-11.5kg' 	=> 68.05,
			'zone5_11.5-12kg' 	=> 68.95,
			'zone5_12-12.5kg' 	=> 69.85,
			'zone5_12.5-13kg' 	=> 70.75,
			'zone5_13-13.5kg' 	=> 71.65,
			'zone5_13.5-14kg' 	=> 72.55,
			'zone5_14-14.5kg' 	=> 73.45,
			'zone5_14.5-15kg' 	=> 74.35,
			'zone5_additional-0.5' 	=> array('basecost'=>74.35, 'perweight'=>0.80),

			// Zone 6 Belgium, Netherlands & Luxembourg
			'zone6_0-0.5kg' 	=> 36.40,
			'zone6_0.5-1kg' 	=> 38.10,
			'zone6_1-1.5kg' 	=> 39.80,
			'zone6_1.5-2kg' 	=> 41.50,
			'zone6_2-2.5kg' 	=> 43.20,
			'zone6_2.5-3kg' 	=> 45.15,
			'zone6_3-3.5kg' 	=> 47.10,
			'zone6_3.5-4kg' 	=> 49.05,
			'zone6_4-4.5kg' 	=> 51.00,
			'zone6_4.5-5kg' 	=> 52.95,
			'zone6_5-5.5kg' 	=> 54.10,
			'zone6_5.5-6kg' 	=> 55.25,
			'zone6_6-6.5kg' 	=> 56.40,
			'zone6_6.5-7kg' 	=> 57.55,
			'zone6_7-7.5kg' 	=> 58.70,
			'zone6_7.5-8kg' 	=> 59.85,
			'zone6_8-8.5kg' 	=> 61.00,
			'zone6_8.5-9kg' 	=> 62.15,
			'zone6_9-9.5kg' 	=> 63.30,
			'zone6_9.5-10kg' 	=> 64.45,
			'zone6_10-10.5kg' 	=> 65.55,
			'zone6_10.5-11kg' 	=> 66.65,
			'zone6_11-11.5kg' 	=> 67.75,
			'zone6_11.5-12kg' 	=> 68.85,
			'zone6_12-12.5kg' 	=> 69.95,
			'zone6_12.5-13kg' 	=> 71.05,
			'zone6_13-13.5kg' 	=> 72.15,
			'zone6_13.5-14kg' 	=> 73.25,
			'zone6_14-14.5kg' 	=> 74.35,
			'zone6_14.5-15kg' 	=> 75.45,
			'zone6_additional-0.5' 	=> array('basecost'=>75.45, 'perweight'=>0.70),

			// Zone 7 France, Germany& Denmark
			'zone7_0-0.5kg' 	=> 38.50,
			'zone7_0.5-1kg' 	=> 41.00,
			'zone7_1-1.5kg' 	=> 43.50,
			'zone7_1.5-2kg' 	=> 46.00,
			'zone7_2-2.5kg' 	=> 48.50,
			'zone7_2.5-3kg' 	=> 50.60,
			'zone7_3-3.5kg' 	=> 52.70,
			'zone7_3.5-4kg' 	=> 54.80,
			'zone7_4-4.5kg' 	=> 56.90,
			'zone7_4.5-5kg' 	=> 59.00,
			'zone7_5-5.5kg' 	=> 60.40,
			'zone7_5.5-6kg' 	=> 61.80,
			'zone7_6-6.5kg' 	=> 63.20,
			'zone7_6.5-7kg' 	=> 64.60,
			'zone7_7-7.5kg' 	=> 66.00,
			'zone7_7.5-8kg' 	=> 67.40,
			'zone7_8-8.5kg' 	=> 68.80,
			'zone7_8.5-9kg' 	=> 70.20,
			'zone7_9-9.5kg' 	=> 71.60,
			'zone7_9.5-10kg' 	=> 73.00,
			'zone7_10-10.5kg' 	=> 74.20,
			'zone7_10.5-11kg' 	=> 75.40,
			'zone7_11-11.5kg' 	=> 76.60,
			'zone7_11.5-12kg' 	=> 77.80,
			'zone7_12-12.5kg' 	=> 79.00,
			'zone7_12.5-13kg' 	=> 80.20,
			'zone7_13-13.5kg' 	=> 81.40,
			'zone7_13.5-14kg' 	=> 82.60,
			'zone7_14-14.5kg' 	=> 83.80,
			'zone7_14.5-15kg' 	=> 85.00,
			'zone7_additional-0.5' 	=> array('basecost'=>85.00, 'perweight'=>0.60),

			// Zone 8 Italy, Spain, Portugal & Greece
			'zone8_0-0.5kg' 	=> 42.65,
			'zone8_0.5-1kg' 	=> 44.85,
			'zone8_1-1.5kg' 	=> 47.05,
			'zone8_1.5-2kg' 	=> 49.25,
			'zone8_2-2.5kg' 	=> 51.45,
			'zone8_2.5-3kg' 	=> 53.95,
			'zone8_3-3.5kg' 	=> 56.45,
			'zone8_3.5-4kg' 	=> 58.95,
			'zone8_4-4.5kg' 	=> 61.45,
			'zone8_4.5-5kg' 	=> 63.95,
			'zone8_5-5.5kg' 	=> 65.50,
			'zone8_5.5-6kg' 	=> 67.05,
			'zone8_6-6.5kg' 	=> 68.60,
			'zone8_6.5-7kg' 	=> 70.15,
			'zone8_7-7.5kg' 	=> 71.70,
			'zone8_7.5-8kg' 	=> 73.25,
			'zone8_8-8.5kg' 	=> 74.80,
			'zone8_8.5-9kg' 	=> 76.35,
			'zone8_9-9.5kg' 	=> 77.90,
			'zone8_9.5-10kg' 	=> 79.45,
			'zone8_10-10.5kg' 	=> 81.05,
			'zone8_10.5-11kg' 	=> 82.65,
			'zone8_11-11.5kg' 	=> 84.25,
			'zone8_11.5-12kg' 	=> 85.85,
			'zone8_12-12.5kg' 	=> 87.45,
			'zone8_12.5-13kg' 	=> 89.05,
			'zone8_13-13.5kg' 	=> 90.65,
			'zone8_13.5-14kg' 	=> 92.25,
			'zone8_14-14.5kg' 	=> 93.85,
			'zone8_14.5-15kg' 	=> 95.45,
			'zone8_additional-0.5' 	=> array('basecost'=>95.45, 'perweight'=>0.70),

			// Zone 9 Rest of Europe
			'zone9_0-0.5kg' 	=> 47.85,
			'zone9_0.5-1kg' 	=> 50.75,
			'zone9_1-1.5kg' 	=> 53.65,
			'zone9_1.5-2kg' 	=> 56.55,
			'zone9_2-2.5kg' 	=> 59.45,
			'zone9_2.5-3kg' 	=> 62.05,
			'zone9_3-3.5kg' 	=> 64.65,
			'zone9_3.5-4kg' 	=> 67.25,
			'zone9_4-4.5kg' 	=> 69.85,
			'zone9_4.5-5kg' 	=> 72.45,
			'zone9_5-5.5kg' 	=> 74.05,
			'zone9_5.5-6kg' 	=> 75.65,
			'zone9_6-6.5kg' 	=> 77.25,
			'zone9_6.5-7kg' 	=> 78.85,
			'zone9_7-7.5kg' 	=> 80.45,
			'zone9_7.5-8kg' 	=> 82.05,
			'zone9_8-8.5kg' 	=> 83.65,
			'zone9_8.5-9kg' 	=> 85.25,
			'zone9_9-9.5kg' 	=> 86.85,
			'zone9_9.5-10kg' 	=> 88.45,
			'zone9_10-10.5kg' 	=> 89.70,
			'zone9_10.5-11kg' 	=> 90.95,
			'zone9_11-11.5kg' 	=> 92.20,
			'zone9_11.5-12kg' 	=> 93.45,
			'zone9_12-12.5kg' 	=> 94.70,
			'zone9_12.5-13kg' 	=> 95.95,
			'zone9_13-13.5kg' 	=> 97.20,
			'zone9_13.5-14kg' 	=> 98.45,
			'zone9_14-14.5kg' 	=> 99.70,
			'zone9_14.5-15kg' 	=> 100.95,
			'zone9_additional-0.5' 	=> array('basecost'=>100.95, 'perweight'=>0.90),
		)
	),
	*/

	array(
		'name' => 'Parcelforce Global Express',
		'id' => 'ph_parcelforce:globalexpress',
		'special_services' => array(),
		'rules' => array( 
			
			// Zone 4 Channel Islands
			'zone4_0-0.5kg' 	=> 52.65,
			'zone4_0.5-1kg' 	=> 55.30,
			'zone4_1-1.5kg' 	=> 57.95,
			'zone4_1.5-2kg' 	=> 60.60,
			'zone4_2-2.5kg' 	=> 63.25,
			'zone4_2.5-3kg' 	=> 65.90,
			'zone4_3-3.5kg' 	=> 68.55,
			'zone4_3.5-4kg' 	=> 71.20,
			'zone4_4-4.5kg' 	=> 73.85,
			'zone4_4.5-5kg' 	=> 76.50,
			'zone4_5-5.5kg' 	=> 79.40,
			'zone4_5.5-6kg' 	=> 82.30,
			'zone4_6-6.5kg' 	=> 85.20,
			'zone4_6.5-7kg' 	=> 88.10,
			'zone4_7-7.5kg' 	=> 91.00,
			'zone4_7.5-8kg' 	=> 93.90,
			'zone4_8-8.5kg' 	=> 96.80,
			'zone4_8.5-9kg' 	=> 99.70,
			'zone4_9-9.5kg' 	=> 102.60,
			'zone4_9.5-10kg' 	=> 105.50,
			'zone4_10-10.5kg' 	=> 107.75,
			'zone4_10.5-11kg' 	=> 110.00,
			'zone4_11-11.5kg' 	=> 112.25,
			'zone4_11.5-12kg' 	=> 114.50,
			'zone4_12-12.5kg' 	=> 116.75,
			'zone4_12.5-13kg' 	=> 119.00,
			'zone4_13-13.5kg' 	=> 121.25,
			'zone4_13.5-14kg' 	=> 123.50,
			'zone4_14-14.5kg' 	=> 125.75,
			'zone4_14.5-15kg' 	=> 128.00,
			'zone4_additional-0.5' 	=> array('basecost'=>128.00, 'perweight'=>2.45),

			// Zone 5 Republic of Ireland
			'zone5_0-0.5kg' 	=> 45.94,
			'zone5_0.5-1kg' 	=> 48.46,
			'zone5_1-1.5kg' 	=> 50.98,
			'zone5_1.5-2kg' 	=> 53.50,
			'zone5_2-2.5kg' 	=> 57.22,
			'zone5_2.5-3kg' 	=> 60.94,
			'zone5_3-3.5kg' 	=> 64.66,
			'zone5_3.5-4kg' 	=> 68.38,
			'zone5_4-4.5kg' 	=> 72.10,
			'zone5_4.5-5kg' 	=> 75.82,
			'zone5_5-5.5kg' 	=> 77.56,
			'zone5_5.5-6kg' 	=> 79.30,
			'zone5_6-6.5kg' 	=> 81.04,
			'zone5_6.5-7kg' 	=> 82.78,
			'zone5_7-7.5kg' 	=> 84.52,
			'zone5_7.5-8kg' 	=> 86.26,
			'zone5_8-8.5kg' 	=> 88.00,
			'zone5_8.5-9kg' 	=> 89.74,
			'zone5_9-9.5kg' 	=> 91.48,
			'zone5_9.5-10kg' 	=> 93.22,
			'zone5_10-10.5kg' 	=> 95.56,
			'zone5_10.5-11kg' 	=> 97.90,
			'zone5_11-11.5kg' 	=> 100.24,
			'zone5_11.5-12kg' 	=> 102.58,
			'zone5_12-12.5kg' 	=> 104.92,
			'zone5_12.5-13kg' 	=> 107.26,
			'zone5_13-13.5kg' 	=> 109.60,
			'zone5_13.5-14kg' 	=> 111.94,
			'zone5_14-14.5kg' 	=> 114.28,
			'zone5_14.5-15kg' 	=> 116.62,
			'zone5_additional-0.5' 	=> array('basecost'=>116.62, 'perweight'=>1.74),

			// Zone 6 Belgium, Netherlands & Luxembourg
			'zone6_0-0.5kg' 	=> 41.50,
			'zone6_0.5-1kg' 	=> 45.58,
			'zone6_1-1.5kg' 	=> 49.66,
			'zone6_1.5-2kg' 	=> 53.74,
			'zone6_2-2.5kg' 	=> 57.10,
			'zone6_2.5-3kg' 	=> 60.46,
			'zone6_3-3.5kg' 	=> 63.82,
			'zone6_3.5-4kg' 	=> 67.18,
			'zone6_4-4.5kg' 	=> 70.54,
			'zone6_4.5-5kg' 	=> 73.90,
			'zone6_5-5.5kg' 	=> 76.00,
			'zone6_5.5-6kg' 	=> 78.10,
			'zone6_6-6.5kg' 	=> 80.20,
			'zone6_6.5-7kg' 	=> 82.30,
			'zone6_7-7.5kg' 	=> 84.40,
			'zone6_7.5-8kg' 	=> 86.50,
			'zone6_8-8.5kg' 	=> 88.60,
			'zone6_8.5-9kg' 	=> 90.70,
			'zone6_9-9.5kg' 	=> 92.80,
			'zone6_9.5-10kg' 	=> 94.90,
			'zone6_10-10.5kg' 	=> 96.82,
			'zone6_10.5-11kg' 	=> 98.74,
			'zone6_11-11.5kg' 	=> 100.66,
			'zone6_11.5-12kg' 	=> 102.58,
			'zone6_12-12.5kg' 	=> 104.50,
			'zone6_12.5-13kg' 	=> 106.42,
			'zone6_13-13.5kg' 	=> 108.34,
			'zone6_13.5-14kg' 	=> 110.26,
			'zone6_14-14.5kg' 	=> 112.18,
			'zone6_14.5-15kg' 	=> 114.10,
			'zone6_additional-0.5' 	=> array('basecost'=>114.10, 'perweight'=>1.74),

			// Zone 7 France, Germany& Denmark
			'zone7_0-0.5kg' 	=> 42.76,
			'zone7_0.5-1kg' 	=> 46.36,
			'zone7_1-1.5kg' 	=> 49.96,
			'zone7_1.5-2kg' 	=> 53.56,
			'zone7_2-2.5kg' 	=> 57.76,
			'zone7_2.5-3kg' 	=> 61.96,
			'zone7_3-3.5kg' 	=> 66.16,
			'zone7_3.5-4kg' 	=> 70.36,
			'zone7_4-4.5kg' 	=> 74.56,
			'zone7_4.5-5kg' 	=> 78.76,
			'zone7_5-5.5kg' 	=> 81.94,
			'zone7_5.5-6kg' 	=> 85.12,
			'zone7_6-6.5kg' 	=> 88.30,
			'zone7_6.5-7kg' 	=> 91.48,
			'zone7_7-7.5kg' 	=> 94.66,
			'zone7_7.5-8kg' 	=> 97.84,
			'zone7_8-8.5kg' 	=> 101.02,
			'zone7_8.5-9kg' 	=> 104.20,
			'zone7_9-9.5kg' 	=> 107.38,
			'zone7_9.5-10kg' 	=> 110.56,
			'zone7_10-10.5kg' 	=> 113.02,
			'zone7_10.5-11kg' 	=> 115.48,
			'zone7_11-11.5kg' 	=> 117.94,
			'zone7_11.5-12kg' 	=> 120.40,
			'zone7_12-12.5kg' 	=> 122.86,
			'zone7_12.5-13kg' 	=> 125.32,
			'zone7_13-13.5kg' 	=> 127.78,
			'zone7_13.5-14kg' 	=> 130.24,
			'zone7_14-14.5kg' 	=> 132.70,
			'zone7_14.5-15kg' 	=> 135.16,
			'zone7_additional-0.5' 	=> array('basecost'=>135.16, 'perweight'=>2.04),

			// Zone 8 Italy, Spain, Portugal & Greece
			'zone8_0-0.5kg' 	=> 46.06,
			'zone8_0.5-1kg' 	=> 49.90,
			'zone8_1-1.5kg' 	=> 53.74,
			'zone8_1.5-2kg' 	=> 57.58,
			'zone8_2-2.5kg' 	=> 60.70,
			'zone8_2.5-3kg' 	=> 63.82,
			'zone8_3-3.5kg' 	=> 66.94,
			'zone8_3.5-4kg' 	=> 70.06,
			'zone8_4-4.5kg' 	=> 73.18,
			'zone8_4.5-5kg' 	=> 76.30,
			'zone8_5-5.5kg' 	=> 79.42,
			'zone8_5.5-6kg' 	=> 82.54,
			'zone8_6-6.5kg' 	=> 85.66,
			'zone8_6.5-7kg' 	=> 88.78,
			'zone8_7-7.5kg' 	=> 91.90,
			'zone8_7.5-8kg' 	=> 95.02,
			'zone8_8-8.5kg' 	=> 98.14,
			'zone8_8.5-9kg' 	=> 101.26,
			'zone8_9-9.5kg' 	=> 104.38,
			'zone8_9.5-10kg' 	=> 107.50,
			'zone8_10-10.5kg' 	=> 110.56,
			'zone8_10.5-11kg' 	=> 113.62,
			'zone8_11-11.5kg' 	=> 116.68,
			'zone8_11.5-12kg' 	=> 119.74,
			'zone8_12-12.5kg' 	=> 122.80,
			'zone8_12.5-13kg' 	=> 125.86,
			'zone8_13-13.5kg' 	=> 128.92,
			'zone8_13.5-14kg' 	=> 131.98,
			'zone8_14-14.5kg' 	=> 135.04,
			'zone8_14.5-15kg' 	=> 138.10,
			'zone8_additional-0.5' 	=> array('basecost'=>138.10, 'perweight'=>2.76),

			// Zone 9 Rest of Europe
			'zone9_0-0.5kg' 	=> 50.50,
			'zone9_0.5-1kg' 	=> 55.18,
			'zone9_1-1.5kg' 	=> 59.86,
			'zone9_1.5-2kg' 	=> 64.54,
			'zone9_2-2.5kg' 	=> 72.04,
			'zone9_2.5-3kg' 	=> 79.54,
			'zone9_3-3.5kg' 	=> 87.04,
			'zone9_3.5-4kg' 	=> 94.54,
			'zone9_4-4.5kg' 	=> 102.04,
			'zone9_4.5-5kg' 	=> 109.54,
			'zone9_5-5.5kg' 	=> 114.58,
			'zone9_5.5-6kg' 	=> 119.62,
			'zone9_6-6.5kg' 	=> 124.66,
			'zone9_6.5-7kg' 	=> 129.70,
			'zone9_7-7.5kg' 	=> 134.74,
			'zone9_7.5-8kg' 	=> 139.78,
			'zone9_8-8.5kg' 	=> 144.82,
			'zone9_8.5-9kg' 	=> 149.86,
			'zone9_9-9.5kg' 	=> 154.90,
			'zone9_9.5-10kg' 	=> 159.94,
			'zone9_10-10.5kg' 	=> 163.30,
			'zone9_10.5-11kg' 	=> 166.66,
			'zone9_11-11.5kg' 	=> 170.02,
			'zone9_11.5-12kg' 	=> 173.38,
			'zone9_12-12.5kg' 	=> 176.74,
			'zone9_12.5-13kg' 	=> 180.10,
			'zone9_13-13.5kg' 	=> 183.46,
			'zone9_13.5-14kg' 	=> 186.82,
			'zone9_14-14.5kg' 	=> 190.18,
			'zone9_14.5-15kg' 	=> 193.54,
			'zone9_additional-0.5' 	=> array('basecost'=>193.54, 'perweight'=>3.72),

			// Zone 10 USA & Canada
			'zone10_0-0.5kg' 		=> 52.65,
			'zone10_0.5-1kg' 		=> 57.85,
			'zone10_1-1.5kg' 		=> 63.05,
			'zone10_1.5-2kg' 		=> 68.25,
			'zone10_2-2.5kg' 		=> 72.40,
			'zone10_2.5-3kg' 		=> 76.55,
			'zone10_3-3.5kg' 		=> 80.70,
			'zone10_3.5-4kg' 		=> 84.85,
			'zone10_4-4.5kg' 		=> 89.00,
			'zone10_4.5-5kg' 		=> 93.15,
			'zone10_5-5.5kg' 		=> 97.55,
			'zone10_5.5-6kg' 		=> 101.95,
			'zone10_6-6.5kg' 		=> 106.35,
			'zone10_6.5-7kg' 		=> 110.75,
			'zone10_7-7.5kg' 		=> 115.15,
			'zone10_7.5-8kg' 		=> 119.55,
			'zone10_8-8.5kg' 		=> 123.95,
			'zone10_8.5-9kg' 		=> 128.35,
			'zone10_9-9.5kg' 		=> 132.75,
			'zone10_9.5-10kg' 		=> 137.15,
			'zone10_10-10.5kg' 		=> 140.55,
			'zone10_10.5-11kg' 		=> 143.95,
			'zone10_11-11.5kg' 		=> 147.35,
			'zone10_11.5-12kg' 		=> 150.75,
			'zone10_12-12.5kg' 		=> 154.15,
			'zone10_12.5-13kg' 		=> 157.55,
			'zone10_13-13.5kg' 		=> 160.95,
			'zone10_13.5-14kg' 		=> 164.35,
			'zone10_14-14.5kg' 		=> 167.75,
			'zone10_14.5-15kg' 		=> 171.15,
			'zone10_additional-0.5' 	=> array('basecost'=>171.15, 'perweight'=>3.35),

			// Zone 11 Far East & Australasia 
			'zone11_0-0.5kg' 		=> 64.25,
			'zone11_0.5-1kg' 		=> 71.10,
			'zone11_1-1.5kg' 		=> 77.95,
			'zone11_1.5-2kg' 		=> 84.80,
			'zone11_2-2.5kg' 		=> 90.80,
			'zone11_2.5-3kg' 		=> 96.80,
			'zone11_3-3.5kg' 		=> 102.80,
			'zone11_3.5-4kg' 		=> 108.80,
			'zone11_4-4.5kg' 		=> 114.80,
			'zone11_4.5-5kg' 		=> 120.80,
			'zone11_5-5.5kg' 		=> 125.70,
			'zone11_5.5-6kg' 		=> 130.60,
			'zone11_6-6.5kg' 		=> 135.50,
			'zone11_6.5-7kg' 		=> 140.40,
			'zone11_7-7.5kg' 		=> 145.30,
			'zone11_7.5-8kg' 		=> 150.20,
			'zone11_8-8.5kg' 		=> 155.10,
			'zone11_8.5-9kg' 		=> 160.00,
			'zone11_9-9.5kg' 		=> 164.90,
			'zone11_9.5-10kg' 		=> 169.80,
			'zone11_10-10.5kg' 		=> 175.15,
			'zone11_10.5-11kg' 		=> 180.50,
			'zone11_11-11.5kg' 		=> 185.85,
			'zone11_11.5-12kg' 		=> 191.20,
			'zone11_12-12.5kg' 		=> 196.55,
			'zone11_12.5-13kg' 		=> 201.90,
			'zone11_13-13.5kg' 		=> 207.25,
			'zone11_13.5-14kg' 		=> 212.60,
			'zone11_14-14.5kg' 		=> 217.95,
			'zone11_14.5-15kg' 		=> 223.30,
			'zone11_additional-0.5' 	=> array('basecost'=>223.30, 'perweight'=>5.25),

			// Zone 12 Rest of the World
			'zone12_0-0.5kg' 		=> 73.65,
			'zone12_0.5-1kg' 		=> 82.75,
			'zone12_1-1.5kg' 		=> 91.85,
			'zone12_1.5-2kg' 		=> 100.95,
			'zone12_2-2.5kg' 		=> 109.35,
			'zone12_2.5-3kg' 		=> 117.75,
			'zone12_3-3.5kg' 		=> 126.15,
			'zone12_3.5-4kg' 		=> 134.55,
			'zone12_4-4.5kg' 		=> 142.95,
			'zone12_4.5-5kg' 		=> 151.35,
			'zone12_5-5.5kg' 		=> 157.95,
			'zone12_5.5-6kg' 		=> 164.55,
			'zone12_6-6.5kg' 		=> 171.15,
			'zone12_6.5-7kg' 		=> 177.75,
			'zone12_7-7.5kg' 		=> 184.35,
			'zone12_7.5-8kg' 		=> 190.95,
			'zone12_8-8.5kg' 		=> 197.55,
			'zone12_8.5-9kg' 		=> 204.15,
			'zone12_9-9.5kg' 		=> 210.75,
			'zone12_9.5-10kg' 		=> 217.35,
			'zone12_10-10.5kg' 		=> 224.20,
			'zone12_10.5-11kg' 		=> 231.05,
			'zone12_11-11.5kg' 		=> 237.90,
			'zone12_11.5-12kg' 		=> 244.75,
			'zone12_12-12.5kg' 		=> 251.60,
			'zone12_12.5-13kg' 		=> 258.45,
			'zone12_13-13.5kg' 		=> 265.30,
			'zone12_13.5-14kg' 		=> 272.15,
			'zone12_14-14.5kg' 		=> 279.00,
			'zone12_14.5-15kg' 		=> 285.85,
			'zone12_additional-0.5' => array('basecost'=>285.85, 'perweight'=>7.05),
		)
	),
	

	array(
		'name' => 'Parcelforce Ireland Express',
		'id' => 'ph_parcelforce:irelandexpress',
		'special_services' => array(),
		'rules' => array( 
			
			// Zone 5 Republic of Ireland
			'zone5_0-0.5kg' 	=> 16.68,
			'zone5_0.5-1kg' 	=> 16.68,
			'zone5_1-1.5kg' 	=> 16.68,
			'zone5_1.5-2kg' 	=> 16.68,
			'zone5_2-2.5kg' 	=> 17.70,
			'zone5_2.5-3kg' 	=> 17.70,
			'zone5_3-3.5kg' 	=> 17.70,
			'zone5_3.5-4kg' 	=> 17.70,
			'zone5_4-4.5kg' 	=> 17.70,
			'zone5_4.5-5kg' 	=> 17.70,
			'zone5_5-5.5kg' 	=> 17.70,
			'zone5_5.5-6kg' 	=> 21.12,
			'zone5_6-6.5kg' 	=> 21.12,
			'zone5_6.5-7kg' 	=> 21.12,
			'zone5_7-7.5kg' 	=> 21.12,
			'zone5_7.5-8kg' 	=> 21.12,
			'zone5_8-8.5kg' 	=> 21.12,
			'zone5_8.5-9kg' 	=> 21.12,
			'zone5_9-9.5kg' 	=> 21.12,
			'zone5_9.5-10kg' 	=> 21.12,
			'zone5_10-10.5kg' 	=> 27.96,
			'zone5_10.5-11kg' 	=> 27.96,
			'zone5_11-11.5kg' 	=> 27.96,
			'zone5_11.5-12kg' 	=> 27.96,
			'zone5_12-12.5kg' 	=> 27.96,
			'zone5_12.5-13kg' 	=> 27.96,
			'zone5_13-13.5kg' 	=> 27.96,
			'zone5_13.5-14kg' 	=> 27.96,
			'zone5_14-14.5kg' 	=> 27.96,
			'zone5_14.5-15kg' 	=> 27.96,
			'zone5_additional-0.5' 	=> array('basecost'=>27.96, 'perweight'=>5.4),
		)
	),
	
	

	array(
		'name' => 'Parcelforce Global Priority',
		'id' => 'ph_parcelforce:globalpriority',
		'special_services' => array(),
		'rules' => array( 
			
			// Zone 9 Rest of Europe
			'zone9_0-0.5kg' 	=> 35.90,
			'zone9_0.5-1kg' 	=> 38.80,
			'zone9_1-1.5kg' 	=> 40.15,
			'zone9_1.5-2kg' 	=> 41.50,
			'zone9_2-2.5kg' 	=> 42.95,
			'zone9_2.5-3kg' 	=> 46.25,
			'zone9_3-3.5kg' 	=> 49.60,
			'zone9_3.5-4kg' 	=> 52.90,
			'zone9_4-4.5kg' 	=> 56.20,
			'zone9_4.5-5kg' 	=> 59.55,
			'zone9_5-5.5kg' 	=> 61.65,
			'zone9_5.5-6kg' 	=> 63.75,
			'zone9_6-6.5kg' 	=> 65.85,
			'zone9_6.5-7kg' 	=> 67.95,
			'zone9_7-7.5kg' 	=> 70.05,
			'zone9_7.5-8kg' 	=> 72.15,
			'zone9_8-8.5kg' 	=> 74.25,
			'zone9_8.5-9kg' 	=> 76.35,
			'zone9_9-9.5kg' 	=> 78.45,
			'zone9_9.5-10kg' 	=> 80.60,
			'zone9_10-10.5kg' 	=> 81.35,
			'zone9_10.5-11kg' 	=> 82.10,
			'zone9_11-11.5kg' 	=> 82.90,
			'zone9_11.5-12kg' 	=> 83.65,
			'zone9_12-12.5kg' 	=> 84.45,
			'zone9_12.5-13kg' 	=> 85.20,
			'zone9_13-13.5kg' 	=> 86.00,
			'zone9_13.5-14kg' 	=> 86.75,
			'zone9_14-14.5kg' 	=> 87.55,
			'zone9_14.5-15kg' 	=> 88.30,
			'zone9_additional-0.5' 	=> array('basecost'=>88.30, 'perweight'=>0.80),

			// Zone 10 USA & Canada
			'zone10_0-0.5kg' 		=> 34.60,
			'zone10_0.5-1kg' 		=> 36.70,
			'zone10_1-1.5kg' 		=> 38.30,
			'zone10_1.5-2kg' 		=> 39.95,
			'zone10_2-2.5kg' 		=> 41.30,
			'zone10_2.5-3kg' 		=> 47.55,
			'zone10_3-3.5kg' 		=> 53.85,
			'zone10_3.5-4kg' 		=> 60.15,
			'zone10_4-4.5kg' 		=> 66.40,
			'zone10_4.5-5kg' 		=> 72.70,
			'zone10_5-5.5kg' 		=> 75.75,
			'zone10_5.5-6kg' 		=> 78.85,
			'zone10_6-6.5kg' 		=> 81.90,
			'zone10_6.5-7kg' 		=> 84.95,
			'zone10_7-7.5kg' 		=> 88.00,
			'zone10_7.5-8kg' 		=> 91.10,
			'zone10_8-8.5kg' 		=> 94.15,
			'zone10_8.5-9kg' 		=> 97.20,
			'zone10_9-9.5kg' 		=> 100.25,
			'zone10_9.5-10kg' 		=> 103.35,
			'zone10_10-10.5kg' 		=> 105.30,
			'zone10_10.5-11kg' 		=> 107.25,
			'zone10_11-11.5kg' 		=> 109.20,
			'zone10_11.5-12kg' 		=> 111.15,
			'zone10_12-12.5kg' 		=> 113.15,
			'zone10_12.5-13kg' 		=> 115.10,
			'zone10_13-13.5kg' 		=> 117.05,
			'zone10_13.5-14kg' 		=> 119.00,
			'zone10_14-14.5kg' 		=> 121.00,
			'zone10_14.5-15kg' 		=> 122.95,
			'zone10_additional-0.5' 	=> array('basecost'=>122.95, 'perweight'=>2.00),

			// Zone 11 Far East & Australasia 
			'zone11_0-0.5kg' 		=> 36.75,
			'zone11_0.5-1kg' 		=> 41.65,
			'zone11_1-1.5kg' 		=> 44.90,
			'zone11_1.5-2kg' 		=> 48.20,
			'zone11_2-2.5kg' 		=> 51.05,
			'zone11_2.5-3kg' 		=> 57.00,
			'zone11_3-3.5kg' 		=> 62.95,
			'zone11_3.5-4kg' 		=> 68.90,
			'zone11_4-4.5kg' 		=> 74.85,
			'zone11_4.5-5kg' 		=> 80.80,
			'zone11_5-5.5kg' 		=> 84.55,
			'zone11_5.5-6kg' 		=> 88.25,
			'zone11_6-6.5kg' 		=> 91.95,
			'zone11_6.5-7kg' 		=> 95.65,
			'zone11_7-7.5kg' 		=> 99.40,
			'zone11_7.5-8kg' 		=> 103.10,
			'zone11_8-8.5kg' 		=> 106.80,
			'zone11_8.5-9kg' 		=> 110.50,
			'zone11_9-9.5kg' 		=> 114.25,
			'zone11_9.5-10kg' 		=> 117.95,
			'zone11_10-10.5kg' 		=> 120.75,
			'zone11_10.5-11kg' 		=> 123.60,
			'zone11_11-11.5kg' 		=> 126.40,
			'zone11_11.5-12kg' 		=> 129.20,
			'zone11_12-12.5kg' 		=> 132.00,
			'zone11_12.5-13kg' 		=> 134.85,
			'zone11_13-13.5kg' 		=> 137.65,
			'zone11_13.5-14kg' 		=> 140.45,
			'zone11_14-14.5kg' 		=> 143.30,
			'zone11_14.5-15kg' 		=> 146.10,
			'zone11_additional-0.5' 	=> array('basecost'=>146.10, 'perweight'=>2.75),

			// Zone 12 Rest of the World
			'zone12_0-0.5kg' 		=> 47.75,
			'zone12_0.5-1kg' 		=> 53.45,
			'zone12_1-1.5kg' 		=> 59.20,
			'zone12_1.5-2kg' 		=> 64.95,
			'zone12_2-2.5kg' 		=> 70.65,
			'zone12_2.5-3kg' 		=> 76.40,
			'zone12_3-3.5kg' 		=> 82.10,
			'zone12_3.5-4kg' 		=> 87.80,
			'zone12_4-4.5kg' 		=> 93.50,
			'zone12_4.5-5kg' 		=> 99.20,
			'zone12_5-5.5kg' 		=> 104.30,
			'zone12_5.5-6kg' 		=> 109.45,
			'zone12_6-6.5kg' 		=> 114.55,
			'zone12_6.5-7kg' 		=> 119.70,
			'zone12_7-7.5kg' 		=> 124.80,
			'zone12_7.5-8kg' 		=> 129.95,
			'zone12_8-8.5kg' 		=> 135.05,
			'zone12_8.5-9kg' 		=> 140.20,
			'zone12_9-9.5kg' 		=> 145.35,
			'zone12_9.5-10kg' 		=> 150.45,
			'zone12_10-10.5kg' 		=> 152.80,
			'zone12_10.5-11kg' 		=> 155.15,
			'zone12_11-11.5kg' 		=> 157.50,
			'zone12_11.5-12kg' 		=> 159.90,
			'zone12_12-12.5kg' 		=> 162.25,
			'zone12_12.5-13kg' 		=> 164.60,
			'zone12_13-13.5kg' 		=> 166.95,
			'zone12_13.5-14kg' 		=> 169.30,
			'zone12_14-14.5kg' 		=> 171.65,
			'zone12_14.5-15kg' 		=> 174.00,
			'zone12_additional-0.5' => array('basecost'=>174.00, 'perweight'=>2.4),
		)
	),



	array(
		'name' => 'Parcelforce Global Value',
		'id' => 'ph_parcelforce:globalvalue',
		'special_services' => array(),
		'rules' => array( 
			
			// Zone 10 USA & Canada
			'zone10_0-0.5kg' 		=> 21.50,
			'zone10_0.5-1kg' 		=> 23.65,
			'zone10_1-1.5kg' 		=> 25.80,
			'zone10_1.5-2kg' 		=> 28.00,
			'zone10_2-2.5kg' 		=> 33.45,
			'zone10_2.5-3kg' 		=> 38.95,
			'zone10_3-3.5kg' 		=> 44.40,
			'zone10_3.5-4kg' 		=> 49.85,
			'zone10_4-4.5kg' 		=> 55.35,
			'zone10_4.5-5kg' 		=> 60.80,
			'zone10_5-5.5kg' 		=> 63.95,
			'zone10_5.5-6kg' 		=> 67.10,
			'zone10_6-6.5kg' 		=> 70.25,
			'zone10_6.5-7kg' 		=> 73.35,
			'zone10_7-7.5kg' 		=> 76.50,
			'zone10_7.5-8kg' 		=> 79.65,
			'zone10_8-8.5kg' 		=> 82.80,
			'zone10_8.5-9kg' 		=> 85.90,
			'zone10_9-9.5kg' 		=> 89.05,
			'zone10_9.5-10kg' 		=> 92.20,
			'zone10_10-10.5kg' 		=> 94.25,
			'zone10_10.5-11kg' 		=> 96.25,
			'zone10_11-11.5kg' 		=> 98.30,
			'zone10_11.5-12kg' 		=> 100.35,
			'zone10_12-12.5kg' 		=> 102.35,
			'zone10_12.5-13kg' 		=> 104.40,
			'zone10_13-13.5kg' 		=> 106.45,
			'zone10_13.5-14kg' 		=> 108.50,
			'zone10_14-14.5kg' 		=> 110.50,
			'zone10_14.5-15kg' 		=> 112.55,
			'zone10_additional-0.5' 	=> array('basecost'=>112.55, 'perweight'=>2.00),

			// Zone 11 Far East & Australasia 
			'zone11_0-0.5kg' 		=> 27.20,
			'zone11_0.5-1kg' 		=> 32.45,
			'zone11_1-1.5kg' 		=> 37.75,
			'zone11_1.5-2kg' 		=> 43.00,
			'zone11_2-2.5kg' 		=> 48.15,
			'zone11_2.5-3kg' 		=> 53.30,
			'zone11_3-3.5kg' 		=> 58.45,
			'zone11_3.5-4kg' 		=> 63.60,
			'zone11_4-4.5kg' 		=> 68.75,
			'zone11_4.5-5kg' 		=> 73.90,
			'zone11_5-5.5kg' 		=> 77.75,
			'zone11_5.5-6kg' 		=> 81.60,
			'zone11_6-6.5kg' 		=> 85.45,
			'zone11_6.5-7kg' 		=> 89.30,
			'zone11_7-7.5kg' 		=> 93.15,
			'zone11_7.5-8kg' 		=> 96.95,
			'zone11_8-8.5kg' 		=> 100.80,
			'zone11_8.5-9kg' 		=> 104.65,
			'zone11_9-9.5kg' 		=> 108.50,
			'zone11_9.5-10kg' 		=> 112.35,
			'zone11_10-10.5kg' 		=> 115.15,
			'zone11_10.5-11kg' 		=> 118.00,
			'zone11_11-11.5kg' 		=> 120.85,
			'zone11_11.5-12kg' 		=> 123.65,
			'zone11_12-12.5kg' 		=> 126.50,
			'zone11_12.5-13kg' 		=> 129.30,
			'zone11_13-13.5kg' 		=> 132.15,
			'zone11_13.5-14kg' 		=> 134.95,
			'zone11_14-14.5kg' 		=> 137.80,
			'zone11_14.5-15kg' 		=> 140.65,
			'zone11_additional-0.5' 	=> array('basecost'=>140.65, 'perweight'=>2.85),

			// Zone 12 Rest of the World
			'zone12_0-0.5kg' 		=> 26.85,
			'zone12_0.5-1kg' 		=> 32.65,
			'zone12_1-1.5kg' 		=> 38.40,
			'zone12_1.5-2kg' 		=> 44.20,
			'zone12_2-2.5kg' 		=> 46.45,
			'zone12_2.5-3kg' 		=> 52.90,
			'zone12_3-3.5kg' 		=> 59.40,
			'zone12_3.5-4kg' 		=> 65.90,
			'zone12_4-4.5kg' 		=> 72.35,
			'zone12_4.5-5kg' 		=> 78.85,
			'zone12_5-5.5kg' 		=> 84.10,
			'zone12_5.5-6kg' 		=> 89.35,
			'zone12_6-6.5kg' 		=> 94.55,
			'zone12_6.5-7kg' 		=> 99.80,
			'zone12_7-7.5kg' 		=> 105.05,
			'zone12_7.5-8kg' 		=> 110.30,
			'zone12_8-8.5kg' 		=> 115.55,
			'zone12_8.5-9kg' 		=> 120.80,
			'zone12_9-9.5kg' 		=> 126.05,
			'zone12_9.5-10kg' 		=> 131.30,
			'zone12_10-10.5kg' 		=> 134.00,
			'zone12_10.5-11kg' 		=> 136.65,
			'zone12_11-11.5kg' 		=> 139.30,
			'zone12_11.5-12kg' 		=> 141.95,
			'zone12_12-12.5kg' 		=> 144.65,
			'zone12_12.5-13kg' 		=> 147.30,
			'zone12_13-13.5kg' 		=> 149.95,
			'zone12_13.5-14kg' 		=> 152.65,
			'zone12_14-14.5kg' 		=> 155.30,
			'zone12_14.5-15kg' 		=> 157.95,
			'zone12_additional-0.5' => array('basecost'=>157.95, 'perweight'=>2.7),
		)
	),	
);