<?php
return array(
	
	array(
		'name' 	=> 'Royal Mail Special Delivery by 1pm&reg;',
		'id' 	=> 'special_delivery_guaranteed_by_1',
		'special_services' 	=> array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 1,
				'price_1000-2500' 	=> 3,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 6.85,
			'uk_0.1-0.5kg' 	=> 7.65,
			'uk_0.5-1kg' 	=> 8.95,
			'uk_1-2kg' 		=> 11.15,
			'uk_2-10kg' 	=> 15.45,
			'uk_10-20kg' 	=> 19.45,

			//Isle of Man
			'im_0-0.1kg' 	=> 6.85,
			'im_0.1-0.5kg' 	=> 7.65,
			'im_0.5-1kg' 	=> 8.95,
			'im_1-2kg' 		=> 11.15,
			'im_2-10kg' 	=> 15.45,
			'im_10-20kg' 	=> 19.45,

			//Jersey
			'je_0-0.1kg' 	=> 6.85,
			'je_0.1-0.5kg' 	=> 7.65,
			'je_0.5-1kg' 	=> 8.95,
			'je_1-2kg' 		=> 11.15,
			'je_2-10kg' 	=> 15.45,
			'je_10-20kg' 	=> 19.45,

			//Guernsey
			'gg_0-0.1kg' 	=> 6.85,
			'gg_0.1-0.5kg' 	=> 7.65,
			'gg_0.5-1kg' 	=> 8.95,
			'gg_1-2kg' 		=> 11.15,
			'gg_2-10kg' 	=> 15.45,
			'gg_10-20kg' 	=> 19.45,
		)
	),

	array(
		'name' 	=> 'Royal Mail Special Delivery by 1pm&reg; with Saturday',
		'id' 	=> 'special_delivery_guaranteed_by_1_with_saturday',
		'special_services' 	=> array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 1.2,
				'price_1000-2500' 	=> 3.6,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 11.22,
			'uk_0.1-0.5kg' 	=> 12.18,
			'uk_0.5-1kg' 	=> 13.74,
			'uk_1-2kg' 		=> 16.38,
			'uk_2-10kg' 	=> 21.54,
			'uk_10-20kg' 	=> 26.34,

			//Isle of Man
			'im_0-0.1kg' 	=> 11.22,
			'im_0.1-0.5kg' 	=> 12.18,
			'im_0.5-1kg' 	=> 13.74,
			'im_1-2kg' 		=> 16.38,
			'im_2-10kg' 	=> 21.54,
			'im_10-20kg' 	=> 26.34,

			//Guernsey
			'gg_0-0.1kg' 	=> 11.22,
			'gg_0.1-0.5kg' 	=> 12.18,
			'gg_0.5-1kg' 	=> 13.74,
			'gg_1-2kg' 		=> 16.38,
			'gg_2-10kg' 	=> 21.54,
			'gg_10-20kg' 	=> 26.34,
		)
	),

	array(
		'name' => 'Royal Mail Special Delivery by 9am&reg;',
		'id' => 'special_delivery_guaranteed_by_9am',
		'special_services' => array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 2.2,
				'price_1000-2500' 	=> 5.7,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg'	=> 22.95,
			'uk_0.1-0.5kg'	=> 25.95,
			'uk_0.5-1kg'	=> 27.95,
			'uk_1-2kg'		=> 33.95,

			//Isle of Man IM1 postcode Only
			'im_0-0.1kg'	=> 22.95,
			'im_0.1-0.5kg'	=> 25.95,
			'im_0.5-1kg'	=> 27.95,
			'im_1-2kg'		=> 33.95,
		)
	),

	array(
		'name' => 'Royal Mail Special Delivery by 9am&reg; with Saturday',
		'id' => 'special_delivery_guaranteed_by_9_with_saturday',
		'special_services' => array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 2.2,
				'price_1000-2500' 	=> 5.7,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 25.95,
			'uk_0.1-0.5kg' 	=> 28.95,
			'uk_0.5-1kg' 	=> 30.95,
			'uk_1-2kg' 		=> 36.95,
		)
	),

	array(
		'name' => 'Royal Mail 1st Class',
		'id' => '1st_class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 //Signature rates are added seperatly
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 0.95,
			'uk_0-0.1kg_largeletter' 		=> 1.45,
			'uk_0.1-0.250kg_largeletter' 	=> 2.05,
			'uk_0.250-0.500kg_largeletter' 	=> 2.65,
			'uk_0.500-0.750kg_largeletter' 	=> 3.30,

			'uk_0-2kg_smallparcel' => 4.45,

			'uk_0-2kg_mediumparcel' 	=> 6.95,
			'uk_2-10kg_mediumparcel' 	=> 7.95,
			'uk_10-20kg_mediumparcel' 	=> 12.95,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel' => 4.45,

			'ijg_0-2kg_mediumparcel' 	=> 6.95,
			'ijg_2-10kg_mediumparcel' 	=> 7.95,
			'ijg_10-20kg_mediumparcel' 	=> 12.95,
		)
	),

	array(
		'name' => 'Royal Mail 1st Class Signed For',
		'id' => '1st_class_signed',
		'special_services' => array(
			// 'signature_cost'  => 1.1 
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 2.35,
			'uk_0-0.1kg_largeletter' 		=> 2.85,
			'uk_0.1-0.250kg_largeletter' 	=> 3.45,
			'uk_0.250-0.500kg_largeletter' 	=> 4.05,
			'uk_0.500-0.750kg_largeletter' 	=> 4.70,

			'uk_0-2kg_smallparcel' => 5.55,

			'uk_0-2kg_mediumparcel' 	=> 8.05,
			'uk_2-10kg_mediumparcel' 	=> 9.05,
			'uk_10-20kg_mediumparcel' 	=> 14.05,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel' => 5.55,

			'ijg_0-2kg_mediumparcel' 	=> 8.05,
			'ijg_2-10kg_mediumparcel' 	=> 9.05,
			'ijg_10-20kg_mediumparcel' 	=> 14.05,
		)
	),

	array(
		'name' => 'Royal Mail 2nd Class',
		'id' => '2nd_class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 //Signature rates are added seperatly
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 0.68,
			'uk_0-0.1kg_largeletter' 		=> 1.05,
			'uk_0.1-0.250kg_largeletter' 	=> 1.65,
			'uk_0.250-0.500kg_largeletter' 	=> 2.15,
			'uk_0.500-0.750kg_largeletter' 	=> 2.70,

			'uk_0-2kg_smallparcel'			=> 3.35,

			'uk_0-2kg_mediumparcel' 		=> 5.30,
			'uk_2-10kg_mediumparcel' 		=> 6.95,
			'uk_10-20kg_mediumparcel' 		=> 10.45,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel'			=> 3.35,

			'ijg_0-2kg_mediumparcel' 		=> 5.30,
			'ijg_2-10kg_mediumparcel' 		=> 6.95,
			'ijg_10-20kg_mediumparcel' 		=> 10.45,
		)
	),

	array(
		'name' => 'Royal Mail 2nd Class Signed For',
		'id' => '2nd_class_signed',
		'special_services' => array(
			// 'signature_cost'  => 1.1
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 2.08,
			'uk_0-0.1kg_largeletter' 		=> 2.45,
			'uk_0.1-0.250kg_largeletter' 	=> 3.05,
			'uk_0.250-0.500kg_largeletter' 	=> 3.55,
			'uk_0.500-0.750kg_largeletter' 	=> 4.10,

			'uk_0-2kg_smallparcel' => 4.45,

			'uk_0-2kg_mediumparcel' 	=> 6.45,
			'uk_2-10kg_mediumparcel' 	=> 8.05,
			'uk_10-20kg_mediumparcel' 	=> 11.55,

			// Using ijg for Isle of Man, Jersey, Guernsey
			'ijg_0-2kg_smallparcel' => 4.45,

			'ijg_0-2kg_mediumparcel' 	=> 6.45,		
			'ijg_2-10kg_mediumparcel'	=> 8.05,
			'ijg_10-20kg_mediumparcel' 	=> 11.55,
		)
	),

	// UK Online Rates

	array(
		'name'				=> 'Royal Mail Tracked 24&reg;',
		'id'				=> 'tracked24',
		'special_services'	=> array(),
		'rules' 			=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 3.80,

			'uk_0-2kg_smallparcel' 		=> 5.45,

			'uk_0-2kg_mediumparcel'		=> 7.95,
			'uk_2-10kg_mediumparcel'	=> 8.95,
			'uk_10-20kg_mediumparcel'	=> 14.45,
		)
	),

	array(
		'name'				=> 'Royal Mail Tracked 24&reg; with Signature',
		'id'				=> 'tracked24_with_signature',
		'special_services'	=> array(),
		'rules'				=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 4.64,

			'uk_0-2kg_smallparcel' 		=> 5.81,

			'uk_0-2kg_mediumparcel'		=> 8.31,
			'uk_2-10kg_mediumparcel'	=> 9.31,
			'uk_10-20kg_mediumparcel'	=> 14.81,
		)
	),

	array(
		'name'				=> 'Royal Mail Tracked 48&reg;',
		'id'				=> 'tracked48',
		'special_services'	=> array(),
		'rules' 			=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 3.20,

			'uk_0-2kg_smallparcel' 		=> 4.35,

			'uk_0-2kg_mediumparcel'		=> 6.35,
			'uk_2-10kg_mediumparcel'	=> 7.95,
			'uk_10-20kg_mediumparcel'	=> 11.45,
		)
	),

	array(
		'name'				=> 'Royal Mail Tracked 48&reg; with Signature',
		'id'				=> 'tracked48_with_signature',
		'special_services'	=> array(),
		'rules'				=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 4.04,

			'uk_0-2kg_smallparcel' 		=> 4.71,

			'uk_0-2kg_mediumparcel'		=> 6.71,
			'uk_2-10kg_mediumparcel'	=> 8.31,
			'uk_10-20kg_mediumparcel'	=> 11.81,
		)
	),

	// International services

	array(
		'name' => 'Royal Mail International Standard',
		'id' => 'international_standard',
		'special_services' => array(
		),
		'rules' => array( 
			//letter
			'eu1_0-0.02kg_letter'	=> 1.85,
			'eu1_0.02-0.1kg_letter'	=> 1.85,

			'eu2_0-0.02kg_letter'	=> 1.85,
			'eu2_0.02-0.1kg_letter'	=> 1.85,

			'eu3_0-0.02kg_letter'	=> 1.85,
			'eu3_0.02-0.1kg_letter'	=> 1.85,

			'w1_0-0.02kg_letter'	=> 1.85,
			'w1_0.02-0.1kg_letter'	=> 2.55,

			'w2_0-0.02kg_letter'	=> 1.85,
			'w2_0.02-0.1kg_letter'	=> 2.55,

			'w3_0-0.02kg_letter'	=> 1.85,
			'w3_0.02-0.1kg_letter'	=> 2.55,

			
			//large letter
			'eu1_0-0.1kg_largeletter'		=> 3.25,
			'eu1_0.1-0.250kg_largeletter'	=> 4.25,
			'eu1_0.250-0.500kg_largeletter'	=> 5.25,
			'eu1_0.500-0.750kg_largeletter'	=> 6.25,
			
			'eu2_0-0.1kg_largeletter'		=> 3.25,
			'eu2_0.1-0.250kg_largeletter'	=> 4.25,
			'eu2_0.250-0.500kg_largeletter'	=> 5.25,
			'eu2_0.500-0.750kg_largeletter'	=> 6.25,

			'eu3_0-0.1kg_largeletter'		=> 3.25,
			'eu3_0.1-0.250kg_largeletter'	=> 4.25,
			'eu3_0.250-0.500kg_largeletter'	=> 5.25,
			'eu3_0.500-0.750kg_largeletter'	=> 6.25,

			'w1_0-0.1kg_largeletter'		=> 4.20,
			'w1_0.1-0.250kg_largeletter'	=> 5.70,
			'w1_0.250-0.500kg_largeletter'	=> 8.00,
			'w1_0.500-0.750kg_largeletter'	=> 10.65,

			'w2_0-0.1kg_largeletter' 		=> 4.20,
			'w2_0.1-0.250kg_largeletter' 	=> 6.80,
			'w2_0.250-0.500kg_largeletter' 	=> 9.85,
			'w2_0.500-0.750kg_largeletter' 	=> 13.55,

			'w3_0-0.1kg_largeletter'		=> 4.20,
			'w3_0.1-0.250kg_largeletter'	=> 5.85,
			'w3_0.250-0.500kg_largeletter'	=> 8.30,
			'w3_0.500-0.750kg_largeletter'	=> 11.10,



			//Small Parcel
			'eu1_0-0.250kg_smallparcel' 	=> 5.85,
			'eu1_0.250-0.500kg_smallparcel' => 7.50,
			'eu1_0.500-0.750kg_smallparcel' => 8.70,
			'eu1_0.750-1kg_smallparcel' 	=> 9.90,
			'eu1_1-1.25kg_smallparcel' 		=> 10.90,
			'eu1_1.25-1.5kg_smallparcel' 	=> 10.90,
			'eu1_1.5-2kg_smallparcel'		=> 12.40,

			'eu2_0-0.250kg_smallparcel' 	=> 5.95,
			'eu2_0.250-0.500kg_smallparcel' => 7.80,
			'eu2_0.500-0.750kg_smallparcel' => 9.05,
			'eu2_0.750-1kg_smallparcel' 	=> 10.20,
			'eu2_1-1.25kg_smallparcel' 		=> 11.40,
			'eu2_1.25-1.5kg_smallparcel' 	=> 11.40,
			'eu2_1.5-2kg_smallparcel'		=> 12.90,

			'eu3_0-0.250kg_smallparcel' 	=> 6.30,
			'eu3_0.250-0.500kg_smallparcel' => 8.20,
			'eu3_0.500-0.750kg_smallparcel' => 9.55,
			'eu3_0.750-1kg_smallparcel' 	=> 10.90,
			'eu3_1-1.25kg_smallparcel' 		=> 11.95,
			'eu3_1.25-1.5kg_smallparcel' 	=> 13.05,
			'eu3_1.5-2kg_smallparcel'		=> 14.05,

			'w1_0-0.1kg_smallparcel' 		=> 7.15,
			'w1_0.1-0.250kg_smallparcel' 	=> 8.30,
			'w1_0.250-0.500kg_smallparcel'	=> 12.10,
			'w1_0.500-0.750kg_smallparcel'	=> 14.85,
			'w1_0.750-1kg_smallparcel'		=> 17.65,
			'w1_1-1.25kg_smallparcel'		=> 19.85,
			'w1_1.25-1.5kg_smallparcel'		=> 22.10,
			'w1_1.5-2kg_smallparcel'		=> 23.30,

			'w2_0-0.1kg_smallparcel'		=> 8.35,
			'w2_0.1-0.250kg_smallparcel'	=> 9.90,
			'w2_0.250-0.500kg_smallparcel'	=> 14.50,
			'w2_0.500-0.750kg_smallparcel'	=> 17.60,
			'w2_0.750-1kg_smallparcel'		=> 20.85,
			'w2_1-1.25kg_smallparcel'		=> 23.75,
			'w2_1.25-1.5kg_smallparcel'		=> 26.85,
			'w2_1.5-2kg_smallparcel'		=> 28.55,

			'w3_0-0.1kg_smallparcel'		=> 9.35,
			'w3_0.1-0.250kg_smallparcel'	=> 10.95,
			'w3_0.250-0.500kg_smallparcel'	=> 16.60,
			'w3_0.500-0.750kg_smallparcel'	=> 19.35,
			'w3_0.750-1kg_smallparcel'		=> 23.00,
			'w3_1-1.25kg_smallparcel'		=> 26.45,
			'w3_1.25-1.5kg_smallparcel'		=> 29.20,
			'w3_1.5-2kg_smallparcel'		=> 30.45,
		)
	),
	
	array(
		'name' => 'Royal Mail International Tracked and Signed',
		'id' => 'international_tracked_signed',
		'special_services' => array(
		),
		'rules' => array( 
			//letter
			'eu1_0-0.02kg_letter'	 => 7.00,
			'eu1_0.02-0.1kg_letter'  => 7.00,

			'eu2_0-0.02kg_letter'	 => 7.00,
			'eu2_0.02-0.1kg_letter'  => 7.00,

			'eu3_0-0.02kg_letter'	 => 7.00,
			'eu3_0.02-0.1kg_letter'  => 7.00,
			
			'w1_0-0.02kg_letter' 	=> 7.00,
			'w1_0.02-0.1kg_letter' 	=> 7.85,

			'w2_0-0.02kg_letter' 	=> 7.00,
			'w2_0.02-0.1kg_letter' 	=> 7.85,
			
			'w3_0-0.02kg_letter' 	=> 7.00,
			'w3_0.02-0.1kg_letter' 	=> 7.85,
			
			//large letter
			'eu1_0-0.1kg_largeletter'		=> 8.75,
			'eu1_0.1-0.250kg_largeletter'	=> 9.20,
			'eu1_0.250-0.500kg_largeletter'	=> 9.95,
			'eu1_0.500-0.750kg_largeletter'	=> 10.35,

			'eu2_0-0.1kg_largeletter' 		=> 8.75,
			'eu2_0.1-0.250kg_largeletter' 	=> 9.20,
			'eu2_0.250-0.500kg_largeletter'	=> 9.95,
			'eu2_0.500-0.750kg_largeletter' => 10.35,

			'eu3_0-0.1kg_largeletter' 		=> 8.75,
			'eu3_0.1-0.250kg_largeletter' 	=> 9.20,
			'eu3_0.250-0.500kg_largeletter' => 9.95,
			'eu3_0.500-0.750kg_largeletter' => 10.35,
			
			'w1_0-0.1kg_largeletter' 		=> 9.70,
			'w1_0.1-0.250kg_largeletter' 	=> 10.50,
			'w1_0.250-0.500kg_largeletter' 	=> 12.30,
			'w1_0.500-0.750kg_largeletter' 	=> 14.15,

			'w2_0-0.1kg_largeletter' 		=> 9.80,
			'w2_0.1-0.250kg_largeletter' 	=> 11.55,
			'w2_0.250-0.500kg_largeletter' 	=> 14.10,
			'w2_0.500-0.750kg_largeletter' 	=> 16.90,

			'w3_0-0.1kg_largeletter'		=> 9.75,
			'w3_0.1-0.250kg_largeletter'	=> 10.65,
			'w3_0.250-0.500kg_largeletter'	=> 12.60,
			'w3_0.500-0.750kg_largeletter'	=> 14.60,

			//Small Parcel
			'eu1_0-0.250kg_smallparcel'		=> 10.80,
			'eu1_0.250-0.500kg_smallparcel'	=> 12.20,
			'eu1_0.500-0.750kg_smallparcel' => 13.30,
			'eu1_0.750-1kg_smallparcel' 	=> 14.30,
			'eu1_1-1.25kg_smallparcel' 		=> 14.85,
			'eu1_1.25-1.5kg_smallparcel' 	=> 15.00,
			'eu1_1.5-2kg_smallparcel' 		=> 15.15,

			'eu2_0-0.250kg_smallparcel'		=> 10.95,
			'eu2_0.250-0.500kg_smallparcel' => 12.60,
			'eu2_0.500-0.750kg_smallparcel' => 13.65,
			'eu2_0.750-1kg_smallparcel' 	=> 14.60,
			'eu2_1-1.25kg_smallparcel' 		=> 14.95,
			'eu2_1.25-1.5kg_smallparcel' 	=> 15.20,
			'eu2_1.5-2kg_smallparcel' 		=> 15.65,

			'eu3_0-0.250kg_smallparcel'		=> 11.50,
			'eu3_0.250-0.500kg_smallparcel' => 13.00,
			'eu3_0.500-0.750kg_smallparcel' => 14.15,
			'eu3_0.750-1kg_smallparcel' 	=> 15.30,
			'eu3_1-1.25kg_smallparcel' 		=> 15.90,
			'eu3_1.25-1.5kg_smallparcel' 	=> 16.50,
			'eu3_1.5-2kg_smallparcel' 		=> 16.80,

			'w1_0-0.1kg_smallparcel' 		=> 12.50,
			'w1_0.1-0.250kg_smallparcel' 	=> 13.45,
			'w1_0.250-0.500kg_smallparcel' 	=> 17.10,
			'w1_0.500-0.750kg_smallparcel' 	=> 19.50,
			'w1_0.750-1kg_smallparcel' 		=> 22.15,
			'w1_1-1.25kg_smallparcel' 		=> 24.00,
			'w1_1.25-1.5kg_smallparcel' 	=> 25.40,
			'w1_1.5-2kg_smallparcel' 		=> 25.85,

			'w2_0-0.1kg_smallparcel' 		=> 13.55,
			'w2_0.1-0.250kg_smallparcel' 	=> 14.90,
			'w2_0.250-0.500kg_smallparcel' 	=> 19.30,
			'w2_0.500-0.750kg_smallparcel' 	=> 22.10,
			'w2_0.750-1kg_smallparcel' 		=> 25.25,
			'w2_1-1.25kg_smallparcel' 		=> 27.65,
			'w2_1.25-1.5kg_smallparcel' 	=> 30.15,
			'w2_1.5-2kg_smallparcel' 		=> 31.20,

			'w3_0-0.1kg_smallparcel' 		=> 14.35,
			'w3_0.1-0.250kg_smallparcel' 	=> 15.95,
			'w3_0.250-0.500kg_smallparcel' 	=> 21.35,
			'w3_0.500-0.750kg_smallparcel' 	=> 23.35,
			'w3_0.750-1kg_smallparcel' 		=> 27.00,
			'w3_1-1.25kg_smallparcel' 		=> 30.45,
			'w3_1.25-1.5kg_smallparcel' 	=> 33.20,
			'w3_1.5-2kg_smallparcel' 		=> 33.70,
		)
	),

	array(
		'name' => 'Royal Mail International Tracked',
		'id' => 'international_tracked',
		'special_services' => array(
			'noneu' => true, //Contains noneu rules
		),
		'rules' => array( 
			// letter
			'eu1_0-0.02kg_letter' 	=> 6.90,
			'eu1_0.02-0.1kg_letter' => 6.90,

			'eu2_0-0.02kg_letter' 	=> 6.90,
			'eu2_0.02-0.1kg_letter' => 6.90,

			'eu3_0-0.02kg_letter' 	=> 6.90,
			'eu3_0.02-0.1kg_letter' => 6.90,
			
			/*'noneu_0-0.01kg_letter' 	=> 6.75,
			'noneu_0.01-0.02kg_letter' 	=> 6.75,
			'noneu_0.02-0.1kg_letter' 	=> 6.75,*/

			'w1_0-0.02kg_letter' 	=> 6.90,
			'w1_0.02-0.1kg_letter' 	=> 7.75,

			'w2_0-0.02kg_letter' 	=> 6.90,
			'w2_0.02-0.1kg_letter' 	=> 7.75,

			'w3_0-0.02kg_letter' 	=> 6.90,
			'w3_0.02-0.1kg_letter' 	=> 7.75,

			// large letter
			'eu1_0-0.1kg_largeletter' 		=> 8.65,
			'eu1_0.1-0.250kg_largeletter' 	=> 8.85,
			'eu1_0.250-0.500kg_largeletter' => 9.85,
			'eu1_0.500-0.750kg_largeletter' => 10.25,

			'eu2_0-0.1kg_largeletter' 		=> 8.65,
			'eu2_0.1-0.250kg_largeletter' 	=> 8.85,
			'eu2_0.250-0.500kg_largeletter' => 9.85,
			'eu2_0.500-0.750kg_largeletter' => 10.25,

			'eu3_0-0.1kg_largeletter' 		=> 8.65,
			'eu3_0.1-0.250kg_largeletter' 	=> 8.85,
			'eu3_0.250-0.500kg_largeletter' => 9.85,
			'eu3_0.500-0.750kg_largeletter' => 10.25,

		/*'noneu_0-0.1kg_largeletter' 		=> 8.65,
			'noneu_0.1-0.250kg_largeletter' 	=> 8.85,
			'noneu_0.250-0.500kg_largeletter'	=> 9.85,
			'noneu_0.500-0.750kg_largeletter' 	=> 10.25,*/

			'w1_0-0.1kg_largeletter' 		=> 9.60,
			'w1_0.1-0.250kg_largeletter' 	=> 10.35,
			'w1_0.250-0.500kg_largeletter' 	=> 12.20,
			'w1_0.500-0.750kg_largeletter' 	=> 14.05,

			'w2_0-0.1kg_largeletter' 		=> 9.65,
			'w2_0.1-0.250kg_largeletter' 	=> 11.45,
			'w2_0.250-0.500kg_largeletter' 	=> 14.00,
			'w2_0.500-0.750kg_largeletter' 	=> 16.80,

			'w3_0-0.1kg_largeletter' 		=> 9.65,
			'w3_0.1-0.250kg_largeletter' 	=> 10.55,
			'w3_0.250-0.500kg_largeletter' 	=> 12.50,
			'w3_0.500-0.750kg_largeletter' 	=> 14.50,

			//Small parcel and printer papers
			'eu1_0-0.250kg_smallparcel' 	=> 9.90,
			'eu1_0.250-0.500kg_smallparcel' => 11.15,
			'eu1_0.500-0.750kg_smallparcel' => 12.15,
			'eu1_0.750-1kg_smallparcel' 	=> 13.10,
			'eu1_1-1.25kg_smallparcel' 		=> 14.00,
			'eu1_1.25-1.5kg_smallparcel' 	=> 14.00,
			'eu1_1.5-2kg_smallparcel' 		=> 14.00,

			'eu2_0-0.250kg_smallparcel' 	=> 9.95,
			'eu2_0.250-0.500kg_smallparcel' => 11.20,
			'eu2_0.500-0.750kg_smallparcel' => 12.25,
			'eu2_0.750-1kg_smallparcel' 	=> 13.20,
			'eu2_1-1.25kg_smallparcel' 		=> 14.00,
			'eu2_1.25-1.5kg_smallparcel' 	=> 14.00,
			'eu2_1.5-2kg_smallparcel' 		=> 14.65,

			'eu3_0-0.250kg_smallparcel' 	=> 10.20,
			'eu3_0.250-0.500kg_smallparcel' => 11.60,
			'eu3_0.500-0.750kg_smallparcel' => 12.75,
			'eu3_0.750-1kg_smallparcel' 	=> 13.90,
			'eu3_1-1.25kg_smallparcel' 		=> 14.50,
			'eu3_1.25-1.5kg_smallparcel' 	=> 15.30,
			'eu3_1.5-2kg_smallparcel' 		=> 15.80,

			/*'noneu_0-0.1kg_smallparcel' 		=> 10.10,
			'noneu_0.1-0.250kg_smallparcel' 	=> 10.25,
			'noneu_0.250-0.500kg_smallparcel' 	=> 11.70,
			'noneu_0.500-0.750kg_smallparcel' 	=> 12.75,
			'noneu_0.750-1kg_smallparcel' 		=> 13.70,
			'noneu_1-1.25kg_smallparcel' 		=> 14.10,
			'noneu_1.25-1.5kg_smallparcel' 		=> 14.85,
			'noneu_1.5-1.75kg_smallparcel' 		=> 15.25,
			'noneu_0u_1.75-2kg_smallparcel' 		=> 15.25,*/

			'w1_0-0.1kg_smallparcel' 		=> 11.25,
			'w1_0.1-0.250kg_smallparcel' 	=> 12.20,
			'w1_0.250-0.500kg_smallparcel' 	=> 15.85,
			'w1_0.500-0.750kg_smallparcel' 	=> 18.25,
			'w1_0.750-1kg_smallparcel' 		=> 20.90,
			'w1_1-1.25kg_smallparcel' 		=> 22.75,
			'w1_1.25-1.5kg_smallparcel' 	=> 24.15,
			'w1_1.5-2kg_smallparcel' 		=> 25.15,

			'w2_0-0.1kg_smallparcel' 		=> 12.30,
			'w2_0.1-0.250kg_smallparcel' 	=> 13.65,
			'w2_0.250-0.500kg_smallparcel' 	=> 18.05,
			'w2_0.500-0.750kg_smallparcel' 	=> 20.85,
			'w2_0.750-1kg_smallparcel' 		=> 24.00,
			'w2_1-1.25kg_smallparcel' 		=> 26.40,
			'w2_1.25-1.5kg_smallparcel' 	=> 28.90,
			'w2_1.5-2kg_smallparcel' 		=> 30.50,

			'w2_0-0.1kg_smallparcel' 		=> 12.15,
			'w2_0.1-0.250kg_smallparcel' 	=> 13.45,
			'w2_0.250-0.500kg_smallparcel' 	=> 18.10,
			'w2_0.500-0.750kg_smallparcel' 	=> 20.85,
			'w2_0.750-1kg_smallparcel' 		=> 24.40,
			'w2_1-1.25kg_smallparcel' 		=> 27.60,
			'w2_1.25-1.5kg_smallparcel' 	=> 27.60,
			'w2_1.5-2kg_smallparcel' 		=> 27.60,
		)
	),

	array(
		'name' => 'Royal Mail International Signed',
		'id' => 'international_signed',
		'special_services' => array(
		),
		'rules' => array( 
			// letter
			'eu1_0-0.02kg_letter' 	=> 7.00,
			'eu1_0.02-0.1kg_letter' => 7.00,

			'eu2_0-0.02kg_letter' 	=> 7.00,
			'eu2_0.02-0.1kg_letter' => 7.00,

			'eu3_0-0.02kg_letter' 	=> 7.00,
			'eu3_0.02-0.1kg_letter' => 7.00,
			
			'w1_0-0.02kg_letter' 	=> 7.00,
			'w1_0.02-0.1kg_letter' 	=> 7.85,

			'w2_0-0.02kg_letter' 	=> 7.00,
			'w2_0.02-0.1kg_letter' 	=> 7.85,

			// large letter
			'eu1_0-0.1kg_largeletter' 		=> 8.75,
			'eu1_0.1-0.250kg_largeletter' 	=> 9.20,
			'eu1_0.250-0.500kg_largeletter' => 9.95,
			'eu1_0.500-0.750kg_largeletter' => 10.35,

			'eu2_0-0.1kg_largeletter' 		=> 8.75,
			'eu2_0.1-0.250kg_largeletter' 	=> 9.20,
			'eu2_0.250-0.500kg_largeletter' => 9.95,
			'eu2_0.500-0.750kg_largeletter' => 10.35,

			'eu3_0-0.1kg_largeletter' 		=> 8.75,
			'eu3_0.1-0.250kg_largeletter' 	=> 9.20,
			'eu3_0.250-0.500kg_largeletter' => 9.95,
			'eu3_0.500-0.750kg_largeletter' => 10.35,

			'w1_0-0.1kg_largeletter' 		=> 9.70,
			'w1_0.1-0.250kg_largeletter' 	=> 10.50,
			'w1_0.250-0.500kg_largeletter' 	=> 12.30,
			'w1_0.500-0.750kg_largeletter' 	=> 14.15,

			'w2_0-0.1kg_largeletter' 		=> 9.80,
			'w2_0.1-0.250kg_largeletter' 	=> 11.55,
			'w2_0.250-0.500kg_largeletter' 	=> 14.10,
			'w2_0.500-0.750kg_largeletter' 	=> 16.90,

			//Small parcel and printer papers
			'eu1_0-0.250kg_smallparcel' 	=> 10.80,
			'eu1_0.250-0.500kg_smallparcel' => 12.20,
			'eu1_0.500-0.750kg_smallparcel' => 13.30,
			'eu1_0.750-1kg_smallparcel'		=> 14.30,
			'eu1_1-1.25kg_smallparcel' 		=> 14.85,
			'eu1_1.25-1.5kg_smallparcel' 	=> 15.00,
			'eu1_1.5-2kg_smallparcel' 		=> 15.15,

			'eu2_0-0.250kg_smallparcel' 	=> 10.95,
			'eu2_0.250-0.500kg_smallparcel' => 12.60,
			'eu2_0.500-0.750kg_smallparcel' => 13.65,
			'eu2_0.750-1kg_smallparcel'		=> 14.60,
			'eu2_1-1.25kg_smallparcel' 		=> 14.95,
			'eu2_1.25-1.5kg_smallparcel' 	=> 15.20,
			'eu2_1.5-2kg_smallparcel' 		=> 15.65,

			'eu3_0-0.250kg_smallparcel' 	=> 11.50,
			'eu3_0.250-0.500kg_smallparcel' => 13.00,
			'eu3_0.500-0.750kg_smallparcel' => 14.15,
			'eu3_0.750-1kg_smallparcel'		=> 15.30,
			'eu3_1-1.25kg_smallparcel' 		=> 15.90,
			'eu3_1.25-1.5kg_smallparcel' 	=> 16.50,
			'eu3_1.5-2kg_smallparcel' 		=> 16.80,

			'w1_0-0.1kg_smallparcel' 		=> 12.50,
			'w1_0.1-0.250kg_smallparcel' 	=> 13.45,
			'w1_0.250-0.500kg_smallparcel' 	=> 17.10,
			'w1_0.500-0.750kg_smallparcel' 	=> 19.50,
			'w1_0.750-1kg_smallparcel' 		=> 22.15,
			'w1_1-1.25kg_smallparcel' 		=> 24.00,
			'w1_1.25-1.5kg_smallparcel' 	=> 25.40,
			'w1_1.5-2kg_smallparcel' 		=> 25.85,

			'w2_0-0.1kg_smallparcel' 		=> 13.55,
			'w2_0.1-0.250kg_smallparcel' 	=> 14.90,
			'w2_0.250-0.500kg_smallparcel' 	=> 19.30,
			'w2_0.500-0.750kg_smallparcel' 	=> 22.10,
			'w2_0.750-1kg_smallparcel' 		=> 25.25,
			'w2_1-1.25kg_smallparcel' 		=> 27.65,
			'w2_1.25-1.5kg_smallparcel' 	=> 30.15,
			'w2_1.5-2kg_smallparcel' 		=> 31.20,

		)
	),
	
	array(
		'name' => 'Royal Mail International Economy',
		'id' => 'international_economy',
		'special_services' => array(
		),
		'rules' => array( 
			// letter
			'0-0.02kg_letter' 		=> 1.60,
			'0.02-0.1kg_letter' 	=> 1.60,
									
			//Large Letter
			'0-0.1kg_largeletter' 		=> 3.20,
			'0.1-0.250kg_largeletter' 	=> 4.60,
			'0.250-0.500kg_largeletter' => 5.30,
			'0.500-0.750kg_largeletter' => 6.35,

			//Small Parcels and Printed Papers
			'0-0.1kg_smallparcel' 		=> 5.05,
			'0.1-0.250kg_smallparcel' 	=> 5.40,
			'0.250-0.500kg_smallparcel' => 7.75,
			'0.500-0.750kg_smallparcel' => 9.05,
			'0.750-1kg_smallparcel' 	=> 10.45,
			'1-1.25kg_smallparcel' 		=> 11.60,
			'1.25-1.5kg_smallparcel' 	=> 12.85,
			'1.5-2kg_smallparcel' 		=> 14.25,
		),
	),

);