<?php

/**
 * The is the factory which creates shipment tracking objects
 */
class PHTrackingFactory {
	public static function init() {
		PHTrackingFactory::phive_include_once( 'PHTrackingAbstract', 'class-ph-tracking-common.php' );
		PHTrackingFactory::phive_include_once( 'PHTrackingAbstract', 'class-ph-tracking-abstract.php' );
	}

    public static function create( $shipment_source_obj ) {	
        switch ( $shipment_source_obj->shipping_service ) {
			case '':
                $tracking_obj = null;
				break;
			default:
				PHTrackingFactory::phive_include_once( 'PHTrackingDefault', 'class-ph-tracking-default.php' );
				$tracking_obj = new PHTrackingDefault();
				break;
        }

		if( null != $tracking_obj ) {
			$tracking_obj->init ( $shipment_source_obj );
		}

        return $tracking_obj;
    }

	private static function phive_include_once( $class_name, $file_name ) {
		if ( ! class_exists( $class_name ) ) {
			include_once ( $file_name );
		}
	}
}

?>