<?php
return array(
	
	array(
		'name' 	=> 'Royal Mail Special Delivery by 1pm&reg;',
		'id' 	=> 'special_delivery_guaranteed_by_1',
		'special_services' 	=> array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 1,
				'price_1000-2500' 	=> 3,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 6.85,
			'uk_0.1-0.5kg' 	=> 7.65,
			'uk_0.5-1kg' 	=> 8.95,
			'uk_1-2kg' 		=> 11.15,
			'uk_2-10kg' 	=> 26.75,
			'uk_10-20kg' 	=> 41.35,
		)
	),

	array(
		'name' 	=> 'Royal Mail Special Delivery by 1pm&reg; with Saturday',
		'id' 	=> 'special_delivery_guaranteed_by_1_with_saturday',
		'special_services' 	=> array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 1.2,
				'price_1000-2500' 	=> 3.6,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 11.22,
			'uk_0.1-0.5kg' 	=> 12.18,
			'uk_0.5-1kg' 	=> 13.74,
			'uk_1-2kg' 		=> 16.38,
			'uk_2-10kg' 	=> 35.10,
			'uk_10-20kg' 	=> 52.62,
		)
	),

	array(
		'name' => 'Royal Mail Special Delivery by 9am&reg;',
		'id' => 'special_delivery_guaranteed_by_9am',
		'special_services' => array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 2.2,
				'price_1000-2500' 	=> 5.7,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg'	=> 22.26,
			'uk_0.1-0.5kg'	=> 25.18,
			'uk_0.5-1kg'	=> 27.29,
			'uk_1-2kg'		=> 31.19,
		)
	),

	array(
		'name' => 'Royal Mail Special Delivery by 9am&reg; with Saturday',
		'id' => 'special_delivery_guaranteed_by_9_with_saturday',
		'special_services' => array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 2.2,
				'price_1000-2500' 	=> 5.7,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 25.26,
			'uk_0.1-0.5kg' 	=> 28.18,
			'uk_0.5-1kg' 	=> 30.29,
			'uk_1-2kg' 		=> 34.19,
		)
	),

	array(
		'name' => 'Royal Mail 1st Class',
		'id' => '1st_class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 //Signature rates are added seperatly
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 0.85,
			'uk_0-0.1kg_largeletter' 		=> 1.29,
			'uk_0.1-0.250kg_largeletter' 	=> 1.83,
			'uk_0.250-0.500kg_largeletter' 	=> 2.39,
			'uk_0.500-0.750kg_largeletter' 	=> 3.30,

			'uk_0-1kg_smallparcel' => 3.85,
			'uk_1-2kg_smallparcel' => 5.57,

			'uk_0-1kg_mediumparcel' 	=> 6.00,
			'uk_1-2kg_mediumparcel' 	=> 9.02,
			'uk_2-5kg_mediumparcel' 	=> 15.85,
			'uk_5-10kg_mediumparcel' 	=> 21.90,
			'uk_10-20kg_mediumparcel' 	=> 33.40,
		)
	),

	array(
		'name' => 'Royal Mail 1st Class Signed For',
		'id' => '1st_class_signed',
		'special_services' => array(
			// 'signature_cost'  => 1.1 
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 2.25,
			'uk_0-0.1kg_largeletter' 		=> 2.69,
			'uk_0.1-0.250kg_largeletter' 	=> 3.23,
			'uk_0.250-0.500kg_largeletter' 	=> 3.79,
			'uk_0.500-0.750kg_largeletter' 	=> 4.70,

			'uk_0-1kg_smallparcel' => 4.85,
			'uk_1-2kg_smallparcel' => 6.57,

			'uk_0-1kg_mediumparcel' 	=> 7.00,
			'uk_1-2kg_mediumparcel' 	=> 10.02,
			'uk_2-5kg_mediumparcel' 	=> 16.85,
			'uk_5-10kg_mediumparcel' 	=> 22.90,
			'uk_10-20kg_mediumparcel' 	=> 34.40,
		)
	),

	array(
		'name' => 'Royal Mail 2nd Class',
		'id' => '2nd_class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 //Signature rates are added seperatly
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 0.66,
			'uk_0-0.1kg_largeletter' 		=> 0.96,
			'uk_0.1-0.250kg_largeletter' 	=> 1.53,
			'uk_0.250-0.500kg_largeletter' 	=> 1.99,
			'uk_0.500-0.750kg_largeletter' 	=> 2.70,

			'uk_0-1kg_smallparcel' 			=> 3.20,
			'uk_1-2kg_smallparcel'			=> 3.20,

			'uk_0-1kg_mediumparcel' 		=> 5.30,
			'uk_1-2kg_mediumparcel' 		=> 5.30,
			'uk_2-5kg_mediumparcel' 		=> 8.99,
			'uk_5-10kg_mediumparcel' 		=> 20.25,
			'uk_10-20kg_mediumparcel' 		=> 28.55,
		)
	),

	array(
		'name' => 'Royal Mail 2nd Class Signed For',
		'id' => '2nd_class_signed',
		'special_services' => array(
			// 'signature_cost'  => 1.1
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 2.06,
			'uk_0-0.1kg_largeletter' 		=> 2.36,
			'uk_0.1-0.250kg_largeletter' 	=> 2.93,
			'uk_0.250-0.500kg_largeletter' 	=> 3.39,
			'uk_0.500-0.750kg_largeletter' 	=> 4.10,

			'uk_0-1kg_smallparcel' => 4.20,
			'uk_1-2kg_smallparcel' => 4.20,

			'uk_0-1kg_mediumparcel' 	=> 6.30,
			'uk_1-2kg_mediumparcel' 	=> 6.30,		
			'uk_2-5kg_mediumparcel'		=> 9.99,
			'uk_5-10kg_mediumparcel' 	=> 21.25,
			'uk_10-20kg_mediumparcel' 	=> 29.55,
		)
	),

	// UK Online Rates

	array(
		'name'				=> 'Royal Mail Tracked 24&reg;',
		'id'				=> 'tracked24',
		'special_services'	=> array(),
		'rules' 			=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 4.02,

			'uk_0-1kg_smallparcel' 		=> 5.46,
			'uk_1-2kg_smallparcel' 		=> 7.80,

			'uk_0-1kg_mediumparcel'		=> 8.46,
			'uk_1-2kg_mediumparcel'		=> 11.94,
			'uk_2-5kg_mediumparcel'		=> 18.00,
			'uk_5-10kg_mediumparcel'	=> 21.60,
			'uk_10-20kg_mediumparcel'	=> 33.60,
		)
	),

	array(
		'name'				=> 'Royal Mail Tracked 24&reg; with Signature',
		'id'				=> 'tracked24_with_signature',
		'special_services'	=> array(),
		'rules'				=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 4.86,

			'uk_0-1kg_smallparcel' 		=> 5.82,
			'uk_1-2kg_smallparcel' 		=> 8.16,

			'uk_0-1kg_mediumparcel'		=> 8.82,
			'uk_1-2kg_mediumparcel'		=> 12.30,
			'uk_2-5kg_mediumparcel'		=> 18.36,
			'uk_5-10kg_mediumparcel'	=> 21.96,
			'uk_10-20kg_mediumparcel'	=> 33.96,
		)
	),

	array(
		'name'				=> 'Royal Mail Tracked 48&reg;',
		'id'				=> 'tracked48',
		'special_services'	=> array(),
		'rules' 			=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 3.60,

			'uk_0-1kg_smallparcel' 		=> 4.74,
			'uk_1-2kg_smallparcel' 		=> 4.74,

			'uk_0-1kg_mediumparcel'		=> 7.26,
			'uk_1-2kg_mediumparcel'		=> 7.26,
			'uk_2-5kg_mediumparcel'		=> 10.55,
			'uk_5-10kg_mediumparcel'	=> 16.80,
			'uk_10-20kg_mediumparcel'	=> 30.00,
		)
	),

	array(
		'name'				=> 'Royal Mail Tracked 48&reg; with Signature',
		'id'				=> 'tracked48_with_signature',
		'special_services'	=> array(),
		'rules'				=> array( 
			
			'uk_0-0.750kg_largeletter' 	=> 4.44,

			'uk_0-1kg_smallparcel' 		=> 5.10,
			'uk_1-2kg_smallparcel' 		=> 5.10,

			'uk_0-1kg_mediumparcel'		=> 7.62,
			'uk_1-2kg_mediumparcel'		=> 7.62,
			'uk_2-5kg_mediumparcel'		=> 10.91,
			'uk_5-10kg_mediumparcel'	=> 17.16,
			'uk_10-20kg_mediumparcel'	=> 30.36,
		)
	),

	// International services

	array(
		'name' => 'Royal Mail International Standard',
		'id' => 'international_standard',
		'special_services' => array(
		),
		'rules' => array( 
			//letter
			'eu_0-0.01kg_letter' 	=> 1.70,
			'eu_0.01-0.02kg_letter' => 1.70,
			'eu_0.02-0.1kg_letter'	=> 1.70,
			
			'w1_0-0.01kg_letter'	=> 1.70,
			'w1_0.01-0.02kg_letter' => 1.70,
			'w1_0.02-0.1kg_letter'	=> 2.55,
			
			'w2_0-0.01kg_letter'	=> 1.70,
			'w2_0.01-0.02kg_letter'	=> 1.70,
			'w2_0.02-0.1kg_letter'	=> 2.55,

			'w3_0-0.01kg_letter'	=> 1.70,
			'w3_0.01-0.02kg_letter'	=> 1.70,
			'w3_0.02-0.1kg_letter'	=> 2.55,
			
			//large letter
			'eu_0-0.1kg_largeletter'		=> 3.25,
			'eu_0.1-0.250kg_largeletter'	=> 4.25,
			'eu_0.250-0.500kg_largeletter'	=> 5.25,
			'eu_0.500-0.750kg_largeletter'	=> 6.25,

			'w1_0-0.1kg_largeletter'		=> 4.20,
			'w1_0.1-0.250kg_largeletter'	=> 5.70,
			'w1_0.250-0.500kg_largeletter'	=> 8.00,
			'w1_0.500-0.750kg_largeletter'	=> 10.65,

			'w2_0-0.1kg_largeletter' 		=> 4.20,
			'w2_0.1-0.250kg_largeletter' 	=> 6.80,
			'w2_0.250-0.500kg_largeletter' 	=> 9.85,
			'w2_0.500-0.750kg_largeletter' 	=> 13.55,

			'w3_0-0.1kg_largeletter'		=> 4.20,
			'w3_0.1-0.250kg_largeletter'	=> 5.85,
			'w3_0.250-0.500kg_largeletter'	=> 8.30,
			'w3_0.500-0.750kg_largeletter'	=> 11.10,

			//Small Parcel
			'eu_0-0.1kg_smallparcel' 		=> 5.80,
			'eu_0.1-0.250kg_smallparcel' 	=> 5.95,
			'eu_0.250-0.500kg_smallparcel' 	=> 7.80,
			'eu_0.500-0.750kg_smallparcel' 	=> 9.05,
			'eu_0.750-1kg_smallparcel' 		=> 10.20,
			'eu_1-1.25kg_smallparcel' 		=> 11.05,
			'eu_1.25-1.5kg_smallparcel' 	=> 12.10,
			'eu_1.5-1.75kg_smallparcel'		=> 13.00,
			'eu_1.75-2kg_smallparcel' 		=> 13.00,

			'w1_0-0.1kg_smallparcel' 		=> 7.15,
			'w1_0.1-0.250kg_smallparcel' 	=> 8.30,
			'w1_0.250-0.500kg_smallparcel'	=> 12.10,
			'w1_0.500-0.750kg_smallparcel'	=> 14.85,
			'w1_0.750-1kg_smallparcel'		=> 17.65,
			'w1_1-1.25kg_smallparcel'		=> 19.85,
			'w1_1.25-1.5kg_smallparcel'		=> 22.10,
			'w1_1.5-1.75kg_smallparcel'		=> 23.30,
			'w1_1.75-2kg_smallparcel'		=> 23.30,

			'w2_0-0.1kg_smallparcel'		=> 8.35,
			'w2_0.1-0.250kg_smallparcel'	=> 9.90,
			'w2_0.250-0.500kg_smallparcel'	=> 14.50,
			'w2_0.500-0.750kg_smallparcel'	=> 17.60,
			'w2_0.750-1kg_smallparcel'		=> 20.85,
			'w2_1-1.25kg_smallparcel'		=> 23.75,
			'w2_1.25-1.5kg_smallparcel'		=> 26.85,
			'w2_1.5-1.75kg_smallparcel' 	=> 28.55,
			'w2_1.75-2kg_smallparcel'		=> 28.55,

			'w3_0-0.1kg_smallparcel'		=> 9.35,
			'w3_0.1-0.250kg_smallparcel'	=> 10.95,
			'w3_0.250-0.500kg_smallparcel'	=> 16.60,
			'w3_0.500-0.750kg_smallparcel'	=> 19.35,
			'w3_0.750-1kg_smallparcel'		=> 23.00,
			'w3_1-1.25kg_smallparcel'		=> 26.45,
			'w3_1.25-1.5kg_smallparcel'		=> 29.20,
			'w3_1.5-1.75kg_smallparcel'		=> 30.45,
			'w3_1.75-2kg_smallparcel'		=> 30.45,
		)
	),
	
	array(
		'name' => 'Royal Mail International Tracked and Signed',
		'id' => 'international_tracked_signed',
		'special_services' => array(
		),
		'rules' => array( 
			//letter
			'eu_0-0.01kg_letter' 	=> 6.85,
			'eu_0.01-0.02kg_letter' => 6.85,
			'eu_0.02-0.1kg_letter' 	=> 6.85,
			
			'w1_0-0.01kg_letter' 	=> 6.85,
			'w1_0.01-0.02kg_letter' => 6.85,
			'w1_0.02-0.1kg_letter' 	=> 7.85,
			
			'w2_0-0.01kg_letter' 	=> 6.85,
			'w2_0.01-0.02kg_letter' => 6.85,
			'w2_0.02-0.1kg_letter'	=> 7.85,


			'w3_0-0.01kg_letter'	=> 6.85,
			'w3_0.01-0.02kg_letter'	=> 6.85,
			'w3_0.02-0.1kg_letter'	=> 7.85,
			
			//large letter
			'eu_0-0.1kg_largeletter' 		=> 8.75,
			'eu_0.1-0.250kg_largeletter' 	=> 9.20,
			'eu_0.250-0.500kg_largeletter' 	=> 9.95,
			'eu_0.500-0.750kg_largeletter' 	=> 10.35,
			
			'w1_0-0.1kg_largeletter' 		=> 9.70,
			'w1_0.1-0.250kg_largeletter' 	=> 10.50,
			'w1_0.250-0.500kg_largeletter' 	=> 12.30,
			'w1_0.500-0.750kg_largeletter' 	=> 14.15,

			'w2_0-0.1kg_largeletter' 		=> 9.80,
			'w2_0.1-0.250kg_largeletter' 	=> 11.55,
			'w2_0.250-0.500kg_largeletter' 	=> 14.10,
			'w2_0.500-0.750kg_largeletter' 	=> 16.90,

			'w3_0-0.1kg_largeletter'		=> 9.75,
			'w3_0.1-0.250kg_largeletter'	=> 10.65,
			'w3_0.250-0.500kg_largeletter'	=> 12.60,
			'w3_0.500-0.750kg_largeletter'	=> 14.60,

			//Small Parcel
			'eu_0-0.1kg_smallparcel' 		=> 10.50,
			'eu_0.1-0.250kg_smallparcel' 	=> 10.65,
			'eu_0.250-0.500kg_smallparcel' 	=> 12.10,
			'eu_0.500-0.750kg_smallparcel' 	=> 13.15,
			'eu_0.750-1kg_smallparcel' 		=> 14.10,
			'eu_1-1.25kg_smallparcel' 		=> 14.50,
			'eu_1.25-1.5kg_smallparcel' 	=> 15.05,
			'eu_1.5-1.75kg_smallparcel' 	=> 15.25,
			'eu_1.75-2kg_smallparcel' 		=> 15.25,

			'w1_0-0.1kg_smallparcel' 		=> 12.00,
			'w1_0.1-0.250kg_smallparcel' 	=> 12.95,
			'w1_0.250-0.500kg_smallparcel' 	=> 16.60,
			'w1_0.500-0.750kg_smallparcel' 	=> 19.00,
			'w1_0.750-1kg_smallparcel' 		=> 21.65,
			'w1_1-1.25kg_smallparcel' 		=> 23.50,
			'w1_1.25-1.5kg_smallparcel' 	=> 24.90,
			'w1_1.5-1.75kg_smallparcel' 	=> 25.35,
			'w1_1.75-2kg_smallparcel' 		=> 25.35,

			'w2_0-0.1kg_smallparcel' 		=> 13.05,
			'w2_0.1-0.250kg_smallparcel' 	=> 14.40,
			'w2_0.250-0.500kg_smallparcel' 	=> 18.80,
			'w2_0.500-0.750kg_smallparcel' 	=> 21.60,
			'w2_0.750-1kg_smallparcel' 		=> 24.75,
			'w2_1-1.25kg_smallparcel' 		=> 27.15,
			'w2_1.25-1.5kg_smallparcel' 	=> 29.65,
			'w2_1.5-1.75kg_smallparcel' 	=> 30.70,
			'w2_1.75-2kg_smallparcel' 		=> 30.70,

			'w3_0-0.1kg_smallparcel' 		=> 13.85,
			'w3_0.1-0.250kg_smallparcel' 	=> 15.45,
			'w3_0.250-0.500kg_smallparcel' 	=> 20.85,
			'w3_0.500-0.750kg_smallparcel' 	=> 22.85,
			'w3_0.750-1kg_smallparcel' 		=> 26.50,
			'w3_1-1.25kg_smallparcel' 		=> 29.95,
			'w3_1.25-1.5kg_smallparcel' 	=> 32.70,
			'w3_1.5-1.75kg_smallparcel' 	=> 33.20,
			'w3_1.75-2kg_smallparcel' 		=> 33.20,
		)
	),

	array(
		'name' => 'Royal Mail International Tracked',
		'id' => 'international_tracked',
		'special_services' => array(
			'noneu' => true, //Contains noneu rules
		),
		'rules' => array( 
			// letter
			'eu_0-0.01kg_letter' 	=> 6.75,
			'eu_0.01-0.02kg_letter' => 6.75,
			'eu_0.02-0.1kg_letter' 	=> 6.75,
			
			/*'noneu_0-0.01kg_letter' 	=> 6.75,
			'noneu_0.01-0.02kg_letter' 	=> 6.75,
			'noneu_0.02-0.1kg_letter' 	=> 6.75,*/

			'w1_0-0.01kg_letter' 	=> 6.75,
			'w1_0.01-0.02kg_letter' => 6.75,
			'w1_0.02-0.1kg_letter' 	=> 7.75,

			'w2_0-0.01kg_letter' 	=> 6.75,
			'w2_0.01-0.02kg_letter' => 6.75,
			'w2_0.02-0.1kg_letter' 	=> 7.75,

			'w3_0-0.01kg_letter' 	=> 6.75,
			'w3_0.01-0.02kg_letter' => 6.75,
			'w3_0.02-0.1kg_letter' 	=> 7.75,

			// large letter
			'eu_0-0.1kg_largeletter' 		=> 8.65,
			'eu_0.1-0.250kg_largeletter' 	=> 8.85,
			'eu_0.250-0.500kg_largeletter' 	=> 9.85,
			'eu_0.500-0.750kg_largeletter' 	=> 10.25,

		/*'noneu_0-0.1kg_largeletter' 		=> 8.65,
			'noneu_0.1-0.250kg_largeletter' 	=> 8.85,
			'noneu_0.250-0.500kg_largeletter'	=> 9.85,
			'noneu_0.500-0.750kg_largeletter' 	=> 10.25,*/

			'w1_0-0.1kg_largeletter' 		=> 9.60,
			'w1_0.1-0.250kg_largeletter' 	=> 10.35,
			'w1_0.250-0.500kg_largeletter' 	=> 12.20,
			'w1_0.500-0.750kg_largeletter' 	=> 14.05,

			'w2_0-0.1kg_largeletter' 		=> 9.65,
			'w2_0.1-0.250kg_largeletter' 	=> 11.45,
			'w2_0.250-0.500kg_largeletter' 	=> 14.00,
			'w2_0.500-0.750kg_largeletter' 	=> 16.80,

			'w3_0-0.1kg_largeletter' 		=> 9.65,
			'w3_0.1-0.250kg_largeletter' 	=> 10.55,
			'w3_0.250-0.500kg_largeletter' 	=> 12.50,
			'w3_0.500-0.750kg_largeletter' 	=> 14.50,

			//Small parcel and printer papers
			'eu_0-0.1kg_smallparcel' 		=> 10.10,
			'eu_0.1-0.250kg_smallparcel' 	=> 10.25,
			'eu_0.250-0.500kg_smallparcel' 	=> 11.70,
			'eu_0.500-0.750kg_smallparcel' 	=> 12.75,
			'eu_0.750-1kg_smallparcel' 		=> 13.70,
			'eu_1-1.25kg_smallparcel' 		=> 14.10,
			'eu_1.25-1.5kg_smallparcel' 	=> 14.85,
			'eu_1.5-1.75kg_smallparcel' 	=> 15.25,
			'eu_1.75-2kg_smallparcel' 		=> 15.25,

			/*'noneu_0-0.1kg_smallparcel' 		=> 10.10,
			'noneu_0.1-0.250kg_smallparcel' 	=> 10.25,
			'noneu_0.250-0.500kg_smallparcel' 	=> 11.70,
			'noneu_0.500-0.750kg_smallparcel' 	=> 12.75,
			'noneu_0.750-1kg_smallparcel' 		=> 13.70,
			'noneu_1-1.25kg_smallparcel' 		=> 14.10,
			'noneu_1.25-1.5kg_smallparcel' 		=> 14.85,
			'noneu_1.5-1.75kg_smallparcel' 		=> 15.25,
			'noneu_0u_1.75-2kg_smallparcel' 		=> 15.25,*/

			'w1_0-0.1kg_smallparcel' 		=> 11.75,
			'w1_0.1-0.250kg_smallparcel' 	=> 12.70,
			'w1_0.250-0.500kg_smallparcel' 	=> 16.35,
			'w1_0.500-0.750kg_smallparcel' 	=> 18.75,
			'w1_0.750-1kg_smallparcel' 		=> 21.40,
			'w1_1-1.25kg_smallparcel' 		=> 23.25,
			'w1_1.25-1.5kg_smallparcel' 	=> 24.65,
			'w1_1.5-1.75kg_smallparcel' 	=> 25.65,
			'w1_1.75-2kg_smallparcel' 		=> 25.65,

			'w2_0-0.1kg_smallparcel' 		=> 12.80,
			'w2_0.1-0.250kg_smallparcel' 	=> 14.15,
			'w2_0.250-0.500kg_smallparcel' 	=> 18.55,
			'w2_0.500-0.750kg_smallparcel' 	=> 21.35,
			'w2_0.750-1kg_smallparcel' 		=> 24.50,
			'w2_1-1.25kg_smallparcel' 		=> 26.90,
			'w2_1.25-1.5kg_smallparcel' 	=> 29.40,
			'w2_1.5-1.75kg_smallparcel' 	=> 31.00,
			'w2_1.75-2kg_smallparcel' 		=> 31.00,

			'w3_0-0.1kg_smallparcel' 		=> 11.85,
			'w3_0.1-0.250kg_smallparcel' 	=> 13.45,
			'w3_0.250-0.500kg_smallparcel' 	=> 18.10,
			'w3_0.500-0.750kg_smallparcel' 	=> 20.85,
			'w3_0.750-1kg_smallparcel' 		=> 24.50,
			'w3_1-1.25kg_smallparcel' 		=> 27.95,
			'w3_1.25-1.5kg_smallparcel' 	=> 30.70,
			'w3_1.5-1.75kg_smallparcel' 	=> 31.95,
			'w3_1.75-2kg_smallparcel' 		=> 31.95,

		)
	),

	array(
		'name' => 'Royal Mail International Signed',
		'id' => 'international_signed',
		'special_services' => array(
		),
		'rules' => array( 
			// letter
			'eu_0-0.01kg_letter' 	=> 6.85,
			'eu_0.01-0.02kg_letter' => 6.85,
			'eu_0.02-0.1kg_letter' 	=> 6.85,
			
			'w1_0-0.01kg_letter' 	=> 6.85,
			'w1_0.01-0.02kg_letter' => 6.85,
			'w1_0.02-0.1kg_letter' 	=> 7.85,

			'w2_0-0.01kg_letter' 	=> 6.85,
			'w2_0.01-0.02kg_letter' => 6.85,
			'w2_0.02-0.1kg_letter' 	=> 7.85,

			// large letter
			'eu_0-0.1kg_largeletter' 		=> 8.75,
			'eu_0.1-0.250kg_largeletter' 	=> 9.20,
			'eu_0.250-0.500kg_largeletter' 	=> 9.95,
			'eu_0.500-0.750kg_largeletter' 	=> 10.35,

			'w1_0-0.1kg_largeletter' 		=> 9.70,
			'w1_0.1-0.250kg_largeletter' 	=> 10.50,
			'w1_0.250-0.500kg_largeletter' 	=> 12.30,
			'w1_0.500-0.750kg_largeletter' 	=> 14.15,

			'w2_0-0.1kg_largeletter' 		=> 9.80,
			'w2_0.1-0.250kg_largeletter' 	=> 11.55,
			'w2_0.250-0.500kg_largeletter' 	=> 14.10,
			'w2_0.500-0.750kg_largeletter' 	=> 16.90,

			//Small parcel and printer papers
			'eu_0-0.1kg_smallparcel' 		=> 10.50,
			'eu_0.1-0.250kg_smallparcel' 	=> 10.65,
			'eu_0.250-0.500kg_smallparcel' 	=> 12.10,
			'eu_0.500-0.750kg_smallparcel' 	=> 13.15,
			'eu_0.750-1kg_smallparcel'		=> 14.10,
			'eu_1-1.25kg_smallparcel' 		=> 14.50,
			'eu_1.25-1.5kg_smallparcel' 	=> 15.05,
			'eu_1.5-1.75kg_smallparcel' 	=> 15.25,
			'eu_1.75-2kg_smallparcel' 		=> 15.25,

			'w1_0-0.1kg_smallparcel' 		=> 12.00,
			'w1_0.1-0.250kg_smallparcel' 	=> 12.95,
			'w1_0.250-0.500kg_smallparcel' 	=> 16.60,
			'w1_0.500-0.750kg_smallparcel' 	=> 19.00,
			'w1_0.750-1kg_smallparcel' 		=> 21.65,
			'w1_1-1.25kg_smallparcel' 		=> 23.50,
			'w1_1.25-1.5kg_smallparcel' 	=> 24.90,
			'w1_1.5-1.75kg_smallparcel' 	=> 25.35,
			'w1_1.75-2kg_smallparcel' 		=> 25.35,

			'w2_0-0.1kg_smallparcel' 		=> 13.05,
			'w2_0.1-0.250kg_smallparcel' 	=> 14.40,
			'w2_0.250-0.500kg_smallparcel' 	=> 18.80,
			'w2_0.500-0.750kg_smallparcel' 	=> 21.60,
			'w2_0.750-1kg_smallparcel' 		=> 24.75,
			'w2_1-1.25kg_smallparcel' 		=> 27.15,
			'w2_1.25-1.5kg_smallparcel' 	=> 29.65,
			'w2_1.5-1.75kg_smallparcel' 	=> 30.70,
			'w2_1.75-2kg_smallparcel' 		=> 30.70,

		)
	),
	
	array(
		'name' => 'Royal Mail International Economy',
		'id' => 'international_economy',
		'special_services' => array(
		),
		'rules' => array( 
			// letter
			'0-0.01kg_letter' 		=> 1.45,
			'0.01-0.02kg_letter' 	=> 1.45,
			'0.02-0.1kg_letter' 	=> 1.55,
									
			//Large Letter
			'0-0.1kg_largeletter' 		=> 3.00,
			'0.1-0.250kg_largeletter' 	=> 4.00,
			'0.250-0.500kg_largeletter' => 4.90,
			'0.500-0.750kg_largeletter' => 5.90,

			//Small Parcels and Printed Papers
			'0-0.1kg_smallparcel' 		=> 4.85,
			'0.1-0.250kg_smallparcel' 	=> 5.20,
			'0.250-0.500kg_smallparcel' => 7.45,
			'0.500-0.750kg_smallparcel' => 8.70,
			'0.750-1kg_smallparcel' 	=> 9.50,
			'1-1.25kg_smallparcel' 		=> 10.55,
			'1.25-1.5kg_smallparcel' 	=> 11.65,
			'1.5-1.75kg_smallparcel' 	=> 12.80,
			'1.75-2kg_smallparcel' 		=> 12.95,
		),
	),

);