<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class phive_parcelforce_rate_calculator {
	private $package;
	private $special_services;
	private $boxes;
	public function __construct() {
		$this->settings 			= get_option( 'woocommerce_'.PHive_Royal_Mail_ID.'_settings', null );
		$this->debug 				= ( $bool = $this->settings[ 'debug' ] ) && $bool == 'yes' ? true : false;
		$this->set_boxes();
		$this->rules = include('data-rate-rules.php');
	}
	public function set_boxes(){
		$this->boxes = include('data-boxes.php');
	}
	public function set_packages($packages){
		$this->packages = $packages;
	}

	public function calculate_rate( $packages=array(), $special_services=array() ){

		$wc_currency = apply_filters('ph_change_woocommerce_currency_for_multicurrency', get_woocommerce_currency() );
		
		if($wc_currency != "GBP" ){
			return array();
		}



		$rules = array();
		$rates = array();
		$this->packages = $packages;
		
		$this->special_services = $special_services;

		if( count($this->packages) == 0  ){
			return array();
		}

		foreach ($this->packages as $key => $package) {
			$zones = $this->find_zones( $package['destination']['country'] );
			$this->debug( "Parcelforce satisfied zones for package '$key': <pre>".print_r($zones,1)."</pre>" );
			
			$rules = $this->find_rules(
				array(
					'zone'		=> $zones,
					'weight'	=> $package['weight']['value'],
					'box'		=> isset($package['package_id']) ? $package['package_id'] : '',
				)
			);
			$this->debug("Parcelforce Rules for package '$key': <pre>".print_r($rules,1)."</pre>");
			$rates = array_merge( $rates, $this->find_rates( $rules, $package ) );
		}

		// in_array( get_woocommerce_currency(), array( 'USD' ) );
		return $rates;
	}

	private function find_rates($rule, $package){
		$all_rates = include('data-rates.php');
		$find_rates = array();
		foreach ($all_rates as $rate) {
			$fount = array_intersect_key( $rate['rules'], array_flip($rule) );
			if( count($fount) ){

				if ( is_array( current($fount) ) ){
					$rate_arr = current($fount);
					if( isset($rate_arr['basecost']) && isset($rate_arr['perweight']) ){
						$rule_key = array_keys($fount)[0];
						$cost = $this->find_per_weight_cost( $rate_arr, $this->rules[$rule_key], $package );
					}
				}else{
					$cost = min($fount);
				}

				$surcharges = 0;
				if( in_array('insurance', $this->special_services) ){
					$surcharges += $this->get_insured_rate( $rate, $package['cost']['amount'] );
					$this->debug( 'Adding isurance charge ' );
				}
				if( in_array('signature', $this->special_services) ){
					$surcharges += $this->get_signature_rate( $rate );
					$this->debug( 'Adding Signature charge ' );
				}
				$find_rates[] = array(
					'code' => $rate['id'],
					'id' => $rate['id'],
					'name' => $rate['name'],
					'cost' => floatval( $cost ) + $surcharges,
				);
			}
		}
		$this->debug( 'Parcelforce Rate found <pre>'.print_r($find_rates,1).'</pre>' );
		return $find_rates;
	}

	private function find_per_weight_cost( $rate, $rule, $package){
		$weight = $package['weight']['value'] - $rule['min_weight'];
		$weight_intervals = ($weight/$rule['per_weight']) > 0 ? ceil($weight/$rule['per_weight']) : 1;
		return $rate['basecost'] + ($weight_intervals * $rate['perweight']);
	}

	private function get_signature_rate($rate){
		if( !empty( $rate['special_services']['signature_cost'] ) ){
			return $rate['special_services']['signature_cost'];
		}else{
			return 0;
		}
	}

	private function get_insured_rate($rate, $package_cost){
		if( !empty( $rate['special_services']['insured_cost'] ) ){
			$rules = include('data-rate-rules.php');
			foreach( $rate['special_services']['insured_cost'] as $rule => $cost ){
				if( $this->phive_is_eligible_rule( $rules[$rule], array('price'=>$package_cost ) ) ){
					return $cost;
				}
			}
		}
		return 0;
	}

	private function find_zones($country){
		$zones = array();
		$this->zones = include('data-zones.php');
		foreach ($this->zones as $zone_name => $zone_countries) {
			if( in_array( $country, $zone_countries) ){
				return $zone_name;
			}
		}

		return 'zone12'; //Rest of the world
	}

	private function find_rules( $input_values ){
		$eligible_rules = array();
		foreach ($this->rules as $rule_name => $rule) {
			if( $this->phive_is_eligible_rule( $rule, $input_values ) ){
				$eligible_rules[] = $rule_name;
			}
		}
		return $eligible_rules;
	}

	private function phive_is_eligible_rule( $rule, $input_values ){		
		foreach ($rule as $filter_name => $rule_value ) {
			if( false == $this->phive_compare_rule_field( $filter_name, $rule_value, $input_values ) ){
				return false;
			}
		}
		return true;
	}

	private function phive_compare_rule_field( $filter_name, $rule_value, $input_values ) {
		if(empty($filter_name)){
			return true;
		}
		//Case of zone
		if( is_array($rule_value ) ){
			return in_array( $input_values[$filter_name], $rule_value );
		}

		// if string
		if( !is_numeric($rule_value) ){
			
			//if the rule filed is not defined.
			if( !isset( $input_values[$filter_name] ) ){
				return false;
			}else{
				return $rule_value == $input_values[$filter_name];
			}
		}

		$input_key = str_replace( 'per_', '', str_replace( 'min_', '', str_replace('max_', '', $filter_name) ) );
		if( empty($input_values[$input_key]) ){
			return false;
		}
		if( strpos($filter_name, 'max') !== false  ){
			return $input_values[$input_key] <= $rule_value;
		}elseif( strpos($filter_name, 'min') !== false  ){
			return $input_values[$input_key] > $rule_value;
		}elseif( strpos($filter_name, 'per') !== false  ){
			return true;
		}else{
			return $input_values[$input_key] == $rule_value;
		}
	}

	public function debug( $message, $type = 'notice' ) {
		if ( $this->debug ) {
			wc_add_notice( $message, $type );
		}
	}
}