<?php
return array(
	
	array(
		'name' 	=> 'Royal Mail Special Delivery by 1pm&reg;',
		'id' 	=> 'special_delivery_guaranteed_by_1',
		'special_services' 	=> array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 1,
				'price_1000-2500' 	=> 3,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 6.70,
			'uk_0.1-0.5kg' 	=> 7.50,
			'uk_0.5-1kg' 	=> 8.80,
			'uk_1-2kg' 		=> 11.00,
			'uk_2-10kg' 	=> 26.60,
			'uk_10-20kg' 	=> 41.20,
		)
	),

	array(
		'name' 	=> 'Royal Mail Special Delivery by 1pm&reg; with Saturday',
		'id' 	=> 'special_delivery_guaranteed_by_1_with_saturday',
		'special_services' 	=> array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 1.2,
				'price_1000-2500' 	=> 3.6,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 11.04,
			'uk_0.1-0.5kg' 	=> 12.00,
			'uk_0.5-1kg' 	=> 13.56,
			'uk_1-2kg' 		=> 16.20,
			'uk_2-10kg' 	=> 34.92,
			'uk_10-20kg' 	=> 52.44,
		)
	),

	array(
		'name' => 'Royal Mail Special Delivery by 9am&reg;',
		'id' => 'special_delivery_guaranteed_by_9am',
		'special_services' => array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 2.2,
				'price_1000-2500' 	=> 5.7,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg'	=> 20.24,
			'uk_0.1-0.5kg'	=> 22.89,
			'uk_0.5-1kg'	=> 24.81,
			'uk_1-2kg'		=> 29.70,
		)
	),

	array(
		'name' => 'Royal Mail Special Delivery by 9am&reg; with Saturday',
		'id' => 'special_delivery_guaranteed_by_9_with_saturday',
		'special_services' => array(
			'insured_cost'  => array(
				'price_500-1000' 	=> 2.2,
				'price_1000-2500' 	=> 5.7,
			),
		),
		'rules' => array( 
			'uk_0-0.1kg' 	=> 23.24,
			'uk_0.1-0.5kg' 	=> 25.89,
			'uk_0.5-1kg' 	=> 27.81,
			'uk_1-2kg' 		=> 32.70,
		)
	),

	array(
		'name' => 'Royal Mail 1st Class',
		'id' => '1st_class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 //Signature rates are added seperatly
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' => 0.76,
			'uk_0-0.1kg_largeletter' => 1.15,
			'uk_0.1-0.250kg_largeletter' => 1.64,
			'uk_0.250-0.500kg_largeletter' => 2.14,
			'uk_0.500-0.750kg_largeletter' => 2.95,

			'uk_0-1kg_smallparcel' => 3.70,
			'uk_1-2kg_smallparcel' => 5.57,

			'uk_0-1kg_mediumparcel' => 5.90,
			'uk_1-2kg_mediumparcel' => 9.02,
			'uk_2-5kg_mediumparcel' => 15.85,
			'uk_5-10kg_mediumparcel' => 21.90,
			'uk_10-20kg_mediumparcel' => 33.40,
		)
	),

	array(
		'name' => 'Royal Mail 1st Class Signed For',
		'id' => '1st_class_signedRoyal Mail 1st Class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' => 2.06,
			'uk_0-0.1kg_largeletter' => 2.45,
			'uk_0.1-0.250kg_largeletter' => 2.94,
			'uk_0.250-0.500kg_largeletter' => 3.44,
			'uk_0.500-0.750kg_largeletter' => 4.25,

			'uk_0-1kg_smallparcel' => 4.70,
			'uk_1-2kg_smallparcel' => 6.57,

			'uk_0-1kg_mediumparcel' => 6.90,
			'uk_1-2kg_mediumparcel' => 10.02,
			'uk_2-5kg_mediumparcel' => 16.85,
			'uk_5-10kg_mediumparcel' => 22.90,
			'uk_10-20kg_mediumparcel' => 34.40,
		)
	),

	array(
		'name' => 'Royal Mail 2nd Class',
		'id' => '2nd_class',
		'special_services' => array(
			// 'signature_cost'  => 1.1 //Signature rates are added seperatly
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' 			=> 0.65,
			'uk_0-0.1kg_largeletter' 		=> 0.88,
			'uk_0.1-0.250kg_largeletter' 	=> 1.40,
			'uk_0.250-0.500kg_largeletter' 	=> 1.83,
			'uk_0.500-0.750kg_largeletter' 	=> 2.48,

			'uk_0-1kg_smallparcel' 			=> 3.10,
			'uk_1-2kg_smallparcel'			=> 3.10,

			'uk_0-1kg_mediumparcel' 		=> 5.20,
			'uk_1-2kg_mediumparcel' 		=> 5.20,
			'uk_2-5kg_mediumparcel' 		=> 8.99,
			'uk_5-10kg_mediumparcel' 		=> 20.25,
			'uk_10-20kg_mediumparcel' 		=> 28.55,
		)
	),

	array(
		'name' => 'Royal Mail 2nd Class Signed For',
		'id' => '2nd_class_signed',
		'special_services' => array(
			// 'signature_cost'  => 1.1
		),
		'rules' => array( 
			'uk_0-0.1kg_letter' => 1.95,
			'uk_0-0.1kg_largeletter' => 2.18,
			'uk_0.1-0.250kg_largeletter' => 2.70,
			'uk_0.250-0.500kg_largeletter' => 3.13,
			'uk_0.500-0.750kg_largeletter' => 3.78,

			'uk_0-1kg_smallparcel' => 4.10,
			'uk_1-2kg_smallparcel' => 4.10,

			'uk_0-1kg_mediumparcel' => 6.20,
			'uk_1-2kg_mediumparcel' => 6.20,
			'uk_2-5kg_mediumparcel' => 9.99,
			'uk_5-10kg_mediumparcel' => 21.25,
			'uk_10-20kg_mediumparcel' => 29.55,
		)
	),

	// International services

	array(
		'name' => 'Royal Mail International Standard',
		'id' => 'international_standard',
		'special_services' => array(
		),
		'rules' => array( 
			//letter
			'eu_0-0.01kg_letter' => 1.42,
			'eu_0.01-0.02kg_letter' => 1.42,
			'eu_0.02-0.1kg_letter' => 1.68,
			
			'w1_0-0.01kg_letter' => 1.42,
			'w1_0.01-0.02kg_letter' => 1.63,
			'w1_0.02-0.1kg_letter' => 2.42,
			
			'w2_0-0.01kg_letter' => 1.42,
			'w2_0.01-0.02kg_letter' => 1.63,
			'w2_0.02-0.1kg_letter' => 2.42,

			'w3_0-0.01kg_letter'	=> 1.42,
			'w3_0.01-0.02kg_letter'	=> 1.63,
			'w3_0.02-0.1kg_letter'	=> 2.42,
			
			//large letter
			'eu_0-0.1kg_largeletter' => 2.97,
			'eu_0.1-0.250kg_largeletter' => 4.24,
			'eu_0.250-0.500kg_largeletter' => 4.88,
			'eu_0.500-0.750kg_largeletter' => 5.83,

			'w1_0-0.1kg_largeletter' => 3.66,
			'w1_0.1-0.250kg_largeletter' => 5.30,
			'w1_0.250-0.500kg_largeletter' => 7.21,
			'w1_0.500-0.750kg_largeletter' => 9.22,

			'w2_0-0.1kg_largeletter' => 3.82,
			'w2_0.1-0.250kg_largeletter' => 5.62,
			'w2_0.250-0.500kg_largeletter' => 7.63,
			'w2_0.500-0.750kg_largeletter' => 9.81,

			'w3_0-0.1kg_largeletter'		=> 3.66,
			'w3_0.1-0.250kg_largeletter'	=> 5.30,
			'w3_0.250-0.500kg_largeletter'	=> 7.21,
			'w3_0.500-0.750kg_largeletter'	=> 9.22,

			//Small Parcel
			'eu_0-0.1kg_smallparcel' => 5.11,
			'eu_0.1-0.250kg_smallparcel' => 5.35,
			'eu_0.250-0.500kg_smallparcel' => 7.25,
			'eu_0.500-0.750kg_smallparcel' => 8.47,
			'eu_0.750-1kg_smallparcel' => 9.53,
			'eu_1-1.25kg_smallparcel' => 10.38,
			'eu_1.25-1.5kg_smallparcel' => 11.39,
			'eu_1.5-1.75kg_smallparcel' => 12.11,
			'eu_1.75-2kg_smallparcel' => 12.52,

			'w1_0-0.1kg_smallparcel' => 5.80,
			'w1_0.1-0.250kg_smallparcel' => 6.63,
			'w1_0.250-0.500kg_smallparcel' => 10.06,
			'w1_0.500-0.750kg_smallparcel' => 12.23,
			'w1_0.750-1kg_smallparcel' => 14.49,
			'w1_1-1.25kg_smallparcel' => 16.35,
			'w1_1.25-1.5kg_smallparcel' => 18.01,
			'w1_1.5-1.75kg_smallparcel' => 18.38,
			'w1_1.75-2kg_smallparcel' => 19.22,

			'w2_0-0.1kg_smallparcel' => 6.24,
			'w2_0.1-0.250kg_smallparcel' => 7.18,
			'w2_0.250-0.500kg_smallparcel' => 10.83,
			'w2_0.500-0.750kg_smallparcel' => 13.02,
			'w2_0.750-1kg_smallparcel' => 15.28,
			'w2_1-1.25kg_smallparcel' => 17.40,
			'w2_1.25-1.5kg_smallparcel' => 19.39,
			'w2_1.5-1.75kg_smallparcel' => 19.95,
			'w2_1.75-2kg_smallparcel' => 21.05,

			'w3_0-0.1kg_smallparcel'		=> 8.38,
			'w3_0.1-0.250kg_smallparcel'	=> 9.84,
			'w3_0.250-0.500kg_smallparcel'	=> 15.18,
			'w3_0.500-0.750kg_smallparcel'	=> 17.73,
			'w3_0.750-1kg_smallparcel'		=> 21.18,
			'w3_1-1.25kg_smallparcel'		=> 24.33,
			'w3_1.25-1.5kg_smallparcel'		=> 26.98,
			'w3_1.5-1.75kg_smallparcel'		=> 28.15,
			'w3_1.75-2kg_smallparcel'		=> 29.71,
		)
	),
	
	array(
		'name' => 'Royal Mail International Tracked and Signed',
		'id' => 'international_tracked_Signed',
		'special_services' => array(
		),
		'rules' => array( 
			//letter
			'eu_0-0.01kg_letter' => 6.41,
			'eu_0.01-0.02kg_letter' => 6.41,
			'eu_0.02-0.1kg_letter' => 6.88,
			
			'w1_0-0.01kg_letter' => 6.41,
			'w1_0.01-0.02kg_letter' => 6.77,
			'w1_0.02-0.1kg_letter' => 7.67,
			
			'w2_0-0.01kg_letter' => 6.41,
			'w2_0.01-0.02kg_letter' => 6.77,
			'w2_0.02-0.1kg_letter' => 7.67,

			'w3_0-0.01kg_letter'	=> 6.41,
			'w3_0.01-0.02kg_letter'	=> 6.77,
			'w3_0.02-0.1kg_letter'	=> 7.67,
			
			//large letter
			'eu_0-0.1kg_largeletter' => 8.48,
			'eu_0.1-0.250kg_largeletter' => 8.96,
			'eu_0.250-0.500kg_largeletter' => 9.33,
			'eu_0.500-0.750kg_largeletter' => 9.70,
			
			'w1_0-0.1kg_largeletter' => 9.17,
			'w1_0.1-0.250kg_largeletter' => 10.07,
			'w1_0.250-0.500kg_largeletter' => 11.50,
			'w1_0.500-0.750kg_largeletter' => 12.72,

			'w2_0-0.1kg_largeletter' => 9.38,
			'w2_0.1-0.250kg_largeletter' => 10.39,
			'w2_0.250-0.500kg_largeletter' => 11.87,
			'w2_0.500-0.750kg_largeletter' => 13.20,

			'w3_0-0.1kg_largeletter'		=> 9.17,
			'w3_0.1-0.250kg_largeletter'	=> 10.07,
			'w3_0.250-0.500kg_largeletter'	=> 11.50,
			'w3_0.500-0.750kg_largeletter'	=> 12.72,

			//Small Parcel
			'eu_0-0.1kg_smallparcel' => 9.86,
			'eu_0.1-0.250kg_smallparcel' => 9.90,
			'eu_0.250-0.500kg_smallparcel' => 11.55,
			'eu_0.500-0.750kg_smallparcel' => 12.57,
			'eu_0.750-1kg_smallparcel' => 13.43,
			'eu_1-1.25kg_smallparcel' => 13.83,
			'eu_1.25-1.5kg_smallparcel' => 14.54,
			'eu_1.5-1.75kg_smallparcel' => 14.81,
			'eu_1.75-2kg_smallparcel' => 15.02,

			'w1_0-0.1kg_smallparcel' => 10.65,
			'w1_0.1-0.250kg_smallparcel' => 11.28,
			'w1_0.250-0.500kg_smallparcel' => 14.56,
			'w1_0.500-0.750kg_smallparcel' => 16.38,
			'w1_0.750-1kg_smallparcel' => 18.49,
			'w1_1-1.25kg_smallparcel' => 20.00,
			'w1_1.25-1.5kg_smallparcel' => 20.81,
			'w1_1.5-1.75kg_smallparcel' => 20.98,
			'w1_1.75-2kg_smallparcel' => 21.27,

			'w2_0-0.1kg_smallparcel' => 10.94,
			'w2_0.1-0.250kg_smallparcel' => 11.68,
			'w2_0.250-0.500kg_smallparcel' => 15.13,
			'w2_0.500-0.750kg_smallparcel' => 17.02,
			'w2_0.750-1kg_smallparcel' => 19.18,
			'w2_1-1.25kg_smallparcel' => 20.80,
			'w2_1.25-1.5kg_smallparcel' => 22.19,
			'w2_1.5-1.75kg_smallparcel' => 22.65,
			'w2_1.75-2kg_smallparcel' => 23.20,

			'w3_0-0.1kg_smallparcel' 		=> 12.88,
			'w3_0.1-0.250kg_smallparcel' 	=> 14.34,
			'w3_0.250-0.500kg_smallparcel' 	=> 18.68,
			'w3_0.500-0.750kg_smallparcel' 	=> 21.23,
			'w3_0.750-1kg_smallparcel' 		=> 24.68,
			'w3_1-1.25kg_smallparcel' 		=> 27.83,
			'w3_1.25-1.5kg_smallparcel' 	=> 30.48,
			'w3_1.5-1.75kg_smallparcel' 	=> 31.65,
			'w3_1.75-2kg_smallparcel' 		=> 33.21,
		)
	),

	array(
		'name' => 'Royal Mail International Tracked',
		'id' => 'international_tracked',
		'special_services' => array(
			'noneu' => true, //Contains noneu rules
		),
		'rules' => array( 
			// letter
			'eu_0-0.01kg_letter' => 7.69,
			'eu_0.01-0.02kg_letter' => 7.69,
			'eu_0.02-0.1kg_letter' => 8.26,
			
			'noneu_0-0.01kg_letter' => 6.41,
			'noneu_0.01-0.02kg_letter' => 6.41,
			'noneu_0.02-0.1kg_letter' => 6.88,

			'w1_0-0.01kg_letter' => 6.41,
			'w1_0.01-0.02kg_letter' => 6.77,
			'w1_0.02-0.1kg_letter' => 7.67,

			'w2_0-0.01kg_letter' => 6.41,
			'w2_0.01-0.02kg_letter' => 6.77,
			'w2_0.02-0.1kg_letter' => 7.67,

			'w3_0-0.01kg_letter' 	=> 6.41,
			'w3_0.01-0.02kg_letter' => 6.77,
			'w3_0.02-0.1kg_letter' 	=> 7.67,

			// large letter
			'eu_0-0.1kg_largeletter' => 10.18,
			'eu_0.1-0.250kg_largeletter' => 10.75,
			'eu_0.250-0.500kg_largeletter' => 11.20,
			'eu_0.500-0.750kg_largeletter' => 11.64,

			'noneu_0-0.1kg_largeletter' => 8.48,
			'noneu_0.1-0.250kg_largeletter' => 8.96,
			'noneu_0.250-0.500kg_largeletter' => 9.33,
			'noneu_0.500-0.750kg_largeletter' => 9.70,

			'w1_0-0.1kg_largeletter' => 9.17,
			'w1_0.1-0.250kg_largeletter' => 10.07,
			'w1_0.250-0.500kg_largeletter' => 11.50,
			'w1_0.500-0.750kg_largeletter' => 12.72,

			'w2_0-0.1kg_largeletter' => 9.38,
			'w2_0.1-0.250kg_largeletter' => 10.39,
			'w2_0.250-0.500kg_largeletter' => 11.87,
			'w2_0.500-0.750kg_largeletter' => 13.20,

			'w3_0-0.1kg_largeletter' 		=> 9.17,
			'w3_0.1-0.250kg_largeletter' 	=> 10.07,
			'w3_0.250-0.500kg_largeletter' 	=> 11.50,
			'w3_0.500-0.750kg_largeletter' 	=> 12.72,

			//Small parcel and printer papers
			'eu_0-0.1kg_smallparcel' => 11.83,
			'eu_0.1-0.250kg_smallparcel' => 11.88,
			'eu_0.250-0.500kg_smallparcel' => 13.86,
			'eu_0.500-0.750kg_smallparcel' => 15.08,
			'eu_0.750-1kg_smallparcel' => 16.12,
			'eu_1-1.25kg_smallparcel' => 16.60,
			'eu_1.25-1.5kg_smallparcel' => 17.45,
			'eu_1.5-1.75kg_smallparcel' => 17.77,
			'eu_1.75-2kg_smallparcel' => 18.03,

			'noneu_0-0.1kg_smallparcel' => 9.86,
			'noneu_0.1-0.250kg_smallparcel' => 9.90,
			'noneu_0.250-0.500kg_smallparcel' => 11.55,
			'noneu_0.500-0.750kg_smallparcel' => 12.57,
			'noneu_0.750-1kg_smallparcel' => 13.43,
			'noneu_1-1.25kg_smallparcel' => 13.83,
			'noneu_1.25-1.5kg_smallparcel' => 14.54,
			'noneu_1.5-1.75kg_smallparcel' => 14.81,
			'noneu_1.75-2kg_smallparcel' => 15.02,

			'w1_0-0.1kg_smallparcel' => 10.65,
			'w1_0.1-0.250kg_smallparcel' => 11.28,
			'w1_0.250-0.500kg_smallparcel' => 14.56,
			'w1_0.500-0.750kg_smallparcel' => 16.38,
			'w1_0.750-1kg_smallparcel' => 18.49,
			'w1_1-1.25kg_smallparcel' => 20.00,
			'w1_1.25-1.5kg_smallparcel' => 20.81,
			'w1_1.5-1.75kg_smallparcel' => 20.98,
			'w1_1.75-2kg_smallparcel' => 21.27,

			'w2_0-0.1kg_smallparcel' => 10.94,
			'w2_0.1-0.250kg_smallparcel' => 11.68,
			'w2_0.250-0.500kg_smallparcel' => 15.13,
			'w2_0.500-0.750kg_smallparcel' => 17.02,
			'w2_0.750-1kg_smallparcel' => 19.18,
			'w2_1-1.25kg_smallparcel' => 20.80,
			'w2_1.25-1.5kg_smallparcel' => 22.19,
			'w2_1.5-1.75kg_smallparcel' => 22.65,
			'w2_1.75-2kg_smallparcel' => 23.20,

			'w3_0-0.1kg_smallparcel' 		=> 11.03,
			'w3_0.1-0.250kg_smallparcel' 	=> 12.34,
			'w3_0.250-0.500kg_smallparcel' 	=> 16.68,
			'w3_0.500-0.750kg_smallparcel' 	=> 19.23,
			'w3_0.750-1kg_smallparcel' 		=> 22.68,
			'w3_1-1.25kg_smallparcel' 		=> 25.83,
			'w3_1.25-1.5kg_smallparcel' 	=> 28.48,
			'w3_1.5-1.75kg_smallparcel' 	=> 29.65,
			'w3_1.75-2kg_smallparcel' 		=> 31.21,

		)
	),

	array(
		'name' => 'Royal Mail International Signed',
		'id' => 'international_signed',
		'special_services' => array(
		),
		'rules' => array( 
			// letter
			'eu_0-0.01kg_letter' => 6.41,
			'eu_0.01-0.02kg_letter' => 6.41,
			'eu_0.02-0.1kg_letter' => 6.88,
			
			'w1_0-0.01kg_letter' => 6.41,
			'w1_0.01-0.02kg_letter' => 6.77,
			'w1_0.02-0.1kg_letter' => 7.67,

			'w2_0-0.01kg_letter' => 6.41,
			'w2_0.01-0.02kg_letter' => 6.77,
			'w2_0.02-0.1kg_letter' => 7.67,

			// large letter
			'eu_0-0.1kg_largeletter' => 8.48,
			'eu_0.1-0.250kg_largeletter' => 8.96,
			'eu_0.250-0.500kg_largeletter' => 9.33,
			'eu_0.500-0.750kg_largeletter' => 9.70,

			'w1_0-0.1kg_largeletter' => 9.17,
			'w1_0.1-0.250kg_largeletter' => 10.07,
			'w1_0.250-0.500kg_largeletter' => 11.50,
			'w1_0.500-0.750kg_largeletter' => 12.72,

			'w2_0-0.1kg_largeletter' => 9.38,
			'w2_0.1-0.250kg_largeletter' => 10.39,
			'w2_0.250-0.500kg_largeletter' => 11.87,
			'w2_0.500-0.750kg_largeletter' => 13.20,

			//Small parcel and printer papers
			'eu_0-0.1kg_smallparcel' => 9.86,
			'eu_0.1-0.250kg_smallparcel' => 9.90,
			'eu_0.250-0.500kg_smallparcel' => 11.55,
			'eu_0.500-0.750kg_smallparcel' => 12.57,
			'eu_0.750-1kg_smallparcel' => 13.43,
			'eu_1-1.25kg_smallparcel' => 13.83,
			'eu_1.25-1.5kg_smallparcel' => 14.54,
			'eu_1.5-1.75kg_smallparcel' => 14.81,
			'eu_1.75-2kg_smallparcel' => 15.02,

			'w1_0-0.1kg_smallparcel' => 10.65,
			'w1_0.1-0.250kg_smallparcel' => 11.28,
			'w1_0.250-0.500kg_smallparcel' => 14.56,
			'w1_0.500-0.750kg_smallparcel' => 16.38,
			'w1_0.750-1kg_smallparcel' => 18.49,
			'w1_1-1.25kg_smallparcel' => 20.00,
			'w1_1.25-1.5kg_smallparcel' => 20.81,
			'w1_1.5-1.75kg_smallparcel' => 20.98,
			'w1_1.75-2kg_smallparcel' => 21.27,


			'w2_0-0.1kg_smallparcel' => 10.94,
			'w2_0.1-0.250kg_smallparcel' => 11.68,
			'w2_0.250-0.500kg_smallparcel' => 15.13,
			'w2_0.500-0.750kg_smallparcel' => 17.02,
			'w2_0.750-1kg_smallparcel' => 19.18,
			'w2_1-1.25kg_smallparcel' => 20.80,
			'w2_1.25-1.5kg_smallparcel' => 22.19,
			'w2_1.5-1.75kg_smallparcel' => 22.65,
			'w2_1.75-2kg_smallparcel' => 23.20,

		)
	),
	
	array(
		'name' => 'Royal Mail International Economy',
		'id' => 'international_economy',
		'special_services' => array(
		),
		'rules' => array( 
			// letter
			'0-0.01kg_letter' => 1.26,
			'0.01-0.02kg_letter' => 1.26,
			'0.02-0.1kg_letter' => 1.58,

			//Large Letter
			'0-0.1kg_largeletter' => 2.92,
			'0.1-0.250kg_largeletter' => 4.19,
			'0.250-0.500kg_largeletter' => 4.82,
			'0.500-0.750kg_largeletter' => 5.78,

			//Small Parcels and Printed Papers
			'0-0.1kg_smallparcel' => 4.57,
			'0.1-0.250kg_smallparcel' => 4.89,
			'0.250-0.500kg_smallparcel' => 7.04,
			'0.500-0.750kg_smallparcel' => 8.22,
			'0.750-1kg_smallparcel' => 9.51,
			'1-1.25kg_smallparcel' => 10.53,
			'1.25-1.5kg_smallparcel' => 11.66,
			'1.5-1.75kg_smallparcel' => 12.52,
			'1.75-2kg_smallparcel' => 12.95,
		),
	),

);