<tr valign="top" id="packing_options" class="royalmail_packaging_tab">
	<td class="titledesc" colspan="2" style="padding-left:0px">
	<strong><?php _e( 'Box Sizes', 'ph-shipping-royalmail' ); ?></strong><br><br>
		<style type="text/css">
			.royalmail_boxes td, .royalmail_services td {
				vertical-align: middle;
				padding-top: 4px;
				padding-bottom: 4px;
				padding-left: 7px;
				padding-right: 4px;
			}
			.royalmail_services th, .royalmail_boxes th {
				padding: 9px 7px;
			}
			.royalmail_boxes td input {
				margin-right: 4px;
			}
			.royalmail_boxes .check-column {
				vertical-align: middle;
				text-align: left;
				padding: 0 7px;
			}
			.royalmail_services th.sort {
				width: 16px;
				padding: 0 16px;
			}
			.royalmail_services td.sort {
				cursor: move;
				width: 16px;
				padding: 0 16px;
				cursor: move;
				background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAHUlEQVQYV2O8f//+fwY8gJGgAny6QXKETRgEVgAAXxAVsa5Xr3QAAAAASUVORK5CYII=) no-repeat center;
			}
		</style>
		<table class="royalmail_boxes widefat">
			<thead>
				<tr>
					<th class="check-column"></th>
					<th><?php _e( 'Name', 'ph-shipping-royalmail' ); ?></th>
					<th><?php _e( 'Length', 'ph-shipping-royalmail' ); ?></th>
					<th><?php _e( 'Width', 'ph-shipping-royalmail' ); ?></th>
					<th><?php _e( 'Height', 'ph-shipping-royalmail' ); ?></th>
					<th><?php _e( 'Max Weight', 'ph-shipping-royalmail' ); ?></th>
					<th><?php _e( 'Enabled', 'ph-shipping-royalmail' ); ?></th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<th colspan="7">
						<small class="description"><?php _e( 'Items will be packed into these boxes depending based on item dimensions and volume. Dimensions will be passed to Royal Mail and used for packing. Items not fitting into boxes will be packed individually.', 'ph-shipping-royalmail' ); ?></small>
					</th>
				</tr>
			</tfoot>
			<tbody id="rates">
				<?php
					if ( $this->default_boxes ) {
						foreach ( $this->default_boxes as $key => $box ) {
							?>
							<tr>
								<td class="check-column"></td>
								<td><input type="text" size="25" readonly value="<?php echo esc_attr( $box['name'] ); ?>" /></td>
								<td><input type="text" size="4" readonly value="<?php echo isset($box['length']) ? esc_attr( $box['length'] ) : ''; ?>" /><?php echo $this->dimension_unit;?></td>
								<td><input type="text" size="4" readonly value="<?php echo isset($box['width']) ? esc_attr( $box['width'] ) : ''; ?>" /><?php echo $this->dimension_unit;?></td>
								<td><input type="text" size="4" readonly value="<?php echo isset($box['height']) ? esc_attr( $box['height'] ) : ''; ?>" /><?php echo $this->dimension_unit;?></td>
								<td><input type="text" size="4" readonly value="<?php echo esc_attr( $box['max_weight'] ); ?>" /><?php echo $this->weight_unit;?></td>
								<td><input type="checkbox" name="boxes_enabled[<?php echo $box['id']; ?>]" <?php checked( ! isset( $this->boxes[ $box['id'] ]['enabled'] ) || $this->boxes[ $box['id'] ]['enabled'] == 1, true ); ?> /></td>
							</tr>
							<?php
						}
					}
					if ( $this->boxes ) {
						foreach ( $this->boxes as $key => $box ) {
							if ( ! is_numeric( $key ) )
								continue;
							?>

							<tr>
								<td class="check-column">
									<input type="checkbox" />
									<input type="hidden" name="box_type[]" value="<?php echo !empty($box['box_type']) ? $box['box_type'] : 'defaul_box';?>">
								</td>
								<td><input type="text" size="25" name="boxes_name[<?php echo $key; ?>]" value="<?php echo esc_attr( $box['name'] ); ?>"/></td>
								<td><input type="text" size="4" name="boxes_length[<?php echo $key; ?>]" value="<?php echo isset($box['length']) ? esc_attr( $box['length'] ) : ''; ?>" /><?php echo $this->dimension_unit;?></td>
								<td><input type="text" size="4" name="boxes_width[<?php echo $key; ?>]" value="<?php echo isset($box['width']) ? esc_attr( $box['width'] ) : ''; ?>" /><?php echo $this->dimension_unit;?></td>
								<td><input type="text" size="4" name="boxes_height[<?php echo $key; ?>]" value="<?php echo isset($box['height']) ? esc_attr( $box['height'] ) : ''; ?>" /><?php echo $this->dimension_unit;?></td>
								
								<td><input type="text" size="4" name="boxes_max_weight[<?php echo $key; ?>]" value="<?php echo esc_attr( $box['max_weight'] ); ?>" /><?php echo $this->weight_unit;?></td>
								<td><input type="checkbox" name="boxes_enabled[<?php echo $key; ?>]" <?php if( isset($box['enabled']) ) checked( $box['enabled'], true ); ?> /></td>
							</tr>
							<?php
						}
					}
				?>
			</tbody>
		</table>
		<script type="text/javascript">

			jQuery(window).load(function(){

				/*jQuery('.royalmail_boxes .insert').click( function() {
					var $tbody = jQuery('.royalmail_boxes').find('tbody');
					var size = $tbody.find('tr').size();
					var code = '<tr class="new">\
							<td><input type="checkbox" /></td>\
							<td><input type="text" size="25" name="boxes_name[' + size +']" /></td>\
							<td><input type="text" size="4" name="boxes_length[' + size + ']" />in</td>\
							<td><input type="text" size="4" name="boxes_width[' + size + ']" />in</td>\
							<td><input type="text" size="4" name="boxes_height[' + size + ']" />in</td>\
							<td><input type="text" size="4" name="boxes_max_weight[' + size + ']" />lbs</td>\
							<td><input type="checkbox" name="boxes_enabled[' + size + ']" /></td>\
						</tr>';

					$tbody.append( code );

					return false;
				} );

				jQuery('.royalmail_boxes .remove').click(function() {
					var $tbody = jQuery('.royalmail_boxes').find('tbody');

					$tbody.find('.check-column input:checked').each(function() {
						jQuery(this).closest('tr').hide().find('input').val('');
					});

					return false;
				});*/

				// Ordering
				jQuery('.royalmail_services tbody').sortable({
					items:'tr',
					cursor:'move',
					axis:'y',
					handle: '.sort',
					scrollSensitivity:40,
					forcePlaceholderSize: true,
					helper: 'clone',
					opacity: 0.65,
					placeholder: 'wc-metabox-sortable-placeholder',
					start:function(event,ui){
						ui.item.css('baclbsround-color','#f6f6f6');
					},
					stop:function(event,ui){
						ui.item.removeAttr('style');
						royalmail_services_row_indexes();
					}
				});

				function royalmail_services_row_indexes() {
					jQuery('.royalmail_services tbody tr').each(function(index, el){
						jQuery('input.order', el).val( parseInt( jQuery(el).index('.royalmail_services tr') ) );
					});
				};

			});

		</script>
	</td>
</tr>