<?php

class PH_Tracking_Admin_RoyalMail
{
	const SHIPPING_METHOD_DISPLAY	= "Tracking";
	const TRACKING_TITLE_DISPLAY	= "Royal Mail Shipment Tracking";
	
	const TRACK_SHIPMENT_KEY		= "phive_royalmail_shipment"; //Note: If this key is getting changed, do the same change in JS code below.
	const SHIPMENT_SOURCE_KEY		= "phive_royalmail_shipment_source";
	const SHIPMENT_RESULT_KEY		= "phive_royalmail_shipment_result";
	const TRACKING_MESSAGE_KEY 		= "phroyalmailtrackingmsg";
	const TRACKING_METABOX_KEY		= "PH_Tracking_Metabox_royalmail";

	private function phive_init() {
		if ( ! class_exists( 'PHTrackingFactory' ) )
			include_once ( 'track/class-ph-tracking-factory.php' );
		if ( ! class_exists( 'PHTrackingUtil' ) )
			include_once ( 'track/class-ph-tracking-util.php' );

		// Sorted tracking data.
		$this->tracking_data	= PHTrackingUtil::load_tracking_data( true );
	}

	function __construct(){
		$this->phive_init();

		if ( is_admin() ) { 
			add_action( 'add_meta_boxes', array( $this, 'phive_add_tracking_metabox' ), 15 );
			add_action('admin_notices', array( $this, 'phive_admin_notice'), 15);

			if ( isset( $_GET[self::TRACK_SHIPMENT_KEY] ) ) {
				add_action( 'init', array( $this, 'phive_display_admin_track_shipment' ), 15 );
			}
		}
		

		// Shipment Tracking - Customer Order Details Page.
		add_action( 'woocommerce_view_order', array( $this, 'phive_display_tracking_info_for_customer' ), 6 );
		add_action( 'woocommerce_view_order', array( $this, 'phive_display_tracking_api_info_for_customer' ), 20 );
		add_action( 'woocommerce_email_order_meta', array( $this, 'phive_add_tracking_info_to_email'), 20 );
	}

	function phive_add_tracking_info_to_email( $order, $sent_to_admin = false, $plain_text = false ) {
		$order_id = ( WC()->version < '2.7.0' ) ? $order->id : $order->get_id();
		$shipment_result_array 	= get_post_meta( $order_id , self::SHIPMENT_RESULT_KEY, true );

		if( !empty( $shipment_result_array ) ) {
			echo '<h3>'.__( 'Shipping Detail', 'ph-shipping-royalmail' ).'</h3>';
			$shipment_source_data 	= $this->get_shipment_source_data( $order_id );
			$order_notice 	= PHTrackingUtil::get_shipment_display_message ( $shipment_result_array, $shipment_source_data );
			echo '<p>'.$order_notice.'</p></br>';
		}
	}
 
	public function phive_display_tracking_info_for_customer( $order_id ) {
		
		$shipment_result_array 	= get_post_meta( $order_id , self::SHIPMENT_RESULT_KEY, true );

		if( !empty( $shipment_result_array ) ) {
			// Note: There is a bug in wc_add_notice which gives inconstancy while displaying messages.
			// Uncomment after it gets resolved.
			// $this->display_notice_message( $order_notice );
			$shipment_source_data 	= $this->get_shipment_source_data( $order_id );
			$order_notice 	= PHTrackingUtil::get_shipment_display_message ( $shipment_result_array, $shipment_source_data );
			echo $order_notice;
		}
	}

	public function phive_display_tracking_api_info_for_customer( $order_id ) {
		$turn_off_api = get_option( PHTrackingUtil::TRACKING_SETTINGS_TAB_KEY.PHTrackingUtil::TRACKING_TURN_OFF_API_KEY );
		if( 'yes' == $turn_off_api ) {
			return;
		}
		
		$shipment_result_array 	= get_post_meta( $order_id , self::SHIPMENT_RESULT_KEY, true );

		if( !empty( $shipment_result_array ) ) {
			if( !empty( $shipment_result_array['tracking_info_api'] ) ) {
				$this->display_api_message_table( $shipment_result_array['tracking_info_api'] );
			}
		}
	}

	function display_api_message_table ( $tracking_info_api_array ) {
		
		echo '<h3>'.__( self::TRACKING_TITLE_DISPLAY, 'ph-shipping-royalmail' ).'</h3>';
		echo '<table class="shop_table wooforce_tracking_details">
			<thead>
				<tr>
					<th class="product-name">'.__( 'Shipment ID', 'ph-shipping-royalmail' ).'<br/>('.__( 'Follow link for detailed status.', 'ph-shipping-royalmail' ).')</th>
					<th class="product-total">'.__( 'Status', 'ph-shipping-royalmail' ).'</th>
				</tr>
			</thead>
			<tfoot>';

		foreach ( $tracking_info_api_array as $tracking_info_api ) {
			echo '<tr>';
			echo '<th scope="row">'.'<a href="'.$tracking_info_api['tracking_link'].''.$tracking_info_api['tracking_id'].'" target="_blank">'.$tracking_info_api['tracking_id'].'</a></th>';
			
			if( '' == $tracking_info_api['api_tracking_status'] ) {
				$message = __( 'Unable to update real time status at this point of time. Please follow the link on shipment id to check status.', 'ph-shipping-royalmail' );
			}
			else {
				$message = $tracking_info_api['api_tracking_status'];
			}
			echo '<td><span>'.__( $message, 'ph-shipping-royalmail' ).'</span></td>';
			echo '</tr>';
		}
		echo '</tfoot>
		</table>';
	}

	function display_notice_message( $message, $type = 'notice' ) {
		if ( version_compare( WOOCOMMERCE_VERSION, '2.1', '>=' ) ) {
			wc_add_notice( $message, $type );
		} else {
			global $woocommerce;
			$woocommerce->add_message( $message );
		}
	}

	function phive_admin_notice(){
		global $pagenow;
		global $post;
		
		if( !isset( $_GET[ self::TRACKING_MESSAGE_KEY ] ) && empty( $_GET[ self::TRACKING_MESSAGE_KEY ] ) ) {
			return;
		}

		$phtrackingmsg = $_GET[ self::TRACKING_MESSAGE_KEY ];

		switch ( $phtrackingmsg ) {
			case "0":
				echo '<div class="error"><p>'.self::SHIPPING_METHOD_DISPLAY.': '.__( 'Sorry, Unable to proceed.', 'ph-shipping-royalmail' ).'</p></div>';
				break;
			case "4":
				echo '<div class="error"><p>'.self::SHIPPING_METHOD_DISPLAY.': '.__( 'Unable to track the shipment. Please cross check shipment id or try after some time.', 'ph-shipping-royalmail' ).'</p></div>';
				break;
			case "5":
				$phtrackingmsg = get_post_meta( $post->ID, self::TRACKING_MESSAGE_KEY, true);
				if( '' != trim( $phtrackingmsg )) {
					echo '<div class="updated"><p>'.__( $phtrackingmsg, 'ph-shipping-royalmail' ).'</p></div>';
				}
				break;
			case "6":
				echo '<div class="updated"><p>'.__( 'Tracking is unset.', 'ph-shipping-royalmail' ).'</p></div>';
				break;
			case "7":
				echo '<div class="updated"><p>'.__( 'Tracking Data is reset to default.', 'ph-shipping-royalmail' ).'</p></div>';
				break;
			default:
				break;
		}
	}

	function phive_add_tracking_metabox() {
		global $post;
		if ( !$post ) return;

		if ( in_array( $post->post_type, array('shop_order') )) {
			$order = $this->phive_load_order( $post->ID );
			if ( !$order ) return; 

			// Shipping method is available. 
			add_meta_box( self::TRACKING_METABOX_KEY, __( self::TRACKING_TITLE_DISPLAY, 'ph-shipping-royalmail' ), array( $this, 'phive_tracking_metabox_content' ), 'shop_order', 'side', 'default' );
		}
	}

	function get_shipment_source_data( $post_id ) {
		$shipment_source_data 	= get_post_meta( $post_id, self::SHIPMENT_SOURCE_KEY, true );
		
		if ( empty( $shipment_source_data ) || !is_array( $shipment_source_data ) ) {
			$shipment_source_data	= array();
			$shipment_source_data['shipment_id_cs']		= '';
			$shipment_source_data['shipping_service']	= '';
			$shipment_source_data['order_date']			= '';
		}
		return $shipment_source_data;
	}
	
	function phive_tracking_metabox_content(){
		global $post;
		$shipmentId 	= '';
		
		$order 			= $this->phive_load_order( $post->ID );
		$tracking_url 	= admin_url( '/?post='.( $post->ID ) );
		
		$shipment_source_data 	= $this->get_shipment_source_data( $post->ID );

	?>
		<ul class="order_actions submitbox">
			<li id="actions" class="wide">
				<select name="shipping_service_royalmail" id="shipping_service_royalmail">
	<?php
				echo "<option value=''>".__( 'None', 'ph-shipping-royalmail' )."</option>";
				//foreach ( $this->tracking_data as $key => $details ) {
					echo '<option value='.'royalmail'.' '.selected($shipment_source_data['shipping_service'], 'royalmail').' >'.__( 'Royal Mail', 'ph-shipping-royalmail' ).'</option>';
				//}
	?>
				</select><br>
				<strong><?php _e( 'Enter Tracking IDs', 'ph-shipping-royalmail' ) ?></strong>
				<img class="help_tip" style="float:none;" data-tip="<?php _e( 'Comma separated, in case of multiple shipment ids for this order.', 'ph-shipping-royalmail' ); ?>" src="<?php echo WC()->plugin_url();?>/assets/images/help.png" height="16" width="16" /><br>
				<textarea id="tracking_royalmail_shipment_ids" class="input-text" type="text" name="tracking_royalmail_shipment_ids" ><?php echo $shipment_source_data['shipment_id_cs']; ?></textarea><br>
				<strong>Shipment Date</strong>
				<img class="help_tip" style="float:none;" data-tip="<?php _e( 'This field is Optional.', 'ph-shipping-royalmail' ); ?>" src="<?php echo WC()->plugin_url();?>/assets/images/help.png" height="16" width="16" /><br>
				<input type="text" id="order_date_royalmail" class="date-picker" value="<?php echo $shipment_source_data['order_date']; ?>"></p>
			</li>
			<li id="" class="wide">
				<a class="button button-primary woocommerce_shipment_royalmail_tracking tips" href="<?php echo $tracking_url; ?>" data-tip="<?php _e( 'Save/Show Tracking Info', 'ph-shipping-royalmail' ); ?>"><?php _e('Save/Show Tracking Info', 'ph-shipping-royalmail'); ?></a>
			</li>
		</ul>
		<script>
			jQuery(document).ready(function($) {
				$( "date-picker" ).datepicker();
			});
			
			jQuery("a.woocommerce_shipment_royalmail_tracking").on("click", function(e) {
				e.preventDefault();
			   location.href = this.href + '&phive_royalmail_shipment=' + jQuery('#tracking_royalmail_shipment_ids').val().replace(/ /g,'')+'&shipping_service='+ jQuery( "#shipping_service_royalmail" ).val()+'&order_date='+ jQuery( "#order_date_royalmail" ).val();
			   return false;
			});
		</script>
	<?php
	}

	function phive_display_admin_track_shipment() {
		if( !$this->phive_user_check() ) {
			_e( "You don't have admin privileges to view this page.", 'ph-shipping-royalmail' );
			exit;
		}

		$post_id 			= isset( $_GET['post'] ) ? $_GET['post'] : '';
		$shipment_id_cs		= isset( $_GET[ self::TRACK_SHIPMENT_KEY ] ) ? $_GET[ self::TRACK_SHIPMENT_KEY ] : '';
		$shipping_service	= isset( $_GET[ 'shipping_service' ] ) ? $_GET[ 'shipping_service' ] : '';
		$order_date			= isset( $_GET[ 'order_date' ] ) ? $_GET[ 'order_date' ] : '';
		// Setting up custom message option.
		$royalmail_settings = get_option( 'woocommerce_'.PHive_Royal_Mail_ID.'_settings', null );
		if( !empty( $royalmail_settings['custom_message'] ) ) {
		    update_option( PHTrackingUtil::TRACKING_SETTINGS_TAB_KEY.PHTrackingUtil::TRACKING_MESSAGE_KEY, $royalmail_settings['custom_message'] );
		}

		$shipment_source_data	= PHTrackingUtil::prepare_shipment_source_data( $post_id, $shipment_id_cs, $shipping_service, $order_date );
		
		$shipment_result 		= $this->get_shipment_info( $post_id, $shipment_source_data );

		if ( null != $shipment_result && is_object( $shipment_result ) ) {
			$shipment_result_array = PHTrackingUtil::convert_shipment_result_obj_to_array ( $shipment_result );
			
			update_post_meta( $post_id, self::SHIPMENT_RESULT_KEY, $shipment_result_array );
			$admin_notice = PHTrackingUtil::get_shipment_display_message ( $shipment_result_array, $shipment_source_data );
		}
		else {
			$admin_notice = __( 'Unable to update tracking info.', 'ph-shipping-royalmail' );
			update_post_meta( $post_id, self::SHIPMENT_RESULT_KEY, '' );
		}

		self::display_admin_notification_message( $post_id, $admin_notice );
	}

	public static function display_admin_notification_message( $post_id, $admin_notice ) {
		$phtrackingmsg = 5;
		update_post_meta( $post_id, self::TRACKING_MESSAGE_KEY, $admin_notice );
		wp_redirect( admin_url( '/post.php?post='.$post_id.'&action=edit&'.self::TRACKING_MESSAGE_KEY.'='.$phtrackingmsg ) );
		exit;
	}

	function get_shipment_info( $post_id, $shipment_source_data ) {

		if( empty( $post_id ) ) {
			$phtrackingmsg = 0;
			wp_redirect( admin_url( '/post.php?post='.$post_id.'&action=edit&'.self::TRACKING_MESSAGE_KEY.'='.$phtrackingmsg ) );
			exit;
		}
		
 		if( '' == $shipment_source_data['shipping_service'] ) {
			update_post_meta( $post_id, self::SHIPMENT_SOURCE_KEY, $shipment_source_data );
			update_post_meta( $post_id, self::SHIPMENT_RESULT_KEY, '' );

			$phtrackingmsg = 6;
			wp_redirect( admin_url( '/post.php?post='.$post_id.'&action=edit&'.self::TRACKING_MESSAGE_KEY.'='.$phtrackingmsg ) );
			exit;
		}
		// $shipment_source_data['shipping_service'] = 'fedex';
		update_post_meta( $post_id, self::SHIPMENT_SOURCE_KEY, $shipment_source_data );
		
		try {
			$shipment_result 	= PHTrackingUtil::get_shipment_result( $shipment_source_data );
		}catch( Exception $e ) {
			$phtrackingmsg = 0;
			wp_redirect( admin_url( '/post.php?post='.$post_id.'&action=edit&'.self::TRACKING_MESSAGE_KEY.'='.$phtrackingmsg ) );
			exit;
		}

		return $shipment_result;
	}

	function phive_load_order( $orderId ){
		if ( !class_exists( 'WC_Order' ) ) {
			return false;
		}
		return new WC_Order( $orderId );      
	}

	function phive_user_check() {
		if ( is_admin() ) {
			return true;
		}
		return false;
	}
}

new PH_Tracking_Admin_RoyalMail();
?>
