<?php
/*
	Plugin Name: PH Royal Mail WooCommerce Shipping Premium
	Plugin URI: http://pluginhive.com/product/woocommerce-royal-mail-shipping-with-tracking/
	Description: Display RoyalMail shipping rates.
	Version: 1.1.2
	Author: PluginHive
	Author URI: http://pluginhive.com/about/
	WC requires at least: 2.6
	WC tested up to: 3.6.2
	Text Domain: ph-shipping-royalmail

*/

if (!defined('PHive_Royal_Mail_ID')){
	define("PHive_Royal_Mail_ID", "phive_royalmail_shipping");
}


/**
 * Plugin activation check
 */
function phive_royalmail_pre_activation_check_premium(){
	//check if basic version is there
	if ( is_plugin_active('royalmail-woocommerce-shipping/royalmail-woocommerce-shipping.php') ){
        deactivate_plugins( basename( __FILE__ ) );
		wp_die( __("Oops! You tried installing the premium version without deactivating and deleting the basic version. Kindly deactivate and delete RoyalMail(Basic) Woocommerce Extension and then try again", "ph-shipping-royalmail" ), "", array('back_link' => 1 ));
	}
}

register_activation_hook( __FILE__, 'phive_royalmail_pre_activation_check_premium' );


/**
 * Check if WooCommerce is active
 */
if (in_array( 'woocommerce-update/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) )) {	
	class phive_royalmail_wooCommerce_shipping_setup {
		
		public function __construct() {
			add_action(	'init', array($this,'phive_init') );
			add_action( 'woocommerce_shipping_init', array( $this, 'phive_royalmail_wooCommerce_shipping_init' ) );
			add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'plugin_action_links' ) );
			add_filter( 'woocommerce_shipping_methods', array( $this, 'phive_royalmail_wooCommerce_shipping_methods' ) );		
			add_filter( 'admin_enqueue_scripts', array( $this, 'phive_royalmail_scripts' ) );		
				
			load_plugin_textdomain( 'ph-shipping-royalmail', false, dirname( plugin_basename( __FILE__ ) ) . '/i18n/' );
		}
		public function phive_init() {
			include_once( 'includes/ph-legacy-handler.php' );
			include_once ( 'includes/class-ph-tracking-admin.php' );
			if ( is_admin() ) {
				include_once ( 'includes/phive_api_manager/ph-api-manager-config.php' );
			}
		}
		
		public function phive_royalmail_scripts() {
			wp_enqueue_script( 'jquery-ui-sortable' );
			wp_enqueue_script( 'ph-common-script', plugins_url( '/resources/js/ph_common.js', __FILE__ ), array( 'jquery' ) );
			wp_enqueue_style( 'ph-common-style', plugins_url( '/resources/css/ph_common_style.css', __FILE__ ));
		}
		
		public function plugin_action_links( $links ) {
			$plugin_links = array(
				'<a href="' . admin_url( 'admin.php?page=' . $this->phive_get_settings_url() . '&tab=shipping&section=phive_royalmail_shipping' ) . '">' . __( 'Settings', 'ph-shipping-royalmail' ) . '</a>',
				'<a href="https://www.xadapter.com/online-support/" target="_blank">' . __('Support', 'ph-shipping-royalmail') . '</a>',
			);
			return array_merge( $plugin_links, $links );
		}			
		
		private function phive_get_settings_url(){
			return version_compare(WC()->version, '2.1', '>=') ? "wc-settings" : "woocommerce_settings";
		}

		public function phive_royalmail_wooCommerce_shipping_init() {
			include_once( 'includes/class-ph-royalmail-woocommerce-shipping.php' );
		}

		
		public function phive_royalmail_wooCommerce_shipping_methods( $methods ) {
			$methods[] = 'phive_royalmail_woocommerce_shipping_method';
			return $methods;
		}		
	}
	new phive_royalmail_wooCommerce_shipping_setup();
}
