<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if( !class_exists('PH_API_Manager') ){
	class PH_API_Manager {
		public function __construct( $product_id, $plugin_version, $plugin_slug, $server_url, $plugin_settings_url='' ){
			$this->phive_email_key = $product_id.'_email';
			$this->phive_api_licence_key = $product_id.'_licence_key';
			$this->phive_instance_key = $product_id.'_instance_id';
			$this->plugin_settings_url = $plugin_settings_url;
			$this->product_id = $product_id; // Software Title
			$this->software_version = $plugin_version;
			$this->plugin_name = $plugin_slug; //this might me plugin folder directory/plugin name

			$this->upgrade_url = $server_url; // URL to access the Update API Manager.





			$this->domain = home_url(); // blog domain name
			
			$phive_api_licence_key = get_option($this->phive_api_licence_key);
			$this->api_key = !empty($phive_api_licence_key) ? $phive_api_licence_key : ''; // API License Key
			
			$phive_email_key = get_option($this->phive_email_key);
			$this->activation_email = !empty( $phive_email_key ) ? $phive_email_key : ''; // License Email
			
			$phive_instance_key = get_option($this->phive_instance_key);
			$this->instance = !empty( $phive_instance_key ) ? $phive_instance_key : '';  // Instance ID (unique to each blog activation)
			
			$this->renew_license_url = ''; // URL to renew a license
			$this->plugin_or_theme = 'plugin'; // 'theme' or 'plugin'
			$this->text_domain = ''; // localization for translation
			$this->extra = ''; // Used to send any extra information.

			$this->phive_init();
		}
		
		private function phive_init(){
			$phive_email_key = $this->phive_email_key;
			$phive_api_licence_key = $this->phive_api_licence_key;
			$phive_instance_key = $this->phive_instance_key;
			$plugin_settings_url = $this->plugin_settings_url;
			$upgrade_url = $this->upgrade_url;
			$plugin_name = $this->plugin_name;
			$product_id = $this->product_id;
			$api_key = $this->api_key;
			$activation_email = $this->activation_email;
			$renew_license_url = $this->renew_license_url;
			$instance = $this->instance;
			$domain = $this->domain;
			$software_version = $this->software_version;
			$plugin_or_theme = $this->plugin_or_theme;
			$text_domain = $this->text_domain;
			$extra = $this->extra;

			include_once ( 'class-wc-am-plugin-activate.php' );
			$activation_obj = new PH_Software_Activate( $upgrade_url, $plugin_name, $product_id, $api_key, $activation_email, $renew_license_url, $instance, $domain, $software_version, $plugin_or_theme, $text_domain, $extra, $phive_email_key, $phive_api_licence_key, $phive_instance_key );

			add_action('wp_ajax_phive_activate_license_keys_'.$this->product_id, array($activation_obj, 'phive_activation' ) );
			add_action('wp_ajax_phive_deactivate_license_keys_'.$this->product_id, array($activation_obj, 'phive_deactivation' ) );

			include_once ( 'class-wc-am-plugin-update.php' );

			new PH_API_Manager_Software_Update( $upgrade_url, $plugin_name, $product_id, $api_key, $activation_email, $renew_license_url, $instance, $domain, $software_version, $plugin_or_theme, $text_domain, $extra, $plugin_settings_url);

		}


	} // End of class
}