<?php
/*
Plugin Name: Blue2 Plugin Inspector
Plugin URI: https://bitbucket.org/blue2digital/plugin-inspector
Description: Reports on where plugins are used across Planet Express.
Version: 0.1.0
Author: Blue2
Author URI: https://blue2.co.uk
*/

new PluginInspector();

class PluginInspector
{
    public function __construct()
    {
        add_action('plugins_loaded', [$this, 'preventUpdate']);
        add_action('admin_menu', [$this, 'createMenu']);
    }

    public function preventUpdate()
    {
        add_filter('site_transient_update_plugins', function ($value) {
            unset($value->response['plugin-inspector/plugin-inspector.php']);
            return $value;
        });
    }

    /**
     * Generate the link to the options page under settings
     *
     * @access public
     * @return void
     */
    public function createMenu()
    {
        add_options_page('Plugin Inspector', 'Plugin Inspector', 'manage_options', 'plugin-inspector', [$this, 'showPluginPage']);
    }


    public function showPluginPage()
    {
        $this->showPluginSelection();

        if (isset($_POST['plugin-select']) && $_POST['plugin-select'] !== '') {
            $this->getPluginUsageDetails($_POST['plugin-select']);
        }
    }

    private function showPluginSelection()
    {
        $pluginSelections = "";

        $plugins = get_plugins();
        foreach ($plugins as $pluginName => $pluginData) {
            $pluginSelections .= '<option value="' . $pluginName . '">' . $pluginData['Name'] . '</option>';
        }

        ?>
        <div>
            <h2>Plugin Usage Inspector</h2>
            <form method="post" action="options-general.php?page=plugin-inspector">
                <label for="plugin-select">Select plugin</label>
                <select id="plugin-select" name="plugin-select">
                    <option value="">-- Please choose a plugin --</option>
                    <?= $pluginSelections ?>
                </select>
                <?php submit_button("Check Plugin Usage"); ?>
            </form>
        </div>
        <?php
    }

    private function getPluginUsageDetails($plugin)
    {
        global $wpdb;
        $currentDatabase = $wpdb->dbname;

        $pex = new \B2\PlanetExpress();
        $sites = $pex->getSiteList(true);

        $pluginSites = [];
        $errorSites = [];

        foreach ($sites as $site => $siteData) {

            $siteDatabase = $siteData['database'];

            if ($this->isValidDatabase($siteDatabase)) {
                $plugins = $this->getActivePluginsFromDatabase($siteDatabase);
                if (in_array($plugin, $plugins)) {
                    $pluginSites[$site] = $siteDatabase;
                }
            } else {
                $errorSites[$site] = $siteDatabase;
            }
        }

        echo "<pre>";
        echo "Plugin found on: \n\n";
        foreach($pluginSites as $site => $database){
            echo $site . " : " . $database . "\n";
        }

        echo "\n\nCould not connect to: \n\n";
        foreach($errorSites as $site => $database){
            echo $site . " : " . $database . "\n";
        }
        echo "</pre>";

        $wpdb->select($currentDatabase);
    }

    private function isValidDatabase($database)
    {
        global $wpdb;
        return $wpdb->query("SHOW DATABASES LIKE '$database'") !== 0;
    }

    private function getActivePluginsFromDatabase($database)
    {
        global $wpdb;
        $wpdb->select($database);

        $query = "Select option_value from " . $database . "_options where option_name = 'active_plugins'";
        $results = $wpdb->get_results($query);

        if (count($results) > 0) {
            return unserialize($results[0]->option_value);
        } else {
            return [];
        }
    }

}
