<?php
/*
Plugin Name: Blue2 Plugin Inspector
Plugin URI: https://bitbucket.org/blue2digital/plugin-inspector
Description: Reports on where plugins are used across Planet Express.
Version: 0.1.0
Author: Blue2
Author URI: https://blue2.co.uk
*/

new PluginInspector();

class PluginInspector
{
    public function __construct()
    {
        add_action('admin_menu', [$this, 'createMenu']);
    }

    /**
     * Generate the link to the options page under settings
     *
     * @access public
     * @return void
     */
    public function createMenu()
    {
        add_options_page('Plugin Inspector', 'Plugin Inspector', 'manage_options', 'plugin-inspector', [$this, 'showPluginPage']);
    }


    public function showPluginPage()
    {
        $this->showPluginSelection();

        if (isset($_POST['plugin-select']) && $_POST['plugin-select'] !== '') {
            $this->showPostdata();
            $selectedPlugin = $_POST['plugin-select'];
            $this->getPluginUsageDetails($selectedPlugin);

        }
    }

    private function showPluginSelection()
    {
        $pluginSelections = "";

        $plugins = get_plugins();
        foreach ($plugins as $pluginName => $pluginData) {
            $pluginSelections .= '<option value="' . $pluginName . '">' . $pluginData['Name'] . '</option>';
        }

        ?>
        <div>
            <h2>Plugin Usage</h2>
            <form method="post" action="options-general.php?page=plugin-reports">
                <label for="plugin-select">Select plugin</label>
                <select id="plugin-select" name="plugin-select">
                    <option value="">-- Please choose a plugin --</option>
                    <?= $pluginSelections ?>
                </select>
                <?php submit_button("Check Plugin Usage"); ?>
            </form>
        </div>
        <?php
    }


    private function showPostdata()
    {
        echo "<pre>";
        print_r($_POST);
        echo "</pre>";
    }

    private function getPluginUsageDetails($plugin)
    {
        $pex = new \B2\PlanetExpress();
        $sites = $pex->getSiteList();

        foreach ($sites as $site => $siteData) {
            echo "<pre>";
            echo $site . "\n";
            echo "</pre>";
        }
    }

}
