<?php

namespace PixelYourSite\SuperPack;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use PixelYourSite;

global $post;

?>

<?php if ( PixelYourSite\Facebook()->enabled() ) : ?>
    <?php
        $value = get_post_meta( $post->ID, '_pys_super_pack_remove_pixel', true );
        $pixels = PixelYourSite\Facebook()->getAllPixels();
        $disabledPixel = '';

        if($value == "1" && is_array($pixels) && count($pixels) > 0) {
            $disabledPixel = 'all';
        } else if(!empty($value)) {
            $disabledPixel = $value;
        }

    ?>
    <p>
        <label>
            <strong>Remove Facebook pixel on this <?php echo get_post_type(); ?></strong>
    <p>
            <select name="pys_super_pack_remove_pixel">
                <option>Select Pixel</option>
                <option value="all" <?=selected("all",$disabledPixel)?>>Remove All</option>
                <?php foreach ($pixels as $pixel) : ?>
                    <option value="<?=$pixel?>" <?=selected($pixel,$disabledPixel)?> ><?=$pixel?></option>
                <?php endforeach; ?>
            </select>
    </p>

        </label>
    </p>
<?php endif; ?>

<?php if ( PixelYourSite\GA()->enabled() ) : ?>
	<?php
        $value = get_post_meta( $post->ID, '_pys_super_pack_remove_ga_pixel', true );
        $pixels = PixelYourSite\GA()->getAllPixels();
        $disabledPixel = '';

        if($value == "1" && is_array($pixels) && count($pixels) > 0) {
            $disabledPixel = 'all';
        } else if(!empty($value)) {
            $disabledPixel = $value;
        }
        ?>
	<p>
		<label>
			<strong>Remove Google Analytics on this <?php echo get_post_type(); ?></strong>
            <p>
                <select name="pys_super_pack_remove_ga_pixel">
                    <option>Select Pixel</option>
                    <option value="all" <?=selected("all",$disabledPixel)?>>Remove All</option>
                    <?php foreach ($pixels as $pixel) : ?>
                        <option value="<?=$pixel?>" <?=selected($pixel,$disabledPixel)?> ><?=$pixel?></option>
                    <?php endforeach; ?>
                </select>
            </p>
		</label>
	</p>
<?php endif; ?>


<?php if ( PixelYourSite\Ads()->enabled() ) : ?>
    <?php
    $value = get_post_meta( $post->ID, '_pys_super_pack_remove_ads_pixel', true );
    $pixels = PixelYourSite\Ads()->getAllPixels();
    $disabledPixel = $value;

    ?>
    <p>
        <label>
            <strong>Remove Google Ads Tag on this <?php echo get_post_type(); ?></strong>
    <p>
        <select name="pys_super_pack_remove_ads_pixel">
            <option>Select Pixel</option>
            <option value="all" <?=selected("all",$disabledPixel)?>>Remove All</option>
            <?php foreach ($pixels as $pixel) : ?>
                <option value="<?=$pixel?>" <?=selected($pixel,$disabledPixel)?> ><?=$pixel?></option>
            <?php endforeach; ?>
        </select>
    </p>

    </label>
    </p>
<?php endif; ?>

<?php if ( PixelYourSite\Bing()->enabled() ) : ?>
    <?php
    $value = get_post_meta( $post->ID, '_pys_super_pack_remove_bing_pixel', true );
    if(method_exists(PixelYourSite\Bing(),'getAllPixels')) {
        $pixels = PixelYourSite\Bing()->getAllPixels();
    } else {
        $pixels = PixelYourSite\Bing()->getPixelIDs();// remove in next version
    }
    $disabledPixel = $value;

    ?>
    <p>
        <label>
            <strong>Remove Bing Tag on this <?php echo get_post_type(); ?></strong>
    <p>
        <select name="pys_super_pack_remove_bing_pixel">
            <option>Select Pixel</option>
            <option value="all" <?=selected("all",$disabledPixel)?>>Remove All</option>
            <?php foreach ($pixels as $pixel) : ?>
                <option value="<?=$pixel?>" <?=selected($pixel,$disabledPixel)?> ><?=$pixel?></option>
            <?php endforeach; ?>
        </select>
    </p>

    </label>
    </p>
<?php endif; ?>

<?php if ( PixelYourSite\Pinterest()->enabled() ) : ?>
    <?php
    $value = get_post_meta( $post->ID, '_pys_super_pack_remove_pinterest_pixel', true );
    if(method_exists(PixelYourSite\Pinterest(),'getAllPixels')) {
        $pixels = PixelYourSite\Pinterest()->getAllPixels();
    } else {
        $pixels = PixelYourSite\Pinterest()->getPixelIDs(); // remove in next version
    }

    $disabledPixel = '';

    if($value == "1" && is_array($pixels) && count($pixels) > 0) {
        $disabledPixel = 'all';
    } else if(!empty($value)) {
        $disabledPixel = $value;
    }

    ?>
    <p>
        <label>
            <strong>Remove Pinterest Tag on this <?php echo get_post_type(); ?></strong>
    <p>
        <select name="pys_super_pack_remove_pinterest_pixel">
            <option>Select Pixel</option>
            <option value="all" <?=selected("all",$disabledPixel)?>>Remove All</option>
            <?php foreach ($pixels as $pixel) : ?>
                <option value="<?=$pixel?>" <?=selected($pixel,$disabledPixel)?> ><?=$pixel?></option>
            <?php endforeach; ?>
        </select>
    </p>

    </label>
    </p>
<?php endif; ?>
