<?php

namespace PixelYourSite\SuperPack;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use PixelYourSite;

?>

<?php
$isWpmlActive = isWPMLActive();
if($isWpmlActive) {
    $savedLang = (array)PixelYourSite\GA()->getOption("pixel_lang");
    $languageCodes = array_keys(apply_filters( 'wpml_active_languages',null,null));
    if(!$savedLang) $savedLang = array();
}

foreach ( PixelYourSite\GA()->getPixelIDs() as $index => $pixel_id ) : ?>
	<?php
	
	if ( $index === 0 ) {
		continue; // skip default ID
	}
    if($isWpmlActive) {

        if(count($savedLang) > $index) {
            $activeLang = $savedLang[$index];
        } else {
            $activeLang = implode("_",$languageCodes);
        }
    }

	
	?>
    <div class="plate mt-3 pb-3 pt-3">
        <div class="row">
            <div class="col-10">
                <p><?php PixelYourSite\GA()->render_pixel_id( 'tracking_id', 'Google Analytics tracking ID', $index ); ?></p>
                <?php PixelYourSite\GA()->render_checkbox_input_array("is_enable_debug_mode","Enable Analytics Debug mode for this property",$index);?>
                <?php
                if($isWpmlActive &&  !empty( $languageCodes )) {
                    printLangList($activeLang, $languageCodes, "ga");
                }
                ?>
            </div>
            <div class="col-2">
                <button type="button" class="btn btn-sm remove-row">
                    <i class="fa fa-trash-o" aria-hidden="true"></i>
                </button>
            </div>
        </div>
    </div>

<?php endforeach; ?>

<div class="plate mt-3 pb-3 pt-3" id="pys_superpack_ga_tracking_id" style="display: none;">
    <div class="row mt-3" >
	    <div class="col-10">
        <p><input type="text" name="" id="" value="" placeholder="Google Analytics tracking ID" class="form-control"></p>
        <label class="custom-control custom-checkbox debug_chekbox">
            <input type="hidden" name="" value="">
            <input type="checkbox" name="" value="" class="custom-control-input">
            <span class="custom-control-indicator"></span>
            <span class="custom-control-description">Enable Analytics Debug mode for this property</span>
        </label>
        <?php
            if($isWpmlActive && !empty( $languageCodes )) {
                printLangList(implode("_",$languageCodes), $languageCodes, "ga",true);
            }
        ?>
	</div>
	    <div class="col-2">
		<button type="button" class="btn btn-sm remove-row">
			<i class="fa fa-trash-o" aria-hidden="true"></i>
		</button>
	</div>
    </div>
</div>

<div class="row my-3">
    <div class="col-12">
        <button class="btn btn-sm btn-primary" type="button"
                id="pys_superpack_add_ga_tracking_id">
            Add Extra Google Analytics Tracking ID
        </button>
    </div>
</div>


<script type="text/javascript">
    jQuery(document).ready(function ($) {
        
        $('#pys_superpack_add_ga_tracking_id').click(function (e) {

            e.preventDefault();

            var $row = $('#pys_superpack_ga_tracking_id').clone()
                .insertBefore('#pys_superpack_ga_tracking_id')
                .attr('id', '')
                .css('display', 'block');

            $('input[type="text"]', $row)
                .attr('name', 'pys[ga][tracking_id][]');
            var $lang = $row.find(".pixel_lang");
            if($lang.length>0){
                $lang.val($lang.data("value"));
            }

            // debug mode
            var $debug = $row.find(".debug_chekbox");
            var index = $("input[name='pys[ga][tracking_id][]']").length - 1;
            $debug.find('.custom-control-input')
                .val("index_"+index)
                .attr("name","pys[ga][is_enable_debug_mode][]")

        });

        $(document).on('click', '.remove-row', function () {
            $(this).closest('.plate').remove();
        });
    });
</script>