<?php

namespace PixelYourSite\SuperPack;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use PixelYourSite;

?>

<?php
$isWpmlActive = isWPMLActive();
if($isWpmlActive) {
    $savedLang = (array)PixelYourSite\Facebook()->getOption("pixel_lang");
    $languageCodes = array_keys(apply_filters( 'wpml_active_languages',null,null));
    if(!$savedLang) $savedLang = array();
}

foreach ( PixelYourSite\Facebook()->getPixelIDs() as $index => $pixel_id ) : ?>
	<?php
	
	if ( $index === 0 ) {
		continue; // skip default ID
	}
	if($isWpmlActive) {

        if (count($savedLang) > $index) {
            $activeLang = $savedLang[$index];
        } else {
            $activeLang = implode("_", $languageCodes);
        }
    }

	?>
    <div class="plate mt-3 pt-4 pb-3">
        <div class="row">
        <div class="col-10">
            <p><?php PixelYourSite\Facebook()->render_pixel_id( 'pixel_id', 'Facebook Pixel ID', $index ); ?></p>
            <?php if(method_exists(PixelYourSite\Facebook(),'render_text_area_array_item')) : ?>
                <p><?php PixelYourSite\Facebook()->render_text_area_array_item("server_access_api_token","Api token",$index) ?></p>
                <p><?php PixelYourSite\Facebook()->render_text_input_array_item("test_api_event_code","Code",$index); ?>
                    <small class="form-text"><strong>Remove it after testing</strong></small>
                </p>
                <?php if($isWpmlActive && !empty( $languageCodes )) {
                    printLangList($activeLang,$languageCodes,"facebook");
                }

             endif; ?>
        </div>
        <div class="col-2">
            <button type="button" class="btn btn-sm remove-row">
                <i class="fa fa-trash-o" aria-hidden="true"></i>
            </button>
        </div>
    </div>
    </div>

<?php endforeach; ?>
<div class="plate mt-3 pt-4 pb-3" id="pys_superpack_facebook_pixel_id" style="display: none;">
    <div class="row"  >
        <div class="col-10">

            <p><input type="text" name="pys[facebook][pixel_id][]" id="" value="" placeholder="Facebook Pixel ID" class="form-control"></p>
            <p><textarea          name="pys[facebook][server_access_api_token][]" id="" placeholder="Facebook Api token" class="form-control"></textarea></p>
            <p><input type="text" name="pys[facebook][test_api_event_code][]" id="" value="" placeholder="Facebook Api test event code" class="form-control"></p>
            <?php
                if(isWPMLActive() && !empty( $languageCodes )) {
                    printLangList(implode("_",$languageCodes),$languageCodes,"facebook",true);
                }
            ?>
        </div>
        <div class="col-2">
            <button type="button" class="btn btn-sm remove-row">
                <i class="fa fa-trash-o" aria-hidden="true"></i>
            </button>
        </div>
    </div>
</div>

<div class="row my-3">

    <div class="col-12">
        <button class="btn btn-sm btn-primary" type="button"
                id="pys_superpack_add_facebook_pixel_id">
            Add Extra Facebook Pixel ID
        </button>
    </div>
</div>


<script type="text/javascript">
    jQuery(document).ready(function ($) {
        
        $('#pys_superpack_add_facebook_pixel_id').click(function (e) {

            e.preventDefault();
            
            var $row = $('#pys_superpack_facebook_pixel_id').clone()
                .insertBefore('#pys_superpack_facebook_pixel_id')
                .attr('id', '')
                .css('display', 'block');
            var $lang = $row.find(".pixel_lang");
            if($lang.length>0){
                $lang.val($lang.data("value"));
            }

        });

        $(document).on('click', '.remove-row', function () {
            $(this).closest('.plate').remove();
        });
        
    });
</script>