<?php if(!defined('ABSPATH')) {die('You are not allowed to call this page directly.');}

return array(
  'subscr_id' => array(
    'name' => __('Recurring Subscription Number', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => 'mp-sub-xxx...',
    'required' => false,
    'desc' => __('The Recurring Subscription Number. In order for recurring billings to be tracked, this should be the exact Subsription Number generated by the Payment Gateway for this Subscription.', 'memberpress-developer-tools')
  ),
  'response' => array(
    'name' => __('Subscription Response', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => '',
    'required' => false,
    'desc' => __('A place where you can store Payment Gateway POST or GET responses for later reference.', 'memberpress-developer-tools')
  ),
  'gateway' => array(
    'name' => __('Gateway ID', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => 'manual',
    'required' => false,
    'valid_values' => __('manual, free, or the ID of any live Gateway setup in your MemberPress Options', 'memberpress-developer-tools'),
    'desc' => __('The Payment Gateway to use for this Subscription.', 'memberpress-developer-tools')
  ),
  'member' => array(
    'name' => __('Member ID', 'memberpress-developer-tools'),
    'type' => 'integer',
    'default' => '0',
    'required' => __('Required', 'memberpress-developer-tools'),
    'desc' => __('The Member\'s WordPress User ID.', 'memberpress-developer-tools')
  ),
  'membership' => array(
    'name' => __('Membership ID', 'memberpress-developer-tools'),
    'type' => 'integer',
    'default' => '0',
    'required' => __('Required', 'memberpress-developer-tools'),
    'desc' => __('The ID of the Membership this Subscription is for.', 'memberpress-developer-tools')
  ),
  'coupon' => array(
    'name' => __('Coupon ID', 'memberpress-developer-tools'),
    'type' => 'integer',
    'default' => '0',
    'required' => false,
    'desc' => __('The ID of the Coupon used on this Subscription.', 'memberpress-developer-tools')
  ),
  'price' => array(
    'name' => __('Subscription Price', 'memberpress-developer-tools'),
    'type' => 'decimal',
    'default' => '0.00',
    'required' => false,
    'desc' => __('The Subscription Sub-Total Amount.', 'memberpress-developer-tools') //BLAIR TODO - Is this correct???
  ),
  'tax_amount' => array(
    'name' => __('Tax Amount', 'memberpress-developer-tools'),
    'type' => 'decimal',
    'default' => '0.00',
    'required' => false,
    'desc' => __('The Subscription Tax Amount.', 'memberpress-developer-tools') //BLAIR TODO - Is this correct???
  ),
  'tax_rate' => array(
    'name' => __('Tax Rate', 'memberpress-developer-tools'),
    'type' => 'decimal',
    'default' => '0.000',
    'required' => false,
    'desc' => __('The Subscription Tax Rate. Up to 3 decimal points allowed.', 'memberpress-developer-tools') //BLAIR TODO - Is this correct???
  ),
  'tax_desc' => array(
    'name' => __('Tax Description', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => 'lifetime',
    'required' => false,
    'desc' => __('A brief description of the tax applied. Example: UK VAT (20%)', 'memberpress-developer-tools')
  ),
  'period' => array(
    'name' => __('Subscription Period', 'memberpress-developer-tools'),
    'type' => 'integer',
    'default' => '1',
    'required' => false,
    'desc' => __('The Period for the Subscription billing cycles. See Memberships documentation for more info.', 'memberpress-developer-tools')
  ),
  'period_type' => array(
    'name' => __('Subscription Period Type', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => 'lifetime',
    'required' => false,
    'desc' => __('The billing period type. See Memberships documentation for more info.', 'memberpress-developer-tools')
  ),
  'limit_cycles' => array(
    'name' => __('Enable Limited Billing Cycles', 'memberpress-developer-tools'),
    'type' => 'bool',
    'default' => 'false',
    'required' => false,
    'desc' => __('Whether or not to limit the billing cycles for recurring membership payments. If set to true, MemberPress will cancel the recurring payments after the limit_cycles_num amount has been reached.', 'memberpress-developer-tools')
  ),
  'limit_cycles_num' => array(
    'name' => __('Limited Billing Cycles Number', 'memberpress-developer-tools'),
    'type' => 'integer',
    'default' => '2',
    'required' => false,
    'desc' => __('If limit_cycles is true, then this number is used to determine how many recurring billings should happen before MemberPress automatically cancels the Subscription. If set to 1, the Subscription will be cancelled immediately after the first payment has come through, however the member will maintain access until their Transaction has expired.', 'memberpress-developer-tools')
  ),
  'limit_cycles_action' => array(
    'name' => __('Limited Billing Cycles Action', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => 'expire',
    'required' => false,
    'valid_values' => __('expire or lifetime', 'memberpress-developer-tools'),
    'desc' => __('If limit_cycles is enabled, then this will determine the Member\'s access after their Subscription has reached its limit_cycles_num limit and has been cancelled. If set to "expire" then the Member will lose access after their last Transaction expires. If set to "lifetime", the Member will be granted lifetime access.', 'memberpress-developer-tools')
  ),
  //'prorated_trial' => array(
  //), // => false,
  'trial' => array(
    'name' => __('Enable Trial Period', 'memberpress-developer-tools'),
    'type' => 'bool',
    'default' => 'false',
    'required' => false,
    'desc' => __('Whether or not there is a trial period on this Subscription. Trial periods ONLY work on auto-recurring payments.', 'memberpress-developer-tools')
  ),
  'trial_days' => array(
    'name' => __('Trial Period Days', 'memberpress-developer-tools'),
    'type' => 'integer',
    'default' => '0',
    'required' => false,
    'desc' => __('How many days the trial period should last before the regular billing cycles begin.', 'memberpress-developer-tools')
  ),
  'trial_amount' => array(
    'name' => __('Trial Period Amount', 'memberpress-developer-tools'),
    'type' => 'decimal',
    'default' => '0.00',
    'required' => false,
    'desc' => __('If a trial period is enabled, this specifies how much the user paid for the trial period.', 'memberpress-developer-tools')
  ),
  'status' => array(
    'name' => __('Subscription Billing Status', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => 'pending',
    'required' => __('Required', 'memberpress-developer-tools'),
    'valid_values' => __('pending, active, or cancelled', 'memberpress-developer-tools'),
    'desc' => __('The Subscription\'s current billing status. This can be set to "active", "cancelled", "suspended", or "pending"', 'memberpress-developer-tools')
  ),
  'created_at' => array(
    'name' => __('Created At Date', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => 'null',
    'required' => __('Required', 'memberpress-developer-tools'),
    'desc' => __('The date the Subscription was created. This should be in a MySQL datetime format or PHP\'s date(\'c\') format. All dates stored in the database should be in UTC timezone.', 'memberpress-developer-tools')
  ),
  'total' => array(
    'name' => __('Subscription Total', 'memberpress-developer-tools'),
    'type' => 'decimal',
    'default' => '0.00',
    'required' => false,
    'desc' => __('The Subscription\'s Total Amount (including taxes).', 'memberpress-developer-tools') //BLAIR TODO - Is this correct???
  ),
  //'tax_rate' => array(
  //), // => 0.00,
  //'tax_amount' => array(
  //), // => 0.00,
  //'tax_desc' => array(
  //), // => '',
  //'tax_class' => array(
  //), // => 'standard',
  'cc_last4' => array(
    'name' => __('Credit Card Last Four Digits', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => 'null',
    'required' => false,
    'desc' => __('The last four digits of the Member\'s Credit Card associated with this Recurring Subscription.', 'memberpress-developer-tools')
  ),
  'cc_exp_month' => array(
    'name' => __('Credit Card Expiring Month', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => 'null',
    'required' => false,
    'desc' => __('The Month (0-12) which the Credit Card expires.', 'memberpress-developer-tools')
  ),
  'cc_exp_year' => array(
    'name' => __('Credit Card Expiring Year', 'memberpress-developer-tools'),
    'type' => 'string',
    'default' => 'null',
    'required' => false,
    'desc' => __('The 4 digit Year which the Credit Card expires.', 'memberpress-developer-tools')
  ),
);
