<?php

namespace B2;

class maggiesSite extends \Fuse\Site {

    public function __construct($pluginDirectory) {
        parent::__construct($pluginDirectory, 'UA-92618699-12');
        add_action('init', array($this, 'registerTaxonomies'));
        add_action('init', array($this, 'registerPostTypes'));
        add_action('init', array($this, 'addCustomOptionsPages'));
        //add_action('acf/init', array($this, 'my_acf_init'));

        add_action('after_setup_theme', array($this, 'theme_setup'));

        //declare woocommerce support
        add_action('after_setup_theme', array($this, 'woocommerce_support'));

        add_filter('robots_txt', array($this, 'outputRobotsTxt'), 10,  2);
    }

    public function outputRobotsTxt($output, $public) {
        if ($public != 0) {
            $output .= "Disallow: /sponsors-toolkit/\n";
        }
        return $output;
    }

    public function registerPostTypes() {

        $eventsPT = new \Fuse\PostType("events");
        $eventsPT->register("Event", "Events", array(), array("menu_icon" => "dashicons-calendar-alt", "has_archive" => true, "rewrite" => array("slug" => "events")));

        $peoplePT = new \Fuse\PostType("people");
        $peoplePT->register("Person", "People", array(), array("menu_icon" => "dashicons-groups", "has_archive" => true, "rewrite" => array("slug" => "people")));

        $penguinsPT = new \Fuse\PostType("penguins");
        $penguinsPT->register("Penguin", "Penguins", array(), array("menu_icon" => "dashicons-universal-access", "has_archive" => true, "rewrite" => array("slug" => "penguins")));

        $sponsorsPT = new \Fuse\PostType("sponsors");
        $sponsorsPT->register("Sponsor", "Sponsors", array(), array("menu_icon" => "dashicons-star-filled", "has_archive" => true, "rewrite" => array("slug" => "sponsors")));

        // $tourPT = new \Fuse\PostType("tourpenguin");
        // $tourPT->register("Tour Penguin", "Tour Penguin", array(), array("menu_icon" => "dashicons-universal-access", "has_archive" => true, "rewrite" => array("slug" => "sponsors")));

        $schoolPT = new \Fuse\PostType("schoolpenguins");
        $schoolPT->register("School Penguin", "School Penguins", array(), array("menu_icon" => "dashicons-universal-access", 'taxonomies'  => array( 'post_tag' ), "has_archive" => true, "rewrite" => array("slug" => "schoolpenguins")));

    }

    public function registerTaxonomies() {

        $sitesCat = new \Fuse\Taxonomy("site_category");
        $sitesCat->register("Site Theme", "Site Theme", array("events"), array(), array("rewrite" => array("slug" => "site_category", "with_front" => false, "hierarchical" => true)));

        $sitesCat = new \Fuse\Taxonomy("site_theme");
        $sitesCat->register("Site Theme", "Site Theme", array("people"), array(), array("rewrite" => array("slug" => "site_theme", "with_front" => false, "hierarchical" => true)));

        $penguinsCat = new \Fuse\Taxonomy("penguins");
        $penguinsCat->register("penguins", "penguins", array("penguins"), array(), array("rewrite" => array("slug" => "penguins", "with_front" => false, "hierarchical" => true)));

        // $tourCat = new \Fuse\Taxonomy("penguin_tour");
        // $tourCat->register("Penguin Tour", "Penguin Tour", array("penguin_tour"), array(), array("rewrite" => array("slug" => "penguin_tour", "with_front" => false, "hierarchical" => true)));

        $schoolCat = new \Fuse\Taxonomy("school_penguins");
        $schoolCat->register("School Penguin", "School Penguins", array("school_penguin"), array(), array("rewrite" => array("slug" => "school_penguin", "with_front" => false, "hierarchical" => true)));
    }

    public function theme_setup() {
        register_nav_menus(array(
            'primary_navigation' => 'Primary Navigation',
            'footer-menu-1' => 'Footer menu 1',
            'footer-menu-2' => 'Footer menu 2',
        ));
    }

    public function addCustomOptionsPages() {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page(array(
                "page_title" => "Theme Settings",
                "icon_url" => "dashicons-admin-generic",
            ));
        }
    }

    public function woocommerce_support() {
        add_theme_support('woocommerce');
    }

    function my_acf_init() {
        acf_update_setting('google_api_key', 'AIzaSyB0qsHf3R5GlGd5w2xeSo_BYpT35GLdj8o');
    }

}
