// #region [Imports] ===================================================================================================

// Libraries
import React from "react";
import ReactDOM from "react-dom";
import { Provider } from "react-redux";
import { BrowserRouter, Route } from "react-router-dom";

// Store
import initializeStore from "./store";

// CSS
import "antd/lib/grid/style/index.css";
import "antd/lib/tabs/style/index.css";
import "antd/lib/table/style/index.css";
import "antd/lib/pagination/style/index.css";
import "antd/lib/icon/style/index.css";
import "antd/lib/spin/style/index.css";
import "antd/lib/skeleton/style/index.css";
import "antd/lib/input/style/index.css";
import "antd/lib/input-number/style/index.css";
import "antd/lib/button/style/index.css";
import "antd/lib/message/style/index.css";
import "./index.scss";

// Components
import App from "./components/App";

// Helpers
import { getPathPrefix } from "./helpers/utils";

// #endregion [Imports]

// #region [Variables] =================================================================================================

// Initialize redux store.
const store = initializeStore();

const pathPrefix = getPathPrefix();

// #endregion [Variables]

// #region [Component] =================================================================================================

document
    .querySelectorAll("#lpfw_my_points_app")
    .forEach((domContainer: any) => {
        ReactDOM.render(
            <Provider store={store}>
                <BrowserRouter>
                    <Route
                        path={`${pathPrefix}lpfw-my-points/`}
                        component={App}
                    />
                </BrowserRouter>
            </Provider>,
            domContainer
        );
    });

// #endregion [Component]
