// #region [Imports] ===================================================================================================

// Libraries
import "cross-fetch/polyfill";

// Actions
import {
    IReadCustomerStatusActionPayload,
    IReadCustomerHistoryActionPayload,
    IAdjustCustomerPointsActionPayload,
    ECustomerDataActionTypes,
    CustomerDataActions,
} from "../actions/customer";

// #endregion [Imports]

// #region [Variables] =================================================================================================

declare var acfwpElements: any;
const {
    axiosInstance,
    redux: { sagaEffects },
} = acfwpElements;

const { put, call, takeEvery } = sagaEffects;

// #endregion [Variables]

// #region [Sagas] =====================================================================================================

export function* readCustomerStatusSaga(action: {
    type: string;
    payload: IReadCustomerStatusActionPayload;
}): any {
    const { id, processingCB, successCB, failCB } = action.payload;

    try {
        if (typeof processingCB === "function") processingCB();

        const response = yield call(() =>
            axiosInstance.get(`loyalty-program/v1/customers/status/${id}`)
        );

        if (response && response.data && put) {
            yield put(
                CustomerDataActions.setStoreCustomerStatus({
                    data: response.data.status,
                })
            );
            yield put(
                CustomerDataActions.setStoreCustomerSources({
                    data: response.data.sources,
                })
            );

            if (typeof successCB === "function") successCB(response);
        }
    } catch (e) {
        if (typeof failCB === "function") failCB({ error: e });
    }
}

export function* readCustomerHistorySaga(action: {
    type: string;
    payload: IReadCustomerHistoryActionPayload;
}): any {
    const { id, page, processingCB, successCB, failCB } = action.payload;

    try {
        if (typeof processingCB === "function") processingCB();

        const response = yield call(() =>
            axiosInstance.get(`loyalty-program/v1/customers/history/${id}`, {
                params: {
                    page: page,
                },
            })
        );

        if (response && response.data && put) {
            yield put(
                CustomerDataActions.setStoreHIstoryEntries({
                    data: response.data,
                })
            );

            if (typeof successCB === "function") successCB(response);
        }
    } catch (e) {
        if (typeof failCB === "function") failCB({ error: e });
    }
}

export function* adjustCustomerPointsSaga(action: {
    type: string;
    payload: IAdjustCustomerPointsActionPayload;
}): any {
    const { id, type, points, processingCB, successCB, failCB } =
        action.payload;

    try {
        if (typeof processingCB === "function") processingCB();

        const response = yield call(() =>
            axiosInstance.post(`loyalty-program/v1/customers/points/${id}`, {
                id,
                type,
                points,
            })
        );

        if (response && response.data && put) {
            if (typeof successCB === "function") successCB(response);
        }
    } catch (e) {
        if (typeof failCB === "function") failCB({ error: e });
    }
}

// #endregion [Sagas]

// #region [Action Listeners] ==========================================================================================

export const actionListener = [
    takeEvery(
        ECustomerDataActionTypes.READ_CUSTOMER_STATUS,
        readCustomerStatusSaga
    ),
    takeEvery(
        ECustomerDataActionTypes.READ_CUSTOMER_HISTORY,
        readCustomerHistorySaga
    ),
    takeEvery(
        ECustomerDataActionTypes.ADJUST_CUSTOMER_POINTS,
        adjustCustomerPointsSaga
    ),
];

// #endregion [Action Listeners]
