// #region [Imports] ===================================================================================================

// Types
import ICustomer from "../../types/customer";

// Actions
import {
    ISetCustomerActionPayload,
    ISetCustomerStatusActionPayload,
    ISetCustomerSourcesActionPayload,
    ISetHistoryEntriesActionPayload,
    ISetHistoryEntryActionPayload,
    ECustomerDataActionTypes,
} from "../actions/customer";

// #endregion [Imports]

interface IAction {
    type: string;
    payload: any;
}

// #region [Variables] ===================================================================================================

declare var acfwpElements: any;
const {
    lodash: { cloneDeep },
} = acfwpElements;

// #endregion [Variables]

// #region [Reducer] ===================================================================================================

export default (customerData: ICustomer | null = null, action: IAction) => {
    switch (action.type) {
        case ECustomerDataActionTypes.SET_STORE_CUSTOMER: {
            const { data } = action.payload as ISetCustomerActionPayload;
            return data;
        }

        case ECustomerDataActionTypes.SET_STORE_CUSTOMER_STATUS: {
            const { data } = action.payload as ISetCustomerStatusActionPayload;
            return { ...customerData, status: data };
        }

        case ECustomerDataActionTypes.SET_STORE_CUSTOMER_SOURCES: {
            const { data } = action.payload as ISetCustomerSourcesActionPayload;
            return { ...customerData, sources: data };
        }

        case ECustomerDataActionTypes.SET_STORE_HISTORY_ENTRIES: {
            const { data } = action.payload as ISetHistoryEntriesActionPayload;
            return { ...customerData, history: [...data] };
        }

        case ECustomerDataActionTypes.SET_STORE_HISTORY_ENTRY: {
            const { data } = action.payload as ISetHistoryEntryActionPayload;
            const history = customerData?.history
                ? [...customerData?.history, data]
                : [data];
            return { ...customerData, history };
        }

        default:
            return customerData;
    }
};

// #endregion [Reducer]
